--[[ Buff Selector -------------------------------------------------------------- ]]
local T = AceLibrary("AceLocale-2.2"):new("WeaponRebuff")

function WeaponRebuff:OnItemButtonClick(button, mouseButtonUsed)
	local button = getglobal(this:GetName())
	
	if button:GetAttribute("type") == "item" then
		local itemName = button:GetAttribute("item")
		
		 -- [ Decrement Item Count ] --
		if (not SpellCanTargetItem()) then
			-- assumes the buff was applied, of course.
			-- decrement the count in case it's perma-displayed
			if (WeaponRebuffInfo.BuffTable) then
				local rec = WeaponRebuffInfo.BuffTable[itemName];
				if (rec) then
					rec.quantity = rec.quantity - 1;
					self:CheckThreshold(rec.name, rec.quantity)
				end
			end
		else
			-- Hmm....
		end

		-- [ Flag button for update ] -- 
		button.needUpdate = true;  
		-- note: spells don't need to be updated in this manner
		
		-- [ Combat / Non-Combat Behavior ] -- 
		if not self:inCombat() then
			if mouseButtonUsed == "LeftButton" then
				self:SetBuffAttribute(itemName, 1, "16")
			elseif mouseButtonUsed == "RightButton" then
				self:SetBuffAttribute(itemName, 1, "17")
			else
				-- should be interesting if we wind up here
			end
		
		else
			-- [ setup delay attributes so they can change after combat] --			
			if mouseButtonUsed == "LeftButton" then
				WeaponRebuffCombat.mhBuffReset     = itemName
				WeaponRebuffCombat.mhBuffResetType = 1
			elseif mouseButtonUsed == "RightButton" then
				WeaponRebuffCombat.ohBuffReset     = itemName
				WeaponRebuffCombat.ohBuffResetType = 1
			else
				-- should be interesting if we wind up here
			end
		end
	
	elseif button:GetAttribute("type") == "spell" then
		local spellName = button:GetAttribute("Spell")
		
		-- [ Combat / Non-Combat Behavior ] -- 
		if not self:inCombat() then
			if mouseButtonUsed == "LeftButton" then
				self:SetBuffAttribute(spellName, 2, "16")
			elseif mouseButtonUsed == "RightButton" then
				self:SetBuffAttribute(spellName, 2, "17")
			else
				-- should be interesting if we wind up here
			end
		
		else
			-- [ setup delay attributes so they can change after combat] --			
			if mouseButtonUsed == "LeftButton" then
				WeaponRebuffCombat.mhBuffReset     = spellName
				WeaponRebuffCombat.mhBuffResetType = 2
			elseif mouseButtonUsed == "RightButton" then
				WeaponRebuffCombat.ohBuffReset     = spellName
				WeaponRebuffCombat.ohBuffResetType = 2
			else
				-- should be interesting if we wind up here
			end
		end
	
	else
		-- we shouldn't be here...don't do anything
	end

	-- [ Handle Two-Buff Mode ] --
	wr.wrBuffsTillClose = wr.wrBuffsTillClose - 1
	
	-- [ Handle Button Menu ] --
	if not self:inCombat() and wr.wrBuffsTillClose == 0 then
		WeaponRebuffMenu:Hide()
	else
		--	if in combat, do not try to close	
	end 
	
end

function WeaponRebuff:OnItemButtonUpdate(button, elapsed)
	button.elapsed = button.elapsed + elapsed;
	if (button.needUpdate or button.elapsed > button.updateDelay) then
		local sdp = self.db.profile
		
		-- and display it
		local text = getglobal(button:GetName().."Count");
		local icon = getglobal(button:GetName().."Icon"); 
			
		local l_buttonType
		if WeaponRebuffCombat.createMode == "preCombat" then
			l_buttonType = sdp.wrButtonType_Combat
			text:SetFont("Fonts\\ARIALN.TTF", sdp.wrFontSize_Combat, "OUTLINE")
		else
			l_buttonType = sdp.wrButtonType_NonCombat
			text:SetFont("Fonts\\ARIALN.TTF", sdp.wrFontSize_NonCombat, "OUTLINE")
		end	

		if button:GetAttribute("type") == "item" then
			-- Inventory Buff Items
			local itemName = button:GetAttribute("item")
			local count;
		
			if (WeaponRebuffInfo.BuffTable) then
				local rec = WeaponRebuffInfo.BuffTable[itemName];
				if (rec) then
					count = rec.quantity;
				end
			end
			
			if (count and count > 0) then
				if l_buttonType == 1 then
					text:SetText(count.."x "..itemName);
				else
					text:SetText(""..count);
				end
				
			else
			
				if l_buttonType == 1 then
					text:SetText("0x "..itemName);
				else
					text:SetText("0");
				end
			end
						
		else
			-- Spell buttons	
			local itemName = button:GetAttribute("spell")
						
			if l_buttonType == 1 then
				text:SetText(itemName);
			else
				text:SetText("");
			end
			
		end
		
		button.elapsed = 0;
		button.needUpdate = false;
	end
end

function WeaponRebuff:ShowBuffSelectorMenu()
	if not self:inCombat() then

		-- [ Handle Two-Buff Mode ] --
		if not WeaponRebuffMenu:IsShown() then
			if WeaponRebuff.db.profile.wr2BuffMode or IsShiftKeyDown() then
				wr.wrBuffsTillClose = 2
				if IsShiftKeyDown() then
					-- just a little extra confirmation
					self:AnnounceMsg(T["ACTIVE_2BuffMode"], 1, 1, 1);			
				end
			else
				wr.wrBuffsTillClose = 1
			end
		end

		
		if WeaponRebuffMenu:IsShown() then
			WeaponRebuffMenu:Hide() -- allows toggling
		else
			-- generate the appropriate buttons
			if self:CreateButtons() then -- if we actually have buttons created on the menu (skips the "nothign there but window open" confusion)

				-- [ Buff Menu ] --
				WeaponRebuffMenu:ClearAllPoints();
				WeaponRebuffMenu:SetPoint("BOTTOMLEFT", wrMainhandButton, "TOPLEFT", 0, 0);			
				WeaponRebuffMenu:Show()
			end
		end

	else
		self:AnnounceMsg("Not available in Combat", 1, 1, 0)
	end -- in combat
	
end

-- [[ Position Buttons on Bar ---------------------------------------------------- ]] 
function WeaponRebuff:PositionButtonsOnMenu(button, px, py)
	-- 1: Left to Right -- 2: Right to Left -- 3: Top to Bottom -- 4: Bottom to Top

	local sdp = self.db.profile
	local l_MenuButtonSize, l_MenuDirection, l_MenuPoint, l_ButtonType
	
	if WeaponRebuffCombat.createMode == "preCombat" then
		l_MenuButtonSize = sdp.wrMenuButtonSize_Combat
		l_MenuDirection  = sdp.wrMenuDirection_Combat
		l_MenuPoint      = sdp.wrMenuPoint_Combat
		l_ButtonType     = sdp.wrButtonType_Combat
	else
		l_MenuButtonSize = sdp.wrMenuButtonSize_NonCombat
		l_MenuDirection  = sdp.wrMenuDirection_NonCombat
		l_MenuPoint      = sdp.wrMenuPoint_NonCombat
		l_ButtonType     = sdp.wrButtonType_NonCombat
	end
	
		
	-- [ Set Button Size ] --
	button:SetHeight(l_MenuButtonSize);
	
	if l_ButtonType == 1 then
		button:SetWidth(l_MenuButtonSize * 8); -- text
	else
		button:SetWidth(l_MenuButtonSize);
	end
	
	-- [ Position Buttons ] --
	button:ClearAllPoints()

	if l_MenuDirection == "Left to Right" then
		button:SetPoint(l_MenuPoint, WeaponRebuffMenu, "BOTTOMLEFT", px, py);
		px = px + button:GetWidth();
	elseif l_MenuDirection == "Right to Left" then
		button:SetPoint(l_MenuPoint, WeaponRebuffMenu, "BOTTOMLEFT", px, py);
		px = px - button:GetWidth();
	elseif l_MenuDirection == "Top to Bottom" then
		button:SetPoint(l_MenuPoint, WeaponRebuffMenu, "BOTTOMLEFT", px, py);
		py = py - button:GetHeight();	
	elseif l_MenuDirection == "Bottom to Top" then
		button:SetPoint(l_MenuPoint, WeaponRebuffMenu, "BOTTOMLEFT", px, py);
		py = py + button:GetHeight();	
	else
		-- uh oh
	end
	
	return px, py
end

function WeaponRebuff:CreateButtons()
	local buttonName, button -- Name of Button, handle of Button
	local sdp = self.db.profile
	local px, py = 0, 0
	local l_ButtonType
	
	if WeaponRebuffCombat.createMode == "preCombat" then
		l_ButtonType = sdp.wrButtonType_Combat
	else
		l_ButtonType = sdp.wrButtonType_NonCombat
	end
	
	-- [[ Tuck residual buttons under the covers ]] --
	--    Just in case someone adds then immediately removes a user-defined buff
	local kids = { WeaponRebuffMenu:GetChildren() }
	for _, child in ipairs(kids) do
		child:Hide() 
	end
		
	-- [[ Add Buff Items ]] -- 
		-- find the current number of buff items available
	WeaponRebuffInfo.BuffTable = WeaponRebuff:LocateBuffItems();
	
	for _, t in pairs(WeaponRebuffInfo.BuffTable) do
		buttonName = "WeaponRebuffMenuButton"..t.name;
		button = getglobal(buttonName);

		if not self:inCombat() then
			if (button == nil) then
				button = CreateFrame("Button", buttonName, WeaponRebuffMenu, "WeaponRebuffMenuButtonTemplate");
	
				local texture = getglobal(button:GetName().."Icon");	
				if l_ButtonType == 0 then
					texture:SetTexture(t.icon);
				else
					texture:SetTexture(.1, .1, .1);	
				end
						
				button:SetScript("OnEnter", loadstring("WeaponRebuff_ShowWeaponRebuffTooltip(\""..t.name.."\");"));
				button:SetScript("OnLeave", function() wrBuffSelectorTooltip:Hide() end);

				button:SetAttribute("item", t.name);
			else

				local texture = getglobal(button:GetName().."Icon");	
				if l_ButtonType == 0 then
					texture:SetTexture(t.icon);
				else
					texture:SetTexture(.1, .1, .1);	
				end

			end

			px, py = self:PositionButtonsOnMenu(button, px, py)						
			button:Show();
		end
		button.needUpdate = true;
	end

	-- [[ Add Spells ]] -- 
	 -- [[ If not Fishin' ]] --
	if not sdp.wrFishingMode then	 
		for i=1, table.getn(sdp.spellNames), 1 do
			local spellId, spellTexture = self:GetSpellId(sdp.spellNames[i])
			
			if ( spellId > 0) then
				local buttonName = "WeaponRebuffMenuButton"..sdp.spellNames[i];
				local button = getglobal(buttonName);
  	
				if not self:inCombat() then
					if (button == nil) then
						button = CreateFrame("Button", buttonName, WeaponRebuffMenu, "WeaponRebuffMenuButtonTemplate");
  	
						local texture = getglobal(button:GetName().."Icon");
						if l_ButtonType == 0 then
							texture:SetTexture(spellTexture);
						else
							texture:SetTexture(.1, .1, .1);	
						end
						
						button:SetScript("OnEnter", loadstring("WeaponRebuff_ShowWeaponRebuffTooltip(\""..sdp.spellNames[i].."\");"));
						button:SetScript("OnLeave", function() wrBuffSelectorTooltip:Hide() end);
		
						button:SetAttribute("spell", sdp.spellNames[i]);
						button:SetAttribute("unit", "player")
						button:SetAttribute("type", "spell")
					else
						local texture = getglobal(button:GetName().."Icon");
						if l_ButtonType == 0 then
							texture:SetTexture(spellTexture);					
						else
							texture:SetTexture(.1, .1, .1);	
						end
  	
					end
					
					px, py = self:PositionButtonsOnMenu(button, px, py)
					button:Show();
				end
				button.needUpdate = true;
  	
			end
		end			
	end	
 -- [ Recheck to see if we have buttons ] --
	local kids = { WeaponRebuffMenu:GetChildren() }
	for _, child in ipairs(kids) do
		if child:IsShown() then return true end -- kids, need to show 'em off
	end	
	
	return false -- no buttons, no need to open window
--	return true
end


function WeaponRebuff:SetBuffAttribute(buff, bufftype, slot)
	local textToUpdate, button
	
	if ( slot == "16" ) then
		RememberBuff[16].BuffName =  buff
		RememberBuff[16].BuffType =  bufftype
		button = getglobal("wrMainhandButton")

		-- [ Load Buff Data to SavedVariable ] -- 	
		self:SaveVariables()		
	elseif ( slot == "17" ) then
		RememberBuff[17].BuffName =  buff
		RememberBuff[17].BuffType =  bufftype
		button = getglobal("wrOffhandButton")
	
		-- [ Load Buff Data to SavedVariable ] -- 	
		self:SaveVariables()
	else
		WeaponRebuff.ChatPrint("Unable to set Attributes", "slot "..slot)
		return
	end

	-- [ Set Buffs ] --
	if bufftype == 1 then
  	button:SetAttribute("type", "item")
  	button:SetAttribute("target-slot1", slot)
		button:SetAttribute("item", buff)
		
	elseif bufftype == 2 then
  	button:SetAttribute("type", "spell")
	 	button:SetAttribute("spell", buff)
	 	button:SetAttribute("unit", "player")

	else
		-- bufftype = 0 for "no buffs" default
 		-- WeaponRebuff.ChatPrint("Unknown bufftype", bufftype)
 	end
 	 
end

function WeaponRebuff_ShowWeaponRebuffTooltip(itemName)

	wrBuffSelectorTooltip:SetOwner(this, "ANCHOR_"..WeaponRebuff.db.profile.tooltips.buffselector);
	wrBuffSelectorTooltip:ClearLines()
	wrBuffSelectorTooltip:SetFrameStrata("TOOLTIP")
	wrBuffSelectorTooltip:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
                                     edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
                                     tile = true, tileSize = 16, edgeSize = 16, 
                                     insets = { left = 4, right = 4, top = 4, bottom = 4 }
                                    }
	)
	wrBuffSelectorTooltip:SetBackdropColor(0, 0, 0, 1)
	wrBuffSelectorTooltip:SetBackdropBorderColor(1, .6, 0, 1)
	
	wrBuffSelectorTooltipTextLeft1:SetFontObject("GameFontNormal")
	wrBuffSelectorTooltip:AddLine(itemName, 0,1,0);

	wrBuffSelectorTooltipTextLeft2:SetFontObject("GameFontHighlightSmall")
	wrBuffSelectorTooltip:AddLine(wrColor.gold..T["WEAPONREBUFF_TOOLTIP_LEFTMOUSE"].."\n"..wrColor.copper..T["WEAPONREBUFF_TOOLTIP_RIGHTMOUSE"], 
		1,1,1
	);

	wrBuffSelectorTooltip:Show();

end

--[[ UI Controls -------------------------------------------------------------- ]]
function WeaponRebuff:SetMenuDirection(combat, direction)
	if combat == 1 then
		self.db.profile.wrMenuDirection_Combat = direction
	else
		self.db.profile.wrMenuDirection_NonCombat = direction
	
	end
end

function WeaponRebuff:SetMenuAnchorPoint(combat, anchorpoint)
if combat == 1 then
		self.db.profile.wrMenuPoint_Combat = anchorpoint
	else
		self.db.profile.wrMenuPoint_NonCombat = anchorpoint
	end
end


--[[ End Buff Selector ---------------------------------------------------------- ]]
