--[[
Name: Wardrobe2Fu
Revision: $Rev: 53982 $
Author(s): Kazun of Warsong (badhex@fusemail.com)
SVN: http://svn.wowace.com/root/trunk/Wardrobe2/
Description: Switch between unlimited outfit configurations.
Dependencies: AceLibrary, CompostLib, DewdropLib, TabletLib, Fubar
]]--

local dewdrop = AceLibrary("Dewdrop-2.0")
local tablet = AceLibrary("Tablet-2.0")
local Compost = AceLibrary("Compost-2.0")

local L = AceLibrary("AceLocale-2.2"):new("Wardrobe2Fu")
Wardrobe2Fu = AceLibrary("AceAddon-2.0"):new("FuBarPlugin-2.0", "AceDB-2.0", "AceHook-2.1")
Wardrobe2Fu:RegisterDB("Wardrobe2DB")
Wardrobe2Fu.hasIcon = true
Wardrobe2Fu.defaultPosition = "LEFT"
Wardrobe2Fu.defaultMinimapPosition = 250

----------------------------
--      Localization      --
----------------------------

L:RegisterTranslations("enUS", function() return {
	-- syntax
	["Delete"] = true,
	["Update"] = true,
	["Save"] = true,
	["Set Mounted"] = true,
	["Used Slots"] = true,
	["Current"] = true,
	["Mounted"] = true,
} end)

L:RegisterTranslations("esES", function() return {
	-- syntax
	["Delete"] = "Borrar",
	["Update"] = "Actualizar",
	["Save"] = "Guardar",
	["Set Mounted"] = "Equipo de Montura",
	["Used Slots"] = "Casillas usadas",
	["Current"] = "Actual",
	["Mounted"] = "Montado",
} end)

	-- Methods
	
	function Wardrobe2Fu:OnEnable()
		self:Hook(Wardrobe2, "SaveOutfit", "MySaveOutfit")
		self:Hook(Wardrobe2, "WearOutfit", "MyWearOutfit")
		self:Hook(Wardrobe2, "DeleteOutfit", "MyDeleteOutfit")
	end

	function Wardrobe2Fu:OnMenuRequest(level,value)	
		if level == 1 then
			if (table.getn(Wardrobe2.db.profile.Outfit) > 0) then
				for i, each in ipairs(Wardrobe2.db.profile.Outfit) do
					if (Wardrobe2.db.profile.Outfit[i].name ~= nil) then
						dewdrop:AddLine(
							'text', string.format("%s", Wardrobe2.db.profile.Outfit[i].name),
							'func', function(j) Wardrobe2:WearOutfit(j) end,
							'arg1',i,
							'closeWhenClicked', true,
							'isRadio', true,
							'checked', (i == Wardrobe2.db.profile.current)
						)
					end
				end
			end

			dewdrop:AddLine() 
			dewdrop:AddLine(
				'text', L["Save"],
				'hasArrow', true,
				'hasEditBox', true,
				'editBoxFunc', function(text)
					Wardrobe2:SaveOutfit(text)
				end
			)	
			if (table.getn(Wardrobe2.db.profile.Outfit) > 0) then
				dewdrop:AddLine(
					'text', L["Delete"],
					'hasArrow', true,
					'value', "delete"
				)
				dewdrop:AddLine(
					'text', L["Update"],
					'hasArrow', true,
					'value', "update"
				)
				dewdrop:AddLine(
					'text', L["Set Mounted"],
					'hasArrow', true,
					'value', "mounted"
				)
				dewdrop:AddLine()
				
				dewdrop:AddLine(
					'text', L["Used Slots"],
					'hasArrow', true,
					'value', "slots"
				)
				
				dewdrop:AddLine()
			end				
					
		elseif level == 2 then
			if value == "update" then
				if (table.getn(Wardrobe2.db.profile.Outfit) > 0) then
					for i, each in ipairs(Wardrobe2.db.profile.Outfit) do
						dewdrop:AddLine(
							'text', string.format("%s", Wardrobe2.db.profile.Outfit[i].name),
							'func', function(j) Wardrobe2:UpdateOutfit(j) end,
							'closeWhenClicked', true,
							'arg1', i
						)
					end
				end
			end
			
			if value == "delete" then
				if (table.getn(Wardrobe2.db.profile.Outfit) > 0) then
					for i, each in ipairs(Wardrobe2.db.profile.Outfit) do
						dewdrop:AddLine(
							'text', string.format("%s", Wardrobe2.db.profile.Outfit[i].name),
							'func', function(j) Wardrobe2:DeleteOutfit(j) end,
							'closeWhenClicked', true,
							'arg1', i
						)
					end
				end
			end
			
			if value == "mounted" then
				dewdrop:AddLine(
					'text', "None",
					'func', function(j) Wardrobe2.db.profile.Mounted = 0 end,
					'closeWhenClicked', true,
					'isRadio', true,
					'checked', (Wardrobe2.db.profile.Mounted == 0)
				)					
				if (table.getn(Wardrobe2.db.profile.Outfit) > 0) then
					for i, each in ipairs(Wardrobe2.db.profile.Outfit) do
						dewdrop:AddLine(
							'text', string.format("%s", Wardrobe2.db.profile.Outfit[i].name),
							'func', function(j) Wardrobe2.db.profile.Mounted = j end,
							'closeWhenClicked', true,
							'arg1', i,
							'isRadio', true,
							'checked', (i == Wardrobe2.db.profile.Mounted)
						)
					end
				end
			end
			
			if value == "slots" then
				if (table.getn(Wardrobe2.db.profile.Outfit) > 0) then
					for i, each in ipairs(Wardrobe2.db.profile.Outfit) do
						dewdrop:AddLine(
							'text', string.format("%s", Wardrobe2.db.profile.Outfit[i].name),
							'hasArrow', true,
							'value', i
						)
					end
				end
			end
			
		elseif level == 3 then
		
			if value > 0 then
				for i = 0, 19 do
					if(Wardrobe2.db.profile.Outfit[value].slot[i] == nil) then
						newText = "-none-"
					else
						newText = Wardrobe2.db.profile.Outfit[value].slot[i]
					end
					if (i == 0) then
						newSlot = "AmmoSlot"
					elseif (i == 1) then
						newSlot = "HeadSlot"
					elseif (i == 2) then
						newSlot = "NeckSlot"
					elseif (i == 3) then
						newSlot = "ShoulderSlot"
					elseif (i == 4) then
						newSlot = "ShirtSlot"
					elseif (i == 5) then
						newSlot = "ChestSlot"
					elseif (i == 6) then
						newSlot = "WaistSlot"
					elseif (i == 7) then
						newSlot = "LegsSlot"
					elseif (i == 8) then
						newSlot = "FeetSlot"
					elseif (i == 9) then
						newSlot = "WristSlot"
					elseif (i == 10) then
						newSlot = "HandsSlot"
					elseif (i == 11) then
						newSlot = "Finger0Slot"
					elseif (i == 12) then
						newSlot = "Finger1Slot"
					elseif (i == 13) then
						newSlot = "Trinket0Slot"
					elseif (i == 14) then
						newSlot = "Trinket1Slot"
					elseif (i == 15) then
						newSlot = "BackSlot"
					elseif (i == 16) then
						newSlot = "MainHandSlot"
					elseif (i == 17) then
						newSlot = "SecondaryHandSlot"
					elseif (i == 18) then
						newSlot = "RangedSlot"
					elseif (i == 19) then
						newSlot = "TabardSlot"
					end
					dewdrop:AddLine(
						'text', string.format("%s: %s", newSlot, newText),
						'checked', (Wardrobe2.db.profile.Outfit[value].used[GetInventorySlotInfo(newSlot)]),
						'func', function(a, b) Wardrobe2:SetOutfitIgnoreSlot(a, b) end,
						'arg1', newSlot,
						'arg2', value
					)
				end
			end
				
		end
	end

function Wardrobe2Fu:OnTextUpdate()
	if Wardrobe2.db.profile.current ~= nil and Wardrobe2.db.profile.current > 0 then
		self:SetText(Wardrobe2.db.profile.Outfit[Wardrobe2.db.profile.current].name)
	else
		self:SetText("-none-")
	end
end

function Wardrobe2Fu:OnTooltipUpdate()
	if (table.getn(Wardrobe2.db.profile.Outfit) > 0) then
		tablet:SetTitle("|cff00ff00".."Outfits")

		local cat = tablet:AddCategory("columns", 2)
		if (Wardrobe2.db.profile.current ~= nil and Wardrobe2.db.profile.current > 0) then
			cat:AddLine("text", L["Current"], "text2", Wardrobe2.db.profile.Outfit[Wardrobe2.db.profile.current].name or "None")
		else
			cat:AddLine("text", L["Current"], "text2", "None")
		end
		if (Wardrobe2.db.profile.Mounted ~= nil and Wardrobe2.db.profile.Mounted > 0) then
			cat:AddLine("text", L["Mounted"], "text2", Wardrobe2.db.profile.Outfit[Wardrobe2.db.profile.Mounted].name or "None")
		else
			cat:AddLine("text", L["Current"], "text2", "None")
		end
	end
end

function Wardrobe2Fu:MyWearOutfit(this,name)
	self.hooks[Wardrobe2].WearOutfit(this,name)
	self:Update()
end

function Wardrobe2Fu:MySaveOutfit(this,name)
	self.hooks[Wardrobe2].SaveOutfit(this,name)
	self:Update()
end

function Wardrobe2Fu:MyDeleteOutfit(this,name)
	self.hooks[Wardrobe2].DeleteOutfit(this,name)
	self:Update()
end
