--[[
Name: Wardrobe2
Revision: $Rev: 53982 $
Author(s): Kazun of Warsong (badhex@fusemail.com)
SVN: http://svn.wowace.com/root/trunk/Wardrobe2/
Description: Switch between unlimited outfit configurations.
Dependencies: AceLibrary, CompostLib, DewdropLib, TabletLib, Fubar
]]--
local WARDROBE2 = { }

local MAJOR_VERSION = "Wardrobe2"
local MINOR_VERSION = "$Revision: 53982 $"

local L = AceLibrary("AceLocale-2.2"):new("Wardrobe2")
Wardrobe2 = AceLibrary("AceAddon-2.0"):new("AceDB-2.0", "AceConsole-2.0", "AceEvent-2.0")
local Wardrobe2 = Wardrobe2
Wardrobe2:RegisterDB("Wardrobe2DB")
local Compost = AceLibrary("Compost-2.0")

----------------------------
--      Localization      --
----------------------------

L:RegisterTranslations("enUS", function() return {
	-- syntax
	["<outfit>"] = true,
	["<name>"] = true,
	-- setting a default mounted outfit
	["mounted"] = true,
	["Set an outfit to wear when mounted."] = true,
	["Please include a valid outfit you want to use as your mounted outfit."] = true,
	-- saving an outfit
	["save"] = true,
	["Save an outfit."] = true,
	["Please include a new unique name for the outfit you wish to save."] = true,
	-- list outfits
	["list"] = true,
	["List all outfits."] = true,
	-- delete an outfit
	["delete"] = true,
	["Delete an outfit."] = true,
	["Please include an existing outfit you wish to delete."] = true,
	-- update an outfit
	["update"] = true,
	["Update an outfit."] = true,
	["Please include an existing outfit you wish to update."] = true,
	-- wear an outfit
	["wear"] = true,
	["Wear an outfit."] = true,
	["Please include an existing outfit you wish to wear."] = true,
	-- toggle slots
	["useslot"] = true,
	["Toggles the used value of a slot"] = true,
	["Please include an existing outfit you wish to modify."] = true,
	["The ranged weapon slot."] = true,
	["The offhand slot."] = true,
	["The main hand slot."] = true,
	["The second trinket slot."] = true,
	["The first trinket slot."] = true,
	["The second finger slot."] = true,
	["The first finger slot."] = true,
	["The feet slot."] = true,
	["The legs slot."] = true,
	["The waist slot."] = true,
	["The hands slot."] = true,
	["The wrist slot."] = true,
	["The tabard slot."] = true,
	["The shirt slot."] = true,
	["The chest slot."] = true,
	["The back slot."] = true,
	["The shoulder slot."] = true,
	["The neck slot."] = true,
	["The ammo slot."] = true,
	["The head slot."] = true,
	-- Misc Stuff
	["Error saving outfit."] = true,
	["Saving as"] = true,
	["in slot"] = true,
	["Updated outfit"] = true,
	["Deleted outfit"] = true,
	["Queued to wear"] = true,
	["set to"] = true,
	["Busy switching outfits"] = true,
	["Cant find"] = true,
	["in your bags or inventory"] = true,
	["Triple Checking..."] = true,
	["Mounted"] = true,
	["UnMounted"] = true,
} end)

L:RegisterTranslations("esES", function() return {
	-- syntax
	["<outfit>"] = "<equipo>",
	["<name>"] = "<nombre>",
	-- setting a default mounted outfit
	["mounted"] = "montado",
	["Set an outfit to wear when mounted."] = "Establece un conjunto para vestir cuando montes",
	["Please include a valid outfit you want to use as your mounted outfit."] = "Por favor, incluye un conjunto v\195\161lido que quieras usar como equipo de montura" ,
	-- saving an outfit
	["save"] = "guardar",
	["Save an outfit."] = "Guarda un conjunto.",
	["Please include a new unique name for the outfit you wish to save."] = "Por favor, incluye un nombre \195\186nico para el conjunto que quieres guardar.",
	-- list outfits
	["list"] = "listar",
	["List all outfits."] = "Lista todos los conjuntos",
	-- delete an outfit
	["delete"] = "borrar",
	["Delete an outfit."] = "Borra un conjunto.",
	["Please include an existing outfit you wish to delete."] = "Por favor, incluye un conjunto existente que quieras borrar.",
	-- update an outfit
	["update"] = "actualizar",
	["Update an outfit."] = "Actualiza un conjunto.",
	["Please include an existing outfit you wish to update."] = "Por favor, incluye un conjunto existente que quieras actualizar.",
	-- wear an outfit
	["wear"] = "equipar",
	["Wear an outfit."] = "Te equipa con un conjunto",
	["Please include an existing outfit you wish to wear."] = "Por favor, incluye un conjunto existente que quieras equiparte.",
	-- toggle slots
	["useslot"] = "usarcasilla",
	["Toggles the used value of a slot"] = "Establece el alor usado en una casilla",
	["Please include an existing outfit you wish to modify."] = "Por favor, incluye un conjunto existente que quieras modificar.",
	["The ranged weapon slot."] = "La casilla de arma a distancia.",
	["The offhand slot."] = "La casilla de mano secundaria.",
	["The main hand slot."] = "La casilla de mano principal.",
	["The second trinket slot."] = "La casilla de la segunda alhaja.",
	["The first trinket slot."] = "La casilla de la primera alhaja.",
	["The second finger slot."] = "La casilla del segundo dedo.",
	["The first finger slot."] = "La casilla del primer dedo.",
	["The feet slot."] = "La casilla de los pies.",
	["The legs slot."] = "La casilla de las piernas.",
	["The waist slot."] = "La casilla de la cintura.",
	["The hands slot."] = "La casilla de las manos.",
	["The wrist slot."] = "La casilla de las mu\195\177ecas.",
	["The tabard slot."] = "La casilla del tabardo.",   -- check
	["The shirt slot."] = "La casilla de la camisa.",
	["The chest slot."] = "La casilla del torso.",
	["The back slot."] = "La casilla de la espalda.",
	["The shoulder slot."] = "La casilla de los hombros.",
	["The neck slot."] = "La casilla del cuello.",
	["The ammo slot."] = "La casilla de munici\195\179n.",
	["The head slot."] = "La casilla de la cabeza.",
	-- Misc Stuff
	["Error saving outfit."] = "Error al guardar el conjunto.",
	["Saving as"] = "Guardando como",
	["in slot"] = "en la casilla",
	["Updated outfit"] = "Conjunto actualizado",
	["Deleted outfit"] = "Conjunto borrado",
	["Queued to wear"] = "En cola para ser equipado",
	["set to"] = "establecido a",
	["Busy switching outfits"] = "Ocupado cambiando conjuntos",
	["Cant find"] = "No puedo encontrar",
	["in your bags or inventory"] = "en tus bolsas o inventario",
	["Triple Checking..."] = "Comprobando tres veces...",
	["Mounted"] = "Montado",
	["UnMounted"] = "Desmontado",
} end)


----------------------------
--      Static Vars       --
----------------------------

local charID = AceLibrary("AceDB-2.0").CHAR_ID
local realmID = AceLibrary("AceDB-2.0").REALM_ID
local classID = AceLibrary("AceDB-2.0").CLASS_ID

-- Default Config
WARDROBE2.DBDEFAULT = {
	Outfit 		= { 
	},
	Form		= {
	}
}

WARDROBE2.problem_mounts = {
	["Interface\\Icons\\Ability_Mount_PinkTiger"] = 1,
	["Interface\\Icons\\Ability_Mount_WhiteTiger"] = 1,
	["Interface\\Icons\\Spell_Nature_Swiftness"] = 1,
	["Interface\\Icons\\INV_Misc_Foot_Kodo"] = 1,
	["Interface\\Icons\\Ability_Mount_JungleTiger"] =1,
        ["Interface\\Icons\\INV_Staff_08"] = 1,
}

WARDROBE2.InCombat = false
WARDROBE2.BankOpen = false
WARDROBE2.SearchDirection = 1
WARDROBE2.busy = false
WARDROBE2.CurrentForm = ""
WARDROBE2.Queue = nil
WARDROBE2.Mounted = false

Wardrobe2:RegisterChatCommand({"/wardrobe", "/wd", '/acewardrobe', '/awd', '/wardrobe2', '/wd2'}, {
	type = 'group',
	args = {
		mounted = {
			type = "text",
			name = L["mounted"],
			desc = L["Set an outfit to wear when mounted."],
			input = false,
			validate = function(name)
				local self = Wardrobe2
				if (tonumber(name) == nil) then
					for i = 1, table.getn(self.db.profile.Outfit) do
						if (self.db.profile.Outfit[i].name ~= nil and self.db.profile.Outfit[i].name == name) then
							return true
						end
					end
				else
					if (self.db.profile.Outfit[tonumber(name)] ~= nil and self.db.profile.Outfit[tonumber(name)].name ~= nil) then
						return true
					end
				end
				return false
			end,
			error = L["Please include a valid outfit you want to use as your mounted outfit."],
			get = function() return Wardrobe2.db.profile.Mounted end,
			set = "SetMounted",
			usage = L["<outfit>"],
		},
		save = {
			type = "text",
			name = L["save"],
			desc = L["Save an outfit."],
			input = false,
			validate = function(name)
				local self = Wardrobe2
				if (tonumber(name) == nil) then
					for i = 1, table.getn(self.db.profile.Outfit) do
						if (self.db.profile.Outfit[i].name ~= nil and self.db.profile.Outfit[i].name == name) then
							return false
						end
					end
				else
					return false
				end
				return true
			end,
			error = L["Please include a new unique name for the outfit you wish to save."],
			set = "SaveOutfit",
			get = false,
			usage = L["<name>"],
		},
		list = {
			type = "execute",
			name = L["list"],
			desc = L["List all outfits."],
			func = "ListOutfits"
		},
		delete = {
			type = "text",
			name = L["delete"],
			desc = L["Delete an outfit."],
			input = false,
			validate = function(name)
				local self = Wardrobe2
				if (tonumber(name) == nil) then
					for i = 1, table.getn(self.db.profile.Outfit) do
						if (self.db.profile.Outfit[i].name ~= nil and self.db.profile.Outfit[i].name == name) then
							return true
						end
					end
				else
					if (self.db.profile.Outfit[tonumber(name)] ~= nil and self.db.profile.Outfit[tonumber(name)].name ~= nil) then
						return true
					end
				end
				return false
			end,
			error = L["Please include an existing outfit you wish to delete."],
			set = "DeleteOutfit",
			get = false,
			usage = L["<outfit>"],
		},
		update = {
			type = "text",
			name = L["update"],
			desc = L["Update an outfit."],
			input = false,
			validate = function(name)
				local self = Wardrobe2
				if (tonumber(name) == nil) then
					for i = 1, table.getn(self.db.profile.Outfit) do
						if (self.db.profile.Outfit[i].name ~= nil and self.db.profile.Outfit[i].name == name) then
							return true
						end
					end
				else
					if (self.db.profile.Outfit[tonumber(name)] ~= nil and self.db.profile.Outfit[tonumber(name)].name ~= nil) then
						return true
					end
				end
				return false
			end,
			error = L["Please include an existing outfit you wish to update."],
			set = "UpdateOutfit",
			get = false,
			usage = L["<outfit>"],
		},
		wear = {
			type = "text",
			name = L["wear"],
			desc = L["Wear an outfit."],
			input = false,
			validate = "WearOutfit",
			error = L["Please include an existing outfit you wish to wear."],
			set = function(args) if (WARDROBE2.busy == false) then Wardrobe2:Print("Wearing outfit %s", args) end end,
			get = false,
			usage = L["<outfit>"],
		},
		useslot = {
			type = 'group',
			name = L["useslot"],
			desc = L["Toggles the used value of a slot"],
			args = {
				RangedSlot = {
					type = 'text',
					name = "RangedSlot",
					desc = L["The ranged weapon slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("RangedSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				SecondaryHandSlot = {
					type = 'text',
					name = "SecondaryHandSlot",
					desc = L["The offhand slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("SecondaryHandSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				MainHandSlotSlot = {
					type = 'text',
					name = "MainHandSlot",
					desc = L["The main hand slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("MainHandSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				Trinket1Slot = {
					type = 'text',
					name = "Trinket1Slot",
					desc = L["The second trinket slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("Trinket1Slot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				Trinket0Slot = {
					type = 'text',
					name = "Trinket0Slot",
					desc = L["The first trinket slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("Trinket0Slot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				Finger1Slot = {
					type = 'text',
					name = "Finger1Slot",
					desc = L["The second finger slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("Finger1Slot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				Finger0Slot = {
					type = 'text',
					name = "Finger0Slot",
					desc = L["The first finger slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("Finger0Slot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				FeetSlot = {
					type = 'text',
					name = "FeetSlot",
					desc = L["The feet slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("FeetSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				LegsSlot = {
					type = 'text',
					name = "LegsSlot",
					desc = L["The legs slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("LegsSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				WaistSlot = {
					type = 'text',
					name = "WaistSlot",
					desc = L["The waist slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("WaistSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				HandsSlot = {
					type = 'text',
					name = "HandsSlot",
					desc = L["The hands slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("HandsSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				WristSlot = {
					type = 'text',
					name = "WristSlot",
					desc = L["The wrist slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("WristSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				TabardSlot = {
					type = 'text',
					name = "TabardSlot",
					desc = L["The tabard slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("TabardSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				ShirtSlot = {
					type = 'text',
					name = "ShirtSlot",
					desc = L["The shirt slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("ShirtSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				ChestSlot = {
					type = 'text',
					name = "ChestSlot",
					desc = L["The chest slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("ChestSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				BackSlot = {
					type = 'text',
					name = "BackSlot",
					desc = L["The back slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("BackSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				ShoulderSlot = {
					type = 'text',
					name = "ShoulderSlot",
					desc = L["The shoulder slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("ShoulderSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				NeckSlot = {
					type = 'text',
					name = "NeckSlot",
					desc = L["The neck slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("NeckSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				AmmoSlot = {
					type = 'text',
					name = "AmmoSlot",
					desc = L["The ammo slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("AmmoSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				},
				HeadSlot = {
					type = 'text',
					name = "HeadSlot",
					desc = L["The head slot."],
					input = false,
					validate = function(args) return Wardrobe2:SetOutfitIgnoreSlot("HeadSlot", args) end,
					error = L["Please include an existing outfit you wish to modify."],
					set = function () return end,
					get = false,
					usage = L["<outfit>"]
				}
			}
		}
	}
}) -- :RegisterChatCommand takes the slash commands and an AceOptions data table.

function Wardrobe2:OnInitialize()
	-- stuff to do when the mod starts up
	self:RegisterDefaults('profile', WARDROBE2.DBDEFAULT )
	self:SetProfile("char")
end

function Wardrobe2:OnEnable()
	self:RegisterEvent("PLAYER_REGEN_DISABLED", "event_PlayerEnterCombat")
	self:RegisterEvent("PLAYER_REGEN_ENABLED", "event_PlayerLeaveCombat")
	self:RegisterEvent("PLAYER_AURAS_CHANGED", "event_PlayerAurasChanged")
	self:RegisterEvent("UPDATE_SHAPESHIFT_FORMS", "event_PlayerAurasChanged")
	self:RegisterEvent("PLAYER_ENTERING_WORLD", "event_PlayerLeaveCombat")
	self:RegisterEvent("PLAYER_LEAVING_WORLD", "event_PlayerLeaveCombat")
end

function Wardrobe2:OnDisable()
	WARDROBE2.InCombat = false
end
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--  EVENT FUNCTIONS
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------

-- this event is called when an aura changes (used for mounted and stances
function Wardrobe2:event_PlayerAurasChanged()
	local tmpForm = self:util_GetForm()
	local _, englishClass = UnitClass("player")
	-----------------------------------------------------------------------
	-- Stance/Form Stuff here
	-----------------------------------------------------------------------
	if (WARDROBE2.CurrentForm ~= tmpForm) then
		if (englishClass == "ROGUE" and tmpForm == "") then
			WARDROBE2.CurrentForm = "No Stealth"
		elseif (englishClass == "DRUID" and tmpForm == "") then
			WARDROBE2.CurrentForm = "Normal Form"
		else
			WARDROBE2.CurrentForm = tmpForm
		end
		-- lets look for the outfit number for this stance
		local tmpOutfitNum = self.db.profile.Form[WARDROBE2.CurrentForm]
		if (tmpOutfitNum ~= nil and not self:util_IsPlayerMounted()) then
			if (englishClass == "DRUID") then
				self:WearOutfit(tmpOutfitNum, true)
			else
				self:WearOutfit(tmpOutfitNum)
			end
		end
	end
	
	-----------------------------------------------------------------------
	-- Mounted Stuff here
	-----------------------------------------------------------------------
	if (self:util_IsPlayerMounted() == true and WARDROBE2.Mounted == false) then
		-- mount up
		local mntOutfit = self.db.profile.Mounted
		self:Print(L["Mounted"])
		WARDROBE2.Mounted = true
		if (mntOutfit ~= nil) then
			self.db.profile.last = self.db.profile.current
			self:WearOutfit(mntOutfit)
		end
	elseif (WARDROBE2.Mounted == true and self:util_IsPlayerMounted() == false) then
		-- dismount
		self:Print(L["UnMounted"])
		WARDROBE2.Mounted = false
		if (self.db.profile.last ~= nil and self.db.profile.Mounted == self.db.profile.current) then
			self:WearOutfit(self.db.profile.last)
			self.db.profile.last = nil
		end
	end
end

-- this event is called when we enter combat
function Wardrobe2:event_PlayerEnterCombat()
	WARDROBE2.InCombat = true
end

-- this event is called when we enter combat
function Wardrobe2:event_PlayerLeaveCombat()
	WARDROBE2.InCombat = false
	-- queue fires here
	if(WARDROBE2.Queue ~= nil) then
		self:WearOutfit(WARDROBE2.Queue)
		WARDROBE2.Queue = nil
	end
end

--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--  WORKING FUNCTIONS
--  	These functions do most of the dirty work in the mod
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
-- this sets a mounted outfit
function Wardrobe2:SetMounted(name)
	local tmpOutfit = 0
	if (tonumber(name) ~= nil) then
		tmpOutfit = tonumber(name)
	elseif (table.getn(self.db.profile.Outfit) > 0) then
		for i, each in ipairs(self.db.profile.Outfit) do
			if (each.name ~= nil and each.name == name) then
				tmpOutfit = i
				break
			end
		end
	end
	if (tmpOutfit > 0) then
		self.db.profile.Mounted = tmpOutfit
		--self:Print("Mounted outfit set to: (%i) %s", tmpOutfit, self.db.profile.Outfit[tmpOutfit].name)
	end
end

-- this lists all outfits
function Wardrobe2:ListOutfits()
	local tmpFound = false
	self:Print("List of Outfits:")
	if (table.getn(self.db.profile.Outfit) > 0) then
		for i, each in ipairs(self.db.profile.Outfit) do
			if (self.db.profile.Outfit[i].name ~= nil) then
				self:Print("    [%i] %s", i, self.db.profile.Outfit[i].name)
				tmpFound = true
			end
		end
	end
	if (tmpFound == false) then
		self:Print("    o ".."No outfits found.")
	end
end

-- this saves an outfit
-- WARNING: no error checking
function Wardrobe2:SaveOutfit(name)
	local FreeSlot = self:util_FreeOutfit()
	local CurrentInventory = Compost:Acquire()
	
	if (tonumber(name) == nil) then
		for i = 1, table.getn(self.db.profile.Outfit) do
			if (self.db.profile.Outfit[i].name ~= nil and self.db.profile.Outfit[i].name == name) then
				self:Print(L["Error saving outfit."])
				return
			end
		end
	else
		self:Print(L["Error saving outfit."])
		return
	end
	
	self:util_CurrentInventory(CurrentInventory)
	self:Print("%s '%s' %s %i", L["Saving as"], name, L["in slot"], FreeSlot)
	self.db.profile.Outfit[FreeSlot] = { }
	self.db.profile.Outfit[FreeSlot].name = name
	self.db.profile.Outfit[FreeSlot].slot = { }
	self.db.profile.Outfit[FreeSlot].used = { }
	self.db.profile.Outfit[FreeSlot].cloak = ShowingCloak()
	self.db.profile.Outfit[FreeSlot].helm = ShowingHelm()
	self.db.profile.current = FreeSlot
	for i = 0, (table.getn(CurrentInventory)-1) do
		self.db.profile.Outfit[FreeSlot].slot[i] = CurrentInventory[i]
		self.db.profile.Outfit[FreeSlot].used[i] = true
--		self:Print("%i: %s", i, self.db.profile.Outfit[FreeSlot].slot[i])
	end
	Compost:Reclaim(CurrentInventory)
end

-- this updates an outfit
-- WARNING: no error checking
function Wardrobe2:UpdateOutfit(name)
	local tmpOutfit = 0
	if (tonumber(name) ~= nil) then
		tmpOutfit = tonumber(name)
	elseif (table.getn(self.db.profile.Outfit) > 0) then
		for i, each in ipairs(self.db.profile.Outfit) do
			if (each.name ~= nil and each.name == name) then
				tmpOutfit = i
				break
			end
		end
	end
	if (tmpOutfit > 0) then
		local CurrentInventory = Compost:Acquire()
		self:util_CurrentInventory(CurrentInventory)
		self.db.profile.Outfit[tmpOutfit].cloak = ShowingCloak()
		self.db.profile.Outfit[tmpOutfit].helm = ShowingHelm()
		for i = 0, (table.getn(CurrentInventory)-1) do
			self.db.profile.Outfit[tmpOutfit].slot[i] = CurrentInventory[i]
			self.db.profile.Outfit[tmpOutfit].used[i] = true
			--self:Print("%i: %s", i, self.db.profile.Outfit[tmpOutfit].slot[i])
		end
		self:Print("%s '%s' %s %i", L["Updated outfit"], self.db.profile.Outfit[tmpOutfit].name, L["in slot"], tmpOutfit)
		Compost:Reclaim(CurrentInventory)
	end
end

-- this deletes an outfit
-- WARNING: no error checking
function Wardrobe2:DeleteOutfit(args)
	if (tonumber(args) ~= nil) then
		-- a number, try to delete by number
		if (self.db.profile.Outfit[tonumber(args)] ~= nil and self.db.profile.Outfit[tonumber(args)].name ~= nil) then
			-- delete the outfit
			self:Print("Deleted outfit '%s' in slot %i", self.db.profile.Outfit[tonumber(args)].name, tonumber(args))
			self.db.profile.Outfit[tonumber(args)] = nil
			if self.db.profile.current == tonumber(args) then
				self.db.profile.current = nil
			end
			
		end
	else
		-- a name, try to delete by name
		for i, each in ipairs(self.db.profile.Outfit) do
			if (each.name ~= nil and (string.lower(each.name) == string.lower(args))) then
				self:Print("%s %s %s %i", L["Deleted outfit"], args, L["in slot"], i)
				self.db.profile.Outfit[i] = nil
				if self.db.profile.current == 1 then
                                        self.db.profile.current = nil
                                end
                                return
			end
		end
	end
end

-- this wears an outfit
-- WARNING: no error checking
-- returns true if valid
function Wardrobe2:WearOutfit(args, force)
	if (force == nil) then force = false end
	local tmpOutfit = 0
	if (tonumber(args) ~= nil) then
		if (self.db.profile.Outfit[tonumber(args)] ~= nil and self.db.profile.Outfit[tonumber(args)].name ~= nil) then
			-- this is a legit outfit
			tmpOutfit = tonumber(args)
		end
	else
		-- a name, look up its number
		for i, each in ipairs(self.db.profile.Outfit) do
			if (each.name ~= nil and (string.lower(each.name) == string.lower(args))) then
				tmpOutfit = i
				break
			end
		end
	end
	if (tmpOutfit > 0) then
		-- we found an outfit
		if (WARDROBE2.InCombat == false or force == true) then
			self:util_WearOutfit(tmpOutfit)
		else
			WARDROBE2.Queue = tmpOutfit
			self:Print("%s: (%i) %s", L["Queued to wear"], tmpOutfit, self.db.profile.Outfit[tmpOutfit].name)
		end
		return true
	end

	return false
end

-- this toggles a slot being used in an outfit
-- WARNING: no error checking
function Wardrobe2:SetOutfitIgnoreSlot(key, args)
	local tmpOutfit = 0
	local slotID = GetInventorySlotInfo(key)
	-- a name, try to get the number
	if (tonumber(args) ~= nil) then
		if (self.db.profile.Outfit[tonumber(args)] ~= nil and self.db.profile.Outfit[tonumber(args)].name ~= nil) then
			-- this is a legit outfit
			tmpOutfit = tonumber(args)
		end
	else
		for i, each in ipairs(self.db.profile.Outfit) do
			if (each.name ~= nil and (string.lower(each.name) == string.lower(args))) then
				tmpOutfit = i
				break
			end
		end
	end
	if (tmpOutfit ~= 0) then
		-- toggle
		if (self.db.profile.Outfit[tmpOutfit].used[slotID]) then
			self.db.profile.Outfit[tmpOutfit].used[slotID] = false
			self:Print("%s %s [|cffff0000false|r]", key, L["set to"])
		else
			self.db.profile.Outfit[tmpOutfit].used[slotID] = true
			self:Print("%s %s [|cff00ff00true|r]", key, L["set to"])
		end
		return true
	end
	return false
end

--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--  UTILITY FUNCTIONS
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
-- Returns: string
-- This will return the specific stance or form the player is in
function Wardrobe2:util_GetForm()
	local i,name,form

	for i=1,GetNumShapeshiftForms() do
		_,name,is_active = GetShapeshiftFormInfo(i)
		if is_active then
			form = name
		end
	end
	if (form == nil) then form = "" end
	return form
end

-- Takes: number, number
-- Moves an inventory slot
function Wardrobe2:util_SwapInventoryItem(oNum, dNum)
	if (CursorHasItem()) then return false end
	PickupInventoryItem(dNum)
	PickupInventoryItem(oNum)
end

-- Takes: string
-- Returns: number, number
-- This will return the bag number and slot number of an item in your inventory
function Wardrobe2:util_FindContainerItem(targetItemName)
	local foundBag = nil
	local foundSlot = nil
    
	-- for each bag and slot
	if ( WARDROBE2.SearchDirection == 1 ) then
		bagcounterA = 0
		bagcounterB = NUM_CONTAINER_FRAMES
	else
		bagcounterB = 0
		bagcounterA = NUM_CONTAINER_FRAMES
	end

	for bag = bagcounterA, bagcounterB, WARDROBE2.SearchDirection do
		local frame = getglobal("ContainerFrame"..bag)
		local counterA = 1
		local counterB = 1

		if ( WARDROBE2.SearchDirection == 1 ) then
			counterA = 1
			counterB = GetContainerNumSlots(bag)
		else
			counterB = 1
			counterA = GetContainerNumSlots(bag)
		end
		for slot = counterA, counterB, WARDROBE2.SearchDirection do
			-- get the name of the item in this bag/slot
			bagItemName = GetContainerItemLink(bag, slot)
			-- if it matches what we're looking for
			if (targetItemName == bagItemName) then
				foundBag  = bag
				foundSlot = slot
				break
			end
		end
		if (foundBag and foundSlot) then
			break
		end
	end

	if ( WARDROBE2.SearchDirection == 1 ) then WARDROBE2.SearchDirection = -1 else WARDROBE2.SearchDirection = 1 end
	return foundBag, foundSlot
end

-- Takes: string
-- This will attempt to equip a bag item by name
function Wardrobe2:util_EquipBagItem(name, slotNum)
	if (CursorHasItem()) then return false end
	if (slotNum == 0) then name = self:GetBestMatch(name) end

	local bag, slot = self:util_FindContainerItem(name)
	
	if(bag == nil or slot == nil) then
		return false
	else
		PickupContainerItem(bag, slot)
		if (slotNum < 11 or slotNum == 15 or slotNum == 19) then
			AutoEquipCursorItem()
		else
			EquipCursorItem(slotNum)
		end
		return true
	end
end

-- Takes: number
-- This function wears an outfit by number
function Wardrobe2:util_WearOutfit(number, force, dblcheck, errormsg)
	local freeBagSpacesUsed = Compost:Acquire()
	if (force == nil) then force = false end
	if (dblcheck == nil) then dblcheck = false end
	if (errormsg == nil) then errormsg = false end
	if (WARDROBE2.busy == false and dblcheck == false) then
		WARDROBE2.busy = true
		self.db.profile.current = number
	elseif (WARDROBE2.busy == true and dblcheck == false) then
		self:Print(L["Busy switching outfits"])
		return
	end
	if (WARDROBE2.InCombat == false or force == true) then
		if (not UnitIsGhost("player")) then
			local CurrentInventory = Compost:Acquire()
			self:util_CurrentInventory(CurrentInventory)
			
			ShowCloak(self.db.profile.Outfit[number].cloak)
			ShowHelm(self.db.profile.Outfit[number].helm)

			for i = 1, (table.getn(CurrentInventory)-1) do
				if (self.db.profile.Outfit[number].slot[i] == CurrentInventory[i]) then
					-- slot matches
					--self:Print("Slot %i Matches", i)
				elseif (self.db.profile.Outfit[number].used[i] == false) then
					-- slot not used
					--self:Print("Slot %i Not Used", i)
				elseif (CurrentInventory[i] ~= "empty" and self.db.profile.Outfit[number].slot[i] == "empty") then
					-- bag this item
					if (i == 17 and not(self.db.profile.Outfit[number].slot[16] == "empty" and self.db.profile.Outfit[number].slot[17] == "empty")) then i = 18 end
					PickupInventoryItem(i)
					result, freeBagSpacesUsed = self:util_BagItem(freeBagSpacesUsed)
					if (not result) then
						self:Print(string.format(WARDROBE.ERROR_NOROOM, tmpCurrentOutfit[i]))
					end
				else
					-- grab this item from out bag
					if (self:util_EquipBagItem(self.db.profile.Outfit[number].slot[i], i) == false) then
						-- check if we need to preform a swap
						if (dblcheck == false) then
							-- repeat the search again
							self:ScheduleEvent("repeat", self.util_WearOutfit, 0.7, self, number, true, true, false)
							-- try to swap inventory for this
							if (CurrentInventory[i+1] == self.db.profile.Outfit[number].slot[i]) then self:util_SwapInventoryItem(i, i+1) end
							Compost:Reclaim(CurrentInventory)
							Compost:Reclaim(freeBagSpacesUsed)
							return
						else
							if (errormsg == true) then
								self:Print("%s %s %s", L["Cant find"], self.db.profile.Outfit[number].slot[i], L["in your bags or inventory"])
							else
								self:Print(L["Triple Checking..."])
								-- repeat the search with error messages
								self:ScheduleEvent("repeat2", self.util_WearOutfit, 0.7, self, number, true, true, true)
								Compost:Reclaim(CurrentInventory)
								Compost:Reclaim(freeBagSpacesUsed)
								return
							end
						end
					end
				end
			end
			Compost:Reclaim(CurrentInventory)
		end
	end
	Compost:Reclaim(freeBagSpacesUsed)
	WARDROBE2.busy = false
end

-- Takes: Table, number, number
-- Returns: boolean
-- See if this bag / slot is being used or is free
function Wardrobe2:util_UsedThisSlot(freeBagSpacesUsed, theBag, theSlot)
	for i = 1, table.getn(freeBagSpacesUsed) do
		if (freeBagSpacesUsed[i][1] == theBag and freeBagSpacesUsed[i][2] == theSlot) then
			return true
		end
	end
	return false
end

-- Takes: Table
-- Returns: boolean, Table
-- This will put an item on the character into a free bag slot
function Wardrobe2:util_BagItem(freeBagSpacesUsed)
    -- for each bag and slot
	for theBag = 0, 4, 1 do
		for theSlot = 1, GetContainerNumSlots(theBag), 1 do
			-- get info about the item here
			local texture, itemCount, locked = GetContainerItemInfo(theBag, theSlot)
			-- if we found nothing, add us to the list of free bag slots
			if (not texture and not self:util_UsedThisSlot(freeBagSpacesUsed, theBag, theSlot)) then
				PickupContainerItem(theBag,theSlot)
				table.insert(freeBagSpacesUsed, {theBag, theSlot})
				return true, freeBagSpacesUsed
			end
		end
	end
	AutoEquipCursorItem()
	return false, freeBagSpacesUsed
end

-- Takes: string
-- Returns: string
-- This function returns an itemlink currently on your character to the closest possible match
-- returns nil if none found
function Wardrobe2:util_GetBestMatch(name)
	-- First go through the inventory
	for i = 1, 19 do
		local tmpName = GetInventoryItemLink("player", i)
		_,_,PrintName=string.find(tmpName or "","^.*%[(.*)%].*$")
		if (PrintName ~= nil and string.lower(name) == string.lower(PrintName)) then
			return tmpName
		end
	end
	-- Next go through the bags
	for bag = 0, NUM_CONTAINER_FRAMES, 1 do
		for slot = 1, GetContainerNumSlots(bag), 1 do
			-- get the name of the item in this bag/slot
			bagItemName = GetContainerItemLink(bag, slot)
			_,_,PrintName=string.find(bagItemName or "","^.*%[(.*)%].*$")
			if (PrintName ~= nil and string.lower(name) == string.lower(PrintName)) then
				return bagItemName
			end
		end
	end
    	return nil
end

-- Takes: nil
-- Returns: boolean
-- returns a true if the player is mounted
-- returns a false if the player is not mounted
function Wardrobe2:util_IsPlayerMounted()
	-- Shortcut if we can, but doesn't always catch changes
	if IsMounted() == 1 then
		return true
	end

	for i = 1, 48 do
		local _, _, buff = UnitBuff("player",i)
		if buff then
			if WARDROBE2.problem_mounts[buff] or string.find(buff,"QirajiCrystal_") then
				Wardrobe2Tooltip:SetUnitBuff("player",i)
				if ( string.find(Wardrobe2TooltipTextLeft2:GetText() or "", "^Increases speed") or 
				     string.find(Wardrobe2TooltipTextLeft2:GetText() or "", "^Increases flight speed")) then
					return true
				end
			elseif string.find(buff,"Mount_") then
				return true
			end
		else
			break
		end
	end
	return false
end


function Wardrobe2:util_FreeOutfit()
	for i = 1, (table.getn(self.db.profile.Outfit)+1) do
		if (self.db.profile.Outfit[i] == nil or self.db.profile.Outfit[i].name == nil) then
			return i
		end
	end
end

function Wardrobe2:util_CurrentInventory(tempTBL)
	-- insert the ammo slot stuff here
	table.insert(tempTBL, 0, "Ammo Slot")
	for i = 1, 19 do
		local tmpSlot = GetInventoryItemLink("player", i)
		if (tmpSlot ~= nil) then
			table.insert(tempTBL, i, tmpSlot)
		else
			table.insert(tempTBL, i, "empty")
		end
	end
end
