-- WIM - WhisperSelect
-- This is plugin was created as an example of how to use WIM's plugin API as well
-- as how to use WIM's API.

--some default settings
wpWhisperSelect_Data_DEFAULT = {
	enabled = true,
	friends = true,
	guild = true,
	raid = true,
	custom = true,
	list = {}
};

wpWhisperSelect_List_Selected = "";

--simple localization definition.
wpWhisperSelect_LOCALIZED_OPTIONS_DESC = [[WIM - WhisperSelect is a plugin which gives you the ability
to choose which charcters will be captured by WIM. For example, 
messages from strangers will be displayed shown in the default
chat frame while your friends and acquaintances will be shown 
through WIM.

More information on WIM and WIM - WhisperSelect 
can be found at: |rhttp://www.wimaddon.com
]];

--Call when this plugin is loaded by its associated xml file.
function wpWhisperSelect_OnLoad()
	-- create plugin info table & register with WIM.
	local pluginInfo = {
		version = "1.0.4",
		description = wpWhisperSelect_LOCALIZED_OPTIONS_DESC,
		optionsFrame = wpWhisperSelect_Options
	};
	WIM_RegisterPlugin("WIM - Whisper Select", pluginInfo, "2.1.0");
	
	-- define static dialog for adding characters.
	StaticPopupDialogs["wpWhisperSelect_Add"] = {
		text = "Enter Character Name",
		button1 = "OK",
		button2 = "Cancel",
		hasEditBox = 1;
		timeout = 0,
		whileDead = 1,
		hideOnEscape = 1,
		OnShow = function()
		    				getglobal(this:GetName().."EditBox"):SetText("");
							end,
		OnAccept = function()
    						local theName = WIM_FormatName(getglobal(this:GetParent():GetName().."EditBox"):GetText());
    						theName = string.gsub(theName, " ", "");
    						if(theName ~= "") then
    							wpWhisperSelect_Data.list[theName] = 1;
    							wpWhisperSelect_List_Update();
    						end 
							end
	};
end

-- basic scroll bar update
function wpWhisperSelect_List_Update()
	local line;
	local lineplusoffset;
	local ListNames = {};
	
	if(wpWhisperSelect_Data == nil) then return; end
	if(wpWhisperSelect_Data.list == nil) then wpWhisperSelect_Data.list = {}; end
	
	for key,_ in pairs(wpWhisperSelect_Data.list) do
		table.insert(ListNames, key);
	end
	
	FauxScrollFrame_Update(wpWhisperSelect_OptionsPanelScrollBar,table.getn(ListNames),4,16);
	for line=1,4 do
		lineplusoffset = line + FauxScrollFrame_GetOffset(wpWhisperSelect_OptionsPanelScrollBar);
		if (lineplusoffset <= table.getn(ListNames)) then
			getglobal("wpWhisperSelect_OptionsPanelButton"..line.."Name"):SetText(ListNames[lineplusoffset]);
			getglobal("wpWhisperSelect_OptionsPanelButton"..line).theName = ListNames[lineplusoffset];
			if ( wpWhisperSelect_List_Selected == ListNames[lineplusoffset] ) then
				getglobal("wpWhisperSelect_OptionsPanelButton"..line):LockHighlight();
			else
				getglobal("wpWhisperSelect_OptionsPanelButton"..line):UnlockHighlight();
			end
			getglobal("wpWhisperSelect_OptionsPanelButton"..line):Show();
		else
			getglobal("wpWhisperSelect_OptionsPanelButton"..line):Hide();
		end
	end

end

-- based off of options should whisper be handled by WIM?
function wpWhisperSelect_CanPassToWIM(theUser)
	if(theUser == UnitName("player")) then
		return true;
	elseif(wpWhisperSelect_Data.friends and WIM_FriendList[theUser]) then
		return true;
	elseif(wpWhisperSelect_Data.guild and WIM_GuildList[theUser]) then
		return true;
	elseif(wpWhisperSelect_Data.raid and wpWhisperSelect_isInRaid(theUser)) then
		return true;
	elseif(wpWhisperSelect_Data.custom and wpWhisperSelect_Data.list[theUser]) then	
		return true;
	else
		return false;
	end
end


function wpWhisperSelect_isInRaid(theUser)
	for i=1,4 do
		if(UnitName("party"..i) == theUser) then 
			return true; 
		end
	end
	for i=1,40 do
		if(UnitName("raid"..i) == theUser) then
			return true; 
		end
	end
	return false;
end

-- A hook of WIM_API_Filter - good example of how it should be done.
function wpWhisperSelect_WIM_API_Filter(theMSG, theUser)
	if(wpWhisperSelect_Data.enabled) then
		if(wpWhisperSelect_CanPassToWIM(theUser)) then
			return wpWhisperSelect_WIM_API_Filter_orig(theMSG, theUser);
		else
			return 1;
		end
	else
		return wpWhisperSelect_WIM_API_Filter_orig(theMSG, theUser);
	end
end


-- this hooked function is needed to bypass WIM's operations
function wpWhisperSelect_WIM_PostMessage(user, msg, ttype, from, raw_msg, skipWhoQuery, msgID)
		if(wpWhisperSelect_Data.enabled) then
			user = WIM_FormatName(user);
			if(wpWhisperSelect_CanPassToWIM(user)) then
				wpWhisperSelect_WIM_PostMessage_orig(user, msg, ttype, from, raw_msg, skipWhoQuery, msgID);
			elseif(ttype == 5 and WIM_Windows[user] == nil) then
				chatFrame = DEFAULT_CHAT_FRAME;
				chatFrame.editBox:SetAttribute("chatType", "WHISPER");
				chatFrame.editBox:SetAttribute("tellTarget", user);
				ChatEdit_UpdateHeader(chatFrame.editBox);
				ChatFrame_OpenChat("", chatFrame);
			else
				wpWhisperSelect_WIM_PostMessage_orig(user, msg, ttype, from, raw_msg, skipWhoQuery, msgID);
			end
		else
			wpWhisperSelect_WIM_PostMessage_orig(user, msg, ttype, from, raw_msg, skipWhoQuery, msgID);
		end
end


