﻿
WHDBTT_Mobs = {};
local old_OnTooltipSetUnit = nil;

function WHDBTT_Init()

	if(itemData ~= nil ) then
		this:RegisterEvent("QUEST_LOG_UPDATE");
        old_OnTooltipSetUnit = GameTooltip:GetScript('OnTooltipSetUnit');
        GameTooltip:SetScript('OnTooltipSetUnit', WHDBTT_OnTooltipSetUnit);
		DEFAULT_CHAT_FRAME:AddMessage('WHDB Mob Tooltips loaded');
	else
		DEFAULT_CHAT_FRAME:AddMessage('WHDB Mob Tooltips not found item data');
	end
end

function WHDBTT_Event(event)
	if (event == "QUEST_LOG_UPDATE") then
		WHDBTT_Quest_Log_Update();
	end
end

function WHDBTT_Quest_Log_Update()
    WHDBTT_Mobs = {};
	local numEntries, numQuests = GetNumQuestLogEntries();
	if numEntries > 0 then
		for questid = 1, numEntries do
			local strQuestLogTitleText, strQuestLevel, strQuestTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(questid);
			--DEFAULT_CHAT_FRAME:AddMessage(strQuestLogTitleText);
			
            local numObjectives = GetNumQuestLeaderBoards(questid);
			for i=1, numObjectives, 1 do
				local text, type, finished = GetQuestLogLeaderBoard(i, questid);
                if not finished then 
                    if type == "item" then
                        local i, j, itemName, numItems, numNeeded = strfind(text, "(.*):%s*([%d]+)%s*/%s*([%d]+)");
                        if (itemData[itemName] ~= nil) then
                            local monsterName, monsterDrop;
                            for monsterName, monsterDrop in pairs(itemData[itemName]) do
                                --DEFAULT_CHAT_FRAME:AddMessage('     '..monsterName..' drops '..itemName..' '..monsterDrop..'%');
                                
                                if WHDBTT_Mobs[monsterName] == nil then
                                    WHDBTT_Mobs[monsterName] = {} ;
                                end 
                                if WHDBTT_Mobs[monsterName][strQuestLogTitleText] == nil then 
                                    WHDBTT_Mobs[monsterName][strQuestLogTitleText] = {} ;
                                end
                                WHDBTT_Mobs[monsterName][strQuestLogTitleText][itemName] = {monsterDrop, numItems, numNeeded};
                            end
                        end
                    end
                end
                
			end
		end
		local toolTip = getglobal('GameTooltip');
		if toolTip ~= nil then
            local unit = toolTip:GetUnit();
            if unit ~= nil then
                if toolTip:IsUnit('mouseover') then 
                    toolTip:SetUnit('mouseover'); 
                end
            end
		end
	end
end

function WHDBTT_OnTooltipSetUnit(tooltip, ...)
    local retVal = old_OnTooltipSetUnit(tooltip, ...);
    local name = tooltip:GetUnit();

    if WHDBTT_Mobs[name]~= nil then
        local quest, questItems;
        for quest,questItems in pairs(WHDBTT_Mobs[name]) do
            tooltip:AddLine(' ');
            tooltip:AddLine(quest);
            local questItemName, questItemData;
            for questItemName, questItemData in pairs(questItems) do
                local monsterDrop, numItems, numNeeded = unpack(questItemData);
                tooltip:AddDoubleLine('   '..questItemName..': '..numItems..'/'..numNeeded, monsterDrop..'%', 1,1,1, 1,1,1);
            end
        end
    end
    return retVal;
end
