local L = AceLibrary("AceLocale-2.2"):new("wftotem")

wftotem = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "CandyBar-2.0","AceDB-2.0" )
wftotem:RegisterDB("WFtotemDB","WFtotemDBPC");
wftotem:RegisterDefaults("profile", {
x=0,
y=40,
scale=0.7
} )

local wftot=0;
local airtotems={
["Grace of Air Totem"]=1,
["Nature Resistance Totem"]=1,
["Sentry Totem"]=1,
["Grounding Totem"]=1,
["Windwall Totem"]=1,
["Tranquil Air Totem"]=1,
["Wrath of Air Totem"]=1,
["  "]=1,
["   "]=1,
[" "]=1,
[" "]=1,
["  "]=1,
[" "]=1,
["  "]=1
};

local wftguid=0;
local xres, yres = 0,0;
local options = {};
local playerName=UnitName("player");

function wftotem:OnEnable()
	wftotem:WFtotemSET();
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
--	self:RegisterEvent("CHAT_MSG_SPELL_SELF_BUFF");
--	self:RegisterEvent("CHAT_MSG_COMBAT_FRIENDLY_DEATH");
	wftotem:getscreenres();
	wftotem:setoptions();
	wftotem:RegisterChatCommand("/wftotem", "/WFtotem", options);
end

function wftotem:COMBAT_LOG_EVENT_UNFILTERED(...)
	local timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, _, spname = select(1, ...);
-- local srcName = select(4, ...);

local message = format("%s> %s, %s, %s, %s, %s, %s, %s",
	                       timestamp, eventtype,
	                       srcGUID, srcName or "nil", srcFlags or "nil",
	                       dstGUID, dstName or "nil", dstFlags or "nil");
	for i = 9, select("#", ...) do
		message = message..", "..(select(i, ...) or "nil");
	end
	if (eventtype=="SPELL_SUMMON" and srcName==playerName) then
		if (spname==L["Windfury Totem"])	then
			wftotem:CancelAllScheduledEvents();
			wftguid=dstGUID;
			local down, up, lag = GetNetStats();
			wftotem:StopCandyBar("WFtotemBAR");
			wftotem:StartCandyBar("WFtotemBAR");
			wftot=GetTime();
			wftotem:ScheduleEvent(self.rebuff,2*lag/1000,self);
--			wftotem:checkbuff();
		else
			if (spname==L["Grace of Air Totem"]) then
				wftotem:destroy();
			end
			if (spname==L["Nature Resistance Totem"]) then
				wftotem:destroy();
			end
			if (spname==L["Sentry Totem"]) then
				wftotem:destroy();
			end
			if (spname==L["Grounding Totem"]) then
				wftotem:destroy();
			end
			if (spname==L["Windwall Totem"]) then
				wftotem:destroy();
			end
			if (spname==L["Tranquil Air Totem"]) then
			wftotem:destroy();
			end
			if (spname==L["Wrath of Air Totem"]) then
				wftotem:destroy();
			end
--		else 
--			DEFAULT_CHAT_FRAME:AddMessage(spname);
		end
--		DEFAULT_CHAT_FRAME:AddMessage(spname.." summond!");
	elseif (eventtype=="SPELL_ENERGIZE" and srcName==playerName and spname==L["Totemic Call"]) then
		wftotem:destroy();
	elseif (eventtype=="UNIT_DIED" and dstGUID==wftguid) then
		wftotem:destroy();
--		DEFAULT_CHAT_FRAME:AddMessage(message);
	end
end

function wftotem:checkbuff()
	local hasMainHandEnchant, mainHandExpiration, mainHandCharges, hasOffHandEnchant, offHandExpiration, offHandCharges = GetWeaponEnchantInfo(); 
	DEFAULT_CHAT_FRAME:AddMessage("Buff "..mainHandExpiration);
end

function wftotem:destroy()
	wftot=0;
	wftotem:StopCandyBar("WFtotemBAR");
	wftotem:StopCandyBar("WFtotrebuffBAR");
	wftotem:CancelAllScheduledEvents();
end

function wftotem:rebuff()
	local reg, t, e, r = wftotem:CandyBarStatus("WFtotemBAR");
	if (r) then
		local down, up, lag = GetNetStats();
		wftotem:StopCandyBar("WFtotrebuffBAR");
		wftotem:StopCandyBar("WFtotfadeBAR");
		wftotem:ScheduleEvent(self.rebuff,5,self);
		wftotem:StartCandyBar("WFtotrebuffBAR");
		wftotem:StartCandyBar("WFtotfadeBAR");
--	DEFAULT_CHAT_FRAME:AddMessage("test");
--	wftotem:checkbuff();
	end
end

function wftotem:WFtotemSET()
	wftotem:RegisterCandyBarGroup("WFtotcandy");
	wftotem:SetCandyBarGroupPoint("WFtotcandy", "CENTER", "UIParent", "CENTER",wftotem.db.profile.x,wftotem.db.profile.y);
	wftotem:RegisterCandyBar("WFtotrebuffBAR",5,"Rebuff");
	wftotem:SetCandyBarColor("WFtotrebuffBAR","green",0.5);
	wftotem:SetCandyBarScale("WFtotrebuffBAR", wftotem.db.profile.scale);
	wftotem:RegisterCandyBarWithGroup("WFtotrebuffBAR","WFtotcandy");
	wftotem:RegisterCandyBar("WFtotfadeBAR",10,"Fade");
	wftotem:SetCandyBarColor("WFtotfadeBAR","green",0.5);
	wftotem:SetCandyBarScale("WFtotfadeBAR", wftotem.db.profile.scale);
	wftotem:RegisterCandyBarWithGroup("WFtotfadeBAR","WFtotcandy");
	wftotem:RegisterCandyBar("WFtotemBAR",120,"Totem");
	wftotem:SetCandyBarColor("WFtotemBAR","green",0.5);
	wftotem:SetCandyBarScale("WFtotemBAR", wftotem.db.profile.scale);
	wftotem:RegisterCandyBarWithGroup("WFtotemBAR","WFtotcandy");
end

function wftotem:getscreenres()
	local xyres=GetCVar("gxResolution");
	xres, yres=strsplit("x",xyres);
	xres=tonumber(xres);
	yres=tonumber(yres);
	-- DEFAULT_CHAT_FRAME:AddMessage(xres.." "..yres);
end

function wftotem:setoptions()
	options = { 
	    type='group',
	    args = {
	        x = {
	            type = 'range',
	            name = 'x',
	            desc = 'Change X coord of WFtotem timer',
	            min = (-1)*xres/2,
				max = xres/2,
				step = 1,
				get = "GetX",
	            set = "SetX",
	        },
			y = {
	            type = 'range',
	            name = 'y',
	            desc = 'Change Y coord of WFtotem timer',
	            min = (-1)*yres/2,
				max = yres/2,
				step = 1,
				get = "GetY",
	            set = "SetY",
	        },
			wfscale = {
	            type = 'range',
	            name = 'scale',
	            desc = 'Change Scale of WFtotem timer',
	            min = 0.3,
				max = 3,
				step = 0.1,
				get = "GetScale",
	            set = "SetScale",
	        }
	    }
	}
end

function wftotem:GetX()
    return wftotem.db.profile.x
end

function wftotem:SetX(newValue)
	wftotem.db.profile.x = newValue;
	wftotem:SetCandyBarGroupPoint("WFtotcandy", "CENTER", "UIParent", "CENTER",wftotem.db.profile.x,wftotem.db.profile.y);
	wftotem:StopCandyBar("WFtotfadeBAR");
	wftotem:StartCandyBar("WFtotfadeBAR");
end

function wftotem:GetY()
    return wftotem.db.profile.y
end

function wftotem:SetY(newValue)
	wftotem.db.profile.y = newValue;
	wftotem:SetCandyBarGroupPoint("WFtotcandy", "CENTER", "UIParent", "CENTER",wftotem.db.profile.x,wftotem.db.profile.y);
	wftotem:StopCandyBar("WFtotfadeBAR");
	wftotem:StartCandyBar("WFtotfadeBAR");
end

function wftotem:GetScale()
    return wftotem.db.profile.scale
end

function wftotem:SetScale(newValue)
	wftotem.db.profile.scale = newValue;
	wftotem:SetCandyBarScale("WFtotrebuffBAR", wftotem.db.profile.scale);
	wftotem:SetCandyBarScale("WFtotfadeBAR", wftotem.db.profile.scale);
	wftotem:SetCandyBarScale("WFtotemBAR", wftotem.db.profile.scale);
	wftotem:StopCandyBar("WFtotfadeBAR");
	wftotem:StartCandyBar("WFtotfadeBAR");
end