
VUHDO_VERSION = "1.0 RC#3";

VUHDO_VERSION_CONFIG = 1;
VUHDO_VERSION_PANELS = 1;
VUHDO_VERSION_BUFFS = 2;
VUHDO_VERSION_PROFILES = VUHDO_VERSION_CONFIG + VUHDO_VERSION_PANELS;

VUHDO_YES = 1;
VUHDO_NO = 2;

VUHDO_MAX_PANELS = 10;        -- Maximum number of Panels, change in VuhDoPanel.XML accordingly
VUHDO_MAX_BUTTONS_PANEL = 51; -- Maximum Number of Buttons per Panel, change in VuhDoPanel.XML accordingly
VUHDO_MAX_GROUPS_PER_PANEL = 15; -- Maximum number of Models (Groups) per Panel
VUHDO_RELOAD_RAID_DELAY = 2; -- Seconds to wait before reloading raid after "PARTY_MEMBERS_CHANGED" etc.
VUHDO_RELOAD_RAID_DELAY_QUICK = 0.2; -- Seconds to wait before reloading raid quickly after raid changed in fight etc.

VUHDO_MAX_MTS = 8;

-- Heal panel operation modes
VUHDO_MODE_NEUTRAL = 1;  -- HealBot Style look, bars will turn from greenisch to reddish along with life loss (standard)
VUHDO_MODE_EMERGENCY_PERC = 2; -- Top emergency mode, least life percent left (standard raid healing)
VUHDO_MODE_EMERGENCY_MOST_MISSING = 3; -- Top emergency mode, least most life missing (for spamming greater heals, MTs preffered)
VUHDO_MODE_EMERGENCY_LEAST_LEFT = 4; -- -- Top emergency mode, least life left (for raid healing when cyclic ae damage on whole raid)

-- Group model types
VUHDO_ID_TYPE_UNDEFINED = 0;
VUHDO_ID_TYPE_CLASS = 1;
VUHDO_ID_TYPE_GROUP = 2;
VUHDO_ID_TYPE_SPECIAL = 3;


VUHDO_ID_TYPE_NAMES = {
  [VUHDO_ID_TYPE_UNDEFINED] = VUHDO_I18N_UNDEFINED,
  [VUHDO_ID_TYPE_CLASS] = VUHDO_I18N_CLASS,
  [VUHDO_ID_TYPE_GROUP] = VUHDO_I18N_GROUP,
  [VUHDO_ID_TYPE_SPECIAL] = VUHDO_I18N_SPECIAL
};


-- Group Model IDs
VUHDO_ID_UNDEFINED = 0;

VUHDO_ID_GROUP_1 = 1;
VUHDO_ID_GROUP_2 = 2;
VUHDO_ID_GROUP_3 = 3;
VUHDO_ID_GROUP_4 = 4;
VUHDO_ID_GROUP_5 = 5;
VUHDO_ID_GROUP_6 = 6;
VUHDO_ID_GROUP_7 = 7;
VUHDO_ID_GROUP_8 = 8;

VUHDO_ID_WARRIORS = 20;
VUHDO_ID_ROGUES = 21;
VUHDO_ID_HUNTERS = 22;
VUHDO_ID_PALADINS = 23;
VUHDO_ID_MAGES = 24;
VUHDO_ID_WARLOCKS = 25;
VUHDO_ID_SHAMANS = 26;
VUHDO_ID_DRUIDS = 27;
VUHDO_ID_PRIESTS = 28;
VUHDO_ID_DEATH_KNIGHT = 29;

VUHDO_ID_PETS = 40;
VUHDO_ID_MAINTANKS = 41;
VUHDO_ID_MAINASSIST = 42;
--VUHDO_ID_MELEES = 43;
--VUHDO_ID_HEALERS = 44;
--VUHDO_ID_RANGED = 45;

VUHDO_ID_ALL = 999;


--VUHDO_SKILL_TYPE_UNDETERMINDED = 0;
--VUHDO_SKILL_TYPE_MELEE = 1;
--VUHDO_SKILL_TYPE_RANGED = 2;
--VUHDO_SKILL_TYPE_HEALER = 2;


--
-- Members of member types
--
VUHDO_ID_TYPE_MEMBERS = { };
-- To ensure yet undefined units wont lead to crash
VUHDO_ID_TYPE_MEMBERS[VUHDO_ID_TYPE_UNDEFINED] = {
};

VUHDO_ID_TYPE_MEMBERS[VUHDO_ID_TYPE_GROUP] = {
  VUHDO_ID_GROUP_1,
  VUHDO_ID_GROUP_2,
  VUHDO_ID_GROUP_3,
  VUHDO_ID_GROUP_4,
  VUHDO_ID_GROUP_5,
  VUHDO_ID_GROUP_6,
  VUHDO_ID_GROUP_7,
  VUHDO_ID_GROUP_8
};

VUHDO_ID_TYPE_MEMBERS[VUHDO_ID_TYPE_CLASS] = {
  VUHDO_ID_WARRIORS,
  VUHDO_ID_ROGUES,
  VUHDO_ID_HUNTERS,
  VUHDO_ID_PALADINS,
  VUHDO_ID_MAGES,
  VUHDO_ID_WARLOCKS,
  VUHDO_ID_SHAMANS,
  VUHDO_ID_DRUIDS,
  VUHDO_ID_PRIESTS,
  VUHDO_ID_DEATH_KNIGHT
};

VUHDO_ID_TYPE_MEMBERS[VUHDO_ID_TYPE_SPECIAL] = {
	VUHDO_ID_MAINTANKS,
	VUHDO_ID_MAINASSIST,
	VUHDO_ID_PETS
};



-- Flags for panel ordering type
VUHDO_ORDERING_STRICT = 0;
VUHDO_ORDERING_LOOSE = 1;



-- sorting criterions within panel
VUHDO_SORT_RAID_UNITID = 0;
VUHDO_SORT_RAID_NAME = 1;
VUHDO_SORT_RAID_MAX_HEALTH = 2;


-- Class IDs by class name
VUHDO_CLASS_IDS = {
	["WARRIOR"] = VUHDO_ID_WARRIORS,
	["ROGUE"] = VUHDO_ID_ROGUES,
	["HUNTER"] = VUHDO_ID_HUNTERS,
	["PALADIN"] = VUHDO_ID_PALADINS,
	["MAGE"] = VUHDO_ID_MAGES,
	["WARLOCK"] = VUHDO_ID_WARLOCKS,
	["SHAMAN"] = VUHDO_ID_SHAMANS,
	["DRUID"] = VUHDO_ID_DRUIDS,
	["PRIEST"] = VUHDO_ID_PRIESTS,
	["DEATH KNIGHT"] = VUHDO_ID_DEATH_KNIGHT,
};


-- Class names by class ID
VUHDO_ID_CLASSES = {
	[VUHDO_ID_WARRIORS] = "WARRIOR",
	[VUHDO_ID_ROGUES] = "ROGUE",
	[VUHDO_ID_HUNTERS] = "HUNTER",
	[VUHDO_ID_PALADINS] = "PALADIN",
	[VUHDO_ID_MAGES] = "MAGE",
	[VUHDO_ID_WARLOCKS] = "WARLOCK",
	[VUHDO_ID_SHAMANS] = "SHAMAN",
	[VUHDO_ID_DRUIDS] = "DRUID",
	[VUHDO_ID_PRIESTS] = "PRIEST",
	[VUHDO_ID_DEATH_KNIGHT] = "DEATH KNIGHT",
};



-- Class IDs by class name
VUHDO_CLASS_NAMES_ORDERED = {
	"WARRIOR",
	"ROGUE",
	"HUNTER",
	"PALADIN",
	"MAGE",
	"WARLOCK",
	"SHAMAN",
	"DRUID",
	"PRIEST",
	"DEATH KNIGHT"
};



-- Action button assignent constant values
VUHDO_SPELL_KEY_ASSIST = "assist";
VUHDO_SPELL_KEY_FOCUS = "focus";
VUHDO_SPELL_KEY_TARGET = "target";
VUHDO_SPELL_KEY_MENU = "menu";
VUHDO_SPELL_KEY_TELL = "tell";



-- Action button text Coloring
VUHDO_TEXT_STYLE_COLOR_FIX = 1;
VUHDO_TEXT_STYLE_COLOR_CLASS = 2;



-- Health bar color falloff
VUHDO_GUI_BAR_COLOR_FALLOFF_CALM = 0;      -- Linear fallof: calm color impression
VUHDO_GUI_BAR_COLOR_FALLOFF_VIVID = 1; -- Exponential fallof (^2) more vivid, drastic color impression


-- Types of updating unit status by event
VUHDO_UPDATE_ALL = 1;
VUHDO_UPDATE_HEALTH = 2;
VUHDO_UPDATE_HEALTH_MAX = 3;
VUHDO_UPDATE_DEBUFF = 4;
VUHDO_UPDATE_RANGE = 5;
VUHDO_UPDATE_POWER = 6;
VUHDO_UPDATE_POWER_MAX = 7;
VUHDO_UPDATE_TARGET = 8;
VUHDO_UPDATE_INC = 9;


-- Unit power types (== Blizzard defined types)
VUHDO_UNIT_POWER_MANA = 0;
VUHDO_UNIT_POWER_RAGE = 1;
VUHDO_UNIT_POWER_FOCUS = 2;
VUHDO_UNIT_POWER_ENERGY = 3;
VUHDO_UNIT_POWER_HAPPINESS = 4;
VUHDO_UNIT_POWER_RUNE = 6;


-- Prefixes for communication with other addons
VUHDO_CHAT_PREFIX_CTRA = "CTRA";
VUHDO_CHAT_PREFIX_HEAL_COMM = "HealComm";
VUHDO_CHAT_DISTRIBUTION_RAID = "RAID";


-- Resurection spells by class
VUHDO_RESURRECTION_SPELLS = {
	["PALADIN"] = VUHDO_I18N_REDEMPTION,
	["SHAMAN"] = VUHDO_I18N_ANCESTRAL_SPIRIT,
	["DRUID"] = VUHDO_I18N_REBIRTH,
	["PRIEST"] = VUHDO_I18N_RESURRECTION
};


VUHDO_BG_ZONES = {
	[VUHDO_I18N_ZONE_ALTERAC] = true,
	[VUHDO_I18N_ZONE_WARSONG] = true,
	[VUHDO_I18N_ZONE_ARATHI] = true,
	[VUHDO_I18N_ZONE_EYE] = true
};



VUHDO_DEFAULT_PROFILE = "Default";



VUHDO_PROFILE_TYPE_UNDEFINED = 0;
VUHDO_PROFILE_TYPE_BG = 1;
VUHDO_PROFILE_TYPE_RAID = 2;
VUHDO_PROFILE_TYPE_PARTY = 3;
VUHDO_PROFILE_TYPE_SOLO = 4;
