--
VUHDO_BUFF_REMOVAL_SPELLS = {
	["WARRIOR"] = nil,
	["ROGUE"] = nil,
	["HUNTER"] = nil,
	["PALADIN"] = nil,
	["MAGE"] = VUHDO_I18N_SPELLSTEAL,
	["WARLOCK"] = nil,
	["SHAMAN"] = VUHDO_I18N_PURGE,
	["DRUID"] = nil,
	["PRIEST"] = VUHDO_I18N_DISPEL_MAGIC,
	["DEATH KNIGHT"] = nil,
}


-- Definition of buff impact types
VUHDO_BUFF_TARGET_SELF = 1;
VUHDO_BUFF_TARGET_SINGLE = 2;
VUHDO_BUFF_TARGET_UNIQUE = 3;
VUHDO_BUFF_TARGET_OWN_GROUP = 4;
VUHDO_BUFF_TARGET_GROUP = 5;
VUHDO_BUFF_TARGET_CLASS = 6;
VUHDO_BUFF_TARGET_TOTEM = 7;
VUHDO_BUFF_TARGET_AURA = 8;
VUHDO_BUFF_TARGET_HOSTILE = 8;



--
VUHDO_GROUPS_BUFFS = {
 [VUHDO_BUFF_TARGET_OWN_GROUP] = true,
 [VUHDO_BUFF_TARGET_GROUP] = true,
 [VUHDO_BUFF_TARGET_CLASS] = true,
 [VUHDO_BUFF_TARGET_TOTEM] = true,
 [VUHDO_BUFF_TARGET_AURA] = true,
};


-- Add here if a players buff name differes from buff spell name
VUHDO_BUFF_BUFF_IRREGUALAR_NAMES = {
};



--
-- Buffs per Class
-- Class => BUff-disjunctive-Group => Buff-Overwriting-Group => BuffName, Target, Duration, Cooldown
--
VUHDO_CLASS_BUFFS = {
	-- Priest
	["PRIEST"] = {
		[VUHDO_I18N_BUFFC_FORTITUDE] = {
			{
				{ VUHDO_I18N_BUFF_PRAYER_OF_FORTITUDE, VUHDO_BUFF_TARGET_GROUP, 60 * 60, 0 },
				{ VUHDO_I18N_BUFF_POWER_WORD_FORTITUDE, VUHDO_BUFF_TARGET_SINGLE, 30 * 60, 0 },
			}
		},
		[VUHDO_I18N_BUFFC_SHADOW_PROTECTION] = {
			{
				{ VUHDO_I18N_BUFF_PRAYER_OF_SHADOW_PROTECTION, VUHDO_BUFF_TARGET_GROUP, 60 * 60, 0 },
				{ VUHDO_I18N_BUFF_SHADOW_PROTECTION, VUHDO_BUFF_TARGET_SINGLE, 30 * 60, 0 },
			}
		},
		[VUHDO_I18N_BUFFC_SPIRIT] = {
			{
				{ VUHDO_I18N_BUFF_DIVINE_SPIRIT, VUHDO_BUFF_TARGET_SINGLE, 30 * 60, 0 },
				{ VUHDO_I18N_BUFF_PRAYER_OF_SPIRIT, VUHDO_BUFF_TARGET_GROUP, 60 * 60, 0 },
			}
		},
		[VUHDO_I18N_BUFFC_FEAR_WARD] = {
			{
				{ VUHDO_I18N_BUFF_FEAR_WARD, VUHDO_BUFF_TARGET_UNIQUE, 3 * 60, 3 * 60 },
			}
		},
		[VUHDO_I18N_BUFFC_INNER_FIRE] = {
			{
				{ VUHDO_I18N_BUFF_INNER_FIRE, VUHDO_BUFF_TARGET_SELF, 10 * 60, 0 },
			}
		},
		[VUHDO_I18N_BUFFC_SHADOW_SHIELD] = {
			{
				{ VUHDO_I18N_BUFF_SHADOWGUARD, VUHDO_BUFF_TARGET_SELF, 10 * 60, 0 },
			}
		},
		[VUHDO_I18N_BUFFC_SHADOW_FIEND] = {
			{
				{ VUHDO_I18N_BUFF_SHADOWFIEND, VUHDO_BUFF_TARGET_HOSTILE, 10 * 60, 0 },
			}
		},
	},

	-- Shaman
	["SHAMAN"] = {
		[VUHDO_I18N_BUFFC_FIRE_TOTEM] = {
			{
				{ VUHDO_I18N_BUFF_FIRE_NOVA_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_FLAMETONGUE_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_SEARING_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_FIRE_ELEMENTAL_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 20 * 60 },
			},
			{
				{ VUHDO_I18N_BUFF_FROST_RESISTANCE_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_MAGMA_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
		},
		[VUHDO_I18N_BUFFC_AIR_TOTEM] = {
			{
				{ VUHDO_I18N_BUFF_GROUNDING_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_WINDWALL_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_TRANQUIL_AIR_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_GRACE_OF_AIR_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_NATURE_RESISTANCE_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_WINDFURY_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_WRATH_OF_AIR_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
		},
		[VUHDO_I18N_BUFFC_EARTH_TOTEM] = {
			{
				{VUHDO_I18N_BUFF_EARTHBIND_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_STRENGTH_OF_EARTH_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_STONESKIN_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_STONECLAW_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_EARTH_ELEMENTAL_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 20 * 60 },
			},
			{
				{ VUHDO_I18N_BUFF_TREMOR_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_SENTRY_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
		},
		[VUHDO_I18N_BUFFC_WATER_TOTEM] = {
			{
				{ VUHDO_I18N_BUFF_POISON_CLEANSING_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_DISEASE_CLEANSING_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_MANA_SPRING_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_FIRE_RESISTANCE_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_HEALING_STREAM_TOTEM, VUHDO_BUFF_TARGET_TOTEM, 0, 0 },
			},
		},
		[VUHDO_I18N_BUFFC_MANA_TIDE] = {
			{
				{ VUHDO_I18N_BUFF_MANA_TIDE, VUHDO_BUFF_TARGET_TOTEM, 0, 6 * 60 },
			},
		},
		[VUHDO_I18N_BUFFC_HEROISM] = {
			{
				{ VUHDO_I18N_BUFF_HEROISM, VUHDO_BUFF_TARGET_OWN_GROUP, 40, 10 * 60},
			},
		},
		[VUHDO_I18N_BUFFC_BLOODLUST] = {
			{
				{ VUHDO_I18N_BUFF_BLOODLUST, VUHDO_BUFF_TARGET_OWN_GROUP, 40, 10 * 60},
			},
		},
		[VUHDO_I18N_BUFFC_EARTH_SHIELD] ={
			{
				{ VUHDO_I18N_BUFF_EARTH_SHIELD, VUHDO_BUFF_TARGET_UNIQUE, 10 * 60, 0 },
			},
		},
		[VUHDO_I18N_BUFFC_WEAPON_ENCHANT] = {
			{
				{ VUHDO_I18N_BUFF_FLAMETONGUE_WEAPON, VUHDO_BUFF_TARGET_SELF, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_ROCKBITER_WEAPON,  VUHDO_BUFF_TARGET_SELF, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_FROSTBRAND_WEAPON,  VUHDO_BUFF_TARGET_SELF, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_WINDFURY_WEAPON,  VUHDO_BUFF_TARGET_SELF, 0, 0 },
			},
		},
		[VUHDO_I18N_BUFFC_SHIELDS] = {
			{
				{ VUHDO_I18N_BUFF_LIGHTNING_SHIELD, VUHDO_BUFF_TARGET_SELF, 10 * 60, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_WATER_SHIELD,  VUHDO_BUFF_TARGET_SELF, 10 * 60, 0 },
			},
		},
	},
	-- Lol, we're Pally, hic!
	["PALADIN"] = {
		[VUHDO_I18N_BUFFC_BLESSING] = {
			{
				{ VUHDO_I18N_BUFF_GREATER_BLESSING_OF_WISDOM, VUHDO_BUFF_TARGET_CLASS, 30 * 60, 0 },
				{ VUHDO_I18N_BUFF_BLESSING_OF_WISDOM, VUHDO_BUFF_TARGET_SINGLE, 15 * 60, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_GREATER_BLESSING_OF_MIGHT, VUHDO_BUFF_TARGET_CLASS, 30 * 60, 0 },
				{ VUHDO_I18N_BUFF_BLESSING_OF_MIGHT, VUHDO_BUFF_TARGET_SINGLE, 15 * 60, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_GREATER_BLESSING_OF_SALVATION, VUHDO_BUFF_TARGET_CLASS, 30 * 60, 0 },
				{ VUHDO_I18N_BUFF_BLESSING_OF_SALVATION, VUHDO_BUFF_TARGET_SINGLE, 15 * 60, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_GREATER_BLESSING_OF_LIGHT, VUHDO_BUFF_TARGET_CLASS, 30 * 60, 0 },
				{ VUHDO_I18N_BUFF_BLESSING_OF_LIGHT, VUHDO_BUFF_TARGET_SINGLE, 15 * 60, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_GREATER_BLESSING_OF_SANCTUARY, VUHDO_BUFF_TARGET_CLASS, 30 * 60, 0 },
				{ VUHDO_I18N_BUFF_BLESSING_OF_SANCTUARY, VUHDO_BUFF_TARGET_SINGLE, 15 * 60, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_GREATER_BLESSING_OF_THE_KINGS, VUHDO_BUFF_TARGET_CLASS, 30 * 60, 0 },
				{ VUHDO_I18N_BUFF_BLESSING_OF_THE_KINGS, VUHDO_BUFF_TARGET_SINGLE, 15 * 60, 0 },
			},
		},
		[VUHDO_I18N_BUFFC_RIGHTEOUS_FURY] = {
			{
				{ VUHDO_I18N_BUFF_RIGHTEOUS_FURY, VUHDO_BUFF_TARGET_SELF, 30 * 60, 0 },
			},
		},
		[VUHDO_I18N_BUFFC_AURA] = {
			{
				{ VUHDO_I18N_BUFF_DEVOTION_AURA, VUHDO_BUFF_TARGET_AURA, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_RETRIBUTION_AURA, VUHDO_BUFF_TARGET_AURA, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_CONCENTRATION_AURA, VUHDO_BUFF_TARGET_AURA, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_SANCTITY_AURA, VUHDO_BUFF_TARGET_AURA, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_SHADOW_RESISTANCE_AURA, VUHDO_BUFF_TARGET_AURA, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_FROST_RESISTANCE_AURA, VUHDO_BUFF_TARGET_AURA, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_FIRE_RESISTANCE_AURA, VUHDO_BUFF_TARGET_AURA, 0, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_CRUSADER_AURA, VUHDO_BUFF_TARGET_AURA, 0, 0 },
			},
		}
	},

	-- Druid
	["DRUID"] = {
		[VUHDO_I18N_BUFFC_INNERVATE] = {
			{
				{ VUHDO_I18N_BUFF_INNERVATE, VUHDO_BUFF_TARGET_SINGLE, 0, 6 * 60 },
			},
		},
		[VUHDO_I18N_BUFFC_TRANQUILITY] = {
			{
				{ VUHDO_I18N_BUFF_TRANQUILITY, VUHDO_BUFF_OWN_GROUP, 0, 10 * 60 },
			},
		},
		[VUHDO_I18N_BUFFC_GIFT_OF_THE_WILD] = {
			{
				{ VUHDO_I18N_BUFF_MARK_OF_THE_WILD, VUHDO_BUFF_TARGET_SINGLE, 30 * 60, 0 },
				{ VUHDO_I18N_BUFF_GIFT_OF_THE_WILD, VUHDO_BUFF_TARGET_GROUP, 60 * 60, 0 },
			},
		},
		[VUHDO_I18N_BUFFC_REBIRTH] = {
			{
				{ VUHDO_I18N_BUFF_REBIRTH, VUHDO_BUFF_TARGET_SINGLE, 0, 20 * 60 },
			},
		},
	},

	-- Warlock
	["WARLOCK"] = {
		[VUHDO_I18N_BUFFC_SOULSTONE] = {
			{
				{ VUHDO_I18N_BUFF_CREATE_SOULSTONE, VUHDO_BUFF_TARGET_SINGLE, 0, 30 * 60 },
			},
		},

		[VUHDO_I18N_BUFFC_SKIN] = {
			{
				{ VUHDO_I18N_BUFF_DEMON_SKIN, VUHDO_BUFF_TARGET_SELF, 30 * 60, 0 },
			},
			{
				{ VUHDO_I18N_BUFF_FEL_ARMOR, VUHDO_BUFF_TARGET_SELF, 30 * 60, 0 },
			},
		},
	},

	-- Mage
	["MAGE"] = {
		[VUHDO_I18N_BUFFC_ARCANCE_BRILLIANCE] = {
			{
				{ VUHDO_I18N_BUFF_ARCANE_BRILLIANCE, VUHDO_BUFF_TARGET_GROUP, 60 * 60, 0 },
				{ VUHDO_I18N_BUFF_ARCANE_INTELLECT, VUHDO_BUFF_TARGET_SINGLE, 30 * 60, 0 },
			}
		},
		[VUHDO_I18N_BUFFC_ICE_BLOCK] = {
			{
				{ VUHDO_I18N_BUFF_ICE_BLOCK, VUHDO_BUFF_TARGET_SELF, 0, 5 * 60 },
			},
		},
		[VUHDO_I18N_BUFFC_INVISIBILITY] = {
			{
				{ VUHDO_I18N_BUFF_INVISIBILITY, VUHDO_BUFF_TARGET_SELF, 20, 5 * 60 },
			}
		},
	},
};



