local AceOO = AceLibrary("AceOO-2.0")
local VisualThemes = VisualThemes
local L = VisualThemes:GetLocaleTable()

local ITheme = AceOO.Interface{
	Theme = "function", --params: frame object
	Detheme = "function", --params: frame object
	IsCompatible = "function", --pararams: frame name; return: bool isCompat, string reasonIfNot
	Name = "string", --property
	OnInitialize = "function",
	OnEnable = "function",
	OnDisable = "function"
}

VisualThemes:RegisterInterface("ITheme", ITheme)

local Theme = AceOO.Class(ITheme, "AceEvent-2.0", "AceHook-2.1", "AceDB-2.0")
local ThemeProto = Theme.prototype


VisualThemes:RegisterClass("Theme", Theme) --register the class with the core


function ThemeProto:init(name)
	if type(name) ~= "string" then
		error(L["Theme name must be a string"], 2)
	end
	if VisualThemes:HasTheme(name) then
		error(L["Theme with name %q already exists"]:format(name), 2)
	end
	Theme.super.prototype.init(self)
	--VisualThemes:Debug("Initializing Theme: %s", name)
	VisualThemes:RegisterTheme(name, self)
	self.Name = name
end

ThemeProto.Name = L["<Not Initialized>"]

function ThemeProto:Theme(frame)
	error(L["%q doesn't implement method %q"]:format(self.Name, ":Theme()"), 2)
end

function ThemeProto:Detheme(frame)
	error(L["%q doesn't implement method %q"]:format(self.Name, ":DeTheme()"), 2)
end

function ThemeProto:IsCompatible(frame)
	return false, L["%q doesn't implement method %q"]:format(self.Name, ":IsCompatible()")
end

function ThemeProto:OnInitialize()
	
end
function ThemeProto:OnEnable()
	
end
function ThemeProto:OnDisable()
	
end