VisualThemes = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceDB-2.0", "AceConsole-2.0", "AceHook-2.1", "FuBarPlugin-2.0")
local VisualThemes = VisualThemes

local L = setmetatable({}, 
{
	__index = function(t, k)
		if type(k) == "string" then
			VisualThemes:Print("Translation for %q is not registered, please translate.", k)
			t[k] = k
			return k
		end
	end,
})
function VisualThemes:GetLocaleTable()
	return L
end
local currentLocale = GetLocale()
function VisualThemes:RegisterTranslations(locale, ...)
	if locale == currentLocale then
		for i=1, select("#", ...), 2 do
			local k, v = select(i, ...)
			if type(k) == "string" and (type(v) == "string" or v == true) then
				L[k] = v == true and k or v
			end
		end
	end
end