--requires an incredible amount of work to get what's needed from dewdrop
--this small object handles everything necessary
local L = VisualThemes:GetLocaleTable()
local DewdropThemer = AceLibrary("AceOO-2.0").Classpool("AceHook-2.1"):new()

local VisualThemes = VisualThemes

--since we embed dewdrop it's safe to assume we have it
local dewdrop = AceLibrary("Dewdrop-2.0")

local Slider, EditBox --these are two unnamed frames created when dewdrop needs them
local HookInitialButtons --used to hook the intitial level's buttons

function DewdropThemer:Open(...)
	self.hooks[dewdrop].Open(...) --let dewdrop create the first frame
	VisualThemes:RegisterFrames(L["Dewdrop Dropdowns"], 0, "Dewdrop20Level1") --register it
	HookInitialButtons() --hook the buttons
	HookInitialButtons = nil --no longer need this function
	self:Unhook(dewdrop, "Open") --no longer need this to be hooked since all new hooks will be created in OnEnter of each button
end


local watch
--hooked CreateFrame function that is only active when dewdrop is creating new buttons, the editbox, or the slider
local function watch_CreateFrame(kind, name, parent)
	if watch then
		if kind == "Slider" then --only one slider is created by dewdrop, capture it and theme it
			Slider = parent
			VisualThemes:RegisterFrames(L["Dewdrop Dropdowns"], 0, Slider)
		elseif kind == "EditBox" then --two editboxes are created by dewdrop, lets make sure its the right one
			if not Slider or Slider ~= parent then --one is created immediately after the slider, make sure its not that one
				EditBox = parent
				VisualThemes:RegisterFrames(L["Dewdrop Dropdowns"], 0, EditBox)
			end
		elseif name then --dewdrop only names buttons and level frames
			if name:match("Dewdrop20Level") then --if its a level frame send it up to be themed
				local frame = _G[name]
				frame:Hide()
				VisualThemes:RegisterFrames(L["Dewdrop Dropdowns"], 0, name)
				frame:Show()
			end
		end
	end
end
hooksecurefunc("CreateFrame", watch_CreateFrame)
function DewdropThemer:OnEnter(frame, ...)
	--start watching our hook
	watch = true
	self.hooks[frame].OnEnter(frame, ...)
	watch = false
end

do
	local i = 1
	HookInitialButtons = function() --sets up the initial index
		local frame = _G["Dewdrop20Button"..i]
		while frame do
			self:HookScript(frame, "OnEnter")
			i = i + 1
			frame = _G["Dewdrop20Button"..i]
		end
	end
	function DewdropThemer:AddLine(...) --new buttons get created in AddLine, hook them as needed
		self.hooks[dewdrop].AddLine(...)

		local frame = _G["Dewdrop20Button"..i]
		while frame do
			self:HookScript(frame, "OnEnter")
			i = i + 1
			frame = _G["Dewdrop20Button"..i]
		end
	end
end



DewdropThemer:Hook(dewdrop, "Open") --used for the very first frame hook
DewdropThemer:Hook(dewdrop, "AddLine")