local L = VisualThemes:GetLocaleTable()

VisualThemes:RegisterAddOnFunc("Baggins", function(self)
	--hook the CreateBagFrame method to catch when new bags are created
	self:Hook(Baggins, "CreateBagFrame", function(obj, bagid, ...)
		self.hooks[obj].CreateBagFrame(obj, bagid, ...)
		--following the original functions lead
		if not bagid then
			return
		end

		local bag = _G["BagginsBag"..bagid] --see if the bag was created
		if not bag then return end --get out if not


		self:RegisterFrames(L["Baggins"], 0, bag:GetName())
		--lets deal with layout changes
		self:HookScript(bag, "OnHide", function(frame, ...) --when the bag fully hides tell baggins to update the layout
			self.hooks[frame].OnHide(frame, ...)
			if self:IsEnabled() and not self:IsGroupDisabled(L["Baggins"]) and self:IsThemed(bag) then
				obj:UpdateLayout()
				if BagginsSearch then --if Baggins_Search is in use then tell it to hide it's search pane (if needed) when this hides
					BagginsSearch:UpdateEditBoxPosition()
				end
			end
		end)		
	end)
end)