VisualMail = LibStub("AceAddon-3.0"):NewAddon("VisualMail", "AceConsole-3.0", "AceEvent-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("VisualMail")
local AceConfig = LibStub("AceConfig-3.0")
local AceConfigDialog = LibStub("AceConfigDialog-3.0")

local defaults = {
   profile = {
      playsounds = true,
      scale = 1.0,
      left = nil,
      top = nil,
      strata = BACKGROUND,
   }
}

local options = {
   type = "group",
   name = "VisualMail",
   args = {
   	config = {
			type = "execute",
			name = L["Open GUI"],
			desc = L["Opens the configuration panel"],
         guiHidden = true,
			func = function()
				InterfaceOptionsFrame:Hide()
            AceConfigDialog:SetDefaultSize("VisualMail", 400, 200)
				AceConfigDialog:Open("VisualMail")
			end
		},
      sound = {
         type = "toggle",
         name = L["Use Sound"],
         desc = L["Play a sound when mail is received"],
         order = 1,
         get = function() return VisualMail.db.profile.playsounds end,
         set = function(info,v) VisualMail.db.profile.playsounds = v end,
      },
      scale = {
         type = 'range',
         name = L["Scale"],
         desc = L["Set the icon scale"],
         order = 2,
         min = 0,
         max = 5,
         step = 0.025,
         get = function() return VisualMail.db.profile.scale end,
         set = function(info,v) VisualMail.db.profile.scale=v VisualMail.frame:SetScale(v) end,
      },
      strata = {
         type = 'select',
         name = L["Strata"],
         desc = L["Changes the mail icon strata in case it gets above or behind other frames"],
         values = {
            BACKGROUND="BACKGROUND",
            LOW="LOW",
            MEDIUM="MEDIUM",
            HIGH="HIGH",
            DIALOG="DIALOG",
            TOOLTIP="TOOLTIP",
         },
         get = function() return VisualMail.db.profile.strata end,
         set = function(info,v) VisualMail.db.profile.strata=v VisualMail.frame:SetFrameStrata(v) end,         
         style = 'dropdown',
         order = 3,
      },
      reset = {
         type = 'execute',
         name = L["Reset icon"],
         desc = L["Resets the mail icon position and scale in case you can't see it"],
         order = 4,
         func = function()
            VisualMail.db.profile.top = nil
            VisualMail.db.profile.left = nil
            VisualMail.db.profile.scale = 1.0
            VisualMail:Update()
         end
      }
   }
}

AceConfig:RegisterOptionsTable("VisualMail", options, "visualmail")

local files = {
	iconnomail = "Interface\\AddOns\\VisualMail\\nomail.tga",
	iconnew = "Interface\\AddOns\\VisualMail\\newmail.tga",
   soundpath = "Interface\\AddOns\\VisualMail\\mail.wav",
}

function VisualMail:OnInitialize()
   self.db = LibStub("AceDB-3.0"):New("VisualMailDB", defaults, "Default")
   AceConfigDialog:AddToBlizOptions("VisualMail", "VisualMail")
end

function VisualMail:OnEnable()
	self:RegisterEvent("UPDATE_PENDING_MAIL")
   
   self.frame = CreateFrame("Frame",nil,UIParent)
   self.frame:SetFrameStrata("BACKGROUND")
   self.frame:SetWidth(16)
   self.frame:SetHeight(16)
   
   self.texture = self.frame:CreateTexture(nil,"BACKGROUND")
   self.texture:SetTexture(files['iconnomail'])
   self.texture:SetAllPoints(self.frame)

   self.frame:RegisterForDrag("LeftButton")
   self.frame:SetMovable(true)
   self.frame:EnableMouse(true)
   self.frame:SetScript("OnDragStart",function() VisualMail:DragStart() end)
   self.frame:SetScript("OnDragStop",function() VisualMail:DragStop() end)
   
   self.frame:SetFrameStrata(self.db.profile.strata)

   self.frame:Show()   
   
   self:Update()   
end

function VisualMail:DragStart()
   self.frame:StartMoving()
   self.isMoving = true
end

function VisualMail:DragStop()
   self.db.profile.top = self.frame:GetTop() 
   self.db.profile.left = self.frame:GetLeft()
   self.frame:StopMovingOrSizing()
   self.isMoving = false
   self:Update()
end

function VisualMail:UPDATE_PENDING_MAIL()
   if(HasNewMail()) then
      self.texture:SetTexture(files['iconnew'])
      self:Print("You have new mail!")
      if self.db.profile.playsounds then PlaySoundFile(files.soundpath) end
   else
      self.texture:SetTexture(files['iconnomail'])
   end
end

function VisualMail:Update()
   if self.db.profile.top and self.db.profile.left then 
      self.frame:SetPoint("TOP",UIParent,"BOTTOM",0,self.db.profile.top)
      self.frame:SetPoint("LEFT",UIParent,"LEFT",self.db.profile.left,0) 
   else 
      self.frame:SetPoint("CENTER",UIParent,"CENTER")
   end
   VisualMail.frame:SetScale(self.db.profile.scale)
end

function VisualMail:OnDisable()
   self:UnregisterEvent("UPDATE_PENDING_MAIL")
   self.frame:Hide()
end
   