if not Violation then return end 
-----------------------------------------------------------------------
-- Locale
-----------------------------------------------------------------------
local L = AceLibrary("AceLocale-2.2"):new("Violation: Healing")

L:RegisterTranslations("enUS", function() return {
	["Healing done"] = true,
	["H"] = true,
} end)

L:RegisterTranslations("zhCN", function() return {
	["Healing done"] = "治疗输出",
	["H"] = "治疗输出(H)",
} end)

L:RegisterTranslations("zhTW", function() return {
	["Healing done"] = "造成治療",
	["H"] = "造成治療(H)",
} end)

L:RegisterTranslations("koKR", function() return {
	["Healing done"] = "치유량",
} end)

L:RegisterTranslations("frFR", function() return {
	["Healing done"] = "Soins prodigués",
	["H"] = "S",
} end)

-----------------------------------------------------------------------
-- Locals
-----------------------------------------------------------------------

local moduleName = "Healing done"

-----------------------------------------------------------------------
-- Module declaration
-----------------------------------------------------------------------

local mod = Violation:NewModule(moduleName, "AceEvent-2.0")
mod.revision = tonumber(("$Revision: 463 $"):sub(12, -3)) or 1
mod.version = 6
mod.violationCategory = "healing"

-----------------------------------------------------------------------
-- Module initialization
-----------------------------------------------------------------------

function mod:OnModuleEnable()
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED", "OnEvent")
end

-----------------------------------------------------------------------
-- Module implementation
-----------------------------------------------------------------------

function mod:GetDisplayName() return L["Healing done"] end
function mod:GetShortDisplayName() return L["H"] end

local function getOverheal(unit, amount)
	if unit and UnitExists(unit) then
		local d = UnitHealthMax(unit) - UnitHealth(unit)
		if d < amount then
			return amount - d
		end
	end
	return 0
end

function mod:OnEvent(timestamp, eventType, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, spellId, spellName, spellSchool, amount, critical)
	if (eventType ~= "SPELL_HEAL" and eventType ~= "SPELL_PERIODIC_HEAL") or not Violation:ShouldAccept(srcFlags) then
		return
	end
	if amount and amount > 0 then
		self:OnData(Violation:GetReferenceGUID(srcGUID, srcFlags), amount - getOverheal(dstName, amount))
	end
end

