--[[
	Task for selling an item.
	
	Copyright (C) Udorn (Blackhand)
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.	
--]]

local AceOO = AceLibrary("AceOO-2.0");
local L = AceLibrary("AceLocale-2.2"):new("Vendor");
vendor.SellTask = AceOO.Class();

--[[
	Sells a stack of the given size and returns whether the operation
	succeeded.
--]]
local function _Sell(self, stackSize)
	-- ensure that the auction slot is free, just in case...
	ClearCursor();
	ClickAuctionSellItemButton();
	ClearCursor();
	-- try to get stack
	local rtn = false;
	local bag, slot = self.inventoryHandle:PickupItemStack(self.itemLink, stackSize); 
	if (bag) then
		ClickAuctionSellItemButton();
		StartAuction(self.minBidPerItem * stackSize, self.buyoutPerItem * stackSize, self.runTime);
		ClickAuctionSellItemButton();
		rtn = not CursorHasItem();
		if (not rtn) then
			vendor.Vendor:Error(L["Failed to sell item"]);
		else
			-- wait for the item to disappear from the bag
			self.inventoryHandle:WaitForEmptySlot(bag, slot, GetTime() + 7);
		end
		ClearCursor();
	end
	return rtn;
end

--[[
	Constructor.
	@param backlog number of items to sell, if all stacks where sold.
--]]
function vendor.SellTask.prototype:init(inventoryHandle, itemLink, minBidPerItem, buyoutPerItem, runTime, stackSize, numStacks, backlog)
	vendor.SellTask.super.prototype.init(self);
	self.inventoryHandle = inventoryHandle;
	self.itemLink = itemLink;
	self.minBidPerItem = minBidPerItem;
	self.buyoutPerItem = buyoutPerItem;
	self.runTime = runTime;
	self.stackSize = stackSize;
	self.numStacks = numStacks;
	self.backlog = backlog;
end

--[[
	Method to execute the task.
--]]
function vendor.SellTask.prototype:Run()
	for i = 1, self.numStacks do
		_Sell(self, self.stackSize);
	end
	if (self.backlog and self.backlog > 0) then
		_Sell(self, self.backlog);
	end
end
