--[[
	Some helpers for handling the GUI.
	
	Copyright (C) Udorn (Blackhand)
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.	
--]]

vendor.GuiTools = {};

--[[
	Shows the given frame as a modal dialog. The call will return after the frame
	has closed again. Will function for calls outside of coroutines. 
--]]
function vendor.GuiTools.ShowModal(frame)
	frame:Show();
	local co = coroutine.create(function() task:Run() end);
	while (true) do
		if (frame:IsShown()) then
			coroutine.yield(); -- continue waiting
		else
			return;
		end
	end	
end

--[[
	Creates a button and sets the specified parameters accordingly.
--]]
function vendor.GuiTools.CreateButton(parent, template, width, height, text, tooltipText)
	local bt = CreateFrame("Button", nil, parent, template);
	bt:SetText(text);
	bt:SetWidth(width);
	bt:SetHeight(height);
	vendor.GuiTools.AddFadingTooltip(bt, tooltipText);
	return bt;
end

--[[
	Adds a fading tooltip to the given gui elemnt.
--]]
function vendor.GuiTools.AddFadingTooltip(obj, tooltipText)
	obj.fadeTask = vendor.FadeTask:new(obj, tooltipText);
	obj:SetScript("OnEnter", function() this.fadeTask:Init(); vendor.TaskQueue:AddTask(this.fadeTask); end);
	obj:SetScript("OnLeave", function() this.fadeTask:Cancel(); GameTooltip:Hide(); end);	
end
