--[[
	Helper for fading in GameTooltip messages.
	
	Copyright (C) Udorn (Blackhand)
	
	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.	
--]]

local AceOO = AceLibrary("AceOO-2.0");
vendor.FadeTask = AceOO.Class();

--[[
	Creates a new instance of the task for the given button.
--]]
function vendor.FadeTask.prototype:init(bt, tooltipText)
	vendor.FadeTask.super.prototype.init(self);
	self.bt = bt;
	self.tooltipText = tooltipText;
	self.isCancelled = false; 
end

--[[
	Method to execute the task.
--]]
function vendor.FadeTask.prototype:Run()
	if (vendor.Vendor.db.profile.useTooltips) then
		fadeStart = GetTime() + vendor.Vendor.db.profile.tooltipFadeTime;
		while (not self.isCancelled) do
			if (GetTime() >= fadeStart) then
				GameTooltip:SetOwner(self.bt, "ANCHOR_RIGHT"); GameTooltip:SetText(self.tooltipText);
				break;
			else
				coroutine.yield(); 
			end
		end
	end
end

--[[
	Cancels the task, the tooltip won't be faded in.
--]]
function vendor.FadeTask.prototype:Cancel()
	self.isCancelled = true;
end

--[[
	Reactivates a FadeTask for reusage.
--]]
function vendor.FadeTask.prototype:Init()
	self.isCancelled = false;
end
