
--[[
Name: PeriodicTable-2.0
Revision: $Rev: 24154 $
Author: Tekkub Stoutwrithe (tekkub@gmail.com)
Credits: nymbia
Website: http://www.wowace.com/
Description: Optimized itemid database
Dependencies: AceLibrary
]]


local vmajor, vminor = "PeriodicTable-2.0", "$Revision: 24154 $"

if not AceLibrary then error(vmajor .. " requires AceLibrary.") end
if not AceLibrary:IsNewVersion(vmajor, vminor) then return end

local lib = {}


-- Activate a new instance of this library
function activate(self, oldLib, oldDeactivate)
	if oldLib then
		self.vars, self.k = oldLib.vars, oldLib.k
	else
		self.vars, self.k = {numcustoms = 0}, {}
	end

	if oldDeactivate then oldDeactivate(oldLib) end
end


-----------------------------
--      Module Loadup      --
-----------------------------

function lib:AddModule(name, table)
	assert(name, "No module name passed")
	assert(table, "No module dataset passed")

	self.k[name] = table
	self.vars.cache = {}
end


--------------------------------
--      Internal Methods      --
--------------------------------

function lib:CacheSet(set)
	if not set then return end

	local rset = self:GetSet(set)
	if not rset or type(rset) ~= "string" then return end

	if not self.vars.cache then self.vars.cache = {} end
	if not self.vars.cache[set] then
		self.vars.cache[set] = {}
		for word in string.gmatch(rset, "%S+") do
			local _, _, id, val = string.find(word, "(%d+):(%d+)")
			id, val = tonumber(id) or tonumber(word), tonumber(val) or 0
			self.vars.cache[set][id] = val
		end
	end

	return true
end


function lib:GetID(item)
	if type(item) == "number" then return item
	elseif type(item) == "string" then
		local _, _, id = string.find(item, "item:(%d+):%d+:%d+:%d+")
		if id then return tonumber(id) end
	end
end


function lib:GetSet(set)
	if not set then return end
	for i,vals in pairs(self.k) do if vals[set] then return vals[set] end end
end


function lib:GetSetModule(set)
	if not set then return end
	for i,vals in pairs(self.k) do if vals[set] then return i end end
end


function lib:GetSetString(set)
	if type(set) == "string" then
		return
	elseif type(set) == "table" then
		local retval
		for i,val in pairs(set) do
			if type(i) == "number" then
				local valstr = (val > 0) and string.format("%s:%s", i, val) or tostring(i)
				retval = retval and string.format("%s %s", retval, valstr) or valstr
			end
		end

		return retval
	end
end


---------------------------
--      API Methods      --
---------------------------

function lib:ItemInSet(item, set)
	local item = self:GetID(item)
	if not item then return end

	if type(set) == "string" then
		local rset = self:GetSet(set)
		if rset and type(rset) == "string" then
			local t = self:GetSetTable(set)
			if t and t[item] then return t[item], set, set end
		elseif type(rset) == "table" then
			for _,s in pairs(rset) do
				local retval, _, atom = self:ItemInSet(item, s)
				if retval then return retval, s, atom end
			end
		end
	elseif type(set) == "table" then
		for i,s in pairs(set) do
			local retval, _, atom = self:ItemInSet(item, s)
			if retval then return retval, s, atom end
		end
	end
end


function lib:ItemInSets(item, sets)
	local item = self:GetID(item)
	if not item then return end

	if type(sets) == "string" then
		local rset = self:GetSet(sets)
		if type(rset) == "string" then
			local inset = self:ItemInSet(item, sets)
			if inset then return {sets} end
		elseif type(rset) == "table" then
			return self:ItemInSets(item, rset)
		end
	elseif type(sets) == "table" then
		local founds

		for i,s in pairs(sets) do
			if self:ItemInSet(item, s) then
				if not founds then founds = {} end
				table.insert(founds, s)
			end
		end

		return founds
	end
end


local iterbag, iterslot, iterset, iterself
local function iter()
	if iterslot > GetContainerNumSlots(iterbag) then iterbag, iterslot = iterbag + 1, 1 end
	if iterbag > 4 then return end

	for b=iterbag,4 do
		for s=iterslot,GetContainerNumSlots(b) do
			iterslot = s + 1

			local link = GetContainerItemLink(b,s)
			local val = link and iterself:ItemInSet(link, iterset)
			if val then return b, s, val end
		end

		iterbag, iterslot = b+1, 1
	end
end


function lib:BagIter(set)
	if not set then return end

	iterself, iterbag, iterslot, iterset = self, 0, 1, set
	return iter
end


local defaultcomparefunc = function(abag, aslot, aval, bbag, bslot, bval) return aval > bval end
local defaultvalidatefunc = function(bag, slot, val) return true end
function lib:GetBest(set, comparefunc, validatefunc)
	comparefunc = comparefunc or defaultcomparefunc
	validatefunc = validatefunc or defaultvalidatefunc
	local ibag, islot, ival

	for bag,slot,val in self:BagIter(set) do
		if validatefunc(bag,slot,val) and (not ival or comparefunc(bag, slot, val, ibag, islot, ival)) then
				ibag, islot, ival = bag, slot, val
		end
	end
	return ibag, islot, ival
end


-- Does not work with Multi Sets
function lib:GetSetTable(set)
	if self:CacheSet(set) then return self.vars.cache[set] end
end


-- Get the superset
-- Works with Multi Sets
function lib:GetMultiSetTable(set)
	local setTable, cacheSet
	if type(set) == "string" then
		local rset = self:GetSet(set)
		if rset and type(rset) == "string" then
			setTable = self:GetSetTable(set)
		elseif type(rset) == "table" then
			setTable = {}
			for _, s in pairs(rset) do
				cacheSet = self:GetMultiSetTable(s)
				for itemId, value in pairs(cacheSet) do
					setTable[itemId] = value
				end
			end
		end
	elseif type(set) == "table" then
		setTable = {}
		for _, s in pairs(set) do
			cacheSet = self:GetMultiSetTable(s)
			for itemId, value in pairs(cacheSet) do
				setTable[itemId] = value
			end
		end
	end

	return setTable
end


function lib:RegisterCustomSet(setcode, name)
	local setname = name or "customset"..self.vars.numcustoms
	if not setcode then return end
	if self:GetSetModule(setname) then return end

	self.k.customsets = self.k.customsets or {}
	self.k.customsets[setname] = setcode
	if not name then self.vars.numcustoms = self.vars.numcustoms + 1 end
	return setname
end


--------------------------------
--      Load this bitch!      --
--------------------------------
AceLibrary:Register(lib, vmajor, vminor, activate)


--------------------------------
--        Module Start        --
--------------------------------

do
--pretend there's a tab here!
local vmajor = "PeriodicTable-CoreData-2.0"

if not AceLibrary then error(vmajor .. " requires AceLibrary.") end
if not AceLibrary:HasInstance("PeriodicTable-2.0") then error(vmajor .. " requires PeriodicTable-2.0.") end
if not AceLibrary:IsNewVersion(vmajor, vminor) then return end
--------------------------------
--      Load this bitch!      --
--------------------------------
AceLibrary:Register({}, vmajor, vminor)
AceLibrary("PeriodicTable-2.0"):AddModule(vmajor, {
-- Ammo
	-- Value == DPS*10 (to make it an int)
	["Ammo"]		= {"Ammo - Arrows", "Ammo - Bullets", "Ammo - Thrown"},
	["Ammo - Arrows"]	= "31737:500 12654:200 30611:385 24412:370 3464:95 19316:165 9399:115 24417:260 18042:175 28056:320 11285:130 3030:75 2512:15 2515:35 28053:220",
	["Ammo - Bullets"]	= "31735:500 23773:370 30612:385 13377:205 11630:180 3465:95 23772:260 10512:125 19317:165 10513:150 15997:175 11284:130 8068:45 8067:20 8069:85 4960:20 2519:35 28060:220 28061:320 2516:15 5568:40 3033:75",
	["Ammo - Thrown"]	= "28319:792 28659:736 29204:634 29211:593 13173:355 28972:391 27631:546 28258:666 27916:644 27929:534 27928:534 28535:482 28544:609 30599:554 29212:486 28531:441 28543:600 20086:300 25878:336 29203:364 28534:476 28538:524 28542:585 28536:491 30227:556 28539:538 28541:568 3463:176 28408:204 28532:456 30568:554 29201:109 29584:106 29202:227 28537:509 28533:465 2946:30 25872:44 29014:322 3111:10 25861:33 3137:117 25875:138 15326:183 25876:217 3108:117 29009:139 29013:322 3107:63 25873:84 25874:102 28979:34 3135:63 29008:84 2947:10 3131:30 29007:47 15327:183 29010:217 5379:21",

	-- Value == Poison level capable of curing
	["Anti-Venom"] = "6452:25 6453:35 13462:60 2633:60 19440:60 12586:60 9030:60 3386:60",
-- Arcanum
	["Arcanum"] = {"Arcanum - Focus", "Arcanum - Protection", "Arcanum - Rapidity", "Arcanum - Constitution", "Arcanum - Resilience", "Arcanum - Rumination", "Arcanum - Tenacity", "Arcanum - Voracity"},
	["Arcanum - Focus"]		= "18333 18335 14344 12753",
	["Arcanum - Protection"]	= "18334 18335 14344 12735",
	["Arcanum - Rapidity"]		= "18332 18335 14344 12938",
	["Arcanum - Constitution"]	= "11754 8411 11733 11952",
	["Arcanum - Resilience"]	= "11754 11567 11751 11736",
	["Arcanum - Rumination"]	= "11754 11752 8424 11732",
	["Arcanum - Tenacity"]		= "11754 11734 11564 11753",
	["Arcanum - Voracity"]		= "11754 11737 11951 11563",

	-- Value == General quality
	["Argent Dawn Commission"] = "12846:1 13209:2 19812:2 23206:3 23207:3",
-- AQ Mats
	-- Ahn'Qiraj items by type
	["AQ - Quest Items"] = {"AQ - Scarabs", "AQ - AQ20 Idols", "AQ - AQ40 Idols", "AQ - AQ20 Tokens", "AQ - AQ40 Tokens"},
	["AQ - Scarabs"]		= "20858 20859 20860 20861 20862 20863 20864 20865",
	["AQ - AQ20 Idols"]		= "20866 20867 20868 20869 20870 20871 20872 20873",
	["AQ - AQ40 Idols"]		= "20874 20875 20876 20877 20878 20879 20881 20882",
	["AQ - AQ20 Tokens"]		= "20884 20885 20886 20888 20889 20890",
	["AQ - AQ40 Tokens"]		= "20926 20927 20928 20929 20930 20931 20932 20933",
	["AQ - AQ Sets"]		= {"AQ - AQ20 Sets", "AQ - AQ40 Sets"},
	["AQ - AQ20 Sets"]		= {"ItemMats - Symbols of Unending Life", "ItemMats - Trappings of the Unseen Path", "ItemMats - Trappings of Vaulted Secrets", "ItemMats - Battlegear of Eternal Justice", "ItemMats - Finery of Infinite Wisdom", "ItemMats - Emblems of Veiled Shadows", "ItemMats - Gift of the Gathering Storm", "ItemMats - Implements of Unspoken Names", "ItemMats - Battlegear of Unyielding Strength"},
	["AQ - AQ40 Sets"]		= {"ItemMats - Genesis Raiment", "ItemMats - Striker's Garb", "ItemMats - Enigma Vestments", "ItemMats - Avenger's Battlegear", "ItemMats - Garments of the Oracle", "ItemMats - Deathdealer's Embrace", "ItemMats - Stormcaller's Garb", "ItemMats - Doomcaller's Attire", "ItemMats - Conqueror's Battlegear"},
-- Bags
	-- Value == bag size
	["Bags"]			= {"Bags - Normal", "Bags - Ammo", "Bags - Quiver", "Bags - Soul Shard", "Bags - Herb", "Bags - Enchanting", "Bags - Engineering"},
	["Bags - Normal"]		= "14156:18 27680:18 19914:18 21876:20 22679:18 10959:16 30744:14 21843:18 14155:16 21841:16 23852:8 17966:18 20400:16 4500:16 11742:16 5765:10 856:8 4498:8 3343:8 22571:6 19291:14 918:10 23389:4 11324:14 932:10 3233:8 5573:8 5764:10 4241:8 1729:10 11845:4 4497:10 4499:12 6756:6 3914:14 5081:6 804:10 5576:10 5575:10 1725:12 857:10 933:10 4238:6 10050:12 22976:4 1470:10 1537:4 4957:6 3352:10 2657:8 5762:6 10051:12 5763:8 14046:14 5571:6 828:6 4496:6 5572:6 805:6 4245:10 6446:10 1652:12 20474:4 9587:14 1685:14 5574:8 2082:6 4240:8",
	["Bags - Special"]		= {"Bags - Ammo", "Bags - Quiver", "Bags - Soul Shard", "Bags - Herb", "Bags - Enchanting", "Bags - Engineering", "Bags - Jewelcrafting", "Bags - Mining"},
	["Bags - Ammo"]			= "19320:16 29118:18 3604:12 7372:14 2663:16 8218:16 3574:10 2102:6 7279:8 5441:8",
	["Bags - Quiver"]		= "18714:18 29143:18 19319:16 29144:18 7371:14 8217:16 3605:12 2662:16 3573:10 7278:8 2101:6 11362:10 5439:8",
	["Bags - Soul Shard"]		= "21342:28 21872:28 21341:24 22244:16 22243:12 21340:20",
	["Bags - Herb"]			= "22251:20 22250:12 22252:24",
	["Bags - Enchanting"]		= "21858:28 22249:24 22246:16 22248:20 30748:20",
	["Bags - Engineering"]		= "23774:24 30745:20",
	["Bags - Jewelcrafting"]	= "24270:24 30747:20",
	["Bags - Mining"]		= "30746:20 29540:28",
-- Bandages
	-- Value == Total health recovered
	["Bandages"]			= {"Bandages - General", "Bandages - Alterac Valley", "Bandages - Arathi Basin", "Bandages - Warsong Gulch"},
	["Bandages - General"]		= "2581:114 8545:1104 21991:3400 14530:2000 6451:640 3531:301 1251:66 8544:800 21990:2800 14529:1360 6450:400 3530:161",
	["Bandages - Alterac Valley"]	= "19307:2000",
	["Bandages - Arathi Basin"]	= "20232:1104 20234:2000 20235:640 20237:1104 20243:2000 20244:640",
	["Bandages - Warsong Gulch"]	= "19067:1104 19066:2000 19068:640",

	["Battleground Tokens"]		= "20558 20559 20560 29024",

	-- Gets you drunk! Not all items here are consumables ~~~~ Value == alchohol content
	["Booze"]				= "21171:3 21721:5 2593:10 2594:20 2595:20 2596:10 2686:5 2723:5 2894:5 3703:10 4595:20 4600:20 744:20 9260:20 9360:20 9361:50 11846:10 12003:50 1262:20 17048:20 17196:5 17198:10 17402:20 17403:10 18269:20 18284:20 18287:10 18288:20 19221:50 19222:5 21151:20 21114:10 20709:10 30615:20",
-- CraftedBy
	-- Value == Skill Level
	["CraftedBy"]					= {"CraftedBy - Alchemy", "CraftedBy - Blacksmith", "CraftedBy - Engineering", "CraftedBy - Leatherworking", "CraftedBy - Tailoring", "CraftedBy - Cooking", "CraftedBy - First Aid"},
	["CraftedBySpecialty"]				= {"CraftedBy - Tailoring", "CraftedBy - Leatherworking General", "CraftedBy - Leatherworking Dragonscale", "CraftedBy - Leatherworking Elemental", "CraftedBy - Leatherworking Tribal", "CraftedBy - First Aid", "CraftedBy - Engineering General", "CraftedBy - Engineering Gnome", "CraftedBy - Engineering Goblin", "CraftedBy - Cooking", "CraftedBy - Alchemy", "CraftedBy - Blacksmith General", "CraftedBy - Armorsmith", "CraftedBy - Axesmith", "CraftedBy - Hammersmith", "CraftedBy - Swordsmith", "CraftedBy - Weaponsmith"},
	["CraftedBy - Alchemy"]				= "2454:1 5997:1 118:1 3382:15 2455:25 2456:40 4596:50 2457:50 2458:50 858:55 5631:60 2459:60 6370:80 6662:90 5996:90 3383:90 6051:100 6372:100 929:110 3384:110 3386:120 3385:120 3388:125 3389:130 6371:130 6048:135 6373:140 3390:140 3391:150 5634:150 1710:155 3827:160 6049:165 3823:165 3824:165 3825:175 5633:175 3826:180 8949:185 17708:190 6050:190 6052:190 3828:195 8951:195 10592:200 3829:200 6149:205 8956:205 9061:210 9036:210 18294:215 4623:215 3928:215 3577:225 6037:225 9149:225 9144:225 12190:230 9154:230 9155:235 9179:235 9172:235 9197:240 9187:240 9088:240 9206:245 9210:245 9224:250 9233:250 21546:250 9264:250 3387:250 13423:250 13442:255 13443:260 13445:265 13447:270 7078:275 12360:275 12803:275 7080:275 7076:275 7076:275 7080:275 7082:275 12808:275 13453:275 20002:275 20007:275 13446:275 13452:280 13455:280 13454:285 20008:285 13462:285 9030:285 13461:290 13457:290 13456:290 13458:290 13459:290 20004:290 13444:295 19931:300 28103:300 13513:300 13511:300 13506:300 13512:300 13510:300 18253:300 28102:300 7068:300 28100:300 22823:305 22824:305 22825:310 28101:310 28104:315 22826:315 22827:320 22828:320 31080:325 22830:325 22829:325 22831:330 31679:335 22871:335 22832:340 22834:345 22833:345 25867:350 23571:350 25868:350 21884:350 21885:350 22452:350 22451:350 22839:350 22835:350 22838:350 22837:350 22840:355 31677:360 22845:360 22841:360 22842:360 22844:360 22846:360 22848:365 22849:365",
	["CraftedBy - Blacksmith"]			= {"CraftedBy - Blacksmith General", "CraftedBy - Armorsmith", "CraftedBy - Axesmith", "CraftedBy - Hammersmith", "CraftedBy - Swordsmith", "CraftedBy - Weaponsmith"},
	["CraftedBy - Blacksmith General"]		= "2853:1 2852:1 10421:1 2862:1 3239:1 2844:15 2845:20 3469:20 2847:25 3470:25 7955:30 7166:30 3488:35 3471:35 2851:35 3472:40 3473:45 3474:60 2863:65 3240:65 6214:65 3489:70 2857:70 3478:75 2864:80 2854:90 3487:95 6350:95 3848:100 6731:100 15869:100 29201:100 6338:100 2865:105 2866:105 2848:110 3480:110 5540:115 2849:115 2868:120 2850:120 3490:125 3481:125 7956:125 3486:125 2871:125 3241:125 3491:130 3482:130 2869:130 7957:130 3483:135 7958:135 5541:140 2870:145 3484:145 3492:145 15870:150 3485:150 11128:150 7071:150 6042:150 3842:155 10423:155 3851:155 7914:160 7913:160 3840:160 3849:160 3835:165 6043:165 3852:170 3843:170 3836:170 7915:175 3841:175 3850:175 3844:180 7916:180 12259:180 3853:180 7917:185 3855:185 3846:185 6040:185 17704:190 3837:190 12260:190 6041:190 3845:195 3854:200 3847:200 3856:200 7963:200 15871:200 29202:200 9060:200 7966:200 7964:200 7965:200 11144:200 9366:205 7919:205 7918:205 7941:210 7921:210 7920:210 7924:215 7967:215 7922:215 7942:220 7927:220 7926:220 7938:225 7928:225 7945:230 7930:230 7931:230 7954:235 7933:235 7932:235 7969:235 7944:240 7961:245 7939:245 7934:245 7946:245 7959:250 12405:250 12406:250 12644:250 12404:250 12643:250 7947:255 12408:255 30069:260 30071:260 30073:260 30072:260 7960:260 30070:260 12416:260 11608:265 12424:265 12428:265 12624:270 11606:270 12425:270 12415:270 11607:275 12774:275 15872:275 12773:275 12645:275 16206:275 12777:280 12776:280 11605:280 12775:280 12409:280 12410:280 11604:285 12628:285 12781:285 12418:285 12782:290 12631:290 19051:290 19043:290 12419:290 12792:290 17014:295 16989:295 12632:295 12426:295 12427:295 12417:295 19166:300 22194:300 19167:300 19168:300 20039:300 19164:300 19148:300 17013:300 19170:300 16988:300 22671:300 22669:300 22670:300 12641:300 22198:300 12640:300 19169:300 22191:300 22384:300 22383:300 12639:300 17193:300 22196:300 22385:300 12798:300 12790:300 12784:300 19690:300 19692:300 19691:300 17016:300 17015:300 20550:300 20549:300 20551:300 19693:300 19694:300 19695:300 12618:300 12620:300 12619:300 12797:300 19057:300 12796:300 12783:300 22197:300 19048:300 12636:300 22764:300 22762:300 22763:300 22195:300 12794:300 12633:300 18262:300 29203:300 12422:300 12429:300 12420:300 12613:300 12611:300 12612:300 12614:300 12610:300 12414:300 25843:300 23528:300 28420:300 23493:305 23484:305 23482:305 23491:310 23497:310 23494:315 23498:315 23487:315 23488:315 23490:320 23499:320 23502:325 23489:325 23559:325 30093:330 30074:330 30089:330 30088:330 30086:330 30087:330 30076:330 30077:330 23503:330 23504:330 23506:335 23508:335 23505:335 23507:340 23575:340 28483:350 28437:350 28425:350 28428:350 28434:350 23563:350 28431:350 28440:350 29204:350 23515:350 23529:350 28421:350 25844:350 25521:350 23510:355 23511:355 23516:355 23509:360 23517:360 23518:360 23514:360 23530:360 23537:365 23539:365 23538:365 23555:365 23554:365 23542:365 23546:365 23531:365 23540:365 23543:365 23532:365 23556:365 23535:365 23541:365 23536:365 23544:365 23533:365 23534:365 23512:365 23519:365 23513:365 23520:365 23522:370 28432:375 28427:375 28426:375 28436:375 28484:375 28485:375 28441:375 28438:375 28439:375 23565:375 31369:375 31371:375 31370:375 28429:375 28430:375 28435:375 28442:375 23564:375 28433:375 31364:375 31368:375 31367:375 25845:375 23576:375",
	["CraftedBy - Armorsmith"]			= "7938:225 7939:245 30069:260 30070:260 12624:270 11604:285 12628:285 12631:290 17014:295 16989:295 12632:295 20039:300 19164:300 19148:300 17013:300 16988:300 12641:300 12640:300 12639:300 22385:300 12618:300 12620:300 12619:300 12636:300 12633:300 30074:330 30076:330 28483:350 23563:350 28484:375 28485:375 23565:375 23564:375",
	["CraftedBy - Axesmith"]			= "12774:275 19169:300 12798:300 12784:300 17016:300 30088:330 30087:330 28434:350 28431:350 28432:375 28436:375 28435:375 28433:375",
	["CraftedBy - Hammersmith"]			= "12776:280 12781:285 19170:300 22384:300 12796:300 12794:300 30093:330 30089:330 28437:350 28440:350 28441:375 28438:375 28439:375 28442:375",
	["CraftedBy - Swordsmith"]			= "12777:280 12782:290 19168:300 22383:300 12790:300 17015:300 12797:300 30086:330 30077:330 28425:350 28428:350 28427:375 28426:375 28429:375 28430:375",
	["CraftedBy - Weaponsmith"]			= "7954:235 7961:245 7959:250 30071:260 30073:260 30072:260 7960:260 11608:265 11607:275 19166:300 19167:300 12783:300",
	["CraftedBy - Cooking"]				= "6290:1 2679:1 12224:1 17197:1 6888:1 27635:1 2681:1 24105:1 787:1 30816:1 5472:10 2680:10 5473:20 2888:25 17198:35 5474:35 6890:40 27636:50 5525:50 2684:50 5476:50 724:50 6316:50 4592:50 5095:50 5477:50 3220:60 22645:60 7676:60 2683:75 733:75 3662:80 2687:80 21072:80 2682:85 6657:85 5526:90 5478:90 3663:90 4593:100 5479:100 1082:100 1017:100 3726:110 3666:110 5480:110 2685:110 3664:120 5527:125 3727:125 12209:125 3665:130 20074:150 3728:150 4457:175 12213:175 6038:175 10841:175 13851:175 12212:175 8364:175 12214:175 12210:175 4594:175 21217:175 3729:175 12217:200 12215:200 17222:200 13927:225 13930:225 12218:225 12216:225 6887:225 18045:225 16766:225 13928:240 13929:240 13931:250 13932:250 13935:275 13933:275 13934:275 18254:275 20452:285 27661:300 27651:300 30155:300 21023:300 27662:300 27655:300 27656:310 27657:315 27664:320 27665:320 27666:325 27658:325 27659:325 31673:335 31672:335 27667:350",
	["CraftedBy - Engineering"]			= {"CraftedBy - Engineering General", "CraftedBy - Engineering Gnome", "CraftedBy - Engineering Goblin"},
	["CraftedBy - Engineering General"]		= "8067:1 4357:1 4358:1 4359:30 4360:30 4362:50 6219:50 4361:50 4405:60 4363:65 4364:75 4365:75 8068:75 4401:75 4366:85 4404:90 4368:100 6714:100 6712:100 4367:100 4369:105 4371:105 4370:105 4406:110 4372:120 4373:120 4374:120 7506:125 8069:125 4376:125 4377:125 4378:125 4375:125 4379:130 5507:135 4381:140 4380:140 4383:145 4382:145 4385:150 6533:150 9312:150 4384:150 10558:150 9313:150 9318:150 4386:155 4388:160 4387:160 7148:165 4403:165 4389:170 10499:175 4391:175 10498:175 4390:175 21590:175 21592:175 10505:175 10507:175 4407:180 4393:185 4392:185 4852:185 4394:190 17716:190 4395:195 10559:195 18588:200 4397:200 4398:200 4396:200 11590:200 10560:200 10500:205 10543:205 10542:205 10508:205 10716:205 10577:205 10644:205 10646:205 10713:205 11826:205 11825:205 10577:205 10545:210 10512:210 10546:210 10720:210 10721:215 10561:215 10514:215 10501:220 10510:220 10724:225 7189:225 10518:225 10502:225 21569:225 10506:230 10503:230 10725:230 10587:230 10726:235 10562:235 10586:235 10645:240 10727:240 10548:240 10504:245 10588:245 10513:245 15992:250 18641:250 10576:250 15846:250 19026:250 21277:250 18634:260 18984:260 15995:260 18986:260 18660:260 15993:260 15994:260 18631:260 18645:265 18587:265 15996:265 15999:270 16004:275 18637:275 21570:275 21714:275 21716:275 21718:275 16023:275 18594:275 16000:275 15997:285 16005:285 16006:285 18638:290 16008:290 16009:290 18282:300 18168:300 16022:300 18283:300 19999:300 19998:300 16007:300 18639:300 16040:300 23781:300 23736:300 23782:300 18232:300 23783:300 23821:305 23772:310 23742:320 23774:325 23784:325 23737:325 23767:325 23841:325 23826:325 23822:330 23773:335 23764:335 23771:335 25886:335 23768:335 23758:340 23761:340 23835:340 23827:340 23823:345 23825:350 23762:350 23746:350 23787:350 23836:350 23785:350 23786:350 23824:355 23838:375 23839:375 23829:375 23828:375 23748:375 23766:375",
	["CraftedBy - Engineering Gnome"]		= "10716:205 10713:205 11826:205 10545:210 10720:210 10724:225 10725:230 10726:235 10645:240 18986:260 18660:260 18645:265",
	["CraftedBy - Engineering Goblin"]		= "10543:205 10542:205 10577:205 10644:205 10646:205 11825:205 10577:205 7189:225 10587:230 10586:235 10727:240 10588:245 18984:260 18587:265",
	["CraftedBy - First Aid"]			= "1251:1 2581:40 6452:80 3530:80 3531:115 6453:130 6450:150 6451:180 8544:210 8545:240 14529:260 14530:290 19440:300 21990:330 21991:360",
	["CraftedBy - Leatherworking"]			= {"CraftedBy - Leatherworking General", "CraftedBy - Leatherworking Dragonscale", "CraftedBy - Leatherworking Elemental", "CraftedBy - Leatherworking Tribal"},
	["CraftedBy - Leatherworking General"]		= "2302:1 7277:1 7276:1 5957:1 2304:1 2318:1 2303:15 4237:25 7278:30 7279:30 7280:35 4231:35 2300:40 5081:40 2309:55 4239:55 2310:60 2311:60 7281:70 4242:75 2312:75 4246:80 2308:85 4243:85 6466:90 6709:90 5780:90 2307:90 7282:95 5781:95 7283:100 20575:100 2317:100 4244:100 4233:100 2315:100 2313:100 2319:100 6467:105 5958:105 2316:110 6468:115 5961:115 4248:120 4250:120 7285:120 7284:120 2314:120 4249:125 7348:125 4251:130 4253:135 7352:135 7349:135 4252:140 7358:140 7359:145 4247:145 4254:150 7372:150 7371:150 4236:150 4265:150 4234:150 18662:150 3719:150 18948:155 4255:155 4257:160 5962:160 7373:165 4456:165 4455:165 5963:170 4258:170 5782:170 5964:175 7374:175 7375:175 4256:175 7377:180 4259:180 4262:185 7378:185 5965:185 17721:190 7386:190 5783:190 5739:190 5966:190 7387:195 4260:195 18238:200 4264:200 8174:200 7390:200 7391:200 8172:200 8173:200 4304:200 8176:205 8175:205 8187:205 8192:210 8198:210 8189:210 8200:215 8201:220 8205:220 8203:220 8210:220 8347:225 8345:225 8217:225 8218:225 8204:225 8214:225 8211:225 8346:230 8193:230 8191:230 8197:235 8209:235 8185:235 8216:240 8202:240 8207:240 8206:245 8213:245 8349:250 8348:250 8208:250 8215:250 8212:250 15407:250 15564:250 8170:250 8367:255 15077:255 15045:260 15083:260 15074:265 15076:265 15084:265 15046:270 15067:270 15061:270 15091:270 15054:270 15057:275 15064:275 15073:275 15071:275 15078:275 15092:275 20296:280 15072:280 15082:280 15093:280 15086:280 15048:285 15060:285 15056:285 15065:285 15069:285 15079:285 15053:285 15050:290 19052:290 15063:290 15066:290 19044:290 15075:290 15094:290 15087:290 16982:295 15049:295 15058:295 15070:295 15080:295 16984:300 18509:300 19157:300 19162:300 20380:300 18510:300 22665:300 22664:300 22666:300 19149:300 19163:300 16983:300 22663:300 22662:300 22661:300 18511:300 15052:300 15051:300 19688:300 19689:300 20295:300 22761:300 22760:300 22759:300 18251:300 15062:300 18504:300 19058:300 15059:300 18506:300 15138:300 19687:300 19686:300 19685:300 15047:300 20476:300 20478:300 20477:300 20481:300 20479:300 20480:300 21278:300 18508:300 19049:300 25654:300 15068:300 18258:300 15081:300 15090:300 15095:300 15096:300 25662:300 25669:300 15055:300 15085:300 15088:300 25673:300 25679:300 25650:300 21887:300 25655:310 25661:310 25674:310 25670:315 25656:320 25668:320 25675:320 29540:325 25660:325 23793:325 25652:325 25651:325 25671:330 25676:330 29534:335 29533:335 25657:335 25659:335 25685:340 25694:340 25692:340 29488:340 29528:340 29485:340 29487:340 29530:345 29500:350 29499:350 29498:350 29497:350 29496:350 29495:350 29491:350 29490:350 29489:350 25686:350 25687:350 25695:350 29494:350 29493:350 29492:350 25693:350 25653:350 25681:350 25682:350 25680:350 29531:350 25691:355 25690:355 25697:360 25696:360 25689:360 29503:365 29502:365 29512:365 29506:365 29505:365 29508:365 29511:365 29510:365 29514:365 29504:365 29507:365 29509:365 29529:365 29536:365 29535:365 29532:370",
	["CraftedBy - Leatherworking Dragonscale"]	= "8347:225 8367:255 15045:260 15046:270 20296:280 15048:285 15050:290 15049:295 16984:300 18509:300 19157:300 20380:300 15052:300 15051:300 20295:300 15047:300",
	["CraftedBy - Leatherworking Elemental"]	= "8346:230 8348:250 15061:270 15054:270 15057:275 15060:285 15056:285 15053:285 15058:295 19163:300 16983:300 18511:300 15059:300 21278:300 15055:300",
	["CraftedBy - Leatherworking Tribal"]		= "8345:225 8349:250 15074:265 15067:270 15064:275 15073:275 15071:275 15072:280 15065:285 15069:285 15063:290 15066:290 15075:290 16982:295 15070:295 19162:300 18510:300 15062:300 15068:300",
	["CraftedBy - Tailoring"]			= "2996:1 4344:1 2570:1 10045:1 2576:1 2568:10 7026:15 10046:20 6238:30 6241:30 4343:30 4307:35 2572:40 2577:40 2575:40 6786:40 4238:45 6240:55 6239:55 4308:60 2580:60 2569:65 2578:70 6242:70 4309:70 2579:70 5762:70 2997:75 10047:75 2584:75 4312:80 4240:80 4310:85 2582:85 5542:90 4313:95 2583:95 4241:95 6263:100 4311:100 2587:100 2585:105 4316:110 4314:110 4330:110 6787:110 6264:115 5763:115 10048:120 4315:120 6384:120 6385:120 4320:125 4331:125 4317:125 4305:125 4318:130 5766:135 4332:135 7046:140 4321:140 4319:145 7047:145 7048:145 4324:150 5770:150 7049:150 4245:150 4333:155 7050:160 6795:160 4322:165 7065:165 7051:170 4323:170 4334:170 7052:175 7053:175 4325:175 7055:175 4339:175 5764:175 6796:175 7056:180 7057:180 4328:180 4326:185 5765:185 7058:185 4335:185 7054:190 7060:190 7059:190 17723:190 7061:195 7062:195 4327:200 4329:200 4336:200 9999:205 9998:205 7063:205 10001:210 7064:210 10002:210 10003:215 10009:215 10007:215 10004:215 10008:215 10056:215 10052:220 10019:225 10021:225 10042:225 22246:225 10018:225 10023:225 10050:225 10026:230 10024:230 10027:230 10054:230 10029:235 10028:235 10055:235 10051:235 10053:235 10030:240 10033:240 10031:240 10034:240 10044:245 10025:245 10035:245 10041:250 14048:250 21154:250 21542:250 14342:250 10036:250 10040:250 13868:255 13869:255 13856:255 14042:260 13858:260 13857:260 21340:260 14046:260 13870:265 14143:265 13860:265 14101:270 14100:270 14043:270 14142:270 14134:275 14103:275 22251:275 14044:275 22248:275 14107:275 14141:275 13863:275 14132:275 21341:280 14045:280 13871:280 13864:280 14136:285 14108:285 13865:285 19056:290 15802:290 14137:290 19047:290 14104:290 14111:290 14144:290 13866:295 18405:300 21342:300 16979:300 19165:300 16980:300 19156:300 18263:300 22658:300 22654:300 22652:300 22655:300 14146:300 14152:300 14153:300 14154:300 19059:300 19684:300 19683:300 19682:300 14156:300 18413:300 18407:300 22660:300 18408:300 19050:300 14140:300 18409:300 18486:300 14139:300 14138:300 20539:300 20537:300 20538:300 22757:300 22758:300 22756:300 22249:300 14106:300 14112:300 18258:300 14155:300 13867:300 22252:300 14128:300 14130:300 21840:300 24268:300 21850:310 21849:310 21841:315 21851:320 21842:325 21852:325 24269:325 24273:335 24275:335 21853:335 21859:340 24270:340 21843:340 21854:340 21855:345 21844:345 21866:350 24251:350 24250:350 30831:350 24253:350 24252:350 30837:350 21860:350 21845:350 24272:350 24271:350 24249:350 24254:350 21869:355 21873:355 21863:355 21846:355 21867:360 30838:360 21861:360 21862:360 24257:365 21870:365 24256:365 24260:365 21874:365 24258:365 21847:365 24255:365 24259:365 21868:370 30839:370 24263:375 21871:375 24276:375 21875:375 24274:375 21865:375 21848:375 24262:375 24261:375 21872:375 21876:375 21858:375",
-- Darkmoon Faire
	-- Cards and decks
	["Darkmoon Faire Cards"]		= {"Darkmoon Faire Deck - Beasts","Darkmoon Faire Deck - Warlords","Darkmoon Faire Deck - Portals","Darkmoon Faire Deck - Elementals"},
	["Darkmoon Faire Decks"]		= "19228 19257 19267 19277",
	["Darkmoon Faire Deck Rewards"]		= "19287 19288 19289 19290",
	["Darkmoon Faire Deck - Beasts"]	= "19227 19228 19230 19231 19232 19233 19234 19235 19236", -- Reward Card: Blue Dragon
	["Darkmoon Faire Deck - Warlords"]	= "19257 19258 19259 19260 19261 19262 19263 19264 19265", -- Reward Card: Heroism
	["Darkmoon Faire Deck - Portals"]	= "19276 19277 19278 19279 19280 19281 19282 19283 19284", -- Reward Card: Twisting Nether
	["Darkmoon Faire Deck - Elementals"]	= "19267 19268 19269 19270 19271 19272 19273 19274 19275", -- Reward Card: Maelstrom
	-- Items turned in for faire tickets
	-- Value == Number of tickets rewarded for item turnin
	["Darkmoon Faire Turnins"]	= {"Faire Turnins - Engineering", "Faire Turnins - Greys", "Faire Turnins - Leather", "Faire Turnins - Blacksmithing"},
	["Darkmoon Faire Turnins - Engineering"]		= "4363:1 4375:4 9313:8 11590:12 15994:20",
	["Darkmoon Faire Turnins - Greys"]		= "4582:5 5117:12 5134:1 11404:20 11407:4 19933:20",
	["Darkmoon Faire Turnins - Leather"]		= "2309:1 2314:4 5739:8 8185:12 15564:20",
	["Darkmoon Faire Turnins - Blacksmithing"]	= "3240:1 3486:4 3835:8 7945:12 12644:20",

	["Devices"]			= "18639 18638 18283 16022 18634 10576 10548 10546 4396 4391 4386 4407 4376 4406 4405 11825 11826 15846 15996 21277 16023 18660 18645 18637 17716 18232 11590 10727 4388 4392 4397 4401 4403 4366 5507 6533 6715 7148 7506 10577 10587 10645 10716 10720 10725 4381",

	["Explosives"] = "4358 4360 4365 4370 6714 4374 4378 4380 10507 4390 4403 4394 18588 10514 10586 10562 18641 15993 16005 16040 23736 23737",

	["Fireworks"]		= "9315 9317 9314 9318 19026 9313 9312 21569 5740 21570 21557 21558 21559 21561 21595 21593 21589 21562 21592 21590 21571 21574 21576 21744 21716 21714 21718",
-- Food
	-- Foods sorted out by type
	["Food Type"]			= {"Food Type - Bread", "Food Type - Fish", "Food Type - Meat", "Food Type - Cheese", "Food Type - Fruit", "Food Type - Fungus", "Food Type - Misc"},
	["Food Type - Bread"]		= {"Food - Bread", "Food - Bread Bonus", "Food - Bread Conjured"},
	["Food Type - Fish"]		= {"Food - Fish Raw", "Food - Fish", "Food - Fish Bonus", "Food - Fish Stats"},
	["Food Type - Meat"]		= {"Food - Meat Raw", "Food - Meat", "Food - Meat Bonus", "Food - Meat Stats"},
	["Food Type - Cheese"]		= {"Food - Cheese", "Food - Cheese Bonus"},
	["Food Type - Fruit"]		= {"Food - Fruit", "Food - Fruit Stats"},
	["Food Type - Fungus"]		= {"Food - Fungus"},
	["Food Type - Misc"]		= {"Food - Misc", "Food - Misc Bonus", "Food - Misc Stats"},
	-- Value == Total health recovered
	["All Food"]			= {"Food - Basic", "Food - Bonus", "Food - Stat", "Food - Special", "Food - Raw"},
	["All Edible Food"]		= {"Food - Basic", "Food - Bonus", "Food - Stat", "Food - Special"},
	-- Raw food with no value is not player-consumable but can be fed to a pet
	["Food - Raw"]			= {"Food - Fish Raw", "Food - Meat Raw"},
	["Food - Fish Raw"]		= "2675 4603:874 4655 5468 5503 5504 6289:61 6291:30 6303:30 6308:243 6317:61 6361:61 6362:552 7974 8365:552 8959:1392 12206 13754:874 13755:874 13756:874 13758:874 13759:874 13760:874 13889:1392 13893:1392 15924 13890 13888:1392",
	["Food - Meat Raw"]		= "20424 769 1015 1081 2672 2673 2677 2924 3173 3404 3667 3712 3730 3731 4739 5051 5465 5467 5469 5470 5471 12037 12184 12202 12203 12204 12205 12208 12223 27669 27671 27677 27678 22644 24477 27668 23676 31670 27674 31671 27682 27681",
	-- Normal food, no stats
	["Food - Basic"]		= {"Food - Bread", "Food - Bread Conjured", "Food - Cheese", "Food - Fish", "Food - Fruit", "Food - Fungus", "Food - Meat", "Food - Misc", "Food - Arathi", "Food - Warsong"},
	["Food - Regular"]		= {"Food - Bread", "Food - Cheese", "Food - Fish", "Food - Fruit", "Food - Fungus", "Food - Meat", "Food - Misc"},
	["Food - Bread"]		= "20857:61 4540:61 4541:243 4542:552 4544:874 16169:874 4601:1392 8950:2148 23160:2148 29314:7500 27855:4320 28486:4320 24072:243 30816:61",
	["Food - Bread Conjured"]	= "1113:243 1114:552 1487:874 5349:61 8075:1392 8076:2148 22895:4320 29449:7500",
	["Food - Cheese"]		= "2070:61 414:243 17406:243 422:552 1707:874 3927:1392 8932:2148 27857:4320 29448:7500 30458:4320",
	["Food - Fish"]			= "6316:243 21552:1392 16766:1392 2682:294 4592:243 4593:552 4594:874 5095:243 6290:61 6887:1392 787:61 8364:874 8957:2148 13546:1392 13930:1392 13935:2148 27661:4320 27858:4320 12238:243 13933:2148",
	["Food - Fruit"]		= "22324:2148 4536:61 4537:243 4538:552 4539:874 4602:1392 8953:2148 16168:1392 21033:2148 21031:2148 21030:1392 29393:4320 27856:4320",
	["Food - Fungus"]		= "3448:294 4604:61 4605:243 4606:552 4607:874 4608:1392 8948:2148 30355:7500 29453:7500",
	["Food - Meat"]			= "2679:61 17407:874 19305:552 19224:874 19223:61 19304:243 117:61 2287:243 2681:61 2685:552 3770:552 3771:874 4599:1392 5478:552 6890:243 8952:2148 19306:1392 9681:1392 9681:61 29451:7500 30610:4320 27854:4320 23495:61 17119:243",
	["Food - Misc"]			= "17344:61 5473:294 17407:874 19225:2148 733:552 5526:552 7228:552 6316:243 13933:2148 16166:61 16167:243 16170:552 16171:2148 18255:1392 29412:4320 24338:2148 24408:4320",
	["Food - Arathi"]		= "20063:1074 20064:1608 20062:2148 20223:1074 20224:1608 20222:2148 20226:1074 20227:1608 20225:2148",
	["Food - Warsong"]		= "19062:1074 19061:1608 19060:2148",
	-- Foods that give the Well Fed buff
	["Food - Bonus"]		= {"Food - Bread Bonus", "Food - Fish Bonus", "Food - Meat Bonus", "Food - Cheese Bonus", "Food - Misc Bonus"},
	["Food - Bread Bonus"]		= "2683:243 3666:552 17197:61",
	["Food - Fish Bonus"]		= "5476:243 6038:874 12216:1392 5527:552 16971:1392",
	["Food - Meat Bonus"]		= "1017:552 2680:61 2684:243 2687:243 2888:61 3220:243 3662:243 3726:552 3727:552 3728:874 3729:874 4457:874 5472:61 5474:61 5477:243 5479:552 5480:552 12209:552 12210:874 12213:874 12224:61 13851:874 17222:1392 18045:1392 20074:874",
	["Food - Cheese Bonus"]		= "3665:552 12218:1392",
	["Food - Misc Bonus"]		= "724:243 1082:552 3663:552 3664:552 5525:243 6038:874 6888:61 11584:61 12212:874 12214:874 12215:1392 12216:1392 17198:61",
	-- Foods that give a stat (not Well Fed)
	["Food - Stat"]			= {"Food - Strength", "Food - Agility", "Food - Stamina", "Food - Intellect", "Food - Spirit", "Food - HP Regen", "Food - Mana Regen", "Food - Other", "Food - Spell Damage", "Food - Healing", "Food - Attack Power"},
	["Food - Strength"]		= "13810:1933 20452:2148 29292:2148 30359:7500 27658:7500",
	["Food - Agility"]		= "13928:874, 27664:7500 30358:7500 33288:7500",
	["Food - Stamina"]		= "13927:1392 13934:1933 11950:1933 21023:2550 28501:4320 27667:7500 30155:4320 27651:4320 27662:4320 31672:7500 27660:7500 33277:61 33276:61 33278:243 22645:243 24009:4320 24540:2148",
	["Food - Intellect"]		= "18254:1933",
	["Food - Spirit"]		= "13929:874 24539:4320",
	["Food - HP Regen"]		= "13932:874",
	["Food - Mana Regen"]		= "21072:378 21217:840 13931:874",
	["Food - Spell Damage"]		= "31673:7500 27657:7500 30361:7500 27665:7500",
	["Food - Healing"]  		= "27666:7500 30357:7500",
	["Food - Attack Power"] 	= "27655:4320",
	["Food - Mana Regen"]		= "21072:378 21217:840 13931:874",
	["Food - Other"]		= "12217",
	["Food - Fish Stats"]		= "13927:1392 13928:874 13929:874 13932:874",
	["Food - Fruit Stats"]		= "11950:1933",
	["Food - Meat Stats"]		= "12217",
	["Food - Misc Stats"]		= "13931:874",
	["Food - Special"]		= {"Food - Combo Health", "Food - Combo Mana", "Food - Combo Percent", "Food - Percent", "Food - Percent Bonus"},
	["Food - Combo Health"]		= "21071:155 21153:567 2682:294 3448:294 13724:2148 20031:2550 19301:4410", -- Value == Total health recovered
	["Food - Combo Mana"]		= "21071:315 21153:882 2682:294 3448:294 13724:4410 20031:4410 19301:4410", -- Value == Total mana recovered
	["Food - Combo Percent"]	= "21537:100 20388:75 20389:75 20390:75 21215:100", -- Value == Total percentage HP/MP recovered
	["Food - Percent"]		= "19696:50 19994:50 19995:50 21235:50 19996:50", -- Value == Percentage HP recovered
	["Food - Percent Bonus"]	= "20516:48 21254:48", -- Value == Percentage HP recovered (with Well Fed buff)
-- Gather
	-- Items harvested by tradeskills
	["Gather"] = {"Gather - Fishing", "Gather - Disenchant", "Gather - Herbalism", "Gather - Mining", "Gather - Skinning", "Gather - Prospecting", "Gather - Pickpocketing"},
	["Gather - Fishing"]		= "10608 7909 8289 4999 9838 6553 15224 6423 19803 7535 7531 7546 4068 8143 3864 4577 19806 6267 10060 2073 7080 11167 9753 8111 4066 12030 6511 19805 10079 10081 6404 6407 2409 4292 4294 4348 2598 6390 9788 9790 19808 2970 8350 818 9923 15245 4571 9963 9960 9964 6540 6536 6292 13909 6294 13910 6295 13901 6309 13902 6310 13911 6311 13885 13886 13876 13882 13883 13877 13884 13878 13879 13880 13907 13914 13915 13908 27422 6356 7973 6647 6645 13881 13891 6643 8366 856 8179 3857 27513 13888 12238 6351 6522 6470 7351 6718 7070 27516 16967 6359 6717 7079 27438 1710 6149 9752 9755 929 13874 27481 27515 27437 6507 27511 21150 13875 1725 13893 858 3385 13757 13446 3827 6307 118 2455 16970 21228 22578 6458 6358 2447 13890 6291 6308 13754 21153 6317 6289 8365 13759 6361 13758 6362 21071 6303 4603 13756 13760 13889 13918 21151 21114 20709 16968 16969 6357 6299 4565 6353 6354 19807 27425 1467 13422 3820 6355 3928 13443 20708 4678 6352 21113 5574 13755 27429 19975 6456 6297 6301 6457 27443",
	["Gather - Disenchant"]		= "20725 14344 11084 11139 22449 11178 14343 10978 11138 22448 11177 11082 16203 10939 11135 11175 22446 10998 16202 10938 11134 11174 22447 22445 11176 16204 11083 10940 11137",
	["Gather - Herbalism"]		= "13468 19726 12048 22790 8836 8839 22710 2450 2453 13463 22786 2449 3818 22795 11514 22794 22785 4625 22788 8845 13464 3821 3369 8846 13467 3358 3356 3357 785 22793 22575 22576 13465 22791 22797 22792 2447 13466 8831 22787 5056 765 3820 8838 2452 22789 24401 3355 8153 3819",
	["Gather - Mining"]		= "23436 23437 7909 12363 12800 23117 11754 23077 11382 12361 3864 23079 7076 23427 21929 2776 23112 12364 1529 23426 12799 1705 774 1206 23107 1210 2775 19774 7910 818 7911 23425 9262 5075 2836 2770 11370 12365 23424 2838 3340 5833 2772 22203 4278 3858 22573 22574 2798 2835 22202 7912 11513 10620 2771",
	["Gather - Skinning"]		= "12731 12607 15410 20381 15416 7286 15415 15423 17012 25699 6470 15417 25707 25700 15422 15412 7392 4235 4234 15408 20501 21887 25649 783 2318 20500 4232 2319 29548 11512 6471 19767 19768 18947 15414 7287 8171 8170 2934 8154 7428 17057 20498 25708 8169 4304 8368 8973 8167 15419 29547 2592 8165 20499 3676",
	["Gather - Prospecting"]	= "23440 23436 23439 23437 7909 12800 23117 23077 12361 3864 23079 21929 23112 12364 1529 12799 1705 774 1206 23107 1210 7910 818 24243 24186 24242 24190 24234 24235 24188",
	["Gather - Pickpocketing"]	= "7909 3864 23079 1529 1705 774 1206 2406 2598 2407 3609 4408 1210 5498 7910 818 8932 16882 4599 414 2070 8953 7675 7923 4607 8948 422 20023 3927 4604 4541 4539 1710 11602 2287 929 16885 8950 858 2589 5373 13446 118 4542 4602 4544 3770 4608 6308 6289 6362 6303 8959 4603 3419 4605 8952 19775 7737 2676 4536 8072 3421 27854 4538 4601 4606 1707 29569 16884 22829 3928 17124 7208 4537 4540 117 3771 16883 6150 29570 29575 5429 29571 5428 5370 5379 5376 5362 5427 5364 5431 10457 5368 5361 5363 5369 5432 5430 20030 5371 5367 5433 5377 5375 5435 5374",

	["Hallowed Wands"]	= "20397 20398 20399 20409 20410 20411 20413 20414",
-- ItemSets
	--Pre 60 or otherwise weird
	["ItemSet - Ironweave Battlesuit"]		= "22306 22311 22313 22302 22304 22305 22303 22301", -- iLVL 61 (Misc level 60 instances)
	["ItemSet - The Postmaster"]			= "13390 13388 13391 13392 13389", -- iLVL 61 (Stratholme - Postmaster Malown)
	["ItemSet - Deathbone Guardian"]		= "14624 14622 14620 14623 14621", -- iLVL 61 (Scholomance)
	["ItemSet - Cadaverous Garb"]			= "14637 14636 14640 14638 14641", -- iLVL 61 (Scholomance)
	["ItemSet - Necropile Raiment"]			= "14631 14629 14632 14633 14626", -- iLVL 61 (Scholomance)
	["ItemSet - Bloodmail Regalia"]			= "14614 14616 14615 14611 14612", -- iLVL 61 (Scholomance)
	["ItemSet - The Gladiator"]			= "11729 11726 11728 11731 11730", -- iLVL 57 (Blackrock Depths)
	["ItemSet - Chain of the Scarlet Crusade"]	= "10329 10332 10328 10331 10330 10333", -- iLVL 38 (Scarlet Monestary)
	["ItemSet - Embrace of the Viper"]		= "10412 10411 10413 10410 6473", -- iLVL 21 (Wailing Caverns)
	["ItemSet - Defias Leather"]			= "10399 10403 10402 10401 10400", -- iLVL 20 (Deadmines)
	["ItemSet - Shard of the Gods"]			= "17082 17064",  -- iLVL 72 (Trinkets)
	["ItemSet - Twilight Trappings"]		= "20406 20408 20407", -- iLVL 60 (not like that matters)
	--Crafted Sets
	["ItemSet - Black Dragon Mail"]		= "16984 15050 15052 15051", -- iLVL 60
	["ItemSet - The Darksoul"]		= "19693 19694 19695", -- iLVL 65
	["ItemSet - Blood Tiger Harness"]	= "19688 19689", -- iLVL 65
	["ItemSet - Primal Batskin"]		= "19685 19687 19686", -- iLVL 65
	["ItemSet - Bloodsoul Embrace"]		= "19690 19691 19692", -- iLVL 65
	["ItemSet - Bloodvine Garb"]		= "19682 19683 19684", -- iLVL 65
	["ItemSet - Devilsaud Armor"]		= "15062 15063", -- iLVL 59
	["ItemSet - Blue Dragon Mail"]		= "15048 20295 15049", -- iLVL 58
	["ItemSet - Stormshroud Armor"]		= "15056 15057 15058 21278", -- iLVL 58
	["ItemSet - Imperial Plate"]		= "12424 12426 12425 12422 12427 12429 12428", -- iLVL 57
	["ItemSet - Volcanic Armor"]		= "15053 15054 15055", -- iLVL 57
	["ItemSet - Ironfeather Armor"]		= "15066 15067", -- iLVL 56
	["ItemSet - Green Dragon Mail"]		= "15045 15046 20296", --iLVL 54
	--Weapon Sets
	["ItemSet - The Twin Blades of Hakkari"]= "19865 19866", -- iLVL 67
	["ItemSet - Spirit of Eskandar"]	= "18202 18203 18204 18205", -- iLVL 67
	["ItemSet - Primal Blessing"]		= "19896 19910", -- iLVL 65
	["ItemSet - Dal'Rend's Arms"]		= "12940 12939", -- iLVL 63
	["ItemSet - Spider's Kiss"]		= "13218 13183", -- iLVL 60
	--Dungeon 1 - iLVL 59
	["ItemSet - Dungeon1"] = {"ItemSet - The Elements", "ItemSet - Beaststalker Armor", "ItemSet - Magister's Regalia", "ItemSet - Vestments of the Devout", "ItemSet - Dreadmist Raiment", "ItemSet - Wildheart Raiment", "ItemSet - Shadowcraft Armor", "ItemSet - Lightforge Armor", "ItemSet - Battlegear of Valor"},
	["ItemSet - The Elements"]		= "16673 16670 16671 16667 16672 16668 16669 16666", -- Shaman
	["ItemSet - Beaststalker Armor"]	= "16680 16675 16681 16677 16674 16678 16679 16676", -- Hunter
	["ItemSet - Magister's Regalia"]	= "16685 16683 16686 16684 16687 16689 16688 16682", -- Mage
	["ItemSet - Vestments of the Devout"]	= "16696 16691 16697 16693 16692 16695 16694 16690", -- Priest
	["ItemSet - Dreadmist Raiment"]		= "16702 16703 16699 16701 16700 16704 16698 16705", -- Warlock
	["ItemSet - Wildheart Raiment"]		= "16716 16715 16714 16720 16706 16718 16719 16717", -- Druid
	["ItemSet - Shadowcraft Armor"]		= "16713 16711 16710 16721 16708 16709 16712 16707", -- Rogue
	["ItemSet - Lightforge Armor"]		= "16723 16725 16722 16726 16724 16728 16729 16727", -- Paladin
	["ItemSet - Battlegear of Valor"]	= "16736 16734 16735 16730 16737 16731 16732 16733", -- Warrior
	--Dungeon 2 - iLVL 62
	["ItemSet - Dungeon2"] = {"ItemSet - Battlegear of Heroism", "ItemSet - Darkmantle Armor", "ItemSet - Beastmaster Armor", "ItemSet - Sorcerer's Regalia", "ItemSet - Deathmist Raiment", "ItemSet - Vestments of the Virtuous", "ItemSet - Soulforge Armor", "ItemSet - The Five Thunders", "ItemSet - Feralheart Raiment"},
	["ItemSet - Battlegear of Heroism"]	= "21994 21995 21996 21997 21998 21999 22000 22001", -- Warrior
	["ItemSet - Darkmantle Armor"]		= "22002 22003 22004 22005 22006 22007 22008 22009", -- Rogue
	["ItemSet - Beastmaster Armor"]		= "22010 22011 22061 22013 22015 22016 22017 22060", -- Hunter
	["ItemSet - Sorcerer's Regalia"]	= "22062 22063 22064 22065 22066 22067 22068 22069", -- Mage
	["ItemSet - Deathmist Raiment"]		= "22070 22071 22072 22073 22074 22075 22076 22077", -- Warlock
	["ItemSet - Vestments of the Virtuous"]	= "22078 22079 22080 22081 22082 22083 22084 22085", -- Priest
	["ItemSet - Soulforge Armor"]		= "22086 22087 22088 22089 22090 22091 22092 22093", -- Paladin
	["ItemSet - The Five Thunders"]		= "22095 22096 22097 22098 22099 22100 22101 22102", -- Shaman
	["ItemSet - Feralheart Raiment"]	= "22106 22107 22108 22109 22110 22111 22112 22113", -- Druid
	--Dungeon 3 - iLVL 115
	["ItemSet - Assassination Armor"]	= "27509 28414 27908 27776 28204",
	["ItemSet - Beast Lord Armor"]		= "28228 27474 28275 27874 27801",
	["ItemSet - Bold Armor"]		= "28205 27475 27977 27803 28350",
	["ItemSet - Desolation Battlegear"]	= "27936 28401 27528 28192 27713",
	["ItemSet - Doomplate Battlegear"]	= "28403 27497 28225 27870 27771",
	["ItemSet - Hallowed Raiment"]		= "28413 28230 27536 27775 27875",
	["ItemSet - Incanter's Regalia"]	= "28278 27508 27738 28229 27838",
	["ItemSet - Mana-Etched Regalia"]	= "28193 27465 27907 28191 27796",
	["ItemSet - Moonglade Raiment"]		= "28348 27468 27873 28202 27737",
	["ItemSet - Oblivion Raiment"]		= "27537 28415 28232 27778 27948",
	["ItemSet - Righteous Armor"]		= "28203 27535 28285 27839 27739",
	["ItemSet - Tidefury Raiment"]		= "28231 27510 28349 27909 27802",
	["ItemSet - Wastewalker Armor"]		= "28264 27531 28224 27797",
	--Zul'Gurub
	["ItemSet - ZG"] = {"ItemSet - Augur's Regalia", "ItemSet - Freethinker's Armor", "ItemSet - Confessor's Raiment", "ItemSet - Demoniac's Threads", "ItemSet - Madcap's Outfit", "ItemSet - Haruspex's Garb", "ItemSet - Predator's Armor", "ItemSet - Vindicator's Battlegear", "ItemSet - Illusionist's Attire"},
	["ItemSet - Augur's Regalia"]		= "19609 19956 19830 19829 19828", -- Shaman
	["ItemSet - Freethinker's Armor"]	= "19952 19588 19827 19826 19825", -- Paladin
	["ItemSet - Confessor's Raiment"]	= "19594 19958 19843 19842 19841", -- Priest
	["ItemSet - Demoniac's Threads"]	= "19605 19957 19848 19849 20033", -- Warlock
	["ItemSet - Madcap's Outfit"]		= "19617 19954 19836 19835 19834", -- Rogue
	["ItemSet - Haruspex's Garb"]		= "19613 19955 19840 19839 19838", -- Druid
	["ItemSet - Predator's Armor"]		= "19621 19953 19833 19832 19831", -- Hunter
	["ItemSet - Vindicator's Battlegear"]	= "19951 19577 19824 19823 19822", -- Warrior
	["ItemSet - Illusionist's Attire"]	= "19601 19959 19846 19845 20034", -- Mage
	["ItemSet - ZG Ring"] = {"ItemSet - Prayer of the Primal", "ItemSet - Major Mojo Infusion"},
	["ItemSet - Prayer of the Primal"]	= "19863 19920", -- iLVL 69
	["ItemSet - Zanzil's Concentration"]	= "19905 19893", -- iLVL 69
	["ItemSet - Overlord's Resolution"]	= "19873 19912", -- iLVL 69
	["ItemSet - Major Mojo Infusion"]	= "19898 19925", -- iLVL 69
	--Ruins of Ahn'Qiraj
	["ItemSet - AQ20"] = {"ItemSet - Symbols of Unending Life", "ItemSet - Trappings of the Unseen Path", "ItemSet - Trappings of Vaulted Secrets", "ItemSet - Battlegear of Eternal Justice", "ItemSet - Finery of Infinite Wisdom", "ItemSet - Emblems of Veiled Shadows", "ItemSet - Gift of the Gathering Storm", "ItemSet - Implements of Unspoken Names", "ItemSet - Battlegear of Unyielding Strength"},
	-- Value = Reputation index of:
	-- {"Hated", "Hostile", "Unfriendly", "Neutral", "Friendly", "Honored", "Revered", "Exalted", "MaxExalted"}
	["ItemSet - Symbols of Unending Life"]		= "21407:8 21408:6 21409:7", -- Druid
	["ItemSet - Trappings of the Unseen Path"]	= "21401:8 21402:6 21403:7", -- Hunter
	["ItemSet - Trappings of Vaulted Secrets"]	= "21413:8 21414:6 21415:7", -- Mage
	["ItemSet - Battlegear of Eternal Justice"]	= "21395:8 21396:6 21397:7", -- Paladin
	["ItemSet - Finery of Infinite Wisdom"]		= "21410:8 21411:6 21412:7", -- Priest
	["ItemSet - Emblems of Veiled Shadows"]		= "21404:8 21405:6 21406:7", -- Rogue
	["ItemSet - Gift of the Gathering Storm"]	= "21398:8 21399:7 21400:6", -- Shaman
	["ItemSet - Implements of Unspoken Names"]	= "21416:8 21417:6 21418:7", -- Warlock
	["ItemSet - Battlegear of Unyielding Strength"]	= "21392:8 21393:6 21394:7", -- Warrior
	["ItemMats - Symbols of Unending Life"]			= {"ItemMats - 21408", "ItemMats - 21409", "ItemMats - 21407"},
	["ItemMats - 21408"]	= "20865 20861 20873 20884", -- CC Honored, Ring
	["ItemMats - 21409"]	= "20860 20864 20872 20889", -- CC Revered, Cloak
	["ItemMats - 21407"]	= "20858 20862 20870 20890", -- CC Exalted, Weapon
	["ItemMats - Trappings of the Unseen Path"]		= {"ItemMats - 21402", "ItemMats - 21403", "ItemMats - 21401"},
	["ItemMats - 21402"]	= "20863 20859 20869 20888", -- CC Honored, Ring
	["ItemMats - 21403"]	= "20889 20868 20858 20862", -- CC Revered, Cloak
	["ItemMats - 21401"]	= "20886 20866 20860 20864", -- CC Exalted, Weapon
	["ItemMats - Trappings of Vaulted Secrets"]		= {"ItemMats - 21414", "ItemMats - 21415", "ItemMats - 21413"},
	["ItemMats - 21414"]	= "20863 20859 20866 20884", -- CC Honored, Ring
	["ItemMats - 21415"]	= "20862 20858 20873 20885", -- CC Revered, Cloak
	["ItemMats - 21413"]	= "20864 20860 20871 20890", -- CC Exalted, Weapon
	["ItemMats - Battlegear of Eternal Justice"]	= {"ItemMats - 21396", "ItemMats - 21397", "ItemMats - 21395"},
	["ItemMats - 21396"]	= "20864 20860 20872 20884", -- CC Honored, Ring
	["ItemMats - 21397"]	= "20863 20859 20871 20889", -- CC Revered, Cloak
	["ItemMats - 21395"]	= "20865 20861 20869 20886", -- CC Exalted, Weapon
	["ItemMats - Finery of Infinite Wisdom"]		= {"ItemMats - 21411", "ItemMats - 21412", "ItemMats - 21410"},
	["ItemMats - 21411"]	= "20864 20860 20871 20888", -- CC Honored, Ring
	["ItemMats - 21412"]	= "20863 20859 20870 20885", -- CC Revered, Cloak
	["ItemMats - 21410"]	= "20865 20861 20868 20890", -- CC Exalted, Weapon
	["ItemMats - Emblems of Veiled Shadows"]		= {"ItemMats - 21405", "ItemMats - 21406", "ItemMats - 21404"},
	["ItemMats - 21405"]	= "20862 20858 20867 20888", -- CC Honored, Ring
	["ItemMats - 21406"]	= "20865 20861 20866 20885", -- CC Revered, Cloak
	["ItemMats - 21404"]	= "20863 20859 20872 20886", -- CC Exalted, Weapon
	["ItemMats - Gift of the Gathering Storm"]		= {"ItemMats - 21400", "ItemMats - 21399", "ItemMats - 21398"},
	["ItemMats - 21400"]	= "20884 20872 20860 20864", -- CC Honored, Ring
	["ItemMats - 21399"]	= "20859 20863 20871 20889", -- CC Revered, Cloak
	["ItemMats - 21398"]	= "20865 20861 20869 20886", -- CC Exalted, Weapon
	["ItemMats - Implements of Unspoken Names"]		= {"ItemMats - 21417", "ItemMats - 21418", "ItemMats - 21416"},
	["ItemMats - 21417"]	= "20862 20858 20870 20888", -- CC Honored, Ring
	["ItemMats - 21418"]	= "20865 20861 20869 20889", -- CC Revered, Cloak
	["ItemMats - 21416"]	= "20863 20859 20867 20890", -- CC Exalted, Weapon
	["ItemMats - Battlegear of Unyielding Strength"]= {"ItemMats - 21393", "ItemMats - 21394", "ItemMats - 21392"},
	["ItemMats - 21393"]	= "20865 20861 20868 20884", -- CC Honored, Ring
	["ItemMats - 21394"]	= "20885 20867 20864 20860", -- CC Revered, Cloak
	["ItemMats - 21392"]	= "20858 20862 20873 20886", -- CC Exalted, Weapon
	--Tier 1 Raid - iLVL 66
	["ItemSet - Tier1"] = {"ItemSet - Arcanist Regalia", "ItemSet - Felheart Raiment", "ItemSet - Cenarion Raiment", "ItemSet - The Earthfury", "ItemSet - Giantstalker Armor", "ItemSet - Lawbringer Armor", "ItemSet - Vestments of Prophecy", "ItemSet - Nightslayer Armor", "ItemSet - Battlegear of Might"},
	["ItemSet - Arcanist Regalia"]		= "16802 16799 16795 16800 16801 16796 16797 16798", -- Mage
	["ItemSet - Felheart Raiment"]		= "16806 16804 16805 16810 16809 16807 16808 16803", -- Warlock
	["ItemSet - Cenarion Raiment"]		= "16828 16829 16830 16833 16831 16834 16835 16836", -- Druid
	["ItemSet - The Earthfury"]		= "16838 16837 16840 16841 16844 16839 16842 16843", -- Shaman
	["ItemSet - Giantstalker Armor"]	= "16851 16849 16850 16845 16848 16852 16846 16847", -- Hunter
	["ItemSet - Lawbringer Armor"]		= "16858 16859 16857 16853 16860 16854 16855 16856", -- Paladin
	["ItemSet - Vestments of Prophecy"]	= "16811 16813 16817 16812 16814 16816 16815 16819", -- Priest
	["ItemSet - Nightslayer Armor"]		= "16827 16824 16825 16820 16821 16826 16822 16823", -- Rogue
	["ItemSet - Battlegear of Might"]	= "16864 16861 16865 16863 16866 16867 16868 16862", -- Warrior
	--Tier 2 Raid - iLVL 76
	["ItemSet - Tier2"] = {"ItemSet - Stormrage Raiment", "ItemSet - Bloodfang Armor", "ItemSet - Netherwind Regalia", "ItemSet - Ventsmenst of Trancendance", "ItemSet - Nemesis Raiment", "ItemSet - Dragonstalker Armor", "ItemSet - The Ten Storms", "ItemSet - Judgement Armor", "ItemSet - Battlegear of Wrath"},
	["ItemSet - Stormrage Raiment"]			= "16903 16898 16904 16897 16900 16899 16901 16902", -- Druid
	["ItemSet - Bloodfang Armor"]			= "16910 16906 16911 16905 16907 16908 16909 16832", -- Rogue
	["ItemSet - Netherwind Regalia"]		= "16818 16918 16912 16914 16917 16913 16915 16916", -- Mage
	["ItemSet - Ventsmenst of Trancendance"]	= "16919 16920 16921 16922 16923 16924 16925 16926", -- Priest
	["ItemSet - Nemesis Raiment"]			= "16933 16927 16934 16928 16930 16931 16929 16932", -- Warlock
	["ItemSet - Dragonstalker Armor"]		= "16936 16935 16942 16940 16941 16939 16938 16937", -- Hunter
	["ItemSet - The Ten Storms"]			= "16944 16943 16950 16945 16948 16949 16947 16946", -- Shaman
	["ItemSet - Judgement Armor"]			= "16952 16951 16958 16955 16956 16954 16957 16953", -- Paladin
	["ItemSet - Battlegear of Wrath"]		= "16959 16966 16964 16963 16962 16961 16965 16960", -- Warrior
	--Temple of Ahn'Qiraj - iLVL 81
	["ItemSet - AQ40"] = {"ItemSet - Genesis Raiment", "ItemSet - Striker's Garb", "ItemSet - Enigma Vestments", "ItemSet - Avenger's Battlegear", "ItemSet - Garments of the Oracle", "ItemSet - Deathdealer's Embrace", "ItemSet - Stormcaller's Garb", "ItemSet - Doomcaller's Attire", "ItemSet - Conqueror's Battlegear"},
	-- Value = Reputation index of:
	-- {"Hated", "Hostile", "Unfriendly", "Neutral", "Friendly", "Honored", "Revered", "Exalted", "MaxExalted"}
	["ItemSet - Genesis Raiment"]		= "21353:5 21354:4 21355:4 21356:5 21357:6", -- Druid
	["ItemSet - Striker's Garb"]		= "21365:4 21366:5 21367:4 21368:5 21370:6", -- Hunter
	["ItemSet - Enigma Vestments"]		= "21343:6 21344:4 21345:4 21346:5 21347:5", -- Mage
	["ItemSet - Avenger's Battlegear"]	= "21387:5 21388:4 21389:6 21390:5 21391:4", -- Paladin
	["ItemSet - Garments of the Oracle"]	= "21348:5 21349:4 21350:4 21351:6 21352:5", -- Priest
	["ItemSet - Deathdealer's Embrace"]	= "21359:4 21360:5 21361:4 21362:5 21364:6", -- Rogue
	["ItemSet - Stormcaller's Garb"]	= "21372:5 21373:4 21374:6 21375:5 21376:4", -- Shaman
	["ItemSet - Doomcaller's Attire"]	= "21334:6 21335:4 21336:5 21337:5 21338:4", -- Warlock
	["ItemSet - Conqueror's Battlegear"]	= "21329:5 21330:4 21331:6 21332:5 21333:4", -- Warrior
	["ItemMats - Genesis Raiment"]		= {"ItemMats - 21354", "ItemMats - 21355", "ItemMats - 21353", "ItemMats - 21356", "ItemMats - 21357"},
	["ItemMats - 21354"]	= "20932 20881 20859 20864", -- BoN Neutral, Shoulders
	["ItemMats - 21355"]	= "20860 20858 20878 20932", -- BoN Neutral, Boots
	["ItemMats - 21353"]	= "20863 20859 20879 20930", -- BoN Friendly, Head
	["ItemMats - 21356"]	= "20862 20858 20882 20931", -- BoN Friendly, Legs
	["ItemMats - 21357"]	= "20865 20861 20878 20933", -- BoN Honored, Chest
	["ItemMats - Striker's Garb"]		= {"ItemMats - 21367", "ItemMats - 21365", "ItemMats - 21366", "ItemMats - 21368", "ItemMats - 21370"},
	["ItemMats - 21367"]	= "20865 20862 20882 20928", -- BoN Neutral, Shoulders
	["ItemMats - 21365"]	= "20864 20858 20879 20928", -- BoN Neutral, Boots
	["ItemMats - 21366"]	= "20865 20861 20881 20930", -- BoN Friendly, Head
	["ItemMats - 21368"]	= "20864 20860 20874 20931", -- BoN Friendly, Legs
	["ItemMats - 21370"]	= "20863 20859 20879 20929", -- BoN Honored, Chest
	["ItemMats - Enigma Vestments"] 		= {"ItemMats - 21345", "ItemMats - 21344", "ItemMats - 21347", "ItemMats - 21346", "ItemMats - 21343"},
	["ItemMats - 21345"]	= "20861 20858 20876 20932", -- BoN Neutral, Shoulders
	["ItemMats - 21344"]	= "20862 20860 20874 20932", -- BoN Neutral, Boots
	["ItemMats - 21347"]	= "20865 20861 20875 20926", -- BoN Friendly, Head
	["ItemMats - 21346"]	= "20864 20860 20877 20927", -- BoN Friendly, Legs
	["ItemMats - 21343"]	= "20863 20859 20874 20933", -- BoN Honored, Chest
	["ItemMats - Avenger's Battlegear"]	= {"ItemMats - 21391", "ItemMats - 21388", "ItemMats - 21387", "ItemMats - 21390", "ItemMats - 21389"},
	["ItemMats - 21391"]	= "20862 20859 20879 20932", -- BoN Neutral, Shoulders
	["ItemMats - 21388"]	= "20863 20861 20877 20932", -- BoN Neutral, Boots
	["ItemMats - 21387"]	= "20862 20858 20878 20930", -- BoN Friendly, Head
	["ItemMats - 21390"]	= "20861 20865 20881 20931", -- BoN Friendly, Legs
	["ItemMats - 21389"]	= "20864 20860 20877 20929", -- BoN Honored, Chest
	["ItemMats - Garments of the Oracle"]	= {"ItemMats - 21350", "ItemMats - 21349", "ItemMats - 21348", "ItemMats - 21352", "ItemMats - 21351"},
	["ItemMats - 21350"]	= "20865 20860 20878 20928", -- BoN Neutral, Shoulders
	["ItemMats - 21349"]	= "20859 20861 20876 20928", -- BoN Neutral, Boots
	["ItemMats - 21348"]	= "20864 20860 20877 20926", -- BoN Friendly, Head
	["ItemMats - 21352"]	= "20863 20859 20879 20927", -- BoN Friendly, Legs
	["ItemMats - 21351"]	= "20862 20858 20876 20933", -- BoN Honored, Chest
	["ItemMats - Deathdealer's Embrace"]	= {"ItemMats - 21361", "ItemMats - 21359", "ItemMats - 21360", "ItemMats - 21362", "ItemMats - 21364"},
	["ItemMats - 21361"]	= "20863 20860 20874 20928", -- BoN Neutral, Shoulders
	["ItemMats - 21359"]	= "20864 20862 20881 20928", -- BoN Neutral, Boots
	["ItemMats - 21360"]	= "20859 20863 20882 20930", -- BoN Friendly, Head
	["ItemMats - 21362"]	= "20862 20858 20875 20927", -- BoN Friendly, Legs
	["ItemMats - 21364"]	= "20865 20861 20881 20929", -- BoN Honored, Chest
	["ItemMats - Stormcaller's Garb"]	= {"ItemMats - 21376", "ItemMats - 21373", "ItemMats - 21372", "ItemMats - 21375", "ItemMats - 21374"},
	["ItemMats - 21376"]	= "20862 20859 20879 20932", -- BoN Neutral, Shoulders
	["ItemMats - 21373"]	= "20863 20861 20877 20932", -- BoN Neutral, Boots
	["ItemMats - 21372"]	= "20862 20858 20878 20930", -- BoN Friendly, Head
	["ItemMats - 21375"]	= "20861 20865 20881 20931", -- BoN Friendly, Legs
	["ItemMats - 21374"]	= "20864 20860 20877 20929", -- BoN Honored, Chest
	["ItemMats - Doomcaller's Attire"]	= {"ItemMats - 21335", "ItemMats - 21338", "ItemMats - 21337", "ItemMats - 21336", "ItemMats - 21334"},
	["ItemMats - 21335"]	= "20864 20861 20877 20932", -- BoN Neutral, Shoulders
	["ItemMats - 21338"]	= "20865 20863 20875 20932", -- BoN Neutral, Boots
	["ItemMats - 21337"]	= "20864 20860 20876 20926", -- BoN Friendly, Head
	["ItemMats - 21336"]	= "20863 20859 20878 20931", -- BoN Friendly, Legs
	["ItemMats - 21334"]	= "20858 20862 20875 20933", -- BoN Honored, Chest
	["ItemMats - Conqueror's Battlegear"]	= {"ItemMats - 21330", "ItemMats - 21333", "ItemMats - 21329", "ItemMats - 21332", "ItemMats - 21331"},
	["ItemMats - 21330"]	= "20858 20863 20875 20928", -- BoN Neutral, Shoulders
	["ItemMats - 21333"]	= "20859 20865 20882 20928", -- BoN Neutral, Boots
	["ItemMats - 21329"]	= "20858 20862 20874 20926", -- BoN Friendly, Head
	["ItemMats - 21332"]	= "20865 20861 20867 20927", -- BoN Friendly, Legs
	["ItemMats - 21331"]	= "20864 20860 20882 20929", -- BoN Honored, Chest
	--Tier 3 Raid - iLVL 88
	["ItemSet - Tier3"] = {"ItemSet - Dreamwalker Raiment", "ItemSet - Bonescythe Armor", "ItemSet - Frostfire Regalia", "ItemSet - Vestments of Faith", "ItemSet - Plagueheart Raiment", "ItemSet - Cryptstalker Armor", "ItemSet - The Earthshatterer", "ItemSet - Redemption Armor", "ItemSet - Dreadnaught's Battlegear"},
	["ItemSet - Dreamwalker Raiment"]	= "22492 22494 22493 22490 22489 22491 22488 22495 23064", -- Druid
	["ItemSet - Bonescythe Armor"]		= "22483 22476 22481 22478 22477 22479 22480 22482 23060", -- Rogue
	["ItemSet - Frostfire Regalia"]		= "22502 22503 22498 22501 22497 22496 22500 22499 23062", -- Mage
	["ItemSet - Vestments of Faith"]	= "22518 22519 22514 22517 22513 22512 22516 22515 23061", -- Priest
	["ItemSet - Plagueheart Raiment"]	= "22510 22511 22506 22509 22505 22504 22508 22507 23063", -- Warlock
	["ItemSet - Cryptstalker Armor"]	= "22440 22442 22441 22438 22437 22439 22436 22443 23067", -- Hunter
	["ItemSet - The Earthshatterer"]	= "22468 22470 22469 22466 22465 22467 22464 22471 23065", -- Shaman
	["ItemSet - Redemption Armor"]		= "22430 22431 22426 22428 22427 22429 22425 22424 23066", -- Paladin
	["ItemSet - Dreadnaught's Battlegear"]	= "22423 22416 22421 22422 22418 22417 22419 22420 23059", -- Warrior
	--Tier 4 - iLVL 105
	["ItemSet - Tier4"] = {"ItemSet - Tier4 Druid", "ItemSet - Demon Stalker Armor", "ItemSet - Aldor Regalia", "ItemSet - Tier4 Paladin", "ItemSet - Tier4 Priest", "ItemSet - Netherblade", "ItemSet - Tier4 Shaman", "ItemSet - Voidheart Raiment", "ItemSet - Tier4 Warrior"},
	["ItemSet - Tier4 Druid"]		= {"ItemSet - Malorne Harness", "ItemSet - Malorne Raiment", "ItemSet - Malorne Regalia"},
	["ItemSet - Malorne Harness"]		= "29096 29097 29099 29100 29098", -- Druid - Feral
	["ItemSet - Malorne Raiment"]		= "29087 29086 29090 29088 29089", -- Druid - Restoration
	["ItemSet - Malorne Regalia"]		= "29093 29094 29091 29092 29095", -- Druid - Balance
	["ItemSet - Demon Stalker Armor"]	= "29085 29081 29083 29082 29084", -- Hunter
	["ItemSet - Aldor Regalia"]		= "29076 29080 29078 29079 29077", -- Mage
	["ItemSet - Tier4 Paladin"]		= {"ItemSet - Justicar Armor", "ItemSet - Justicar Battlegear", "ItemSet - Justicar Raiment"},
	["ItemSet - Justicar Armor"]		= "29066 29068 29067 29069 29070", -- Paladin - Protection
	["ItemSet - Justicar Battlegear"]	= "29071 29073 29072 29074 29075", -- Paladin - Retribution
	["ItemSet - Justicar Raiment"]		= "29062 29061 29065 29063 29064", -- Paladin - Holy
	["ItemSet - Tier4 Priest"]		= {"ItemSet - Incarnate Raiment", "ItemSet - Incarnate Regalia"},
	["ItemSet - Incarnate Raiment"]		= "29055 29049 29054 29050 29053", -- Priest - Healing
	["ItemSet - Incarnate Regalia"]		= "29057 29059 29056 29058 29060", -- Priest - Damage
	["ItemSet - Netherblade"]		= "29046 29045 29044 29048 29047", -- Rogue
	["ItemSet - Tier4 Shaman"]		= {"ItemSet - Cyclone Harness", "ItemSet - Cyclone Raiment", "ItemSet - Cyclone Regalia"},
	["ItemSet - Cyclone Harness"]		= "29038 29039 29040 29043 29042", -- Shaman - Enhancment
	["ItemSet - Cyclone Raiment"]		= "29032 29029 29028 29030 29031", -- Shaman - Restoration
	["ItemSet - Cyclone Regalia"]		= "29033 29035 29034 29036 29037", -- Shaman - Elemental
	["ItemSet - Voidheart Raiment"]		= "28963 28968 28966 28967 28964", -- Warlock
	["ItemSet - Tier4 Warrior"]		= {"ItemSet - Warbringer Armor", "ItemSet - Warbringer Battlegear"},
	["ItemSet - Warbringer Armor"]		= "29012 29011 29017 29015 29016", -- Warrior - Tanking
	["ItemSet - Warbringer Battlegear"]	= "29021 29019 29020 29022 29023", -- Warrior - Damage
	--Tier 5 - iLVL 120
	["ItemSet - Tier5"] = {"ItemSet - Tier5 Druid", "ItemSet - Rift Stalker Armor", "ItemSet - Tirisfal Regalia", "ItemSet - Tier5 Paladin", "ItemSet - Tier5 Priest", "ItemSet - Deathmantle", "ItemSet - Tier5 Shaman", "ItemSet - Corruptor Raiment", "ItemSet - Tier5 Warrior"},
	["ItemSet - Tier5 Druid"]		= {"ItemSet - Nordrassil Harness", "ItemSet - Nordrassil Raiment", "ItemSet - Nordrassil Regalia"},
	["ItemSet - Nordrassil Harness"]	= "30222 30223 30228 30229 30230", -- Druid - Feral
	["ItemSet - Nordrassil Raiment"]	= "30216 30217 30219 30220 30221", -- Druid - Restoration
	["ItemSet - Nordrassil Regalia"]	= "30231 30232 30233 30234 30235", -- Druid - Balance
	["ItemSet - Rift Stalker Armor"]	= "30139 30140 30141 30142 30143", -- Hunter
	["ItemSet - Tirisfal Regalia"]		= "30206 30205 30207 30210 30196", -- Mage
	["ItemSet - Tier5 Paladin"]		= {"ItemSet - Crystalforge Armor", "ItemSet - Crystalforge Battlegear", "ItemSet - Crystalforge Raiment"},
	["ItemSet - Crystalforge Armor"]	= "30123 30125 30124 30126 30127", -- Paladin - Protection
	["ItemSet - Crystalforge Battlegear"]	= "30129 30130 30132 30133 30131", -- Paladin - Retribution
	["ItemSet - Crystalforge Raiment"]	= "30134 30135 30136 30137 30138", -- Paladin - Holy
	["ItemSet - Tier5 Priest"]		= {"ItemSet - Avatar Raiment", "ItemSet - Avatar Regalia"},
	["ItemSet - Avatar Raiment"]		= "30153 30152 30151 30154 30150", -- Priest - Healing
	["ItemSet - Avatar Regalia"]		= "30160 30161 30162 30159 30163", -- Priest - Damage
	["ItemSet - Deathmantle"]		= "30144 30145 30146 30148 30149", -- Rogue
	["ItemSet - Tier5 Shaman"]		= {"ItemSet - Cataclysm Harness", "ItemSet - Cataclysm Raiment", "ItemSet - Cataclysm Regalia"},
	["ItemSet - Cataclysm Harness"]		= "30185 30189 30190 30192 30194", -- Shaman - Enhancment
	["ItemSet - Cataclysm Raiment"]		= "30164 30165 30166 30167 30168", -- Shaman - Restoration
	["ItemSet - Cataclysm Regalia"]		= "", -- Shaman - Elemental
	["ItemSet - Corruptor Raiment"]		= "30211 30212 30213 30215 30214", -- Warlock
	["ItemSet - Tier5 Warrior"]		= {"ItemSet - Destroyer Armor", "ItemSet - Destroyer Battlegear"},
	["ItemSet - Destroyer Armor"]		= "30113 30115 30114 30116 30117", -- Warrior - Tanking
	["ItemSet - Destroyer Battlegear"]	= "30120 30118 30119 30121 30122", -- Warrior - Damage
-- Keys
	-- Value == Lockpicking skill equiv
	["Skeleton Keys"]		= "15869:25 15870:125 15871:200 15872:300",
	["Seaforium Charges"]		= "4367:150 18594:300 4398:250",
-- Libram
	["Libram"] = {"Libram - Burning Steppes", "Libram - Dire Maul"},
	["Libram - Burning Steppes"]	= "11732 11733 11734 11736 11737",
	["Libram - Dire Maul"]		= "18332 18333 18334",
-- Lockboxes
	-- Value == Lockpicking skill needed to open.  Basically anything that contains items, like clams, bag, boxes, etc
	["Lockboxes"]			= "4632:1 4633:1 4634:75 4636:125 4637:175 4638:225 5758:225 5759:225 5760:225 6354:1 6355:125 6356:1 13875:175 13918:75 16882:75 16883:125 16884:175 16885:250 29569:300",
-- Mini-pets
	["Minipet - All"]	= {"Minipet", "Minipet - Holiday"},
	["Minipet"]		= "23083 18597 23007 23015 23002 18598 22235 21277 4401 8485 8486 8487 8488 8489 8490 8491 8492 8494 8495 8496 8497 8498 8499 8500 8501 10360 10361 10392 10393 10394 10398 10822 11023 11026 11110 11474 11825 11826 12264 12529 13582 13583 13584 15996 19450 20371 20769 29953 29956 29957 29958 29364 29363 29901 29902 29903 29904",
	-- Holiday pets require a snowball to lure out of their kitty-carriers
	["Minipet - Holiday"]	= "21301 21305 21308 21309",
-- Mined Gems
	["Mined Gem"] = {"Mined Gem - Copper", "Mined Gem - Tin", "Mined Gem - Silver", "Mined Gem - Iron", "Mined Gem - Gold", "Mined Gem - Mithril", "Mined Gem - Truesilver", "Mined Gem - Thorium", "Mined Gem - ZG Thorium", "Mined Gem - Rich Thorium", "Mined Gem - Dark Iron", "Mined Gem - Fel Iron", "Mined Gem - Adamantite", "Mined Gem - Rich Adamantite", "Mined Gem - Khorium"},
	["Mined Gem - Copper"]		= "818 774 1210",
	["Mined Gem - Tin"]		= "1210 1705 1529",
	["Mined Gem - Silver"]		= "1210 1705",
	["Mined Gem - Iron"]		= "1529 1705 3864 7909",
	["Mined Gem - Gold"]		= "3864 1529 1705",
	["Mined Gem - Mithril"]		= "3864 7909 7910",
	["Mined Gem - Truesilver"]	= "7909 7910 3864",
	["Mined Gem - Thorium"]		= "7910 12361 12364 12799 12800 12363",
	["Mined Gem - ZG Thorium"]	= "12363 12800 12799 7910 12364 12361",
	["Mined Gem - Rich Thorium"]	= "12363 12799 12364 7910 12800 12361",
	["Mined Gem - Dark Iron"]	= "11382",
	["Mined Gem - Fel Iron"]	= "23079 23107 21929",
	["Mined Gem - Adamantite"]	= "12363 23117 23112 23077",
	["Mined Gem - Rich Adamantite"]	= "12363 23112 23117 23077 23437 23079",
	["Mined Gem - Khorium"]		= "23436 23077 23079",
-- Mounts
	-- Value == speed
	["Mounts - All"]	= {"Mounts", "Mounts - AQ", "Mounts - Flying"},
	["Mounts"]		= "1132:60 2411:60 2414:60 5655:60 5656:60 5665:60 5668:60 5864:60 5872:60 5873:60 8588:60 8563:60 8591:60 8592:60 8595:60 8629:60 8631:60 8632:60 8653:60 13321:60 13322:60 13331:60 13332:60 13333:60 15277:60 15290:60 15292:60 28481:60 29743:60 29744:60 29220:60 29221:60 29222:60 28927:60 8586:100 12302:100 12303:100 12330:100 12351:100 12353:100 12354:100 13086:100 13317:100 13326:100 13327:100 13328:100 13329:100 13334:100 13335:100 15293:100 18241:100 18242:100 18243:100 18244:100 18245:100 18246:100 18247:100 18248:100 18766:100 18767:100 18772:100 18773:100 18774:100 18776:100 18777:100 18778:100 18785:100 18786:100 18787:100 18788:100 18789:100 18790:100 18791:100 18793:100 18794:100 18795:100 18796:100 18797:100 18798:100 18902:100 19029:100 19030:100 19872:100 21176:100 29465:100 29466:100 29467:100 29468:100 29469:100 29470:100 29471:100 29472:100 29745:100 29746:100 29747:100 29223:100 29224:100 28936:100 29102:100 29103:100 29104:100 29105:100 29227:100 29228:100 29229:100 29230:100 28915:100 29231:100",
	["Mounts - AQ"]		= "21218:100 21321:100 21323:100 21324:100 21176:100",
	["Mounts - Flying"]	= "25471:60 25470:60 25472:60 25473:280 25528:280 25529:280 25527:280 25475:60 25476:60 25474:60 25531:280 25533:280 25477:280 25532:280",
-- Potions
	["Potion"] = {"Potion - All Heal", "Potion - All Mana", "Potion - Dreamless", "Potion - Rage", "Potion - Cure", "Potion - Buff", "Potion - Energy"},
	-- Value == Avg health recovered
	["Potion - All Heal"]		= {"Potion - Heal", "Potion - Heal Alterac", "Potion - Rejuvenation"},
	["Potion - Heal"]		= "118:80 858:160 4596:160 929:320 1710:520 3928:800 18839:800 13446:1400 22829:2000",
	["Potion - Heal Alterac"]	= "17349:640 17348:1120",
	-- Value == Avg health/mana recovery
	["Potion - Rejuv All"]		= {"Potion - Rejuvenation","Potion - Dreamless"},
	["Potion - Rejuvenation"]	= "2456:120 9144:750 18253:1600",
	["Potion - Dreamless"]		= "12190:1200 20002:2100",
	-- Value == Avg mana recovered
	["Potion - All Mana"]		= {"Potion - Mana", "Potion - Mana Alterac", "Potion - Rejuv Rejuvenation"},
	["Potion - Mana"]		= "2455:160 3385:320 3827:520 6149:800 13443:1200 18841:1200 13444:1800 22832:2500",
	["Potion - Mana Alterac"]	= "17351:1120 17352:640",
	-- Value == Avg rage gained (Mighty Rage Potion	also gives a stat buff)
	["Potion - Rage"]		= "5631:30 5633:45 13442:45",
	["Potion - Cure"]		= "3386 13462 9030 2633",
	["Potion - Buff"]		= {"Potion - Buff Health", "Potion - Buff Mana", "Potion - Buff Armor", "Potion - Buff Strength", "Potion - Buff Stamina", "Potion - Buff Agility", "Potion - Buff Intellect", "Potion - Buff Spirit", "Potion - Buff Regen", "Potion - Buff Attack Power", "Potion - Buff Spell", "Potion - Buff Resistance", "Potion - Buff Elemental", "Potion - Buff Other", "Potion - Buff Flasks"},
	["Potion - Buff Health"]	= "2458:27 3825:120 13510:1200", -- Value == Amount health is buffed
	["Potion - Buff Mana"]		= "13511:2000", -- Value == Amount mana is buffed
	["Potion - Buff Armor"]		= "5997:50 8951:250 3389:150 13445:450 4623:1000 13455:2000", -- Value == Amount armor is buffed
	["Potion - Buff Strength"]	= "2454:4 6662:8 3391:8 13453:18 9206:25", -- Value == Amount str is buffed
	["Potion - Buff Stamina"]	= "13453:18", -- Value == Amount sta is buffed
	["Potion - Buff Agility"]	= "2457:4 3390:8 8949:15 9187:25 13452:25", -- Value == Amount agi is buffed
	["Potion - Buff Intellect"]	= "3383:6 13447:18 9179:25", -- Value == Amount int is buffed
	["Potion - Buff Spirit"]	= "13447:18", -- Value == Amount spr is buffed
	["Potion - Buff Regen"]		= "3382:2 3388:6 3826:12", -- Value == Amount health regenerated every 5 sec
	["Potion - Buff Attack Power"]	= "9224:265 12820:35", -- Value == Amount attack power is increased
	["Potion - Buff Spell"]		= "6373:10 17708:15 13454:35 9155:20 9264:40 13512:150", -- Value == Amount spell dammage is increased
	["Potion - Buff Resistance"]	= "9088:10 3384:25 9036:50 13513:25", -- Value == Amount resistance is increased
	["Potion - Buff Elemental"]	= "6048:900 6049:1300 6050:1800 6051:400 6052:1800 13457:2600 13459:2600 13456:2600 13458:2600 13461:2600", -- Value == Amount of elemental absorbtion
	["Potion - Buff Other"]		= "3387 10592 3823 2459 5996 3828 9233 9154 9172 5634 9197 6372 13506 8529",
	["Potion - Buff Flasks"]	= "13506 13510 13511 13512 13513",
	["Potion - Energy"]		= "7676 27553",
-- Reagents
	-- Value == Earliest level reagent is needed
	["Reagent"] = {"Reagent - Paladin", "Reagent - Druid", "Reagent - Mage", "Reagent - Priest", "Reagent - Rogue", "Reagent - Shaman", "Reagent - Warlock"},
	["Reagent - Paladin"]		= "17033:30",
	["Reagent - Druid"]		= "17021:50 17026:60 17034:20 17035:30 17036:40 17037:50 17038:60 22147:70",
	["Reagent - Mage"]		= "17020:56 17031:20 17032:40 17056:12",
	["Reagent - Priest"]		= "17028:48 17029:60 17056:34",
	["Reagent - Rogue"]		= "5140:22 5530:34",
	["Reagent - Shaman"]		= "17030:30 17057:22 17058:28 5175:4 5176:10 5177:20 5178:30",
	["Reagent - Warlock"]		= "5565:50 6265 16583:60",
-- Recipe
	["Recipe - All"]		= {"Recipe - Vendor", "Recipe - Drop", "Recipe - Quest", "Recipe - Crafted"},
	["Recipe - Alchemy"]		= {"Recipe - Vendor Alchemy", "Recipe - Drop Alchemy", "Recipe - Quest Alchemy", "Recipe - Crafted Alchemy"},
	["Recipe - Blacksmithing"]	= {"Recipe - Vendor Blacksmithing", "Recipe - Drop Blacksmithing", "Recipe - Quest Blacksmithing", "Recipe - Crafted Blacksmithing"},
	["Recipe - Cooking"]		= {"Recipe - Vendor Cooking", "Recipe - Drop Cooking", "Recipe - Quest Cooking"},
	["Recipe - Enchanting"]		= {"Recipe - Vendor Enchanting", "Recipe - Drop Enchanting"},
	["Recipe - Engineering"]	= {"Recipe - Vendor Engineering", "Recipe - Drop Engineering", "Recipe - Quest Engineering"},
	["Recipe - Fishing"]		= {"Recipe - Vendor Fishing"},
	["Recipe - First Aid"]		= {"Recipe - Vendor First Aid", "Recipe - Drop First Aid"},
	["Recipe - Leatherworking"]	= {"Recipe - Vendor Leatherworking", "Recipe - Drop Leatherworking", "Recipe - Quest Leatherworking"},
	["Recipe - Tailoring"]		= {"Recipe - Vendor Tailoring", "Recipe - Drop Tailoring", "Recipe - Quest Tailoring"},
	-- Recipes sold by a vendor, somewhere
	-- Value = vendor price
	["Recipe - Vendor"] = {"Recipe - Vendor Alchemy", "Recipe - Vendor Blacksmithing", "Recipe - Vendor Cooking", "Recipe - Vendor Enchanting", "Recipe - Vendor Engineering", "Recipe - Vendor Fishing", "Recipe - Vendor First Aid", "Recipe - Vendor Leatherworking", "Recipe - Vendor Tailoring"},
	["Recipe - Vendor Alchemy"]		= "13477:12000 13478:13000 5640:100 5642:1800 5643:2000 6053:800 6055:1500 6056:2000 6057:2000 9300:10000 9301:10000 9302:9000 6068:1500 6054:900 14634:2500 13480:15000 9303:8000 12958:50000 9304:8000 9305:8000 13501:30000 13483:15000 13482:15000 13484:15000 13485:15000 20013:50000 20011:50000 20014:50000 20012:50000 20761:120000",
	["Recipe - Vendor Blacksmithing"]	= "12162:3000 12164:4400 7995:6000 10858:3000 6047:4400 12163:4400 19208:70000 19209:70000 19211:120000 19210:120000 19212:120000 17051:70000 17060:220000 19207:80000 19206:60000 17052:180000 17059:220000 20040:80000 17049:90000 17053:200000 19202:22000 19204:40000 19203:22000 19205:40000 19781:50000 19780:50000 19779:50000 19778:50000 19777:50000 19776:50000 22219:50000 22221:80000 22209:50000 22214:50000 22768:50000 22766:50000 22767:50000 8030:10000 12823:20000 12819:16000 12703:40000",
	["Recipe - Vendor Cooking"]		= "16072:10000 13949:20000 4609:1000 2889:240 3734:1600 3679:400 6325:40 6330:1200 5528:800 2698:400 3681:1600 3678:400 3682:1600 12239:7000 5485:400 3683:1600 2697:400 12240:7000 20075:2000 3735:1800 12229:5000 12231:3000 5489:1200 13947:20000 6329:400 6328:400 13948:20000 17062:2200 3680:1600 12233:3000 6368:400 2699:800 12228:5000 6369:2200 2701:1600 6326:40 6892:250 16111:12000 2700:400 18046:12000 728:200 12226:25 5488:400 5484:240 5483:140 5486:440 12232:5000 13940:16000 13941:16000 6039:5000 13942:16000 13943:16000 12227:1600 16110:12000 13945:20000 13946:20000 13939:16000 16767:3000 21099:500 21219:5000 17201:240 17200:25 18160:200",
	["Recipe - Vendor Enchanting"]		= "6349:500 11223:5800 11163:3000 11101:2500 6342:300 11039:800 16217:12000 6377:1000 6346:400 16221:16000 16224:20000 16243:22000 20758:500 20752:3000 20753:4000 20754:10000 20755:20000 19449:100000 19448:80000 19444:30000 19445:30000 19447:60000 19446:30000 20756:40000 20757:40000 20732:90000 20733:90000 22392:25000",
	["Recipe - Vendor Engineering"]		= "18649:1800 10607:3600 7560:1200 13309:1000 14639:1500 10609:4000 16041:12000 16042:12000 18647:1800 13310:2000 10602:3000 16050:20000 7742:2400 7561:2000 18648:1800 18652:12000 13308:1800 16046:16000 13311:10000 18656:16000 16047:16000 18651:12000 20001:50000 20000:50000 19027:5000 18650:5000",
	["Recipe - Vendor Fishing"]		= "16083:10000",
	["Recipe - Vendor First Aid"]		= "16084:10000 16112:2200 16113:5000 19442:100000",
	["Recipe - Vendor Leatherworking"]	= "18949:2000 5973:650 7289:650 20576:350 15751:20000 15729:12000 7613:2000 7451:2800 18731:2000 7361:1800 15735:14000 15734:14000 5786:550 5787:600 5789:2800 8409:4000 13288:2500 7290:1600 15741:16000 5788:650 8385:3500 15725:12000 13287:2500 6474:550 6475:1500 15758:22000 7362:2000 15740:16000 14635:3000 15726:12000 15724:12000 15762:25000 15756:22000 18239:3500 17025:160000 19331:90000 19332:90000 17022:150000 19330:60000 19333:90000 17023:160000 20253:16000 20254:20000 19327:40000 19326:22000 19328:22000 19329:40000 19771:50000 19773:50000 19770:50000 19772:50000 19769:50000 20382:60000 20506:40000 20507:40000 20508:40000 20509:40000 20510:40000 20511:40000 22769:50000 22770:50000 22771:50000 15759:22000",
	["Recipe - Vendor Tailoring"]		= "7089:1500 7114:1000 6272:300 6270:200 6274:400 14627:800 6401:1100 6275:800 4355:1500 10314:4000 10311:3000 10317:4000 5771:200 5772:500 10326:5000 10323:4500 10321:4500 10325:10000 10318:7000 10728:1500 7087:1200 7088:5000 14630:1000 14483:16000 14526:20000 14468:12000 14488:12000 14472:12000 14481:16000 14469:12000 21358:12000 18487:40000 17018:80000 19220:90000 17017:180000 19219:60000 19215:22000 19218:40000 19216:22000 19217:40000 19766:50000 19765:50000 19764:50000 22310:20000 22312:50000 22307:6000 22308:20000 22683:90000 22773:50000 22772:50000 22774:50000",
	-- Dropped recipes (recipes that are only available as drops)
	["Recipe - Drop"] = {"Recipe - Drop Alchemy", "Recipe - Drop Blacksmithing", "Recipe - Drop First Aid", "Recipe - Drop Cooking", "Recipe - Drop Enchanting", "Recipe - Drop Engineering", "Recipe - Drop Leatherworking", "Recipe - Drop Tailoring"},
	["Recipe - Drop Alchemy"]		= "13481 3832 9297 3830 17709 6663 9298 21547 3396 2553 6211 3394 13491 13479 13522 13520 13518 13521 13519 9296 13493 13497 13494 13495 13496 13499 13490 9295 3395 9293 18257 13476 3831 3393 13492 2555 13489 13488 13486 13487 9294",
	["Recipe - Drop Blacksmithing"]		= "12835 12834 12838 22220 7992 12830 11614 11612 11610 11615 11611 7993 2883 8030 17706 18264 3868 12836 3610 7192 3867 3875 3873 3872 3871 3611 3612 3870 12833 12839 7990 7975 12716 12823 12728 5543 6045 6044 3866 12717 12837 3608 7991 7976 7989 12819 22390 3874 12685 12697 12689 12702 12695 12713 2881 8028 12718 12707 12714 12719 12706 22389 12261 12827 3869 5578 10424 2882 6046 12703 12720 22222 12682 12683 12693 12684 12694 12704 12692 22388 12828 12711 8029 12691",
	["Recipe - Drop First Aid"]		= "19442",
	["Recipe - Drop Cooking"]		= "18267 6661 2700",
	["Recipe - Drop Enchanting"]		= "11038 16249 16255 16247 16245 16215 11167 16220 16214 11204 11225 6375 6344 6347 16218 16251 16246 16253 16242 20736 16216 11206 11098 20734 20735 11205 11203 20729 20728 16219 16244 20730 11151 11150 11226 20727 11166 20731 20726 11152 11224 11168 11081 11202 16222 16252 11208 11207 18260 16223 11164 11165 16254 6348 18259 16250 16248 17725 11813",
	["Recipe - Drop Engineering"]		= "16055 16054 18290 21730 10601 10603 18292 4415 16049 16048 4413 6716 4411 6672 16056 18291 18654 18653 4416 21731 18657 21727 21733 21728 21734 21729 21735 4417 16044 11827 18655 16053 4408 10604 4412 10606 11828 4414 21732 4410 21724 21725 21726 4409 10608 17720 10605 16045 16043 16051 18658 16052 18661",
	["Recipe - Drop Leatherworking"]	= "4301 18949 4297 5973 8390 8387 8389 8386 15781 15770 7289 20576 15751 15763 15737 15729 15746 15755 18517 8384 18252 7360 4296 2409 15772 7452 7449 2406 2408 5972 15761 15747 15779 18514 17722 15733 7613 7450 7451 4299 4298 5974 4300 7364 18731 15743 15738 15748 15774 15727 7361 18518 4294 4293 15760 15735 15771 15752 15734 18515 5786 5789 5787 8409 7363 13288 15730 7290 7288 15776 15745 15739 15731 15765 15777 18519 15753 21548 15741 15764 7453 18516 5788 8399 8397 8395 8398 8402 8401 8400 15749 15732 15775 2407 15773 15768 15728 15744 15757 15742 15754",
	["Recipe - Drop Tailoring"]		= "7085 18414 22309 5775 4352 14510 14484 14479 14494 14478 14482 14476 14490 14471 14486 18418 10316 21371 7084 7086 14492 18415 14496 14506 14508 18265 14474 14489 14467 14466 14473 14477 14495 14480 14511 2601 7090 5774 4292 7092 4346 18416 14499 14509 18417 14497 14507 14501 4348 4349 2598 6271 10312 10320 10302 10315 10300 4345 4347 4354 14493 14513 14514 5773 14498 14491 14504 14470 4351 4353 4350 4356 6390 6391 7091 14512 10301 14485 14500 14505",
	-- Quested recipes
	["Recipe - Quest"] = {"Recipe - Quest Alchemy", "Recipe - Quest Blacksmithing", "Recipe - Quest Cooking", "Recipe - Quest Engineering", "Recipe - Quest Leatherworking", "Recipe - Quest Tailoring"},
	["Recipe - Quest Alchemy"]		= "4597 4624",
	["Recipe - Quest Blacksmithing"]	= "7979 12727 12726 12725 6735 7980 12699 12700 12690 12705 12701 12715 12687 3609 7985 7981 7978 7982 9367 7983 7984 12688 18592 20554 20553 20555 12696 12825 12824 12821",
	["Recipe - Quest Cooking"]		= "18160 2889 5487 5486 5482 3737 2889 5486 2697 3679 728 3678 3680 2699 2701 3683 3734 3681 3735 3682 3736 4609 21025",
	["Recipe - Quest Engineering"]		= "21738 21737",
	["Recipe - Quest Leatherworking"]	= "8408 6710 8404 8403 8405 8406 8407 5083 6476",
	["Recipe - Quest Tailoring"]		= "10463 17724 21722 21723 20548 20547 20546",
	-- Crated recipes.
	["Recipe - Crafted"] = {"Recipe - Crafted Alchemy", "Recipe - Crafted Blacksmithing"},
	["Recipe - Crafted Alchemy"]		= "10644",
	["Recipe - Crafted Blacksmithing"]	= "10713",
	["Recipe - Seasonal"]			= "17200 17201",
-- Reputation
	-- Misc crap you collect to turn in for tokens like scourgestones or savage fronds.
	-- ZG stuff is later on!
	["Reputation Junk"]		= "21377 21383 12840 12841 12843 20404 22529 22525 22526 22527 22528",
	-- Rewards from turnins.  Ex: Argent Dawn Valor tokens, Zandalar Honor Tokens
	["Reputation Tokens"]		= "22523 22524 12844 19858 20802 20800 20801",
-- Reputation Rewards
	["Rewards"] = {"Rewards - Argent Dawn", "Rewards - Ashtongue Deathsworn", "Rewards - Bloodsail Buccaneers", "Rewards - Brood of Nozdormu", "Rewards - Cenarion Circle", "Rewards - Cenarion Expedition", "Rewards - Darkspear Trolls", "Rewards - Darnassus", "Rewards - Exodar", "Rewards - Frostwolf Clan", "Rewards - Gnomeregan Exiles", "Rewards - Honor Hold", "Rewards - Hydraxian Waterlords", "Rewards - Ironforge", "Rewards - Keepers of Time", "Rewards - Kurenai", "Rewards - Lower City", "Rewards - Orgrimmar", "Rewards - Silvermoon City", "Rewards - Silverwing Sentinels", "Rewards - Sporeggar", "Rewards - Stormpike Guard", "Rewards - Stormwind", "Rewards - The Aldor", "Rewards - The Consortium", "Rewards - The Defilers", "Rewards - The League of Arathor", "Rewards - The Mag'har", "Rewards - The Scale of the Sands", "Rewards - The Scryers", "Rewards - The Sha'tar", "Rewards - The Violet Eye", "Rewards - Thorium Brotherhood", "Rewards - Thrallmar", "Rewards - Thunder Bluff", "Rewards - Timbermaw Hold", "Rewards - Tranquillien", "Rewards - Undercity", "Rewards - Warsong Outriders", "Rewards - Wintersaber Trainers", "Rewards - Zandalar Tribe"},
	-- Value = Reputation index of:
	-- {"Hated", "Hostile", "Unfriendly", "Neutral", "Friendly", "Honored", "Revered", "Exalted", "MaxExalted"
	["Rewards - Argent Dawn"]		= "18171:7 18182:8 18169:7 18170:7 18172:7 18173:7 13482:6 13810:7 13813:7 13724:5 19447:7 19446:6 19442:6 19216:6 19217:7 19328:6 19329:7 19203:6 19205:7",
	["Rewards - Ashtongue Deathsworn"]	= "",
	["Rewards - Bloodsail Buccaneers"]	= "22744:4 22745:4 22743:4 22742:4 12185:5",
	["Rewards - Brood of Nozdormu"]		= "21206:4 21196:4 21201:4 21207:5 21197:5 21202:5 21208:6 21198:6 21203:6 21209:7 21199:7 21204:7 21210:8 21200:8 21205:8",
	["Rewards - Cenarion Circle"]		= "22209:5 22768:5 22766:7 22767:6 22214:6 20732:5 20733:6 22769:5 22770:6 22771:7 20382:8 20509:5 20511:7 20510:6 20506:5 20508:7 20507:6 22310:5 22683:7 22312:7 22773:6 22772:5 22774:7",
	["Rewards - Cenarion Expedition"]	= "29172:8 29171:8 29170:8 24183:7 25835:6 25737:5 25736:6 25735:6 25836:6 29173:7 24412:7 25838:6 29174:7 29192:7 29194:6 22918:7 24417:6 24429:5 24315:5 23618:6 28632:6 22922:8 23814:5",
	["Rewards - Darkspear Trolls"]		= "18788:8 18789:8 18790:8 13317:8 8588:8 8591:8 8592:8",
	["Rewards - Darnassus"]			= "18766:8 18767:8 18902:8 8632:8 8631:8 8629:8",
	["Rewards - Exodar"]			= "29745:8 29743:8 29744:8 29746:8 29747:8 28481:8",
	["Rewards - Frostwolf Clan"]		= "17909:9 17908:8 17907:7 17906:6 17905:5 17690:4",
	["Rewards - Gnomeregan Exiles"]		= "18772:8 18773:8 18774:8 8595:8 13321:8 8563:8 13322:8",
	["Rewards - Honor Hold"]		= "29153:8 29156:8 29151:8 25825:6 29166:7 29213:5 29214:6 29215:6 29169:7 25826:6 29196:6 29189:7 24008:6 30622:7 24007:5 22531:5 22547:7 23999:8 23619:8 22905:6 25870:6",
	["Rewards - Hydraxian Waterlords"]	= "17333:6 22754:7 18399:6 18398:6",
	["Rewards - Ironforge"]			= "18786:8 18787:8 18785:8 5872:8 5864:8 5873:8",
	["Rewards - Keepers of Time"]		= "29183:8 29182:8 29181:8 29185:7 29713:8 29184:7 28272:6 29198:6 29186:7 22536:6 30635:7",
	["Rewards - Kurenai"]			= "29227:8 29228:8 29229:8 29230:8 29231:8 29138:8 29146:7 29140:8 29136:8 29142:7 29217:5 29218:7 29219:6 30443:7 30444:6",
	["Rewards - Lower City"]		= "30832:8 30834:8 30830:8 30836:7 30841:7 30835:7 30845:6 30846:7 30633:7 30833:6",
	["Rewards - Orgrimmar"]			= "18796:8 18798:8 18797:8 5668:8 5665:8 1132:8",
	["Rewards - Silvermoon City"]		= "29223:8 28936:8 29224:8 29221:8 29220:8 29222:8 28927:8",
	["Rewards - Silverwing Sentinels"]	= "19506:9",
	["Rewards - Sporeggar"]			= "29150:7 25827:6 25828:6 29149:7 22906:8 22916:7 30156:4 27689:4 25550:6 25548:5",
	["Rewards - Stormpike Guard"]		= "17904:9 17903:8 17902:7 17901:6 17900:5 17691:4",
	["Rewards - Stormwind"]			= "18777:8 18776:8 18778:8 2411:8 5656:8 5655:8 2414:8",
	["Rewards - The Aldor"] 		= "29123:8 29124:8 29129:6 29130:7 24177:7 29128:7 29127:7 23149:5 23145:6 24292:6 24294:8 29704:6 29703:7 29702:8 29693:6 29691:7 29689:8 25721:7 23601:5 23604:7 23603:6 23602:8 28886:8 28887:8 28888:8 28889:8 28881:6 28878:6 28885:6 28882:6",
	["Rewards - The Consortium"]		= "29121:8 29119:8 29115:7 29116:6 25733:6 25732:5 25734:7 24314:6 25902:6",
	["Rewards - The Defilers"]		= "20131:9",
	["Rewards - The League of Arathor"]	= "20132:9",
	["Rewards - The Mag'har"]		= "29102:8 28915:8 29104:8 29105:8 29103:8 29145:7 29139:8 29135:8 29137:8 25741:5 25743:7 25742:6 29147:7 29141:7 29664:6",
	["Rewards - The Scale of the Sands"]	= "31737:6 31735:6 22538:7",
	["Rewards - The Scryers"]		= "29125:8 29126:8 24176:7 29134:7 29131:7 29132:7 29133:7 23143:6 23133:5 22908:7 29701:6 29700:7 29698:8 29684:7 29682:6 29677:8 24295:8 25722:7 24293:6 23597:5 23598:6 23599:7 23600:8 28909:8 28910:8 28911:8 28912:8 28903:7 28904:7 28907:7 28908:7",
	["Rewards - The Sha'tar"]		= "29177:8 29176:8 29175:8 29180:7 30826:6 29717:8 29179:7 28273:6 28281:7 29195:6 29191:7 22915:7 22537:7 13517:7 30634:7",
	["Rewards - The Violet Eye"]		= "31395:6 31393:6 29187:6 31394:7",
	["Rewards - Thorium Brotherhood"]	= "17051:5 19206:6 17049:6 17053:7 19207:7 17052:7 20040:8 17059:6 17060:6 19208:7 19209:7 19211:8 19212:8 19210:8 19444:5 19448:6 19449:7 17023:5 17022:5 19330:6 17025:6 19333:7 19331:7 17018:5 17017:6 19219:6 19220:7 20761:5",
	["Rewards - Thrallmar"]			= "29152:8 29155:8 29165:8 29168:7 29167:7 25824:6 25823:6 25738:5 25739:6 25740:6 29197:6 29190:7 24009:6 30637:7 24000:5 24003:7 24006:5 24004:8 24001:6 29232:6 24004:8",
	["Rewards - Thunder Bluff"]		= "18794:8 18795:8 18793:8 15290:8 15277:8",
	["Rewards - Timbermaw Hold"]		= "13484:5 21326:8 22392:5 19445:6 19218:7 19326:6 19327:7 20253:5 20254:5 19215:6 19202:6 19204:7",
	["Rewards - Tranquillien"]		= "22990:8 22986:7 28155:6 22991:5 28158:6 22992:5 22987:7 22985:7 28162:6 28164:5 22993:5",
	["Rewards - Undercity"]			= "13334:8 18791:8 13332:8 13333:8 13331:8",
	["Rewards - Warsong Outriders"]		= "19505:9",
	["Rewards - Wintersaber Trainers"]	= "13086:8",
	["Rewards - Zandalar Tribe"]		= "20757:5 20756:6 19772:7 19773:6 19766:5 19765:6 19764:7 19771:5 19770:6 19769:7 19776:7 19778:5 19777:6 19779:7 19780:6 19781:5 20012:5 20013:8 20011:7 20014:6 20000:6 20001:5",
	-- Recipes that require faction to purchase (Same recipes as recipevendor, but other grouping and values)
	-- Value = Reputation index of:
	-- {"Hated", "Hostile", "Unfirendly", "Neutral", "Friendly", "Honored", "Revered", "Exalted", "Max Exalted"}
	["Faction Recipes"]				= {"Faction Recipes - Alliance", "Faction Recipes - Horde", "Faction Recipes - Neutral", "Faction Recipes - Argent Dawn", "Faction Recipes - Cenarion Circle", "Faction Recipes - Thorium Brotherhood", "Faction Recipes - Timbermaw Hold", "Faction Recipes - Zandalar Tribe", "Faction Recipes - Ravenholdt"},
	["Faction Recipes - Alliance"]			= "7361 16113 12231 6349 10858 5489 21219 10607 21099 10609 728 16072 7560 5973 3734 2889 16111 3679 6326 2701 5786 13288 5787 16084 5788 12228 5789 2699 13947 16217 20752 12233 17200 20758 3680 16110 17062 13948 12162 8385 6329 6368 13309 6369 15725 6053 13949 7451 15729 6055 16112 6056 5485 6057 15735 12229 12240 18649 6401 6330 15741 3681 2697 12239 3678 3682 2698 5528 20576 3683 15751 18731 6892 18046 2700 4609 22307 11163 4355 10321 18949 6325 13477 13478 10326 7089 7114 6328 10317 14627 10314 10311 5643 20753 8409 17201 9300 9301 6270 9302 6274 14639 6272 10323 7289 10325 16041 16042 5640 11101 6275 11039 5642 15734 11223 6342 5771 7613 5772 7995 7290 19027",
	["Faction Recipes - Horde"]			= "6346 6349 10858 7114 16072 5973 5786 5787 16084 5788 16217 20752 17200 20758 5486 12162 16112 12164 6368 21219 6369 21099 15725 6053 13949 7451 16110 6055 5484 16113 16111 6057 11163 20075 18647 11039 6377 6326 15741 5483 12228 13287 13948 3682 5643 13947 12231 10314 8385 3735 6892 12240 6401 6068 12239 5488 4355 12226 18949 6325 13477 13478 12232 7089 6330 6328 9301 17062 9302 10311 6274 20753 8409 17201 9300 10317 6270 6054 18731 10321 6272 10323 12229 10325 16041 16042 22307 15734 7995 10326 5642 6275 11223 6342 5771 7613 5772 11101 5640",
	["Faction Recipes - Neutral"]			= "5640 5642 5643 16110 13309 13311 20754 20758 3735 14634 9303 9305 10602 7742 16224 6474 6475 13943 13945 12164 15740 14469 15758 15762 20755 7362 16083 13483 13485 15726 22308 16767 16047 13946 13501 12228 13939 12232 6369 6368 18046 5489 12231 10728 17062 12240 6275 15756 14488 13941 22696 18239 5772 6330 3734 7560 7561 13308 13310 18656 4609 21358 14481 14472 6039 14635 6047 20752 18487 6053 6056 6057 14483 14630 7088 7087 6272 10318 6068 22307 9304 21099 10858 16221 6342 22697 5788 13940 13942 5789 16243 15724 7451 7613 21219 14468 22698 15759 20753 18648 18652 13480 6377 16046 16050 12227 12229 14526 12233 12239 12162 12163 6401 18651 12958 12703 8030 12823 12819 18650",
	["Faction Recipes - Argent Dawn"]		= "13482:6 19203:6 19205:7 19216:6 19217:7 19328:6 19329:7 19442:6 19446:6 19447:7",
	["Faction Recipes - Cenarion Circle"]		= "22219:7 22221:8 22209:5 22214:6 22766:7 22767:6 22768:5 20382:8 20506:5 20507:6 20508:7 20509:5 20510:6 20511:7 22769:5 22770:6 22771:7 20732:5 20733:6 22310:5 22312:7 22683:7 22772:5 22773:6 22774:7",
	["Faction Recipes - Thorium Brotherhood"]	= "17051:5 20761:5 17018:5 17023:5 17022:5 19444:5 17059:6 17060:6 19206:6 17049:6 17017:6 19219:6 19330:6 17025:6 19448:6 19208:7 19209:7 17053:7 19207:7 17052:7 19220:7 19333:7 19332:7 19331:7 19449:7 19211:8 19212:8 19210:8 20040:8",
	["Faction Recipes - Timbermaw Hold"]		= "13484:5 19202:6 19326:6 19215:6 19445:6 20253:5 19218:7 20254:5 19204:7 19327:7 22392:5",
	["Faction Recipes - Zandalar Tribe"]		= "19764:7 19765:6 19766:5 19769:7 19770:6 19771:5 19772:7 19773:7 19776:7 19777:6 19778:5 19779:7 19780:6 19781:5 20000:6 20001:5 20011:7 20012:5 20013:8 20014:6 20756:6 20757:5",
	["Faction Recipes - Ravenholdt"] 		= "18160:4",
-- Scrolls
	-- Value == Stat boost granted
	["Scrolls"]			= {"Scrolls - Agility", "Scrolls - Intellect", "Scrolls - Protection", "Scrolls - Spirit", "Scrolls - Stamina", "Scrolls - Strength"},
	["Scrolls - Agility"]		= "3012:5 1477:9 4425:13 10309:17 27498:20",
	["Scrolls - Intellect"]		= "955:4 2290:8 4419:12 10308:16 27499:20",
	["Scrolls - Protection"]	= "3013:60 1478:120 4421:180 10305:240 27500:300",
	["Scrolls - Spirit"]		= "1181:3 1712:7 4424:11 10306:15 27501:30",
	["Scrolls - Stamina"]		= "1180:4 1711:8 4422:12 10307:16 27502:20",
	["Scrolls - Strength"]		= "954:5 2289:9 4426:13 10310:17 27503:20",
-- Stones
	["Mana Stone"]		= "5513:600 5514:400 8007:850 8008:1100 22044:1250",
	["Health Stone"]	= "5509:500 5510:800 5511:250 5512:100 9421:1200 19004:110 19005:120 19006:275 19007:300 19008:550 19009:600 19010:880 19011:960 19012:1320 19013:1440 22103:2080 22104:2288 22105:2496",
	["Soulstone"]		= "5232 16892 16893 16895 16896 22116",
	["Firestone"]		= "1254 13699 13700 13701 22128",
	["Spellstone"]		= "5522 13602 13603 22646",
-- Tradeskill Mats
	["Tradeskill Mats"] 	= {"Tradeskill Mats - Alchemy", "Tradeskill Mats - Blacksmithing", "Tradeskill Mats - Booking", "Tradeskill Mats - Enchanting", "Tradeskill Mats - Engineering", "Tradeskill Mats - First Aid", "Tradeskill Mats - Leatherworking", "Tradeskill Mats - Tailoring", "Tradeskill Mats - Poisons", "Tradeskill Mats - Smelting"},
	["Tradeskill Mats - Alchemy"]		= "3824 765 3858 8831 8836 3860 8839 3575 10620 6358 8845 8846 3164 1288 13422 13423 3356 3357 3358 7067 12803 6370 4402 6371 7070 12808 18256 4342 8153 9260 9262 7076 7078 10286 785 13463 13464 13465 7082 13467 13468 2447 3369 2449 2450 3371 6522 3372 3355 5635 8925 7972 3818 2453 8838 11176 3819 7069 12359 2452 3820 15410 12363 5637 3821 4625 7080 9149 13466 118 6359 7068",
	["Tradeskill Mats - Blacksmithing"]	= "15417 12753 20520 20725 13510 13512 22203 22202 3823 5966 2840 17011 2841 1206 2842 11371 3859 6037 3860 14047 3575 11382 3576 2592 19726 3577 12662 3864 2880 1210 12799 8146 7067 3486 4338 7069 7070 19774 1529 12810 12811 8153 7075 7076 1705 7966 17010 17012 7080 2459 7081 2318 7971 774 7972 7909 2605 7910 11186 5498 11188 7912 12809 5500 12655 8168 2589 3478 818 8170 3470 3466 2319 12804 3391 12808 12803 17203 7068 5635 12359 4234 2321 5637 4304 12644 11185 2835 4306 12360 12361 2836 3829 12364 12365 11184 7077 12800 7078 2838 3824 4255",
	["Tradeskill Mats - Booking"]		= "3730 3667 3731 6289 5465 1080 5466 5467 5468 5469 1081 5470 5471 6361 6362 17196 6303 12037 2692 4655 4402 6308 8365 2251 3172 4536 729 3173 3713 1015 3174 6889 1468 5051 12202 769 730 3685 12203 12204 12205 2924 12207 12208 13758 12206 2886 4603 5503 2672 5504 723 731 2673 6522 6317 3404 2674 12223 13889 7974 2675 17194 2678 2665 13754 13755 13756 6291 2677 13759 13760 13888 3821 2894 1179 2452 13893 159 12184 2596",
	["Tradeskill Mats - Enchanting"]	= "7082 20725 11128 7077 14343 16202 14344 16203 16204 7079 12803 11134 16206 11135 10978 13467 6217 7081 8838 11138 12808 11139 11174 11291 7067 4470 12811 8153 7068 5500 11175 11144 11176 11082 11177 11083 11178 11084 10939 12359 7909 1210 9224 2772 5637 6371 7392 11382 6370 7971 6338 13926 6037 7972 10998 3356 7075 3829 8170 10940 10938 11137",
	["Tradeskill Mats - Engineering"]	= "15407 7079 4377 2840 17011 2841 4382 2842 11371 12655 4371 3859 4375 6037 9060 3860 159 14047 3575 4389 4359 2589 3576 2592 19726 4387 3577 17010 10502 4394 10586 10505 17202 10507 12803 7191 2836 1210 3829 4399 12800 4400 4337 7068 4338 4402 7387 10648 12808 4404 8151 4385 12359 18631 8153 4407 10561 7075 10026 7076 1705 7077 10592 7078 7069 16000 10286 7080 1206 10543 14227 7082 10546 7972 7909 1529 7910 16006 3864 774 7912 12804 4357 12799 10558 10559 10560 818 8170 4361 4234 4339 19774 4611 4363 8150 4364 10285 13467 2318 2319 12810 10576 4304 4368 10500 2835 4306 12360 12361 6530 9061 12364 12365 15992 2880 15994 814 2838 7067 10647",
	["Tradeskill Mats - First Aid"]		= "4306 2589 14047 1475 1288 2592 4338 19441",
	["Tradeskill Mats - Leatherworking"]	= "12753 2934 15422 15423 3824 2459 17011 7428 1206 5082 11754 3383 14044 5784 8951 14047 14048 15419 4236 6470 18240 3390 19726 15414 8171 4338 8343 8170 8169 3356 1529 15408 14341 783 4461 1210 7286 12809 8146 7067 4337 12803 12804 19768 2312 7070 8150 7071 12810 8152 8368 8153 8167 8154 7075 14342 7076 7971 7077 8949 7078 17012 7079 2320 7080 4096 8151 14227 7082 5785 4289 2319 2605 5116 4291 5498 4340 2321 8165 5373 8172 8168 2324 4232 3864 4233 19767 4234 15420 4235 7392 5633 4231 2997 3182 2325 14256 7287 12607 5637 4304 2318 4305 18512 15407 4243 15409 15410 17010 15412 3389 4246 15415 15416 15417 2457 6471 5500 20498 20381 20500",
	["Tradeskill Mats - Tailoring"]		= "11137 8831 11040 3824 17011 9210 3827 13468 16203 2589 3383 6037 14047 14048 2592 19726 3577 8343 12662 3864 6048 4589 12800 7067 4337 12803 4338 7069 6371 7070 12808 1529 12810 7072 4342 8153 14341 14342 7076 14344 7077 17010 17012 10285 10286 11176 10290 7971 2319 2605 7910 4291 5498 6261 5500 929 8170 13926 4234 7068 2321 14227 2324 2604 4340 3182 2325 14256 2320 3829 12811 4304 4339 4305 6260 4306 12360 4341 2318 12809 12364 7079 7080 2996 18240 7078 7082 2997 7071",
	["Tradeskill Mats - Poisons"]		= "8924 3818 2928 8923 8925 18256 2930 5173 3372 3371 2931",
	["Tradeskill Mats - Smelting"]		= "2775 2776 18562 2770 3858 2771 11370 2772 7911 10620 2840 3576 3575 3857",
	-- Tradeskill ingreds by type
	["Materials"] = {"Mats - Bars", "Mats - Bolts", "Mats - Cloth", "Mats - Dusts", "Mats - Dyes", "Mats - Elemental", "Mats - Essence", "Mats - Flux", "Mats - Gem", "Mats - Grinding", "Mats - Hide", "Mats - Leather", "Mats - Nexus", "Mats - Oil", "Mats - Ore", "Mats - Parts", "Mats - Pearls", "Mats - Poisons", "Mats - Powders", "Mats - Rods", "Mats - Salt", "Mats - Scales", "Mats - Shards", "Mats - Spices", "Mats - Stones", "Mats - Thread", "Mats - Vials", "Mats - Monster Drops", "Mats - Vendor Bought"},
	["Mats - Bars"]		= "12359 11371 3860 2842 6037 3859 3575 2840 2841 3576 12655 3577 12360",
	["Mats - Bolts"]	= "4305 2997 14048 4339 2996",
	["Mats - Cloth"]	= "4306 14047 4338 14342 2592 14256 2589",
	["Mats - Dusts"]	= "11083 16204 11137 11176 10940",
	["Mats - Dyes"]	 	= "2325 2604 6260 6261 4342 10290 4340 2605 2324 4341 9210",
	["Mats - Elemental"]	= "7070 12808 7078 7082 7067 7075 7079 12803 7068 7076 7080 10286 7069 7972 7077 7081",
	["Mats - Essence"]	= "11174 10938 11135 11175 16202 11134 16203 10998 11082 10939",
	["Mats - Flux"]		= "2880 3466 18567",
	["Mats - Gem"]		= "12799 818 12800 11382 1206 774 1705 1210 12361 9262 1529 12363 11754 12364 7910 3864 19774 7909",
	["Mats - Grinding"]	= "3470 3478 7966 12644 3486",
	["Mats - Hide"]		= "4236 4231 4233 15407 8172 4461 8368 7428 783 4235 8171 4232 8169",
	["Mats - Leather"]	= "15419 2318 15423 2934 4234 2319 15417 12810 15422 8170 5082 19768 17012 4304 19767",
	["Mats - Nexus"]	= "20725",
	["Mats - Oil"]		= "6371 6370 3829 9061 3824 13423 8956",
	["Mats - Ore"]		= "2775 2776 18562 2770 3858 2771 11370 2772 7911 10620",
	["Mats - Parts"]	= "4361 10560 4404 10576 10561 15994 10546 10647 7191 4363 4394 10648 18631 4359 9060 4400 4371 4375 10507 16000 4387 4399 16006 10558 4382 4407 4389 10559 10586",
	["Mats - Pearls"]	= "5498 4611 13926 5500 7971",
	["Mats - Poisons"]	= "8924 3818 2928 8923 8925 18256 2930 5173 3372 3371 2931",
	["Mats - Powders"]	= "10505 4377 4357 15992 4364",
	["Mats - Rods"]		= "16206 6338 11144 11128 6217",
	["Mats - Salt"]		= "15409 4289 8150",
	["Mats - Scales"]	= "15408 15412 8165 6471 8167 15414 8154 6470 7286 7392 15415 7287 15416",
	["Mats - Shards"]	= "11084 14343 11139 10978 11177 14344 11138 11178",
	["Mats - Spices"]	= "2678 2665 17194 3713 2692",
	["Mats - Stones"]	= "2835 7912 2836 2838 12365",
	["Mats - Thread"]	= "2321 14341 4291 2320 8343",
	["Mats - Vials"]	= "3371 18256 8925 3372",
	-- Tradeskill ingred sources (not including harvestables above)
	["Mats - Monster Drops"]	= "15420 1475 17011 3730 3667 3731 5465 1080 5466 5784 5467 5785 5468 5469 1081 5470 13926 5471 3164 1288 12662 4589 12037 8146 4337 4655 12804 4402 12809 8151 7072 18512 2251 3172 3712 12184 729 3173 17010 1015 3174 6889 4096 1468 14227 7971 19441 5051 5373 730 7974 5498 12204 12205 12206 4611 12208 8168 769 9260 12203 5503 2672 5504 723 731 2673 2675 19943 17203 3182 5635 8152 18240 12607 5637 12202 3685 12223 19726 2924 2886 2677 15410 5116 10285 12753 2674 3404 5500 6470 12207 814 12811",
	["Mats - Vendor Bought"]	= "8923 4289 8924 8925 9210 4291 8150 11291 1179 6261 4340 2320 4341 2596 2604 4342 159 2880 2321 3857 18567 4470 2692 18256 8343 5173 2894 2665 2928 2605 4536 6530 10647 2930 10648 3713 17194 2324 3466 6260 2678 14341 3372 15409 17196 2325 4400 10290 3371",
-- Tradeskill Tools
	["Tradeskill Tools"] = {"Tradeskill - Enchanting Tools", "Tradeskill - Engineering Tools", "Tradeskill - Leatherworking Tools", "Tradeskill - Blacksmithing Tools", "Tradeskill - Skinning Tools", "Tradeskill - Mining Tools", "Tradeskill - Fishing Tools"},
	["Tradeskill - Enchanting Tools"]	= "6218 11130 6339 11145 16207 22461 22462 22463",
	["Tradeskill - Engineering Tools"]	= "5956 6219 10498",
	["Tradeskill - Leatherworking Tools"]	= "15846",
	["Tradeskill - Blacksmithing Tools"]	= "5956",
	["Tradeskill - Skinning Tools"]		= "7005 12709",
	["Tradeskill - Mining Tools"]		= "2901",
	["Tradeskill - Fishing Tools"]		= "6256:0 12225:3 6367:20 6365:5 19022:25 19970:35",
	["Tradeskill - Fishing Gear"]		= "7996:5 19972:5",
	["Tradeskill - Fishing Lures"]		= "6529:25 6530:50 6811:50 6532:50 6533:100",
-- Transporters
	-- These items will transport the play to a certain location
	-- "Items" can be used directly from inventory, "Equips" must be equipped to be used.
	["Transporters"] = {"Transporters - Items", "Transporters - Equip"},
	["Transporters - Items"]	= "6948 18150 18149",
	["Transporters - Equip"]	= "18984 18986 17690 17905 17906 17907 17908 17909 17691 17900 17901 17902 17903 17904 30544",

	-- Player-consumable Un'goro crystals
	["Un'Goro Buff Crystals"]	= "11562 11563 11564 11565 11566 11567",
	-- Harvestable Un'goro Crystals
	["Un'Goro Power Crystals"]	= "11184 11185 11186 11188",
-- Water
	-- Value == Mana recovered
	["Water"]			= {"Water - Basic", "Water - Percentage", "Water - Conjured", "Water - ArathiBasin", "Water - WarsongGulch", "Water - SpiritBuff"},
	["Water - Basic"]		= "1401:60 159:151 1179:436 17404:436 1205:835 9451:835 19299:835 1708:1344 4791:1344 10841:1344 17405:1344 1645:1992 19300:1992 8766:2934 23161:2934 28399:5100 27860:7200 29395:7200 24007:4200 30457:7200 29454:5100 29401:7200 24006:2934 23585:2934",
	["Water - Percentage"]		= "19997:60 21241:60",
	["Water - Conjured"]		= "5350:151 2288:436 2136:835 3772:1344 8077:1992 8078:2934 8079:4200 30703:5100 22018:7200",
	["Water - ArathiBasin"]		= "20063:2202 20064:3306 20062:4410 20223:2202 20224:3306 20222:4410 20226:2202 20227:3306 20225:4410",
	["Water - WarsongGulch"]	= "19062:2202 19061:3306 19060:4410",
	["Water - SpiritBuff"]		= "13813:4410 19318:4410",
-- Weapon Buffs
	["Weapon Buff"] = {"Weapon Buff - Poison", "Weapon Buff - Weight Stones", "Weapon Buff - Sharpening Stones", "Weapon Buff - Mana Oil", "Weapon Buff - Wizard Oil"},
	-- Value == Damage bonus
	["Weapon Buff - Weight Stones"]		= "3239:2 3240:3 3241:4 7965:6 12643:8 28420:12 28421",
	-- Value == Damage bonus (elemental has no value, it increases crit chance; consecrated also has no value, it increases attack power)
	["Weapon Buff - Sharpening Stones"]	= "2862:2 2863:3 2871:4 7964:6 12404:8 18262 23122 23529",
	-- Value == Mana gained per 5 sec
	["Weapon Buff - Mana Oil"]		= "20745:4 20747:8 20748:12 22521:14",
	-- Value == Spell damage increase
	["Weapon Buff - Wizard Oil"]		= "20744:8 20746:16 20750:24 20749:36 22522:42",
	-- Rogue poisons by type
	["Weapon Buff - Poison"]		= {"Weapon Buff - Poison Crippling", "Weapon Buff - Poison Deadly", "Weapon Buff - Poison Instant", "Weapon Buff - Poison Mind Numbing", "Weapon Buff - Poison Wound", "Weapon Buff - Poison Anesthetic"},
	["Weapon Buff - Poison Crippling"]	= "3775 3776",
	["Weapon Buff - Poison Deadly"]		= "2892 2893 8984 8985 20844 22053 22054",
	["Weapon Buff - Poison Instant"]	= "6947 6949 6950 8926 8927 8928 21835 21927",
	["Weapon Buff - Poison Mind Numbing"]	= "5237 6951 9186",
	["Weapon Buff - Poison Wound"]		= "10918 10920 10921 10922 22055",
	["Weapon Buff - Poison Anesthetic"]     = "21835",
-- ZG Mats
	-- Zul'Gurub items by type
	["ZG - Quest Items"]		= {"ZG - Coins", "ZG - Bijous", "ZG - Primals"},
	["ZG - Coins"]			= "19698 19699 19700 19701 19702 19703 19704 19705 19706",
	["ZG - Bijous"]			= "19707 19708 19709 19710 19711 19712 19713 19714 19715",
	["ZG - Primals"]		= "19716 19717 19718 19719 19720 19721 19722 19723 19724",
	-- Coin trios for repeatable rep quests
	["ZG - CoinsQuest1"]		= "19698 19699 19700",
	["ZG - CoinsQuest2"]		= "19701 19702 19703",
	["ZG - CoinsQuest3"]		= "19704 19705 19706",
	-- Zul'Gurub items by class need
	-- Value = Reputation index of:
	-- {"Hated", "Hostile", "Unfirendly", "Neutral", "Friendly", "Honored", "Revered", "Exalted", "MaxExalted"}
	["ZG - PrimalClasses"] = {"ZG - DruidParagons", "ZG - HunterParagons", "ZG - Mage Paragons", "ZG - PaladinParagons", "ZG - PriestParagons", "ZG - RogueParagons", "ZG - ShamanParagons", "ZG - WarlockParagons", "ZG - WarriorParagons"},
	["ZG - DruidParagons"]		= "19720:6 19718:5 19722:7",
	["ZG - HunterParagons"]		= "19721:6 19716:5 19724:7",
	["ZG - MageParagons"]		= "19716:5 19723:7 19721:6",
	["ZG - PaladinParagons"]	= "19721:7 19716:5 19722:6",
	["ZG - PriestParagons"]		= "19720:6 19718:5 19724:7",
	["ZG - RogueParagons"]		= "19717:5 19724:7 19719:6",
	["ZG - ShamanParagons"]		= "19719:6 19717:5 19722:7",
	["ZG - WarlockParagons"]	= "19718:5 19723:7 19720:6",
	["ZG - WarriorParagons"]	= "19719:6 19717:5 19723:7",
})
end

