local PICKLOCK = "Pick Lock"
local LOCKED = "Lock"
local shown = ""

function isLocked()
	if(GameTooltipTextLeft2:GetText() and strfind(GameTooltipTextLeft2:GetText(), LOCKED)) then
		return true
	else
		return false
	end
end

TradeFrameItemButton_OnEnter = TradeRecipientItem7ItemButton:GetScript("OnEnter")
function Unlock_TradeFrameItemButton_OnEnter()
	TradeFrameItemButton_OnEnter()
	if (isLocked() and not InCombatLockdown()) then
		this:SetScript("OnLeave", function()
			if (not isLocked() ) then
				this.updateTooltip = nil
				GameTooltip:Hide()
				ResetCursor()
			end
		end)
		button = getglobal("Unlock_"..this:GetName(), this:GetParent())
		if (button == nil) then
			button = CreateFrame("Button", "Unlock_"..this:GetName(), this:GetParent(), "ItemButtonTemplate,SecureActionBUttonTemplate")
		end
		button:SetAttribute("type2", "macro")
		button:SetAttribute("macrotext2", "/cast "..PICKLOCK.."\n/script ClickTargetTradeButton(7)")
		button:SetAttribute("*type*", "click")
		button:SetAttribute("*clickbutton*", this)
		button:SetAttribute("clickbutton2", ATTRIBUTE_NOOP)
		button:RegisterForClicks("RightButtonUp")
		button:SetScript("PostClick", function()
			this:Hide()
		end)
		button:SetScript("OnLeave", function()
			this:Hide()
			this.updateTooltip = nil
			GameTooltip:Hide()
			ResetCursor()
		end)
		button:SetWidth(this:GetWidth())
		button:SetHeight(this:GetHeight())
		button:SetPoint(this:GetPoint(1))
		button:SetFrameStrata("HIGH")
		button:Show()
	end
end

TradeRecipientItem7ItemButton:SetScript("OnEnter", Unlock_TradeFrameItemButton_OnEnter)

function Unlock_ContainerFrameItemButton_OnEnter()
	local bag = this:GetParent():GetID()
	local slot = this:GetID()
	if (isLocked() and not InCombatLockdown() and bag > 0 and slot > 0) then
		button = getglobal("Unlock_ContainerFrame"..bag.."Item"..slot)
		if (button == nil) then
			button = CreateFrame("Button", "Unlock_ContainerFrame"..bag.."Item"..slot, this:GetParent(), "ContainerFrameItemButtonTemplate,SecureActionButtonTemplate")
			button:SetID(this:GetID())
			button:SetAttribute("type2", "macro")
			button:SetAttribute("macrotext2", "/cast "..PICKLOCK.."\n/use "..bag.." "..slot)
			button:SetAttribute("*type*", "click")
			button:SetAttribute("*clickbutton1", this)
			button:SetAttribute("clickbutton2", ATTRIBUTE_NOOP)
			button:RegisterForClicks("RightButtonUp","LeftButtonUp")
			button:RegisterForDrag("LeftButton")	
			button:SetWidth(this:GetWidth())
			button:SetHeight(this:GetHeight())
			button:SetPoint(this:GetPoint(1))
			button:SetFrameStrata("DIALOG")
			button:SetScript("OnLeave", function()
				this:Hide()
				this.updateTooltip = nil
				ResetCursor()			
			end)
			button:SetScript("OnReceiveDrag", function()
				this:Hide()
				ContainerFrameItemButton_OnClick("LeftButton")
			end)
			button:SetScript("OnDragStart", function()
				this:Hide()
				ContainerFrameItemButton_OnClick("LeftButton")
			end)
		end
		if(not strfind(this:GetName(), "Unlock"))then
			local _,_, locked = GetContainerItemInfo(this:GetParent():GetID(),this:GetID())
			if not (shown == "item") and not locked then
				button.UpdateTooltip = ContainerFrameItemButton_OnEnter
				button:Show()
			end
			shown = GetCursorInfo()
		end
	end
end