--------------------------------------------------------------------------------
-- Thanks to Loz for creating Group Buttons his/her amazing work inspired this
-- project.
--
-- Author: Shane Stixrud -  Date: 03-1-07
--------------------------------------------------------------------------------

--------------------------
-- Define local variables
--------------------------
local _G = _G 
local UnitBuff = UnitBuff
local UnitIsFriend = UnitIsFriend
local UnitIsEnemy = UnitIsEnemy
local UIFrameFlashRemoveFrame = UIFrameFlashRemoveFrame
local UIFrameFadeRemoveFrame = UIFrameFadeRemoveFrame
local UnitHealth = UnitHealth
local UnitName = UnitName
local UIFrameIsFading = UIFrameIsFading

local watchUnits = {player = true, target = true, party1 = "1", party2 = "2", party3 = "3", party4 = "4", playerpet = true, partypet1 = "1", partypet2 = "2", partypet3 = "3", partypet4 = "4"}
local watchCures = {Poison = true, Disease = true, Magic = true, Curse = true}

local monitorFrame = CreateFrame("Frame", nil, UIParent)


-----------------------------------------------------------
-- Register events OnLoad() and define slash command
-----------------------------------------------------------
function UB_OnLoad()
	this:RegisterEvent("PARTY_MEMBERS_CHANGED")
    this:RegisterEvent("ADDON_LOADED")
    this:RegisterEvent("PLAYER_ENTERING_WORLD")
	this:RegisterEvent("UNIT_HEALTH")
--  this:RegisterEvent("RAID_ROSTER_UPDATE")
    this:RegisterEvent("UNIT_AURA")
    this:RegisterEvent("PLAYER_TARGET_CHANGED")
    this:RegisterEvent("PLAYER_REGEN_ENABLED")
	this:RegisterEvent("PLAYER_REGEN_DISABLED")
	this:RegisterEvent("ACTIONBAR_SLOT_CHANGED")
	this:RegisterEvent("ACTIONBAR_HIDEGRID")
	this:RegisterEvent("ACTIONBAR_SHOWGRID")
	this:RegisterEvent("UNIT_PET")
--	this:RegisterAllEvents()

  	SLASH_UNITBUTTONS1 = "/ub"
	SlashCmdList["UNITBUTTONS"] = function(msg)
		UB_SlashHandler(string.lower(msg))
	end
end

-----------------------------------------
-- What to do when we receive WOW Events
-----------------------------------------

function UB_OnEvent()
--	DEFAULT_CHAT_FRAME:AddMessage(event)
	if (event == "ADDON_LOADED" and arg1 == "UnitButtons") then
	    UB_LoadVariables()
		monitorFrame:SetScript("OnShow", UB_MonitorReset)
	end
	if (event == "PLAYER_ENTERING_WORLD") then
		UB_InitSpell()
        UB_InitBars()
        UB_ConfigFShow()

	    for k,v in pairs(watchUnits) do
			UB_UnitBuffs(k)
			UB_HealthEvent(k)
			UB_UnitDebuffs(k)
		end
	end
	if (event == "PARTY_MEMBERS_CHANGED") then
        UB_InitPartyFrames()
        UB_InitPartyPetFrames()
		for i = 1, 4 do
		    local unit = "party"..i
		    if UnitInParty(unit) and UnitExists(unit) then
				UB_PrepButtons(unit)
			end
		end
	end
	if (event == "UNIT_PET") then

	    UB_InitPlayerPetFrame()
	    UB_InitPartyPetFrames()
		local unit
		if arg1 == "player" then
			unit = "playerpet"
		elseif arg1 == "party1" then
			unit = "partypet1"
		elseif arg1 == "party2" then
			unit = "partypet2"
		elseif arg1 == "party3" then
			unit = "partypet3"
		elseif arg1 == "party4" then
			unit = "partypet4"
		end
		if UnitExists(unit) and UnitPlayerOrPetInParty(unit) or UnitExists(unit) and unit == "playerpet" then
			UB_PrepButtons(unit)
		end
	end
--	if (event == "RAID_ROSTER_UPDATE") then
--	end
	if (event =="PLAYER_TARGET_CHANGED") then
		local unit = "target"
		if not UnitExists("target") then
			UBTargetBarFrame:Hide()
		elseif UBVAR.NUMTBTNS > 0 then
			UBTargetBarFrame:Show()
			UB_PrepButtons(unit)
		end
	end
	if (event == "UNIT_HEALTH") then
        if watchUnits[arg1] and UnitIsFriend("player", arg1) then
			UB_HealthEvent(arg1)
		end
	end
	if (event == "UNIT_AURA") then
        if watchUnits[arg1] then
			UB_UnitBuffs(arg1)
			UB_UnitDebuffs(arg1)
		end
	end
	if (event == "PLAYER_REGEN_ENABLED") then
		if not UnitExists("target") then
			UBTargetBarFrame:Hide()
		end
	    UB_InitPlayerPetFrame()
	    UB_InitPartyPetFrames()
	    UB_InitPartyFrames()
	end
	if (event == "PLAYER_REGEN_DISABLED") then
		if not UnitExists("target") and UBVAR.NUMTBTNS > 0 then
			UBTargetBarFrame:Show()
		end
		if UBConfig:IsVisible() then
		    DEFAULT_CHAT_FRAME:AddMessage("Entering Combat, disabling Configuration UI")
			UBConfigUIStop()
		end
	end
	if (event == "ACTIONBAR_SLOT_CHANGED") then
		if UBVAR.UBCFGMODE then
			UBConfigUIStart()
		end
	end
	if (event == "ACTIONBAR_SHOWGRID") then
		if UBVAR.UBCFGMODE then
			UBConfigUIStart()
		end
	end
	if (event == "ACTIONBAR_HIDEGRID") then
		if UBVAR.UBCFGMODE then
			UBConfigUIStart()
		end
	end
end

------------------------------------
-- Handle any slash commands entered
------------------------------------

function UB_SlashHandler(msg)
-- Config UI Tab functionality
	PanelTemplates_SetNumTabs(UBConfig, 2)
	UBConfig.selectedTab=1
	PanelTemplates_UpdateTabs(UBConfig)
-- Show config UI
	if string.find(msg, "config") or string.find(msg, "") then
		if UBConfig:IsVisible() then
			UBConfigUIStop()
    	else
			if InCombatLockdown() == 1 then
			    DEFAULT_CHAT_FRAME:AddMessage("In Combat, Configuration UI temporarily disabled")
			 else
				UBVAR.UBCFGMODE = 1
    	  		UBConfig:Show()
    	  		UBConfigSub1:Show()
			end
    	end
	end
end

------------------------------------------------------
-- Load existing or set default configuration settings
------------------------------------------------------

function UB_LoadVariables()
	if not UBVAR then
		UBVAR = {}
		UBVAR.FSHOW = true
	end
	if not UBVAR.DYNVARS then
		UBVAR.DYNVARS = {}
	end
	if not UBVAR.DYNSPELLS then
	    UBVAR.DYNSPELLS = {}
	end
	if not UBVAR.DYNBTNS then
	    UBVAR.DYNBTNS = {}
	end
	if not UBVAR.DYNEVENTS then
	    UBVAR.DYNEVENTS = {}
	end
	if not UBVAR.NUMPLBTNS then
		UBVAR.NUMPLBTNS = 10
	end
	if not UBVAR.NUMPLPBTNS then
		UBVAR.NUMPLPBTNS = 0
	end
	if not UBVAR.NUMTBTNS then
		UBVAR.NUMTBTNS = 10
	end
	if not UBVAR.NUMPABTNS then
		UBVAR.NUMPABTNS = 8
	end
	if not UBVAR.NUMPAPBTNS then
		UBVAR.NUMPAPBTNS = 0
	end
	if not UBVAR.NUMRABTNS then
		UBVAR.NUMRABTNS = 0
	end
	if not UBVAR.PLSCALE then
		UBVAR.PLSCALE = .7
	end
	if not UBVAR.PLPSCALE then
		UBVAR.PLPSCALE = .5
	end
	if not UBVAR.TSCALE then
		UBVAR.TSCALE = .7
	end
	if not UBVAR.PASCALE then
		UBVAR.PASCALE = .7
	end
	if not UBVAR.PAPSCALE then
		UBVAR.PAPSCALE = .5
	end
	if not UBVAR.RASCALE then
		UBVAR.RASCALE = .3
	end
	if not UBVAR.LOCKBARS then
		UBVAR.LOCKBARS = "1"
	end
	UBVAR.VERSION = "2.04"
	UBVAR.UBCFGMODE = nil
	UBVAR.LASTSPELLCFG = nil
	UBVAR.DYNBTNMODE = nil

	UBAURAS = {}
	UBOLDAURAS = {}
	UBIDS = {}

-------------------------------------------------
-- Determine player class and setup button ranges
-------------------------------------------------

	local localizedClass, playerClass = UnitClass("player")
	if playerClass == "WARRIOR" then
		UBIDS.PLSTART = 108
		UBIDS.PLPSTART = 108
		UBIDS.TSTART = 0
		UBIDS.PASTART = 108
		UBIDS.PAPSTART = 108
	elseif playerClass == "PRIEST" then
	    UBIDS.PLSTART = 108
	    UBIDS.PLPSTART = 96
	    UBIDS.TSTART = 84
	    UBIDS.PASTART = 96
	    UBIDS.PAPSTART = 96
	elseif playerClass == "DRUID" then
	    UBIDS.PLSTART = 24
	    UBIDS.PLPSTART = 120
	    UBIDS.TSTART = 36
	    UBIDS.PASTART = 120
	    UBIDS.PAPSTART = 120
	elseif playerClass == "ROGUE" then
	    UBIDS.PLSTART = 84
	    UBIDS.PLPSTART = 108
	    UBIDS.TSTART = 96
	    UBIDS.PASTART = 108
	    UBIDS.PAPSTART = 108
	else
        UBIDS.PLSTART = 72
        UBIDS.PLPSTART = 96
	    UBIDS.TSTART = 84
	    UBIDS.PASTART = 96
	    UBIDS.PAPSTART = 96
	end
----------------------------------------
--  Start by creating the player buttons
----------------------------------------

    local prevpos = UBPlayerBarFrame
	for j = 1, 12 do
        local btn = CreateFrame("CheckButton", "PlayerUnitButton"..j, UBPlayerBarFrame,  "UBCheckButtonTemplate")
		btn:SetScript("OnAttributeChanged", ActionButton_UpdateAction)
        btn:SetAttribute("type", "action")
        btn:SetAttribute("action", UBIDS.PLSTART + j )
        btn:SetAttribute("*unit*", "player")
        btn:SetAttribute("statehidden", true)
   		if j == 1 then
        	btn:SetPoint("TOPLEFT", prevpos, "TOPRIGHT", 1, 0)
		elseif j == 7 and UBVAR.ROWS then
        	btn:SetPoint("TOP", PlayerUnitButton1, "BOTTOM", 0, -5)
        else
			btn:SetPoint("LEFT", prevpos, "RIGHT", 6, 0)
		end
        prevpos = btn
    end
    UBPlayerBarFrame:Hide()

----------------------------------------
--  Creating the playerpet buttons
----------------------------------------

    local prevpos = UBPlayerPetBarFrame
	for j = 1, 12 do
        local btn = CreateFrame("CheckButton", "PlayerPetUnitButton"..j, UBPlayerPetBarFrame,  "UBCheckButtonTemplate")
		btn:SetScript("OnAttributeChanged", ActionButton_UpdateAction)
        btn:SetAttribute("type", "action")
        btn:SetAttribute("action", UBIDS.PLPSTART + j )
        btn:SetAttribute("*unit*", "playerpet")
        btn:SetAttribute("statehidden", true)
   		if j == 1 then
        	btn:SetPoint("TOPLEFT", prevpos, "TOPRIGHT", 1, 0)
		elseif j == 7 and UBVAR.ROWS then
        	btn:SetPoint("TOP", PlayerPetUnitButton1, "BOTTOM", 0, -5)
		else
        	btn:SetPoint("LEFT", prevpos, "RIGHT", 6, 0)
		end
        prevpos = btn
    end
    UBPlayerPetBarFrame:Hide()
----------------------------------------
--  Now create the target buttons
----------------------------------------

    local prevpos = UBTargetBarFrame
	for j = 1, 12 do
        local btn = CreateFrame("CheckButton", "TargetUnitButton"..j, UBTargetBarFrame,  "UBCheckButtonTemplate")
		btn:SetScript("OnAttributeChanged", ActionButton_UpdateAction)
        btn:SetAttribute("type", "action")
        btn:SetAttribute("action", UBIDS.TSTART + j )
        btn:SetAttribute("*unit*", "target")
        btn:SetAttribute("statehidden", true)
   		if j == 1 then
        	btn:SetPoint("TOPLEFT", prevpos, "TOPRIGHT", 1, 0)
		elseif j == 7 and UBVAR.ROWS then
        	btn:SetPoint("TOP", TargetUnitButton1, "BOTTOM", 0, -5)
		else
        	btn:SetPoint("LEFT", prevpos, "RIGHT", 6, 0)
		end
        prevpos = btn
    end
    UBTargetBarFrame:Hide()
	    
--------------------------------------------------------------------------------
-- Now create the buttons for each party member (shared for all group members)
--------------------------------------------------------------------------------

    for i = 1, 4 do
        local partyframe = _G["UBParty"..i.."BarFrame"]
		local prevpos = partyframe
		for j = 1, 12 do 
           	local btn = CreateFrame("CheckButton", "PartyFrame"..i.."PartyButton"..j, partyframe,  "UBCheckButtonTemplate")
           	btn:SetScript("OnAttributeChanged", ActionButton_UpdateAction)
           	btn:SetAttribute("type", "action")
			btn:SetAttribute("action", UBIDS.PASTART + j)
           	btn:SetAttribute("*unit*", "party"..i)
			btn:SetAttribute("statehidden", true) 
			if j == 1 then
        		btn:SetPoint("TOPLEFT", prevpos, "TOPRIGHT", 1, 0)
			elseif j == 7 and UBVAR.ROWS then
	        	btn:SetPoint("TOP", "PartyFrame"..i.."PartyButton1", "BOTTOM", 0, -5)
			else
    			btn:SetPoint("LEFT", prevpos, "RIGHT", 6, 0)
			end
           	prevpos = btn
		end
		_G["UBParty"..i.."BarFrame"]:Hide()
	end

--------------------------------------------------------------------------------
-- Now create the buttons for each partypet member (shared for all group members)
--------------------------------------------------------------------------------

    for i = 1, 4 do
        local partypetframe = _G["UBPartyPet"..i.."BarFrame"]
		local prevpos = partypetframe
		for j = 1, 12 do 
           	local btn = CreateFrame("CheckButton", "PartyPetFrame"..i.."PartyPetButton"..j, partypetframe,  "UBCheckButtonTemplate")
           	btn:SetScript("OnAttributeChanged", ActionButton_UpdateAction)
           	btn:SetAttribute("type", "action")
			btn:SetAttribute("action", UBIDS.PAPSTART + j)
           	btn:SetAttribute("*unit*", "partypet"..i)
			btn:SetAttribute("statehidden", true) 
			if j == 1 then
        		btn:SetPoint("TOPLEFT", prevpos, "TOPRIGHT", 1, 0)
			elseif j == 7 and UBVAR.ROWS then
	        	btn:SetPoint("TOP", "PartyPetFrame"..i.."PartyPetButton1", "BOTTOM", 0, -5)
			else
    			btn:SetPoint("LEFT", prevpos, "RIGHT", 6, 0)
			end
           	prevpos = btn
		end
		_G["UBPartyPet"..i.."BarFrame"]:Hide()
	end
	
--------------------------------------------------------------------------------
-- Now create the buttons for each raid member (shared for all raid members)
--------------------------------------------------------------------------------
--[[
	for i = 1, 40 do
        local raidframe = _G["UBRaid"..i.."BarFrame"]
		local prevpos = raidframe
		for j = 1, 6 do
           	local btn = CreateFrame("CheckButton", "RaidFrame"..i.."RaidButton"..j, raidframe,  "UBCheckButtonTemplate")
           	btn:SetScript("OnAttributeChanged", ActionButton_UpdateAction)
           	btn:SetAttribute("type", "action")
			btn:SetAttribute("action", 90 + j)
           	btn:SetAttribute("*unit*", "raid"..i)
          	btn:SetAttribute("statehidden", true)
			if j == 1 then
        		btn:SetPoint("TOPLEFT", prevpos, "TOPRIGHT")
			else
    		btn:SetPoint("LEFT", prevpos, "RIGHT")
			end
           	prevpos = btn
		end
		_G["UBRaid"..i.."BarFrame"]:Hide()
	end
--]]
	DEFAULT_CHAT_FRAME:AddMessage("UnitButtons "..UBVAR.VERSION.." Loaded")
 	DEFAULT_CHAT_FRAME:AddMessage("Type '/ub' or '/ub config' to configure UnitButtons")
end

-------------------------------------------------------------------------------
-- Determine players current party/raid status and setup frames/buttons
-- reflecting player defined values.
-------------------------------------------------------------------------------

-- If player frame and Buttons are configured initalize them otherwise hide
-- frame.
function UB_InitPlayerFrame()
	if UBVAR.NUMPLBTNS > 0 then
  		UBPlayerBarFrame:Show()
	else
		UBPlayerBarFrame:Hide()
	end
end

function UB_InitPlayerButtons()
	for j = 1, 12 do
		local btn = _G["PlayerUnitButton"..j]
  		btn:SetScale(UBVAR.PLSCALE)
   		btn:SetAttribute("statehidden", true)
   		btn:SetAttribute("*unit*", "player")
		if j > UBVAR.NUMPLBTNS or HasAction(UBIDS.PLSTART + j) == nil then
			btn:Hide()
		elseif j <= UBVAR.NUMPLBTNS and HasAction(UBIDS.PLSTART + j) == 1 then
			btn:Show()
		end
	end
end

-- If playerpet frame and Buttons are configured initalize them otherwise hide
-- frame.
function UB_InitPlayerPetFrame()
	if UBVAR.NUMPLPBTNS > 0 and UnitExists("playerpet") then
  		UBPlayerPetBarFrame:Show()
	else
		UBPlayerPetBarFrame:Hide()
	end
end

function UB_InitPlayerPetButtons()
	for j = 1, 12 do
		local btn = _G["PlayerPetUnitButton"..j]
  		btn:SetScale(UBVAR.PLPSCALE)
   		btn:SetAttribute("statehidden", true)
   		btn:SetAttribute("*unit*", "playerpet")
		if j > UBVAR.NUMPLPBTNS or HasAction(UBIDS.PLPSTART + j) == nil then
			btn:Hide()
		elseif j <= UBVAR.NUMPLPBTNS and HasAction(UBIDS.PLPSTART + j) == 1 then
			btn:Show()
		end
	end
end

-- If target frame and Buttons are configured initalize them otherwise hide
-- frame.
function UB_InitTargetFrame()
	if UBVAR.NUMTBTNS > 0 and UnitExists("target") then
  		UBTargetBarFrame:Show()
	else
		UBTargetBarFrame:Hide()
	end
end

function UB_InitTargetButtons()
	for j = 1, 12 do
		local btn = _G["TargetUnitButton"..j]
  		btn:SetScale(UBVAR.TSCALE)
   		btn:SetAttribute("statehidden", true)
   		btn:SetAttribute("*unit*", "target")
		if j > UBVAR.NUMTBTNS or HasAction(UBIDS.TSTART + j) == nil then
			btn:Hide()
		elseif j <= UBVAR.NUMTBTNS and HasAction(UBIDS.TSTART + j) == 1 then
			btn:Show()
		end
	end
end

-- If party frames and buttons are configured then initalize a frame for each
-- member and show configured buttons.
function UB_InitPartyFrames()
	if UBVAR.NUMPABTNS > 0 then
		for i = 1, 4 do
			if UnitInParty("party"..i) then
			    _G["UBParty"..i.."BarFrame"]:Show()
			else
				_G["UBParty"..i.."BarFrame"]:Hide()
			end
		end
	else
	    for i = 1, 4 do
	    	_G["UBParty"..i.."BarFrame"]:Hide()
		end
	end
end

function UB_InitPartyButtons()
	for i = 1, 4 do
		for j = 1, 12 do
			local btn = _G["PartyFrame"..i.."PartyButton"..j]
			btn:SetScale(UBVAR.PASCALE)
			btn:SetAttribute("statehidden", true)
			btn:SetAttribute("*unit*", "party"..i)
			if j > UBVAR.NUMPABTNS or HasAction(UBIDS.PASTART + j) == nil then
				btn:Hide()
			elseif j <= UBVAR.NUMPABTNS and HasAction(UBIDS.PASTART + j) == 1 then
				btn:Show()
			end
		end
	end
end

-- If partypet frames and buttons are configured then initalize a frame for each
-- member and show configured buttons.
function UB_InitPartyPetFrames()
	if UBVAR.NUMPAPBTNS > 0 then
		for i = 1, 4 do
			if UnitPlayerOrPetInParty("partypet"..i) then
			    _G["UBPartyPet"..i.."BarFrame"]:Show()
			else
				_G["UBPartyPet"..i.."BarFrame"]:Hide()
			end
		end
	else
	    for i = 1, 4 do
	    	_G["UBPartyPet"..i.."BarFrame"]:Hide()
		end
	end
end

function UB_InitPartyPetButtons()
	for i = 1, 4 do
		for j = 1, 12 do
			local btn = _G["PartyPetFrame"..i.."PartyPetButton"..j]
			btn:SetScale(UBVAR.PAPSCALE)
			btn:SetAttribute("statehidden", true)
			btn:SetAttribute("*unit*", "partypet"..i)
			if j > UBVAR.NUMPAPBTNS or HasAction(UBIDS.PAPSTART + j) == nil then
				btn:Hide()
			elseif j <= UBVAR.NUMPAPBTNS and HasAction(UBIDS.PAPSTART + j) == 1 then
				btn:Show()
			end
		end
	end
end

-- If raid frames and buttons are configured then initalize a frame for each
-- member and show configured buttons.
--[[
function UB_InitRaidFrames()
	if UBVAR.NUMRABTNS > 0 and GetNumRaidMembers() > 0 then
		local countTable = {}
		for i = 1, GetNumRaidMembers() do
			-- Loop thru GetRaidRosterInfo and determine which subgroup members are in
		    local name, rank, subgroup, level, class, fileName, zone, online, isDead = GetRaidRosterInfo(i)
			countTable[subgroup] = (countTable[subgroup] or 0) + 1
		end
		for subgroup = 1, 8 do
			UB_InitRaidButtons(subgroup, (countTable[subgroup] or 0))
		end
	else
		for i = 1, 40 do
			_G["UBRaid"..i.."BarFrame"]:Hide()
		end
	end
end

function UB_InitRaidButtons(subgroup, membersInSubgroup)
	local substart = (subgroup * 5) - 4
	local subend = ((substart + membersInSubgroup) - 1)
	for i = substart, subend do
--		_G["UBRaid"..i.."BarFrame"]:Hide()
    	_G["UBRaid"..i.."BarFrame"]:Show()
		for j = 1, 6 do
			local btn = _G["RaidFrame"..i.."RaidButton"..j]
			btn:SetScale(UBVAR.RASCALE)
			DEFAULT_CHAT_FRAME:AddMessage(UBVAR.NUMRABTNS)
			if j > UBVAR.NUMRABTNS or HasAction(90 + j) == nil then
				btn:Hide()
			elseif j <= UBVAR.NUMRABTNS and HasAction(90 + j) == 1 then
				btn:Show()
			end
		end
	end
	for i = subend+1, subgroup * 5 do
		_G["UBRaid"..i.."BarFrame"]:Hide()
	end
end
--]]

------------------------------------------------------------------------------
-- Calculate health % for Unit and call function to update Unit's heal buttons
------------------------------------------------------------------------------

function UB_HealthEvent(unit)
	local unithp = UnitHealth(unit) / UnitHealthMax(unit) * 100
	UB_ChangeButtonsHealth(unit, unithp)
end


-------------------------------------------------------------------------------
-- Determine unit's existing buff/debuff state and call button update functions
-------------------------------------------------------------------------------
local ubuffs = {}
local udebuffs = {}

-- Buffs
function UB_UnitBuffs(unit)

	if not ubuffs[unit] then
		ubuffs[unit] = {}
	end
	
	local unitBuffs = ubuffs[unit]
	
    -- This bit sets all the previous run's buffs to "Old"
	for k,v in pairs(unitBuffs) do
		unitBuffs[k] = v - 1
	end
    local i = 1
    local name
    local status = 1
    local isFriend = UnitIsFriend("player", unit)

	-- loop over all active buffs
	while true do
  		name = UnitBuff(unit, i)
		if not name then 
			break 
		end
		if not unitBuffs[name] then -- new buff, wasnt on the unit last cycle

			if isFriend and UBVAR.DYNEVENTS[unit].Buff[name] then
				UB_ChangeButtonsBuff(unit, name, status)
			end
			
			unitBuffs[name] = 1 -- set active
		elseif unitBuffs[name] == 0 then -- Old buff, but still active
			unitBuffs[name] = 1 -- refresh active
		end			

		i = i + 1
	end

	local name
	status = nil
	-- Clean up any buffs with 0
	for k,v in pairs(unitBuffs) do -- find old and unrefreshed buffs
		if v == 0 then
            name = k
			if isFriend and UBVAR.DYNEVENTS[unit].Buff[name] then
				UB_ChangeButtonsBuff(unit, name, status)
			end
			unitBuffs[k] = nil --remove
		end
	end	
end

-- Debuffs
function UB_UnitDebuffs(unit)
	if not udebuffs[unit] then
		udebuffs[unit] = {}
	end

	local unitDebuffs = udebuffs[unit]
	
    -- This bit sets all the previous run's debuffs to "Old"
	for k,v in pairs(unitDebuffs) do
		unitDebuffs[k] = v - 1
	end
    local i = 1
    local name,rank,texture,count,type
    local status = 1
    local isFriend = UnitIsFriend("player", unit)
    local isEnemy = UnitIsEnemy("player", unit)
    local targetNotFriend = unit == "target" and isFriend == nil
	local targetIsEnemy = unit == "target" and isEnemy


	-- loop over all active debuffs
	while true do
  		name,rank,texture,count,type = UnitDebuff(unit, i)
		if not name then
			break 
		end
		if isFriend and not targetIsEnemy and type then
			if not unitDebuffs[type] then -- new type, deactive last cycle
				if type == "Poison" or type == "Disease" or type == "Magic" or type == "Curse" then
					UB_ChangeButtonsCure(unit, type, status)
				end
				unitDebuffs[type] = 1 -- set active
			elseif unitDebuffs[type] == 0 then -- Old curable, but still active
				unitDebuffs[type] = 1 -- refresh active
			end
		else
			if not unitDebuffs[name] then -- new debuff, deactive last cycle
			    if targetNotFriend or targetIsEnemy and UBVAR.DYNEVENTS[unit].Debuff[name] then
					UB_ChangeButtonsDebuff(unit, name, status)
    			end
				unitDebuffs[name] = 1 -- set active
			elseif unitDebuffs[name] == 0 then -- Old debuff, but still active
				unitDebuffs[name] = 1 -- refresh active
			end
		end					

		i = i + 1
	end

	local type, name
	status = nil
	-- Clean up any debuffs with 0
	for k,v in pairs(unitDebuffs) do -- find old and unrefreshed debuffs
		if v == 0 then
			type = k
			name = k
			if isFriend and type == "Poison" or type == "Disease" or type == "Magic" or type == "Curse" then
				UB_ChangeButtonsCure(unit, type, status)
			elseif targetIsEnemy and UBVAR.DYNEVENTS[unit].Debuff[name] then
				UB_ChangeButtonsDebuff(unit, name, status)
			end				
			unitDebuffs[k] = nil --remove
		end
	end	
end

-----------------------------------------------------------
-- Below are the functions that change button visual state
-----------------------------------------------------------

-- Health
function UB_ChangeButtonsHealth(unit, unithp)	
    for k,v in pairs(UBVAR.DYNEVENTS[unit].Heals) do
		local btn = _G[k]

		if not UBVAR.DYNEVENTS[unit].DisabledButtons[k] then
			if UIFrameIsFading(btn) and unithp > UBVAR.DYNEVENTS[unit].Heals[k].BLINK then
				UIFrameFlashRemoveFrame(btn)
				UIFrameFadeRemoveFrame(btn)
				if UBVAR.DYNEVENTS[unit].Heals[k].HIDE ~= 0 then
					btn:SetAlpha(.1)
				end
			end
				
			if unithp < UBVAR.DYNEVENTS[unit].Heals[k].BLINK and UBVAR.DYNEVENTS[unit].Heals[k].BLINK ~= 0 then
				UIFrameFlash(btn, .25, .25, 99999, true, 0, 0)
			elseif unithp > UBVAR.DYNEVENTS[unit].Heals[k].BLINK and unithp < UBVAR.DYNEVENTS[unit].Heals[k].DIM then
				btn:SetAlpha(1)

            elseif unithp >= UBVAR.DYNEVENTS[unit].Heals[k].HIDE and UBVAR.DYNEVENTS[unit].Heals[k].HIDE ~= 0 then
				btn:SetAlpha(.1)
				
			elseif unithp > UBVAR.DYNEVENTS[unit].Heals[k].DIM and UBVAR.DYNEVENTS[unit].Heals[k].DIM ~= 0 then
				btn:SetAlpha(.4)

			else
				btn:SetAlpha(1)
			end
		end
	end
end

-- Cures
function UB_ChangeButtonsCure(unit, type, status)

	if not UBVAR.DYNEVENTS[unit][type] then
		return
	end

    for k,v in pairs(UBVAR.DYNEVENTS[unit][type]) do
        local btn = _G[k]
 
		if not UBVAR.DYNEVENTS[unit].DisabledButtons[k] then
	        UIFrameFlashRemoveFrame(btn)
    	    UIFrameFadeRemoveFrame(btn)
			if status then
				UIFrameFlash(btn, 1, 1, 99999, true, 0, 0)
			else
				btn:SetAlpha(.1)
			end
		end
	end
end

-- Debuffs
function UB_ChangeButtonsDebuff(unit, name, status)

	if not UBVAR.DYNEVENTS[unit].Debuff[name] then
		return
	end
	
    for k,v in pairs(UBVAR.DYNEVENTS[unit].Debuff[name]) do
		local btn = _G[v]

		if not UBVAR.DYNEVENTS[unit].DisabledButtons[v] then
			UIFrameFlashRemoveFrame(btn)
			UIFrameFadeRemoveFrame(btn)
			if status then
		    	if UBVAR.DYNVARS.UBConfigSub2DebuffDim[name] then
					btn:SetAlpha(.4)
				else
					btn:SetAlpha(.1)
				end
			else
				if UBVAR.DYNVARS.UBConfigSub2DebuffBlink[name] then
					UIFrameFlash(btn, 1, 1, 99999, true, 0, 0)
				else
					btn:SetAlpha(1)
				end
			end
		end
	end
end

-- Buffs
function UB_ChangeButtonsBuff(unit, name, status)

	if not UBVAR.DYNEVENTS[unit].Buff[name] then
		return
	end
	
    for k,v in pairs(UBVAR.DYNEVENTS[unit].Buff[name]) do
		local btn = _G[v]

		if not UBVAR.DYNEVENTS[unit].DisabledButtons[v] then
	  		UIFrameFlashRemoveFrame(btn)
  			UIFrameFadeRemoveFrame(btn)
			if status then
		    	if UBVAR.DYNVARS.UBConfigSub2BuffDim[name] then
					btn:SetAlpha(.4)
				else
					btn:SetAlpha(.1)
				end
			else
				if UBVAR.DYNVARS.UBConfigSub2BuffBlink[name] then
					UIFrameFlash(btn, 1, 1, 99999, true, 0, 0)
				else
					btn:SetAlpha(1)
				end
			end
		end
	end
end

-------------------------------------------------------------------------------
-- This function is much more expensive than UB_UnitBuffs / UB_UnitDebuffs,
-- but has the advantage of being able to reset buttons visual appearance to a
-- default state and then rebuild/apply the unit's buff/debuff state.
-------------------------------------------------------------------------------
function UB_PrepButtons(unit)
    local isFriend = UnitIsFriend("player", unit)
    local isEnemy = UnitIsEnemy("player", unit)
    local targetNotFriend = unit == "target" and isFriend == nil
	local targetIsEnemy = unit == "target" and isEnemy

	-- Reset all visual button attributes to default
	UB_ConfigMode(unit)
 
	-- If unit is a friend process for buffs
	if isFriend then
	    for k,v in pairs(UBVAR.DYNEVENTS[unit].Buff) do
		    local i = 1
		    local name,rank,texture,count,type
		    local status

			while true do
		  		name,rank,texture,count,type = UnitBuff(unit, i)
				if not name then
					break
				end
				if name == k then
				    status = 1
				end
   		     	i = i + 1
			end
			UB_ChangeButtonsBuff(unit, k, status)
			UB_UnitBuffs(unit)
		end

	    -- Process for cureables and dim debuff buttons.
	    local i = 1
		local name,rank,texture,count,type
		local status

		while true do
 			name,rank,texture,count,type = UnitDebuff(unit, i)
			-- Set all cure buttons to false
			for k,v in pairs(watchCures) do
				UB_ChangeButtonsCure(unit, k)
			end

			if not name then
				break
			end
			if type == "Poison" or type == "Disease" or type == "Magic" or type == "Curse" then
			    status = 1
			    UB_ChangeButtonsCure(unit, type, status)
			    UB_UnitDebuffs(unit)
			end
			i = i + 1
		end
		-- Process for health state.
	    UB_HealthEvent(unit)
	end

	-- If unit is target and not a friend and is an Enemy then process debuffs
	if targetNotFriend or targetIsEnemy then
		for k,v in pairs(UBVAR.DYNEVENTS[unit].Debuff) do
		    local i = 1
		    local name,rank,texture,count,type
		    local status

			while true do
		  		name,rank,texture,count,type = UnitDebuff(unit, i)
				if not name then
					break
				end
				if name == k then
				    status = 1
				end
				i = i + 1
			end
			UB_ChangeButtonsDebuff(unit, k, status)
			UB_UnitDebuffs(unit)
		end
	end
end


------------------------------------------------------------------------
-- These are master control functions, globally adjusting addon elements
------------------------------------------------------------------------
function UB_ButtonReset()
    for k,v in pairs(watchUnits) do
		UB_PrepButtons(k)
	end
end

function UB_MonitorReset(self) 
	self:SetScript("OnUpdate", function(self) self:SetScript("OnUpdate", nil) 
	UB_ButtonReset() 
	end) 
end
    
function UB_InitBars()
	UB_InitPlayerFrame()
	UB_InitPlayerButtons()
	UB_InitPlayerPetFrame()
	UB_InitPlayerPetButtons()	
	UB_InitTargetFrame()
	UB_InitTargetButtons()
	UB_InitPartyFrames()
	UB_InitPartyButtons()
	UB_InitPartyPetFrames()
	UB_InitPartyPetButtons()
	UB_ButtonReset()
end


