local _G = _G
local UnitClass = UnitClass
local UnitIsFriend = UnitIsFriend
local UnitIsEnemy = UnitIsEnemy 
local watchUnits = {player = true, target = true, party1 = "1", party2 = "2", party3 = "3", party4 = "4", playerpet = true, partypet1 = "1", partypet2 = "2", partypet3 = "3", partypet4 = "4"}
local classCheckButtons = {UBConfigSub2Warrior = true, UBConfigSub2Paladin = true, UBConfigSub2Shaman = true, UBConfigSub2Hunter = true, UBConfigSub2Rogue = true, UBConfigSub2Warlock = true, UBConfigSub2Mage = true, UBConfigSub2Priest = true, UBConfigSub2Druid = true}
---------------------------------------
-- Swap between Config UI Tabs, OnClick
---------------------------------------

function UB_ButtonHandler()
	if UBConfigSub1:IsVisible() then
		UBConfigSub1:Hide()
		UBConfigSub2:Hide()
		UBConfigSub3:Show()
  		UBVAR.DYNBTNMODE = true
  		LOCK_ACTIONBAR = "1"
  		UBConfigUIStart()
    else
    	UBConfigSub2:Hide()
		UBConfigSub3:Hide()
		UBConfigSub1:Show()
		UBVAR.DYNBTNMODE = nil
		LOCK_ACTIONBAR = "0"
		UBConfigUIStart()
    end
end

------------------------------------------------------------------------------
-- Called prior to Click event, this conditionally supreses ActionButton cast
-- and selects Button for Dynamic configuration.
------------------------------------------------------------------------------
function UB_PreClick()
	if UBVAR.DYNBTNMODE then
		local type, id, subtype = GetActionInfo(this:GetAttribute("action"))
		if type == "spell" then
			local CfgSpellName, CfgSpellRank = GetSpellName(id, subtype)
			UBVAR.LASTSPELLCFG = CfgSpellName

			UBConfigSub2:Hide()
			UBConfigSub3:Hide()
    	  	UBConfigSub2:Show()
    	  	UBConfigUIStart()
		end
		this:SetAttribute("type", "click")
		this:SetAttribute("clickbutton", nilButton)
		return
	else
		this:SetAttribute("type", "action")
	end
end

-------------------------------------------------------------------------------
-- Find and index buttons linked to UBVAR.LASTSPELLCFG, called by UBConfigSub2 
-- frame during it's <OnHide> event.
-------------------------------------------------------------------------------
function UB_InitSpell()

	-------------------------------------------
	-- Create event tables for each Unit Frame 
	-------------------------------------------
	-- Create player tables
	if not UBVAR.DYNEVENTS.player then
		UBVAR.DYNEVENTS.player = {}
	end
	-- Create player pet
	if not UBVAR.DYNEVENTS.playerpet then
		UBVAR.DYNEVENTS.playerpet = {}
	end	
	-- Create target tables
	if not UBVAR.DYNEVENTS.target then
		UBVAR.DYNEVENTS.target = {}
	end
	-- Create party tables
	for i = 1, 4 do
		if not UBVAR.DYNEVENTS["party"..i] then
			UBVAR.DYNEVENTS["party"..i] = {}
		end
	end
	-- Create partypet tables
	for i = 1, 4 do
		if not UBVAR.DYNEVENTS["partypet"..i] then
			UBVAR.DYNEVENTS["partypet"..i] = {}
		end
	end	

--[[
	-- Create Raid tables
	for i = 1, 40 do
		if not UBVAR.DYNEVENTS["raid"..i] then
			UBVAR.DYNEVENTS["raid"..i] = {}
		end
	end
--]]

    --------------------------
	-- Create spelltype tables  
	--------------------------

	if not UBVAR.DYNVARS.UBConfigSub2Buff then
		UBVAR.DYNVARS.UBConfigSub2Buff = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2BuffBlink then
		UBVAR.DYNVARS.UBConfigSub2BuffBlink = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2BuffDim then
		UBVAR.DYNVARS.UBConfigSub2BuffDim = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Debuff then
		UBVAR.DYNVARS.UBConfigSub2Debuff = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2DebuffBlink then
		UBVAR.DYNVARS.UBConfigSub2DebuffBlink = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2DebuffDim then
		UBVAR.DYNVARS.UBConfigSub2DebuffDim = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Poison then
		UBVAR.DYNVARS.UBConfigSub2Poison = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Disease then
		UBVAR.DYNVARS.UBConfigSub2Disease = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Curse then
		UBVAR.DYNVARS.UBConfigSub2Curse = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Magic then
		UBVAR.DYNVARS.UBConfigSub2Magic = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Heal then
		UBVAR.DYNVARS.UBConfigSub2Heal = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2HealBlink then
		UBVAR.DYNVARS.UBConfigSub2HealBlink = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2HealDim then
		UBVAR.DYNVARS.UBConfigSub2HealDim = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2HealHide then
		UBVAR.DYNVARS.UBConfigSub2HealHide = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Warrior then
		UBVAR.DYNVARS.UBConfigSub2Warrior = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Paladin then
		UBVAR.DYNVARS.UBConfigSub2Paladin = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Druid then
		UBVAR.DYNVARS.UBConfigSub2Druid = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Shaman then
		UBVAR.DYNVARS.UBConfigSub2Shaman = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Hunter then
		UBVAR.DYNVARS.UBConfigSub2Hunter = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Rogue then
		UBVAR.DYNVARS.UBConfigSub2Rogue = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Warlock then
		UBVAR.DYNVARS.UBConfigSub2Warlock = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Mage then
		UBVAR.DYNVARS.UBConfigSub2Mage = {}
	end
	if not UBVAR.DYNVARS.UBConfigSub2Priest then
		UBVAR.DYNVARS.UBConfigSub2Priest = {}
	end

--[[
    --------------------------
	-- Create spelltype tables  
	--------------------------

	local dynvars = UBVAR.DYNVARS
	local spelltypes = {
	Buff = true,
	BuffBlink = true,
	BuffDim = true,
	Debuff = true,
	DebuffBlink = true,
	DebuffDim = true,
	Poison = true,
	Disease = true,
	Curse = true,
	Magic = true,
	Heal = true,
	HealBlink = true,
	HealDim = true,
	HealHide = true,
	WARRIOR = true,
	Paladin = true,
	Shaman = true,
	Hunter = true,
	Rogue = true,
	Warlock = true,
	Mage = true,
	Priest = true
	}

	setmetatable(dynvars, { __index = function(self, key)
	    local newkey = key:match("^UBConfigSub2(.+)$")
	    if ( newkey and spelltypes[newkey] ) then
			if ( not rawget(self, key) ) then
	            local tbl = { }
                rawset(self, key, tbl)
	            return tbl
	        end
	    end
	end })

--]]

    -----------------------------------
	-- Create and populate class tables
	-----------------------------------
	UBVAR.DYNVARS.WARRIOR = {}
	for k,v in pairs(UBVAR.DYNVARS.UBConfigSub2Warrior) do
		UBVAR.DYNVARS.WARRIOR[k] = {}
	end

	UBVAR.DYNVARS.PALADIN = {}
	for k,v in pairs(UBVAR.DYNVARS.UBConfigSub2Paladin) do
		UBVAR.DYNVARS.PALADIN[k] = {}
	end

    UBVAR.DYNVARS.DRUID = {}
	for k,v in pairs(UBVAR.DYNVARS.UBConfigSub2Druid) do
		UBVAR.DYNVARS.DRUID[k] = {}
	end
	
	UBVAR.DYNVARS.SHAMAN = {}
	for k,v in pairs(UBVAR.DYNVARS.UBConfigSub2Shaman) do
		UBVAR.DYNVARS.SHAMAN[k] = {}
	end

	UBVAR.DYNVARS.HUNTER = {}
	for k,v in pairs(UBVAR.DYNVARS.UBConfigSub2Hunter) do
		UBVAR.DYNVARS.HUNTER[k] = {}
	end

	UBVAR.DYNVARS.ROGUE = {}
	for k,v in pairs(UBVAR.DYNVARS.UBConfigSub2Rogue) do
		UBVAR.DYNVARS.ROGUE[k] = {}
	end

	UBVAR.DYNVARS.WARLOCK = {}
	for k,v in pairs(UBVAR.DYNVARS.UBConfigSub2Warlock) do
		UBVAR.DYNVARS.WARLOCK[k] = {}
	end

	UBVAR.DYNVARS.MAGE = {}
	for k,v in pairs(UBVAR.DYNVARS.UBConfigSub2Mage) do
		UBVAR.DYNVARS.MAGE[k] = {}
	end

	UBVAR.DYNVARS.PRIEST = {}
	for k,v in pairs(UBVAR.DYNVARS.UBConfigSub2Priest) do
		UBVAR.DYNVARS.PRIEST[k] = {}
	end
	
	-----------------------------------------------------------------------
	-- Create and populate spelltype tables for each Unit with button names
	-----------------------------------------------------------------------

 	-- Player
	local firstRun = true
	for j = 1, 12 do
		local btn = _G["PlayerUnitButton"..j]
		btn:SetAttribute("type", "action")
	    local type, id, subtype = GetActionInfo(btn:GetAttribute("action"))
		if firstRun then
			UBVAR.DYNEVENTS.player.Heals = {}
			UBVAR.DYNEVENTS.player.Poison = {}
			UBVAR.DYNEVENTS.player.Disease = {}
			UBVAR.DYNEVENTS.player.Curse = {}
			UBVAR.DYNEVENTS.player.Magic = {}
			UBVAR.DYNEVENTS.player.Buff = {}
			firstRun = false
		end
	    if type == "spell" then
			-- Populate player heal table
         local SpellName, SpellRank = GetSpellName(id, subtype)

	        if UBVAR.DYNVARS.UBConfigSub2Heal[SpellName] then
            	UBVAR.DYNEVENTS.player.Heals[btn:GetName()] = {BLINK=UBVAR.DYNVARS.UBConfigSub2HealBlink[SpellName], DIM=UBVAR.DYNVARS.UBConfigSub2HealDim[SpellName], HIDE=UBVAR.DYNVARS.UBConfigSub2HealHide[SpellName]}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Poison[SpellName] then
	        	UBVAR.DYNEVENTS.player.Poison[btn:GetName()] = {}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Disease[SpellName] then
	        	UBVAR.DYNEVENTS.player.Disease[btn:GetName()] = {}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Curse[SpellName] then
	        	UBVAR.DYNEVENTS.player.Curse[btn:GetName()] = {}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Magic[SpellName] then
	        	UBVAR.DYNEVENTS.player.Magic[btn:GetName()] = {}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Buff[SpellName] then
                if not UBVAR.DYNEVENTS.player.Buff[SpellName] then
	            	UBVAR.DYNEVENTS.player.Buff[SpellName] = {}
				end
	            table.insert(UBVAR.DYNEVENTS.player.Buff[SpellName], btn:GetName())
   			end
		end
	end

 	-- Playerpet
	local firstRun = true
	for j = 1, 12 do
		local btn = _G["PlayerPetUnitButton"..j]
		btn:SetAttribute("type", "action")
	    local type, id, subtype = GetActionInfo(btn:GetAttribute("action"))
		if firstRun then
			UBVAR.DYNEVENTS.playerpet.Heals = {}
			UBVAR.DYNEVENTS.playerpet.Poison = {}
			UBVAR.DYNEVENTS.playerpet.Disease = {}
			UBVAR.DYNEVENTS.playerpet.Curse = {}
			UBVAR.DYNEVENTS.playerpet.Magic = {}
			UBVAR.DYNEVENTS.playerpet.Buff = {}
			firstRun = false
		end
	    if type == "spell" then
			-- Populate playerpet heal table
			local SpellName, SpellRank = GetSpellName(id, subtype)

	        if UBVAR.DYNVARS.UBConfigSub2Heal[SpellName] then
            	UBVAR.DYNEVENTS.playerpet.Heals[btn:GetName()] = {BLINK=UBVAR.DYNVARS.UBConfigSub2HealBlink[SpellName], DIM=UBVAR.DYNVARS.UBConfigSub2HealDim[SpellName], HIDE=UBVAR.DYNVARS.UBConfigSub2HealHide[SpellName]}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Poison[SpellName] then
	        	UBVAR.DYNEVENTS.playerpet.Poison[btn:GetName()] = {}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Disease[SpellName] then
	        	UBVAR.DYNEVENTS.playerpet.Disease[btn:GetName()] = {}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Curse[SpellName] then
	        	UBVAR.DYNEVENTS.playerpet.Curse[btn:GetName()] = {}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Magic[SpellName] then
	        	UBVAR.DYNEVENTS.playerpet.Magic[btn:GetName()] = {}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Buff[SpellName] then
                if not UBVAR.DYNEVENTS.playerpet.Buff[SpellName] then
	            	UBVAR.DYNEVENTS.playerpet.Buff[SpellName] = {}
				end
	            table.insert(UBVAR.DYNEVENTS.playerpet.Buff[SpellName], btn:GetName())
   			end
		end
	end
	
	-- Target
	local firstRun = true
	for j = 1, 12 do
		local btn = _G["TargetUnitButton"..j]
		btn:SetAttribute("type", "action")
	    local type, id, subtype = GetActionInfo(btn:GetAttribute("action"))
		if firstRun then
			UBVAR.DYNEVENTS.target.Heals = {}
			UBVAR.DYNEVENTS.target.Poison = {}
			UBVAR.DYNEVENTS.target.Disease = {}
			UBVAR.DYNEVENTS.target.Curse = {}
			UBVAR.DYNEVENTS.target.Magic = {}
			UBVAR.DYNEVENTS.target.Buff = {}
			UBVAR.DYNEVENTS.target.Debuff = {}
            firstRun = false
		end
	    if type == "spell" then
			-- Populate target heal table
         local SpellName, SpellRank = GetSpellName(id, subtype)

	        if UBVAR.DYNVARS.UBConfigSub2Heal[SpellName] then
	            UBVAR.DYNEVENTS.target.Heals[btn:GetName()] = {BLINK=UBVAR.DYNVARS.UBConfigSub2HealBlink[SpellName], DIM=UBVAR.DYNVARS.UBConfigSub2HealDim[SpellName], HIDE=UBVAR.DYNVARS.UBConfigSub2HealHide[SpellName]}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Poison[SpellName] then
	        	UBVAR.DYNEVENTS.target.Poison[btn:GetName()] = {}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Disease[SpellName] then
	        	UBVAR.DYNEVENTS.target.Disease[btn:GetName()] = {}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Curse[SpellName] then
	        	UBVAR.DYNEVENTS.target.Curse[btn:GetName()] = {}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Magic[SpellName] then
	        	UBVAR.DYNEVENTS.target.Magic[btn:GetName()] = {}
			end
	        if UBVAR.DYNVARS.UBConfigSub2Buff[SpellName] then
	            if not UBVAR.DYNEVENTS.target.Buff[SpellName] then
	        		UBVAR.DYNEVENTS.target.Buff[SpellName] = {}
				end
	            table.insert(UBVAR.DYNEVENTS.target.Buff[SpellName], btn:GetName())
			end
	        if UBVAR.DYNVARS.UBConfigSub2Debuff[SpellName] then
	            if not UBVAR.DYNEVENTS.target.Debuff[SpellName] then
	                UBVAR.DYNEVENTS.target.Debuff[SpellName] = {}
				end
				table.insert(UBVAR.DYNEVENTS.target.Debuff[SpellName], btn:GetName())
			end			
		end

	end
	
	-- Party
	local firstRun = true
	for i = 1, 4 do
		for j = 1, 12 do
			local btn = _G["PartyFrame"..i.."PartyButton"..j]
			btn:SetAttribute("type", "action")
		    local type, id, subtype = GetActionInfo(btn:GetAttribute("action"))
			if firstRun then
				for x = 1, 4 do
					UBVAR.DYNEVENTS["party"..x].Heals = {}
					UBVAR.DYNEVENTS["party"..x].Poison = {}
					UBVAR.DYNEVENTS["party"..x].Disease = {}
					UBVAR.DYNEVENTS["party"..x].Curse = {}
					UBVAR.DYNEVENTS["party"..x].Magic = {}
					UBVAR.DYNEVENTS["party"..x].Buff = {}
					firstRun = false
				end
			end
		    if type == "spell" then
				-- Populate target heal table
		        local SpellName, SpellRank = GetSpellName(id, subtype)

				if UBVAR.DYNVARS.UBConfigSub2Heal[SpellName] then
		       		UBVAR.DYNEVENTS["party"..i].Heals[btn:GetName()] = {BLINK=UBVAR.DYNVARS.UBConfigSub2HealBlink[SpellName], DIM=UBVAR.DYNVARS.UBConfigSub2HealDim[SpellName], HIDE=UBVAR.DYNVARS.UBConfigSub2HealHide[SpellName]}
				end
			    if UBVAR.DYNVARS.UBConfigSub2Poison[SpellName] then
		   	     	UBVAR.DYNEVENTS["party"..i].Poison[btn:GetName()] = {}
				end
		        if UBVAR.DYNVARS.UBConfigSub2Disease[SpellName] then
	    	    	UBVAR.DYNEVENTS["party"..i].Disease[btn:GetName()] = {}
				end
				if UBVAR.DYNVARS.UBConfigSub2Curse[SpellName] then
		        	UBVAR.DYNEVENTS["party"..i].Curse[btn:GetName()] = {}
				end
		        if UBVAR.DYNVARS.UBConfigSub2Magic[SpellName] then
		        	UBVAR.DYNEVENTS["party"..i].Magic[btn:GetName()] = {}
				end
		        if UBVAR.DYNVARS.UBConfigSub2Buff[SpellName] then
	                if not UBVAR.DYNEVENTS["party"..i].Buff[SpellName] then
		            	UBVAR.DYNEVENTS["party"..i].Buff[SpellName] = {}
					end
	        	    table.insert(UBVAR.DYNEVENTS["party"..i].Buff[SpellName], btn:GetName())
				end				
			end
		end
	end

	-- Partypet
	local firstRun = true
	for i = 1, 4 do
		for j = 1, 12 do
			local btn = _G["PartyPetFrame"..i.."PartyPetButton"..j]
			btn:SetAttribute("type", "action")
		    local type, id, subtype = GetActionInfo(btn:GetAttribute("action"))
			if firstRun then
				for x = 1, 4 do
					UBVAR.DYNEVENTS["partypet"..x].Heals = {}
					UBVAR.DYNEVENTS["partypet"..x].Poison = {}
					UBVAR.DYNEVENTS["partypet"..x].Disease = {}
					UBVAR.DYNEVENTS["partypet"..x].Curse = {}
					UBVAR.DYNEVENTS["partypet"..x].Magic = {}
					UBVAR.DYNEVENTS["partypet"..x].Buff = {}
					firstRun = false
				end
			end
		    if type == "spell" then
				-- Populate target heal table
		        local SpellName, SpellRank = GetSpellName(id, subtype)

				if UBVAR.DYNVARS.UBConfigSub2Heal[SpellName] then
		       		UBVAR.DYNEVENTS["partypet"..i].Heals[btn:GetName()] = {BLINK=UBVAR.DYNVARS.UBConfigSub2HealBlink[SpellName], DIM=UBVAR.DYNVARS.UBConfigSub2HealDim[SpellName], HIDE=UBVAR.DYNVARS.UBConfigSub2HealHide[SpellName]}
				end
			    if UBVAR.DYNVARS.UBConfigSub2Poison[SpellName] then
		   	     	UBVAR.DYNEVENTS["partypet"..i].Poison[btn:GetName()] = {}
				end
		        if UBVAR.DYNVARS.UBConfigSub2Disease[SpellName] then
	    	    	UBVAR.DYNEVENTS["partypet"..i].Disease[btn:GetName()] = {}
				end
				if UBVAR.DYNVARS.UBConfigSub2Curse[SpellName] then
		        	UBVAR.DYNEVENTS["partypet"..i].Curse[btn:GetName()] = {}
				end
		        if UBVAR.DYNVARS.UBConfigSub2Magic[SpellName] then
		        	UBVAR.DYNEVENTS["partypet"..i].Magic[btn:GetName()] = {}
				end
		        if UBVAR.DYNVARS.UBConfigSub2Buff[SpellName] then
	                if not UBVAR.DYNEVENTS["partypet"..i].Buff[SpellName] then
		            	UBVAR.DYNEVENTS["partypet"..i].Buff[SpellName] = {}
					end
	        	    table.insert(UBVAR.DYNEVENTS["partypet"..i].Buff[SpellName], btn:GetName())
				end				
			end
		end
	end
--[[	
	-- Raid
	local firstRun = true
	for i = 1, 40 do
		for j = 1, 12 do
			local btn = _G["RaidFrame"..i.."RaidButton"..j]
		    local type, id, subtype = GetActionInfo(btn:GetAttribute("action"))
		    if (type == "spell") then
				-- Populate raid heal table
		        local SpellName, SpellRank = GetSpellName(id, subtype)
				if firstRun then
					for x = 1, 4 do
						UBVAR.DYNEVENTS["raid"..x].Heals = {}
						UBVAR.DYNEVENTS["raid"..x].Poison = {}
						UBVAR.DYNEVENTS["raid"..x].Disease = {}
						UBVAR.DYNEVENTS["raid"..x].Curse = {}
						UBVAR.DYNEVENTS["raid"..x].Magic = {}
						UBVAR.DYNEVENTS["raid"..x].Buff = {}
						firstRun = false
					end
				end
				if UBVAR.DYNVARS.UBConfigSub2CheckButton17[SpellName] ~= nil then
		       		UBVAR.DYNEVENTS["raid"..i].Heals[btn:GetName()] = {BLINK=UBVAR.DYNVARS.UBConfigSub2SliderBlink[SpellName], DIM=UBVAR.DYNVARS.UBConfigSub2SliderDim[SpellName], HIDE=UBVAR.DYNVARS.UBConfigSub2SliderHide[SpellName]}
				end
			    if UBVAR.DYNVARS.UBConfigSub2CheckButton13[SpellName] ~= nil then
		   	     	UBVAR.DYNEVENTS["raid"..i].Poison[btn:GetName()] = {}
				end
		        if UBVAR.DYNVARS.UBConfigSub2CheckButton14[SpellName] ~= nil then
	    	    	UBVAR.DYNEVENTS["raid"..i].Disease[btn:GetName()] = {}
				end
				if UBVAR.DYNVARS.UBConfigSub2CheckButton15[SpellName] ~= nil then
		        	UBVAR.DYNEVENTS["raid"..i].Curse[btn:GetName()] = {}
				end
		        if UBVAR.DYNVARS.UBConfigSub2CheckButton16[SpellName] ~= nil then
		        	UBVAR.DYNEVENTS["raid"..i].Magic[btn:GetName()] = {}
				end
		        if UBVAR.DYNVARS.UBConfigSub2CheckButton7[SpellName] ~= nil then
		        	UBVAR.DYNEVENTS["raid"..i].Buff[btn:GetName()] = {}
				end				
			end
		end
	end
--]]
end


------------------------------------------------------------------------------
-- This function swaps button visual states between pre-config and post-config
------------------------------------------------------------------------------
function UB_ConfigMode(unit)

	local localizedClass, uClass = UnitClass(unit)
		
-- While in Config Mode unlock actionbars, otherwise lock
	if UBVAR.UBCFGMODE then
	    LOCK_ACTIONBAR = "0"
	else
	    LOCK_ACTIONBAR = UBVAR.LOCKBARS
	end
-- Set/Reset player buttons statehidden
	if unit == "player" then
		UBVAR.DYNEVENTS.player.DisabledButtons = {}
		for j = 1, 12 do
			local btn = _G["PlayerUnitButton"..j]
			local btnName = "PlayerUnitButton"..j
		  	UIFrameFlashRemoveFrame(btn)
		  	UIFrameFadeRemoveFrame(btn)

			local type, id, subtype = GetActionInfo(btn:GetAttribute("action"))
			if type == "spell" and UnitExists(unit) and uClass then
				local SpellName, SpellRank = GetSpellName(id, subtype)
			
			  	if UBVAR.DYNVARS[uClass][SpellName] or j > UBVAR.NUMPLBTNS then
					btn:Hide()
			    	UBVAR.DYNEVENTS.player.DisabledButtons[btnName] = {}
				else
				    btn:Show()
				end
			elseif type ~= "spell" and j <= UBVAR.NUMPLBTNS then
				btn:Show()
			else
			    btn:Hide()
			    UBVAR.DYNEVENTS.player.DisabledButtons[btnName] = {}
			end

			if UBVAR.UBCFGMODE and j <= UBVAR.NUMPLBTNS then
	    		btn:SetAttribute("statehidden", false)
			else
	    		btn:SetAttribute("statehidden", true)
			end
		end
	end
-- Set/Reset playerpet buttons statehidden
	if unit == "playerpet" then
		UBVAR.DYNEVENTS.playerpet.DisabledButtons = {}
		for j = 1, 12 do
			local btn = _G["PlayerPetUnitButton"..j]
			local btnName = "PlayerPetUnitButton"..j
		  	UIFrameFlashRemoveFrame(btn)
		  	UIFrameFadeRemoveFrame(btn)

			local type, id, subtype = GetActionInfo(btn:GetAttribute("action"))
			if type == "spell" and UnitExists(unit) and uClass then
				local SpellName, SpellRank = GetSpellName(id, subtype)
			
			  	if UBVAR.DYNVARS[uClass][SpellName] or j > UBVAR.NUMPLPBTNS then
					btn:Hide()
			    	UBVAR.DYNEVENTS.playerpet.DisabledButtons[btnName] = {}
				else
				    btn:Show()
				end
			elseif type ~= "spell" and j <= UBVAR.NUMPLPBTNS then
				btn:Show()
			else
			    btn:Hide()
			    UBVAR.DYNEVENTS.playerpet.DisabledButtons[btnName] = {}
			end

			if UBVAR.UBCFGMODE and j <= UBVAR.NUMPLPBTNS then
	    		btn:SetAttribute("statehidden", false)
	    		btn:SetAttribute("*unit*", "player")
			else
	    		btn:SetAttribute("statehidden", true)
	    		btn:SetAttribute("*unit*", "playerpet")
			end
		end
	end
-- Set/Reset target buttons statehidden
	if unit == "target" then
		UBVAR.DYNEVENTS.target.DisabledButtons = {}
		for j = 1, 12 do
			local btn = _G["TargetUnitButton"..j]
			local btnName = "TargetUnitButton"..j

		    local isFriend = UnitIsFriend("player", unit)
		    local isEnemy = UnitIsEnemy("player", unit)
			local targetIsEnemy = unit == "target" and isEnemy

		  	UIFrameFlashRemoveFrame(btn)
		  	UIFrameFadeRemoveFrame(btn)

			local type, id, subtype = GetActionInfo(btn:GetAttribute("action"))
			if type == "spell" and UnitExists(unit) and uClass then				
				
			  	if UBVAR.DYNVARS[uClass][SpellName] or j > UBVAR.NUMTBTNS then
			  	    btn:Show()
					btn:SetAlpha(.1)
					UBVAR.DYNEVENTS.target.DisabledButtons[btnName] = {}
				else
					local type, id, subtype = GetActionInfo(btn:GetAttribute("action"))
					local SpellName, SpellRank = GetSpellName(id, subtype)
					local isCastable = IsSpellInRange(SpellName, unit)
					btn:Show()
					if UBVAR.DYNEVENTS.target.Debuff[SpellName] and isFriend and not targetIsEnemy then
						btn:SetAlpha(.1)
					elseif isCastable == nil then
						btn:SetAlpha(.1)
					else
					    btn:SetAlpha(1)
					end
				end
			elseif type ~= "spell" and j <= UBVAR.NUMTBTNS then
				btn:Show()
			else
			    btn:Show()
			    btn:SetAlpha(.1)
			    UBVAR.DYNEVENTS.target.DisabledButtons[btnName] = {}
			end

			if UBVAR.UBCFGMODE and j <= UBVAR.NUMTBTNS then
	    		btn:SetAttribute("statehidden", false)
	    		btn:SetAttribute("*unit*", "player")
			else
   		 		btn:SetAttribute("statehidden", true)
   		 		btn:SetAttribute("*unit*", "target")
			end
		end
	end
-- Set/Reset party buttons statehidden
	if unit == "party1" or unit == "party2" or unit == "party3" or unit == "party4" then
		local i = watchUnits[unit]
		
		UBVAR.DYNEVENTS["party"..i].DisabledButtons = {}

		for j = 1, 12 do
			local btn = _G["PartyFrame"..i.."PartyButton"..j]
			local btnName = "PartyFrame"..i.."PartyButton"..j
		  	UIFrameFlashRemoveFrame(btn)
		  	UIFrameFadeRemoveFrame(btn)

			local type, id, subtype = GetActionInfo(btn:GetAttribute("action"))
			if type == "spell" and UnitExists(unit) and uClass then
				local SpellName, SpellRank = GetSpellName(id, subtype)
				
			  	if UBVAR.DYNVARS[uClass][SpellName] or j > UBVAR.NUMPABTNS then
					btn:Hide()
				    UBVAR.DYNEVENTS["party"..i].DisabledButtons[btnName] = {}
				else
				    btn:Show()
				end
			elseif type ~= "spell" and j <= UBVAR.NUMPABTNS then
                btn:Show()
			else
			    btn:Hide()
			    UBVAR.DYNEVENTS["party"..i].DisabledButtons[btnName] = {}
			end

			if UBVAR.UBCFGMODE and j <= UBVAR.NUMPABTNS then
				btn:SetAttribute("statehidden", false)
				btn:SetAttribute("*unit*", "player")
			else
				btn:SetAttribute("statehidden", true)
				btn:SetAttribute("*unit*", "party"..i)
			end
		end
	end

-- Set/Reset party buttons statehidden
	if unit == "partypet1" or unit == "partypet2" or unit == "partypet3" or unit == "partypet4" then
		local i = watchUnits[unit]

		UBVAR.DYNEVENTS["partypet"..i].DisabledButtons = {}

		for j = 1, 12 do
			local btn = _G["PartyPetFrame"..i.."PartyPetButton"..j]
			local btnName = "PartyPetFrame"..i.."PartyPetButton"..j
		  	UIFrameFlashRemoveFrame(btn)
		  	UIFrameFadeRemoveFrame(btn)

			local type, id, subtype = GetActionInfo(btn:GetAttribute("action"))
			if type == "spell" and UnitExists(unit) and uClass then
				local SpellName, SpellRank = GetSpellName(id, subtype)
				
			  	if UBVAR.DYNVARS[uClass][SpellName] or j > UBVAR.NUMPAPBTNS then
					btn:Hide()
				    UBVAR.DYNEVENTS["partypet"..i].DisabledButtons[btnName] = {}
				else
				    btn:Show()
				end
			elseif type ~= "spell" and j <= UBVAR.NUMPAPBTNS then
                btn:Show()
			else
			    btn:Hide()
			    UBVAR.DYNEVENTS["partypet"..i].DisabledButtons[btnName] = {}
			end

			if UBVAR.UBCFGMODE and j <= UBVAR.NUMPAPBTNS then
				btn:SetAttribute("statehidden", false)
				btn:SetAttribute("*unit*", "player")
			else
				btn:SetAttribute("statehidden", true)
				btn:SetAttribute("*unit*", "partypet"..i)
			end
		end
	end
-- Set/Reset Raid buttons statehidden
--[[
	for i = 1, 40 do
		for j = 1, 6 do
		    local btn = _G["RaidFrame"..i.."RaidButton"..j]
			if UBVAR.UBCFGMODE then
   				btn:SetAttribute("statehidden", false)
   				btn:SetAttribute("*unit*", "player")
			else
   				btn:SetAttribute("statehidden", true)
   				btn:SetAttribute("*unit*", "raid"..i)
			end
		end
	end
--]]
end

function UB_ConfigPlayer()
	if UBVAR.NUMPLBTNS > 0 then
  		UBPlayerBarFrame:Show()
		for j = 1, 12 do
			local btn = _G["PlayerUnitButton"..j]
			btn:SetScale(UBVAR["PLSCALE"])
			if j > UBVAR.NUMPLBTNS then
				btn:Hide()
			elseif j <= UBVAR.NUMPLBTNS then
				btn:Show()
				btn:SetAlpha(1)
			end
		end
	else
		UBPlayerBarFrame:Hide()
	end
end

function UB_ConfigPlayerPet()
	if UBVAR.NUMPLPBTNS > 0 then
  		UBPlayerPetBarFrame:Show()
		for j = 1, 12 do
			local btn = _G["PlayerPetUnitButton"..j]
			btn:SetScale(UBVAR["PLPSCALE"])
			if j > UBVAR.NUMPLPBTNS then
				btn:Hide()
			elseif j <= UBVAR.NUMPLPBTNS then
			    btn:SetAttribute("*unit*", "player")
				btn:Show()
				btn:SetAlpha(1)
			end
		end
	else
		UBPlayerPetBarFrame:Hide()
	end
end

function UB_ConfigTarget()
	if UBVAR.NUMTBTNS > 0 then
  		UBTargetBarFrame:Show()
		for j = 1, 12 do
			local btn = _G["TargetUnitButton"..j]
			btn:SetScale(UBVAR["TSCALE"])
			if j > UBVAR.NUMTBTNS then
				btn:Hide()
			elseif j <= UBVAR.NUMTBTNS then
				btn:SetAttribute("*unit*", "player")
				btn:Show()
				btn:SetAlpha(1)
			end
		end
	else
		UBTargetBarFrame:Hide()
	end
end

function UB_ConfigParty()
	if UBVAR.NUMPABTNS > 0 then
		for i = 1, 4 do
		    _G["UBParty"..i.."BarFrame"]:Show()
			for j = 1, 12 do
				local btn = _G["PartyFrame"..i.."PartyButton"..j]
				btn:SetScale(UBVAR.PASCALE)
				if j > UBVAR.NUMPABTNS then
					btn:Hide()
				elseif j <= UBVAR.NUMPABTNS then
					btn:SetAttribute("*unit*", "player")
					btn:Show()
					btn:SetAlpha(1)
				end
			end
		end
	else
		for i = 1, 4 do
			_G["UBParty"..i.."BarFrame"]:Hide()
		end
	end
end

function UB_ConfigPartyPet()
	if UBVAR.NUMPAPBTNS > 0 then
		for i = 1, 4 do
		    _G["UBPartyPet"..i.."BarFrame"]:Show()
			for j = 1, 12 do
				local btn = _G["PartyPetFrame"..i.."PartyPetButton"..j]
				btn:SetScale(UBVAR.PAPSCALE)
				if j > UBVAR.NUMPAPBTNS then
					btn:Hide()
				elseif j <= UBVAR.NUMPAPBTNS then
					btn:SetAttribute("*unit*", "player")
					btn:Show()
					btn:SetAlpha(1)
				end
			end
		end
	else
		for i = 1, 4 do
			_G["UBPartyPet"..i.."BarFrame"]:Hide()
		end
	end
end

--[[
function UB_ConfigRaid()
	if UBVAR.NUMRABTNS > 0 then
		for i = 1, 40 do
			_G["UBRaid"..i.."BarFrame"]:Show()
			for j = 1, 6 do
			    local btn = _G["RaidFrame"..i.."RaidButton"..j]
	            btn:SetScale(UBVAR.RASCALE)
			    if j > UBVAR.NUMRABTNS then
					btn:Hide()
				elseif j <= UBVAR.NUMRABTNS then
					btn:Show()
					btn:SetAlpha(1)
				end
			end
		end
	else
		for i = 1, 40 do
		    _G["UBRaid"..i.."BarFrame"]:Hide()
		end		
	end
	if not UBVAR.UBCFGMODE then
	    UB_InitRaidFrames()
	end
end
--]]

-------------------------------------------------------------------------
-- This function sets FShow settings on UnitFrames 
-------------------------------------------------------------------------
function UB_ConfigFShow()

    if UBPlayerBarFrame:IsVisible() and UBVAR.FSHOW or UBVAR.UBCFGMODE then
		UBDragP1:Show()
	else
		UBDragP1:Hide()
	end
	
	if UBPlayerPetBarFrame:IsVisible() and UBVAR.FSHOW or UBVAR.UBCFGMODE then
		UBDragPP1:Show()
	else
		UBDragPP1:Hide()
	end

	if UBTargetBarFrame:IsVisible() and UBVAR.FSHOW or UBVAR.UBCFGMODE then
		UBDragT1:Show()
	else
		UBDragT1:Hide()
	end

	for i = 1, 4 do
	   	if _G["UBParty"..i.."BarFrame"]:IsVisible() and UBVAR.FSHOW or UBVAR.UBCFGMODE then
			_G["UBDragP"..(i + 1)]:Show()
		else
			_G["UBDragP"..(i + 1)]:Hide()
		end
	end

	for i = 1, 4 do
	   	if _G["UBPartyPet"..i.."BarFrame"]:IsVisible() and UBVAR.FSHOW or UBVAR.UBCFGMODE then
			_G["UBDragPP"..(i + 1)]:Show()
		else
			_G["UBDragPP"..(i + 1)]:Hide()
		end
	end
	
--[[	for i = 1, 40 do
	   	if _G["UBRaid"..i.."BarFrame"]:IsVisible() and UBVAR.FSHOW or UBVAR.UBCFGMODE then
			_G["UBDragR"..i]:Show()
		else
			_G["UBDragR"..i]:Hide()
		end
	end --]]
	
end

---------------------------------------------------
-- These functions reset configuration ui elements
---------------------------------------------------
function UB_ConfigReset()
    for k,v in pairs(watchUnits) do
		UB_ConfigMode(k)
	end
end

function UBConfigUIStart()
	UBVAR.UBCFGMODE = 1
	UB_InitSpell()
	UB_ConfigReset()
	UB_ConfigPlayer()
	UB_ConfigPlayerPet()
	UB_ConfigParty()
	UB_ConfigPartyPet()
	UB_ConfigTarget()
	UB_ConfigFShow()
end

function UBConfigUIStop()
	UBVAR.DYNBTNMODE = nil
	UBVAR.LASTSPELLCFG = nil
	UBVAR.UBCFGMODE = nil
	UBConfigSub1:Hide()
	UBConfigSub2:Hide()
	UBConfigSub3:Hide()
	UBConfig:Hide()
	UB_InitSpell()
	UB_InitBars()
	UB_ConfigFShow()
end


---------------------------------------------------------------
-- Below we define UBConfigSub1 button/slider behavior
---------------------------------------------------------------
function UBConfigSub1_OnShow()

	_G[this:GetName().."SliderNUMPLBTNS"]:SetValue(UBVAR.NUMPLBTNS)
	_G[this:GetName().."SliderNUMPLPBTNS"]:SetValue(UBVAR.NUMPLPBTNS)
	_G[this:GetName().."SliderNUMTBTNS"]:SetValue(UBVAR.NUMTBTNS)
	_G[this:GetName().."SliderNUMPABTNS"]:SetValue(UBVAR.NUMPABTNS)
	_G[this:GetName().."SliderNUMPAPBTNS"]:SetValue(UBVAR.NUMPAPBTNS)
	_G[this:GetName().."SliderNUMRABTNS"]:SetValue(UBVAR.NUMRABTNS)
	_G[this:GetName().."SliderPLSCALE"]:SetValue(UBVAR.PLSCALE)
	_G[this:GetName().."SliderPLPSCALE"]:SetValue(UBVAR.PLPSCALE)
	_G[this:GetName().."SliderTSCALE"]:SetValue(UBVAR.TSCALE)
	_G[this:GetName().."SliderPASCALE"]:SetValue(UBVAR.PASCALE)
	_G[this:GetName().."SliderPAPSCALE"]:SetValue(UBVAR.PAPSCALE)
	_G[this:GetName().."SliderRASCALE"]:SetValue(UBVAR.RASCALE)
	_G[this:GetName().."CheckButton1"]:SetChecked(UBVAR.FSHOW)
	_G[this:GetName().."CheckButton2"]:SetChecked(UBVAR.LOCKBARS)
	_G[this:GetName().."CheckButton3"]:SetChecked(UBVAR.ROWS)
end

-----------------------------------------------------------
-- Below we define UBConfigSub1 OnClick Handlers
-----------------------------------------------------------

function UBConfigSub1NUMPLBTNS_OnClick()
	UBVAR.NUMPLBTNS = this:GetValue()
	NUMPLBTNSText:SetText(UBVAR.NUMPLBTNS)
	UB_ConfigPlayer()
end

function UBConfigSub1NUMPLPBTNS_OnClick()
	UBVAR.NUMPLPBTNS = this:GetValue()
	NUMPLPBTNSText:SetText(UBVAR.NUMPLPBTNS)
	UB_ConfigPlayerPet()
end

function UBConfigSub1NUMTBTNS_OnClick()
	UBVAR.NUMTBTNS = this:GetValue()
	NUMTBTNSText:SetText(UBVAR.NUMTBTNS)
	UB_ConfigTarget()
end

function UBConfigSub1NUMPABTNS_OnClick()
	UBVAR.NUMPABTNS = this:GetValue()
	NUMPABTNSText:SetText(UBVAR.NUMPABTNS)
	UB_ConfigParty()
end

function UBConfigSub1NUMPAPBTNS_OnClick()
	UBVAR.NUMPAPBTNS = this:GetValue()
	NUMPAPBTNSText:SetText(UBVAR.NUMPAPBTNS)
	UB_ConfigPartyPet()
end

function UBConfigSub1NUMRABTNS_OnClick()
	UBVAR.NUMRABTNS = this:GetValue()
	NUMRABTNSText:SetText(UBVAR.NUMRABTNS)
--	UB_ConfigRaid()
end

function UBConfigSub1PLSCALE_OnClick()
	UBVAR.PLSCALE = this:GetValue()
	PLSCALEText:SetText(UBVAR.PLSCALE)
	UB_ConfigPlayer()
end

function UBConfigSub1PLPSCALE_OnClick()
	UBVAR.PLPSCALE = this:GetValue()
	PLPSCALEText:SetText(UBVAR.PLPSCALE)
	UB_ConfigPlayerPet()
end

function UBConfigSub1TSCALE_OnClick()
	UBVAR.TSCALE = this:GetValue()
	TSCALEText:SetText(UBVAR.TSCALE)
	UB_ConfigTarget()
end

function UBConfigSub1PASCALE_OnClick()
	UBVAR.PASCALE = this:GetValue()
	PASCALEText:SetText(UBVAR.PASCALE)
	UB_ConfigParty()
end

function UBConfigSub1PAPSCALE_OnClick()
	UBVAR.PAPSCALE = this:GetValue()
	PAPSCALEText:SetText(UBVAR.PAPSCALE)
	UB_ConfigPartyPet()
end

function UBConfigSub1RASCALE_OnClick()
	UBVAR.RASCALE = this:GetValue()
	RASCALEText:SetText(UBVAR.RASCALE)
--	UB_ConfigRaid()
end

function UBConfigSub1CheckBox1_OnClick()
	if UBVAR.FSHOW then
		UBVAR.FSHOW = nil
	  	UB_ConfigFShow()
	else
		UBVAR.FSHOW = true
		UB_ConfigFShow()
	end
end

function UBConfigSub1CheckBox2_OnClick()
	if UBVAR.LOCKBARS == "1" then
		UBVAR.LOCKBARS = "0"
	else
		UBVAR.LOCKBARS = "1"
	end
end

function UBConfigSub1CheckBox3_OnClick()
	if UBVAR.ROWS then
		UBVAR.ROWS = nil
	  	ReloadUI()
	else
		UBVAR.ROWS = true
		ReloadUI()
	end
end

---------------------------------------
-- Here we define Dynamic Button Magic
---------------------------------------


function UBConfigSub2CheckBox_OnShow()
	if UBVAR.LASTSPELLCFG then
		local key = UBVAR.DYNVARS[this:GetName()][UBVAR.LASTSPELLCFG]
		this:SetChecked(key)
	else
    	UBConfigSub3:Show()
	end
end


function UBConfigSub2Slider_OnShow()
	if UBVAR.LASTSPELLCFG then
		if UBVAR.DYNVARS[this:GetName()][UBVAR.LASTSPELLCFG] then
            this:SetValue(UBVAR.DYNVARS[this:GetName()][UBVAR.LASTSPELLCFG])
		else
            this:SetValue(0)
		end
	else
    	UBConfigSub3:Show()
	end
end

function UBConfigSub2CheckBox_OnClick()
    local key = UBVAR.LASTSPELLCFG
	if this:GetChecked() == 1 then
	    UBVAR.DYNVARS[this:GetName()][key] = 1
	    if this == UBConfigSub2Heal then
	    	UBVAR.DYNVARS.UBConfigSub2HealBlink[key] = 0
			UBVAR.DYNVARS.UBConfigSub2HealDim[key] = 0
			UBVAR.DYNVARS.UBConfigSub2HealHide[key] = 0
		end
    else
        UBVAR.DYNVARS[this:GetName()][key] = nil
		if this == UBConfigSub2Heal then
            UBConfigSub2HealBlink:SetValue(0)
            UBConfigSub2HealDim:SetValue(0)
            UBConfigSub2HealHide:SetValue(0)
		    UBVAR.DYNVARS.UBConfigSub2HealBlink[key] = nil
		    UBVAR.DYNVARS.UBConfigSub2HealDim[key] = nil
		    UBVAR.DYNVARS.UBConfigSub2HealHide[key] = nil
		end
	end
end

function UBConfigSub2Slider_OnClick()
    local key = UBVAR.LASTSPELLCFG
	local frame = this:GetName()
	if UBVAR.DYNVARS.UBConfigSub2Heal[key] then
	    UBVAR.DYNVARS[this:GetName()][key] = this:GetValue()
	end
	_G[frame.."FontName"]:SetText(UBVAR.DYNVARS[this:GetName()][key])
end


function UBResetFrames()
	UBDragP1:ClearAllPoints()
	UBDragP1:SetPoint("TOP", "UIParent", "TOP", -480, -100);
	UBDragPP1:ClearAllPoints()
	UBDragPP1:SetPoint("TOP", "UBDragP1", "TOP", 0, -80)
	UBDragT1:ClearAllPoints()
	UBDragT1:SetPoint("TOP", "UBDragPP1", "TOP", 0, -80)
	
	UBDragP2:ClearAllPoints()
	UBDragP2:SetPoint("TOP", "UIParent", "TOP", 0, -30)
	UBDragPP2:ClearAllPoints()
	UBDragPP2:SetPoint("TOP", "UBDragP2", "TOP", 0, -80)
	UBDragP3:ClearAllPoints()
	UBDragP3:SetPoint("TOP", "UBDragPP2", "TOP", 0, -80)
	UBDragPP3:ClearAllPoints()
	UBDragPP3:SetPoint("TOP", "UBDragP3", "TOP", 0, -80)
	UBDragP4:ClearAllPoints()
	UBDragP4:SetPoint("TOP", "UBDragPP3", "TOP", 0, -80)
	UBDragPP4:ClearAllPoints()
	UBDragPP4:SetPoint("TOP", "UBDragP4", "TOP", 0, -80)
	UBDragP5:ClearAllPoints()
	UBDragP5:SetPoint("TOP", "UBDragPP4", "TOP", 0, -80)
	UBDragPP5:ClearAllPoints()
	UBDragPP5:SetPoint("TOP", "UBDragP5", "TOP", 0, -80)
end	
	
