-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local uabStatus_Default = uabUnitStatus:NewModule("Default")
uabStatus_Default.defaultDB = {
    disabled = nil,
    priority = 50,
    color = { r = 1,    g = 1,    b = 1, a = 1, },
    classfilter = {
        druid = true,
        hunter = true,
        mage = true,
        paladin = true,
        priest = true,
        rogue = true,
        shaman = true,
        warlock = true,
        warrior = true,
    },
}

function uabStatus_Default:OnInitialize()
    self.super.OnInitialize(self)

	self:RegisterUnitStatus(self.name, nil, self.db.profile)
end

function uabStatus_Default:OnEnable()
end

function uabStatus_Default:OnDisable()
end

function uabStatus_Default:IsStatusGained(name, unit, action)
    local class = self:GetUnitClass(unit)
    
    if not class or self.db.profile.classfilter[class] then
    	if name == self.name then
    		return true
    	end
    end
end

function uabStatus_Default:CreateUnitStatusOptions()
    return self:CreateUnitStatusOption(self.db.profile, "Default", "Default", true)
end
