-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 56358 $"):match("%d+")), ("$Date: 2007-11-30 21:59:40 -0500 (Fri, 30 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

if cyCircled then
    local addonName = "UnitActionBars2"
    
    cyCircled_uab = cyCircled:NewModule(addonName, "AceEvent-2.0")
    
    function cyCircled_uab:AddonLoaded(addon)
        self.db = cyCircled:AcquireDBNamespace(addonName)
        cyCircled:RegisterDefaults(addonName, "profile", {
            ["Main"] = true,
        })
        
        self:SetupElements()
    end
    
    function cyCircled_uab:ApplyCustom()
        
    end
    
    function cyCircled_uab:GetElements()
        return {
            ["Main"] = true,
        }
    end
    
    function cyCircled_uab:SetupElements()
        self.elements = {
            ["Main"] = { 
                args = {
                    button = { width = 35, height = 35, },
    				ct = false,
                },
                elements = {},
            },
        }
    
        local frames = uabActionButton:GetActionButtons()
        for frame, _ in pairs(frames) do
            self:AddActionButton(frame)
        end    
    
        self:RegisterEvent("UnitActionBars_ActionButtonCreated")
    end
    
    function cyCircled_uab:AddActionButton(frame)
        table.insert(self.elements["Main"].elements, frame:GetName())
    end
    
    function cyCircled_uab:UnitActionBars_ActionButtonCreated(frame)
        self:AddActionButton(frame)
        self:ApplySkin()
        self:ApplyColors()
    end
end
