-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local uabStatus_UnitClass = uabUnitStatus:NewModule("Unit Class")

uabStatus_UnitClass.defaultDB = {
    disabled = nil,
    druid = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
    },
    hunter = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
    },
    mage = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
    },
    paladin = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
    },
    priest = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
    },
    rogue = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
    },
    shaman = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
    },
    warlock = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
    },
    warrior = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
    },
    mana = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = nil,
            shaman = true,
            warlock = true,
            warrior = nil,
        },
    },
    caster = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = nil,
            mage = true,
            paladin = true,
            priest = true,
            rogue = nil,
            shaman = true,
            warlock = true,
            warrior = nil,
        },
    },
    healer = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = nil,
            mage = nil,
            paladin = true,
            priest = true,
            rogue = nil,
            shaman = true,
            warlock = nil,
            warrior = nil,
        },
    },
    ranged = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = true,
            shaman = true,
            warlock = true,
            warrior = true,
        },
    },
    melee = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = nil,
            mage = nil,
            paladin = true,
            priest = nil,
            rogue = true,
            shaman = true,
            warlock = nil,
            warrior = true,
        },
    },
    dps = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = true,
            shaman = true,
            warlock = true,
            warrior = true,
        },
    },
}

function uabStatus_UnitClass:OnInitialize()
    self.super.OnInitialize(self)

    if not self.db.profile.disabled then
        self:EnableAllStatus()
    end
end

function uabStatus_UnitClass:EnableAllStatus()
	if not self.db.profile.druid.disabled then
        self:RegisterUnitStatus("Class", "Class: Druid", self.db.profile.druid)
    end

	if not self.db.profile.hunter.disabled then
        self:RegisterUnitStatus("Class", "Class: Hunter", self.db.profile.hunter)
    end

	if not self.db.profile.mage.disabled then
        self:RegisterUnitStatus("Class", "Class: Mage", self.db.profile.mage)
    end

	if not self.db.profile.paladin.disabled then
        self:RegisterUnitStatus("Class", "Class: Paladin", self.db.profile.paladin)
    end

	if not self.db.profile.priest.disabled then
        self:RegisterUnitStatus("Class", "Class: Priest", self.db.profile.priest)
    end

	if not self.db.profile.rogue.disabled then
        self:RegisterUnitStatus("Class", "Class: Rogue", self.db.profile.rogue)
    end

	if not self.db.profile.shaman.disabled then
        self:RegisterUnitStatus("Class", "Class: Shaman", self.db.profile.shaman)
    end

	if not self.db.profile.warlock.disabled then
        self:RegisterUnitStatus("Class", "Class: Warlock", self.db.profile.warlock)
    end

	if not self.db.profile.warrior.disabled then
        self:RegisterUnitStatus("Class", "Class: Warrior", self.db.profile.warrior)
    end

    if not self.db.profile.mana.disabled then
        self:RegisterUnitStatus("ClassGroup", "ClassGroup: Mana", self.db.profile.mana)
    end

	if not self.db.profile.caster.disabled then
        self:RegisterUnitStatus("ClassGroup", "ClassGroup: Caster", self.db.profile.caster)
    end

	if not self.db.profile.healer.disabled then
        self:RegisterUnitStatus("ClassGroup", "ClassGroup: Healer", self.db.profile.healer)
    end

	if not self.db.profile.ranged.disabled then
        self:RegisterUnitStatus("ClassGroup", "ClassGroup: Ranged", self.db.profile.ranged)
    end

	if not self.db.profile.melee.disabled then
        self:RegisterUnitStatus("ClassGroup", "ClassGroup: Melee", self.db.profile.melee)
    end

	if not self.db.profile.dps.disabled then
        self:RegisterUnitStatus("ClassGroup", "ClassGroup: DPS", self.db.profile.dps)
    end
end

function uabStatus_UnitClass:EnableUnitStatus(name, displayname)
    if not self.db.profile.disabled then
        if displayname == "Class: Druid" then
            self:RegisterUnitStatus("Class", "Class: Druid", self.db.profile.druid)
        elseif displayname == "Class: Hunter" then
            self:RegisterUnitStatus("Class", "Class: Hunter", self.db.profile.hunter)
        elseif displayname == "Class: Mage" then
            self:RegisterUnitStatus("Class", "Class: Mage", self.db.profile.mage)
        elseif displayname == "Class: Paladin" then
            self:RegisterUnitStatus("Class", "Class: Paladin", self.db.profile.paladin)
        elseif displayname == "Class: Priest" then
            self:RegisterUnitStatus("Class", "Class: Priest", self.db.profile.priest)
        elseif displayname == "Class: Rogue" then
            self:RegisterUnitStatus("Class", "Class: Rogue", self.db.profile.rogue)
        elseif displayname == "Class: Shaman" then
            self:RegisterUnitStatus("Class", "Class: Shaman", self.db.profile.shaman)
        elseif displayname == "Class: Warlock" then
            self:RegisterUnitStatus("Class", "Class: Warlock", self.db.profile.warlock)
        elseif displayname == "Class: Warrior" then
            self:RegisterUnitStatus("Class", "Class: Warrior", self.db.profile.warrior)
        elseif displayname == "ClassGroup: Mana" then
            self:RegisterUnitStatus("ClassGroup", "ClassGroup: Mana", self.db.profile.mana)
        elseif displayname == "ClassGroup: Caster" then
            self:RegisterUnitStatus("ClassGroup", "ClassGroup: Caster", self.db.profile.caster)
        elseif displayname == "ClassGroup: Healer" then
            self:RegisterUnitStatus("ClassGroup", "ClassGroup: Healer", self.db.profile.healer)
        elseif displayname == "ClassGroup: Ranged" then
            self:RegisterUnitStatus("ClassGroup", "ClassGroup: Ranged", self.db.profile.ranged)
        elseif displayname == "ClassGroup: Melee" then
            self:RegisterUnitStatus("ClassGroup", "ClassGroup: Melee", self.db.profile.melee)
        elseif displayname == "ClassGroup: DPS" then
            self:RegisterUnitStatus("ClassGroup", "ClassGroup: DPS", self.db.profile.dps)
        end
    end
end

function uabStatus_UnitClass:DisableAllStatus()
	self:UnregisterUnitStatus("Class", "Class: Druid")
	self:UnregisterUnitStatus("Class", "Class: Hunter")
	self:UnregisterUnitStatus("Class", "Class: Mage")
	self:UnregisterUnitStatus("Class", "Class: Paladin")
	self:UnregisterUnitStatus("Class", "Class: Priest")
	self:UnregisterUnitStatus("Class", "Class: Rogue")
	self:UnregisterUnitStatus("Class", "Class: Shaman")
	self:UnregisterUnitStatus("Class", "Class: Warlock")
	self:UnregisterUnitStatus("Class", "Class: Warrior")
	
    self:UnregisterUnitStatus("ClassGroup", "ClassGroup: Mana")
	self:UnregisterUnitStatus("ClassGroup", "ClassGroup: Caster")
	self:UnregisterUnitStatus("ClassGroup", "ClassGroup: Healer")
	self:UnregisterUnitStatus("ClassGroup", "ClassGroup: Ranged")
	self:UnregisterUnitStatus("ClassGroup", "ClassGroup: Melee")
	self:UnregisterUnitStatus("ClassGroup", "ClassGroup: DPS")
end

function uabStatus_UnitClass:DisableUnitStatus(name, displayname)
    if not self.db.profile.disabled then
        if displayname == "Class: Druid" then
            self:UnregisterUnitStatus("Class", "Class: Druid")
        elseif displayname == "Class: Hunter" then
            self:UnregisterUnitStatus("Class", "Class: Hunter")
        elseif displayname == "Class: Mage" then
            self:UnregisterUnitStatus("Class", "Class: Mage")
        elseif displayname == "Class: Paladin" then
            self:UnregisterUnitStatus("Class", "Class: Paladin")
        elseif displayname == "Class: Priest" then
            self:UnregisterUnitStatus("Class", "Class: Priest")
        elseif displayname == "Class: Rogue" then
            self:UnregisterUnitStatus("Class", "Class: Rogue")
        elseif displayname == "Class: Shaman" then
            self:UnregisterUnitStatus("Class", "Class: Shaman")
        elseif displayname == "Class: Warlock" then
            self:UnregisterUnitStatus("Class", "Class: Warlock")
        elseif displayname == "Class: Warrior" then
            self:UnregisterUnitStatus("Class", "Class: Warrior")
        elseif displayname == "ClassGroup: Mana" then
            self:UnregisterUnitStatus("ClassGroup", "ClassGroup: Mana")
        elseif displayname == "ClassGroup: Caster" then
            self:UnregisterUnitStatus("ClassGroup", "ClassGroup: Caster")
        elseif displayname == "ClassGroup: Healer" then
            self:UnregisterUnitStatus("ClassGroup", "ClassGroup: Healer")
        elseif displayname == "ClassGroup: Ranged" then
            self:UnregisterUnitStatus("ClassGroup", "ClassGroup: Ranged")
        elseif displayname == "ClassGroup: Melee" then
            self:UnregisterUnitStatus("ClassGroup", "ClassGroup: Melee")
        elseif displayname == "ClassGroup: DPS" then
            self:UnregisterUnitStatus("ClassGroup", "ClassGroup: DPS")
        end
    end
end

function uabStatus_UnitClass:OnEnable()
end

function uabStatus_UnitClass:OnDisable()
end

function uabStatus_UnitClass:IsStatusGained(name, unit, action)
    local class = self:GetUnitClass(unit)
    local isclass

    if self.db.profile.disabled then return end

    if class then
        local status = string.find(name, "ClassGroup: (.+)")
        if not status then
            status = string.find(name, "Class: (.*)")
    
            status = string.lower(status)
            if status == class and self.db.profile[status] and not self.db.profile[status].disabled then
                isclass = true
            end
        else
            status = string.lower(status)
            if self.db.profile[status] and not self.db.profile[status].disabled then
                if self.db.profile[status].classfilter[class] then
                    isclass = true
                end
            end
        end
    end
    
    return isclass
end

function uabStatus_UnitClass:CreateUnitStatusOptions()
    local args = {}

    args = {
        type = 'group',
        name = "Class Check",
        desc = "Configure the options for Class Check unit status values",
        args = {
            enabled = {
                type = 'toggle',
                name = "Enabled",
                desc = "When checked, enable the use of the Class Check unit status values",
                order = 1,
                get = function()
                    return not self.db.profile.disabled
                end,
                set = function(v)
                    self.db.profile.disabled = not v
                    if self.db.profile.disabled then
                        self:DisableAllStatus()
                    else
                        self:EnableAllStatus()
                    end

                    self.core.core.main:FrameGroupsChanged()
                end,
            },

            spacing3 = {
                name = " ",
                type = 'header',
                order = 5,
            },
        },
    }

    args.args.druid = self:CreateUnitStatusOption(self.db.profile.druid, "Class: Druid", "Class: Druid", false)
    args.args.druid.order = 10

    args.args.hunter = self:CreateUnitStatusOption(self.db.profile.hunter, "Class: Hunter", "Class: Hunter", false)
    args.args.hunter.order = 20

    args.args.mage = self:CreateUnitStatusOption(self.db.profile.mage, "Class: Mage", "Class: Mage", false)
    args.args.mage.order = 30

    args.args.paladin = self:CreateUnitStatusOption(self.db.profile.paladin, "Class: Paladin", "Class: Paladin", false)
    args.args.paladin.order = 40

    args.args.priest = self:CreateUnitStatusOption(self.db.profile.priest, "Class: Priest", "Class: Priest", false)
    args.args.priest.order = 50

    args.args.rogue = self:CreateUnitStatusOption(self.db.profile.rogue, "Class: Rogue", "Class: Rogue", false)
    args.args.rogue.order = 60

    args.args.shaman = self:CreateUnitStatusOption(self.db.profile.shaman, "Class: Shaman", "Class: Shaman", false)
    args.args.shaman.order = 70

    args.args.warlock = self:CreateUnitStatusOption(self.db.profile.warlock, "Class: Warlock", "Class: Warlock", false)
    args.args.warlock.order = 80

    args.args.warrior = self:CreateUnitStatusOption(self.db.profile.warrior, "Class: Warrior", "Class: Warrior", false)
    args.args.warrior.order = 90

    args.args.mana = self:CreateUnitStatusOption(self.db.profile.mana, "ClassGroup: Mana", "ClassGroup: Mana", true)
    args.args.mana.order = 100

    args.args.caster = self:CreateUnitStatusOption(self.db.profile.caster, "ClassGroup: Caster", "ClassGroup: Caster", true)
    args.args.caster.order = 110

    args.args.healer = self:CreateUnitStatusOption(self.db.profile.healer, "ClassGroup: Healer", "ClassGroup: Healer", true)
    args.args.healer.order = 120

    args.args.ranged = self:CreateUnitStatusOption(self.db.profile.ranged, "ClassGroup: Ranged", "ClassGroup: Ranged", true)
    args.args.ranged.order = 130

    args.args.melee = self:CreateUnitStatusOption(self.db.profile.melee, "ClassGroup: Melee", "ClassGroup: Melee", true)
    args.args.melee.order = 140

    args.args.dps = self:CreateUnitStatusOption(self.db.profile.dps, "ClassGroup: DPS", "ClassGroup: DPS", true)
    args.args.dps.order = 150

    return args
end

