-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local uabStatus_MissingBuffs = uabUnitStatus:NewModule("Missing Buffs")

uabStatus_MissingBuffs.userdefined = {}
uabStatus_MissingBuffs.mixins = {}
uabStatus_MissingBuffs.mixins.aura = AceLibrary("SpecialEvents-Aura-2.0")
uabStatus_MissingBuffs.defaultDB = {
    disabled = nil,
    intellect = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = nil,
            shaman = true,
            warlock = true,
            warrior = nil,
        },
	},
    fort = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = true,
            shaman = true,
            warlock = true,
            warrior = true,
        },
	},
    shadowprot = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = true,
            shaman = true,
            warlock = true,
            warrior = true,
        },
	},
    spirit = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = nil,
            shaman = true,
            warlock = true,
            warrior = nil,
        },
	},
    mark = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = true,
            shaman = true,
            warlock = true,
            warrior = true,
        },
	},
    
    userdefined = {
    },
}

uabStatus_MissingBuffs.constants = {
    strings = {
        bintellect = "Missing: Arcane Intellect",
        bfort = "Missing: Fortitude",
        bshadowprot = "Missing: Shadow Protection",
        bspirit = "Missing: Divine Spirit",
        bmark = "Missing: Mark of the Wild",
    
        intellect1 = "Arcane Intellect",
        intellect2 = "Arcane Brilliance",
        fort1 = "Power Word: Fortitude",
        fort2 = "Prayer of Fortitude",
        shadowprot = "Shadow Protection",
        spirit1 = "Divine Spirit",
        spirit2 = "Prayer of Spirit",
        mark1 = "Mark of the Wild",
        mark2 = "Gift of the Wild",
    },

    statusinfo = {
        ["Missing: Arcane Intellect"] = { dbsection = "intellect", foundbuff = "Buff: Arcane Intellect", mainbuff = "Arcane Brilliance", altbuff = "Arcane Intellect" },
        ["Missing: Fortitude"] = { dbsection = "fort", foundbuff = "Buff: Fortitude", mainbuff = "Prayer of Fortitude", altbuff = "Power Word: Fortitude" },
        ["Missing: Shadow Protection"] = { dbsection = "shadowprot", foundbuff = "Buff: Shadow Protection", mainbuff = "Shadow Protection", altbuff = nil },
        ["Missing: Divine Spirit"] = { dbsection = "spirit", foundbuff = "Buff: Divine Spirit", mainbuff = "Prayer of Spirit", altbuff = "Divine Spirit" },
        ["Missing: Mark of the Wild"] = { dbsection = "mark", foundbuff = "Buff: Mark of the Wild", mainbuff = "Mark of the Wild", altbuff = "Gift of the Wild" },
    },

    buffinfo = {
        ["Arcane Intellect"] = { dbsection = "intellect", foundbuff = "Missing: Arcane Intellect", altbuff = "Arcane Brilliance" },
        ["Arcane Brilliance"] = { dbsection = "intellect", foundbuff = "Missing: Arcane Intellect", altbuff = "Arcane Intellect" },
        ["Power Word: Fortitude"] = { dbsection = "fort", foundbuff = "Missing: Fortitude", altbuff = "Prayer of Fortitude" },
        ["Prayer of Fortitude"] = { dbsection = "fort", foundbuff = "Missing: Fortitude", altbuff = "Power Word: Fortitude" },
        ["Shadow Protection"] = { dbsection = "shadowprot", foundbuff = "Missing: Shadow Protection", altbuff = nil },
        ["Divine Spirit"] = { dbsection = "spirit", foundbuff = "Missing: Divine Spirit", altbuff = "Prayer of Spirit" },
        ["Prayer of Spirit"] = { dbsection = "spirit", foundbuff = "Missing: Divine Spirit", altbuff = "Divine Spirit" },
        ["Mark of the Wild"] = { dbsection = "mark", foundbuff = "Missing: Mark of the Wild", altbuff = "Gift of the Wild" },
        ["Gift of the Wild"] = { dbsection = "mark", foundbuff = "Missing: Mark of the Wild", altbuff = "Mark of the Wild" },
    }
}

function uabStatus_MissingBuffs:OnInitialize()
    self.super.OnInitialize(self)

    if not self.db.profile.disabled then
        self:EnableAllStatus()
    end
end

function uabStatus_MissingBuffs:EnableAllStatus()
	if not self.db.profile.intellect.disabled then
        self:RegisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bintellect, self.db.profile.intellect, true)
    end
    
	if not self.db.profile.fort.disabled then
        self:RegisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bfort, self.db.profile.fort, true)
    end
    
	if not self.db.profile.shadowprot.disabled then
        self:RegisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bshadowprot, self.db.profile.shadowprot, true)
    end
    
	if not self.db.profile.spirit.disabled then
        self:RegisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bspirit, self.db.profile.spirit, true)
    end
    
	if not self.db.profile.mark.disabled then
        self:RegisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bmark, self.db.profile.mark, true)
    end

    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
    	if not settings.disabled then
            self:RegisterUnitStatus("Missing Buffs", name, settings, true)
        end
    end
end

function uabStatus_MissingBuffs:EnableUnitStatus(name, displayname)
    if not self.db.profile.disabled then
    	if displayname == uabStatus_MissingBuffs.constants.strings.bintellect then
        	self:RegisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bintellect, self.db.profile.intellect, true)
        elseif displayname == uabStatus_MissingBuffs.constants.strings.bfort then
        	self:RegisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bfort, self.db.profile.fort, true)
    	elseif displayname == uabStatus_MissingBuffs.constants.strings.bshadowprot then
        	self:RegisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bshadowprot, self.db.profile.shadowprot, true)
    	elseif displayname == uabStatus_MissingBuffs.constants.strings.bspirit then
        	self:RegisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bspirit, self.db.profile.spirit, true)
    	elseif displayname == uabStatus_MissingBuffs.constants.strings.bmark then
        	self:RegisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bmark, self.db.profile.mark, true)
        else
            for buffname, settings in pairs(self.db.profile.userdefined) do
                if buffname == name then
                    self:RegisterUnitStatus("Missing Buffs", name, settings, true)
                end
            end
        end
    end
end

function uabStatus_MissingBuffs:DisableAllStatus()
	self:UnregisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bintellect)
	self:UnregisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bfort)
	self:UnregisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bshadowprot)
	self:UnregisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bspirit)
	self:UnregisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bmark)

    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
        self:UnregisterUnitStatus("Missing Buffs", name)
    end
end

function uabStatus_MissingBuffs:DisableUnitStatus(name, displayname)
    if not self.db.profile.disabled then
    	if displayname == uabStatus_MissingBuffs.constants.strings.bintellect then
        	self:UnregisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bintellect)
        elseif displayname == uabStatus_MissingBuffs.constants.strings.bfort then
        	self:UnregisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bfort)
    	elseif displayname == uabStatus_MissingBuffs.constants.strings.bshadowprot then
        	self:UnregisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bshadowprot)
    	elseif displayname == uabStatus_MissingBuffs.constants.strings.bspirit then
        	self:UnregisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bspirit)
    	elseif displayname == uabStatus_MissingBuffs.constants.strings.bmark then
        	self:UnregisterUnitStatus("Missing Buffs", uabStatus_MissingBuffs.constants.strings.bmark)
        else
            for buffname, settings in pairs(self.db.profile.userdefined) do
                if buffname == name then
                    self:UnregisterUnitStatus("Missing Buffs", name)
                end
            end
        end
    end
end

function uabStatus_MissingBuffs:SetEffectUse(name)
    if not self.registered then
--        self:RegisterEvent("SpecialEvents_UnitBuffGained", "UnitBuffGained")
--        self:RegisterEvent("SpecialEvents_UnitBuffChanged", "UnitBuffGained")
--        self:RegisterEvent("SpecialEvents_UnitBuffRefreshed", "UnitBuffGained")
--        self:RegisterEvent("SpecialEvents_UnitBuffLost", "UnitBuffLost")
        self.registered = true
    end
end

function uabStatus_MissingBuffs:ClearEffectUse(name)
    if self.registered then
--        self:UnregisterEvent("SpecialEvents_UnitBuffGained")
--        self:UnregisterEvent("SpecialEvents_UnitBuffChanged")
--        self:UnregisterEvent("SpecialEvents_UnitBuffRefreshed")
--        self:UnregisterEvent("SpecialEvents_UnitBuffLost")
        self.registered = nil
    end
end

function uabStatus_MissingBuffs:UnitBuffGained(unit, buffName, index, applications, texture, rank)
    local class = self:GetUnitClass(unit)
    local found
    local hasbuff
    
    if self.db.profile.disabled then return end

    local buffinfo = uabStatus_MissingBuffs.constants.buffinfo[buffName]
    if buffinfo then
        if not self.db.profile[buffinfo.dbsection].disabled then
            foundbuff = true
            hasbuff = buffinfo.foundbuff
        end
    end

    if not found then
        -- dynamically added buffs
        for dynname, settings in pairs(self.db.profile.userdefined) do
            if buffName == settings.name and not settings.disabled then
                found = true
                hasbuff = dynname
                break
            end
        end
    end

    if hasbuff then
        self:UnitStatusLost(hasbuff, unit)
    end
end

function uabStatus_MissingBuffs:UnitBuffLost(unit, buffName, applications, texture, rank)
    local class = self:GetUnitClass(unit)
    local found
    local hasbuff
    
    if self.db.profile.disabled then return end

    local buffinfo = uabStatus_MissingBuffs.constants.buffinfo[buffName]
    if buffinfo then
        if not self.db.profile[buffinfo.dbsection].disabled then
            foundbuff = true
            if not class or self.db.profile[buffinfo.dbsection].classfilter[class] then
                hasbuff = buffinfo.foundbuff
            end
        end
    end

    if not hasbuff then
        -- dynamically added buffs
        for dynname, settings in pairs(self.db.profile.userdefined) do
            if buffName == settings.name and not settings.disabled then
                found = true
                if not class or settings.classfilter[class] then
                    hasbuff = dynname
                end
                break
            end
        end
    end

    if hasbuff then
        self:UnitStatusGained(hasbuff, unit)
    end
end

function uabStatus_MissingBuffs:OnEnable()
end

function uabStatus_MissingBuffs:OnDisable()
end

function uabStatus_MissingBuffs:IsStatusGained(name, unit, action)
    if self.db.profile.disabled then return end
    
    local class = self:GetUnitClass(unit)
    local hasbuff
    
    local info = uabStatus_MissingBuffs.constants.statusinfo[name]
    if info then
        if not self.db.profile[info.dbsection].disabled then
            if not class or self.db.profile[info.dbsection].classfilter[class] then
    		    hasbuff = self.mixins.aura:UnitHasBuff(unit, info.mainbuff) or self.mixins.aura:UnitHasBuff(unit, info.altbuff)
            end
        end
    end

    if not hasbuff then
        for dynname, settings in pairs(self.db.profile.userdefined) do
            if name == dynname and not settings.disabled then
                if not class or settings.classfilter[class] then
                    hasbuff = self.mixins.aura:UnitHasBuff(unit, settings.name)
                end
                break
            end
        end
    end
    
    return not hasbuff
end

local lastorder

function uabStatus_MissingBuffs:RemoveUserDefined(buffname)
    local args = self.core.core.options.args.unitstatus.args[self.name]

    args.args[buffname] = nil
    args.args.remove.args[buffname] = nil
    self.db.profile.userdefined[buffname] = nil
    self:UnregisterUnitStatus("Missing Buffs", buffname)

    lastorder = 50
    
    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
        if not settings.name then
            settings.name = name
        end

        args.args[name].order = lastorder + 10
        lastorder = args.args[name].order
    end
    
    self:SetUserDefinedBuffList()
end

function uabStatus_MissingBuffs:SetUserDefinedBuffList()
    for pos, _ in pairs(self.userdefined) do
        self.userdefined[pos] = nil
    end

    local pos = 1
    
    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
        self.userdefined[pos] = name
        pos = pos + 1
    end
end

function uabStatus_MissingBuffs:CreateUnitStatusOptions()
    local args = {}

    args = {
        type = 'group',
        name = "Missing Buffs",
        desc = "Configure the options for Missing Buffs unit status values",
        args = {
            enabled = {
                type = 'toggle',
                name = "Enabled",
                desc = "When checked, enable the use of the Missing Buffs unit status values",
                order = 1,
                get = function()
                    return not self.db.profile.disabled
                end,
                set = function(v)
                    self.db.profile.disabled = not v
                    if self.db.profile.disabled then
                        self:DisableAllStatus()
                    else
                        self:EnableAllStatus()
                    end

                    self.core.core.main:FrameGroupsChanged()
                end,
            },

            addnew = {
                name = "Add New",
                type = 'text',
                desc = "Create a new missing buff",
                usage = "<name>",
                order = 30,
                get = function() return end,
                set = function(newname)
                    self.db.profile.userdefined["Missing: "..newname] = {
                        name = newname,
                        disabled = nil,
                        priority = 50,
                        color = { r = 0, g = 0, b = 1, a = 1, },
                        classfilter = {
                            druid = true,
                            hunter = true,
                            mage = true,
                            paladin = true,
                            priest = true,
                            rogue = true,
                            shaman = true,
                            warlock = true,
                            warrior = true,
                        },
                    }

                    self:RegisterUnitStatus("Missing Buffs", "Missing: "..newname, self.db.profile.userdefined["Missing: "..newname], true)

                    local args = self.core.core.options.args.unitstatus.args[self.name]
                                    
                    args.args["Missing: "..newname] = self:CreateUnitStatusOption(self.db.profile.userdefined["Missing: "..newname], "Missing: "..newname, "Missing: "..newname, true)
                    args.args["Missing: "..newname].order = lastorder + 10
                    lastorder = args.args["Missing: "..newname].order

                    args.args.remove.args["Missing: "..newname] = {
                        type = 'execute',
                        name = "Buff: "..newname,
                        desc = "Remove the ".."Missing: "..newname.." buff",
                        func = function()
                            self:RemoveUserDefined("Missing: "..newname)
                        end,
                    }
    
                    self:SetUserDefinedBuffList()
                end,
                validate = function(newname)
                    for name, settings in pairs(self.db.profile.userdefined) do
                        if name == "Missing: "..newname then
                            return false
                        end
                    end
                    
                    return true
                end,
                order = 2,
            },

            remove = {
                type = 'group',
                name = "Remove",
                desc = "Remove a buff",
                order = 3,
                args = {
                },
            },

            spacing3 = {
                name = " ",
                type = 'header',
                order = 5,
            },

        },
    }

    args.args.intellect = self:CreateUnitStatusOption(self.db.profile.intellect, uabStatus_MissingBuffs.constants.strings.bintellect, uabStatus_MissingBuffs.constants.strings.bintellect, true)
    args.args.intellect.order = 10

    args.args.fort = self:CreateUnitStatusOption(self.db.profile.fort, uabStatus_MissingBuffs.constants.strings.bfort, uabStatus_MissingBuffs.constants.strings.bfort, true)
    args.args.fort.order = 20

    args.args.spirit = self:CreateUnitStatusOption(self.db.profile.spirit, uabStatus_MissingBuffs.constants.strings.bspirit, uabStatus_MissingBuffs.constants.strings.bspirit, true)
    args.args.spirit.order = 30

    args.args.shadowprot = self:CreateUnitStatusOption(self.db.profile.shadowprot, uabStatus_MissingBuffs.constants.strings.bshadowprot, uabStatus_MissingBuffs.constants.strings.bshadowprot, true)
    args.args.shadowprot.order = 40

    args.args.mark = self:CreateUnitStatusOption(self.db.profile.mark, uabStatus_MissingBuffs.constants.strings.bmark, uabStatus_MissingBuffs.constants.strings.bmark, true)
    args.args.mark.order = 50

    lastorder = 50
    
    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
        if not settings.name then
            settings.name = name
        end
        
        args.args[name] = self:CreateUnitStatusOption(settings, name, name, true)
        args.args[name].order = lastorder + 10
        lastorder = args.args[name].order
    end
    
    for name, settings in pairs(self.db.profile.userdefined) do
        args.args.remove.args[name] = {
            type = 'execute',
            name = name,
            desc = "Remove the "..settings.name.." missing buff",
            order = 100,
            func = function()
                self:RemoveUserDefined(name)
            end,
        }
    end

    self:SetUserDefinedBuffList()

    return args
end

