-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local uabStatus_Debuffs = uabUnitStatus:NewModule("Main Debuffs")

uabStatus_Debuffs.userdefined = {}
uabStatus_Debuffs.mixins = {}
uabStatus_Debuffs.mixins.aura = AceLibrary("SpecialEvents-Aura-2.0")

uabStatus_Debuffs.defaultDB = {
    disabled = nil,
    weaksoul = {
        disabled = nil,
        priority = 50,
        color = { r = 0.75, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = true,
            shaman = true,
            warlock = true,
            warrior = true,
        },
    },
    curse = {
        disabled = nil,
        priority = 50,
        color = { r = 0.75, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = true,
            shaman = true,
            warlock = true,
            warrior = true,
        },
	},
    disease = {
        disabled = nil,
        priority = 50,
        color = { r = 1,    g = 0.75, b = 0, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = true,
            shaman = true,
            warlock = true,
            warrior = true,
        },
	},
    magic = {
        disabled = nil,
        priority = 50,
        color = { r = 0,    g = 0.25, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = true,
            shaman = true,
            warlock = true,
            warrior = true,
        },
	},
    poison = {
        disabled = nil,
        priority = 50,
        color = { r = 0,    g = 1,    b = 0, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = true,
            shaman = true,
            warlock = true,
            warrior = true,
        },
	},
    
    userdefined = {
    },
}

uabStatus_Debuffs.constants = {
    strings = {
        dweaksoul = "Debuff: Weakened Soul",
        dcurse = "Debuff: Curse",
        ddisease = "Debuff: Disease",
        dmagic = "Debuff: Magic",
        dpoison = "Debuff: Poison",
        
        weaksoul = "Weakened Soul",
        curse = "Curse",
        disease = "Disease",
        magic = "Magic",
        poison = "Poison",
    },

    statusinfo = {
        ["Debuff: Weakened Soul"] = { dbsection = "weaksoul", buffname = "Debuff: Weakened Soul" },
        ["Debuff: Curse"] = { dbsection = "curse", bufftype = "Curse" },
        ["Debuff: Disease"] = { dbsection = "disease", bufftype = "Disease" },
        ["Debuff: Magic"] = { dbsection = "magic", bufftype = "Magic" },
        ["Debuff: Poison"] = { dbsection = "poison", bufftype = "Poison" },
    },
    
    buffs = {
        ["Weakened Soul"] = { dbsection = "weaksoul", name = true, foundbuff = "Debuff: Weakened Soul" },
        ["Curse"] = { dbsection = "curse", type = true, foundbuff = "Debuff: Curse" },
        ["Disease"] = { dbsection = "disease", type = true, foundbuff = "Debuff: Disease" },
        ["Magic"] = { dbsection = "magic", type = true, foundbuff = "Debuff: Magic" },
        ["Poison"] = { dbsection = "poison", type = true, foundbuff = "Debuff: Poison" },
    }
}

function uabStatus_Debuffs:OnInitialize()
    self.super.OnInitialize(self)

    if not self.db.profile.disabled then
        self:EnableAllStatus()
    end
end

function uabStatus_Debuffs:EnableAllStatus()
	if not self.db.profile.curse.disabled then
        self:RegisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dcurse, self.db.profile.curse, true)
    end
	
    if not self.db.profile.disease.disabled then
	    self:RegisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.ddisease, self.db.profile.disease, true)
    end
	
    if not self.db.profile.magic.disabled then
	    self:RegisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dmagic, self.db.profile.magic, true)
    end
	
    if not self.db.profile.poison.disabled then
	    self:RegisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dpoison, self.db.profile.poison, true)
    end
	
    if not self.db.profile.weaksoul.disabled then
    	self:RegisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dweaksoul, self.db.profile.weaksoul, true)
    end
    
    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
        if not settings.disabled then
            self:RegisterUnitStatus("Debuffs", name, settings, true)
        end
    end
end

function uabStatus_Debuffs:EnableUnitStatus(name, displayname)
    if not self.db.profile.disabled then
        if displayname == uabStatus_Debuffs.constants.strings.dcurse then
            self:RegisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dcurse, self.db.profile.curse, true)
        elseif displayname == uabStatus_Debuffs.constants.strings.ddisease then
        	self:RegisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.ddisease, self.db.profile.disease, true)
    	elseif displayname == uabStatus_Debuffs.constants.strings.dmagic then
        	self:RegisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dmagic, self.db.profile.magic, true)
    	elseif displayname == uabStatus_Debuffs.constants.strings.dpoison then
        	self:RegisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dpoison, self.db.profile.poison, true)
    	elseif displayname == uabStatus_Debuffs.constants.strings.dweaksoul then
        	self:RegisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dweaksoul, self.db.profile.weaksoul, true)
        else
            -- dynamically added buffs
            for debuffname, settings in pairs(self.db.profile.userdefined) do
                if name == debuffname then
                    self:RegisterUnitStatus("Debuffs", name, settings, true)
                end
            end
        end
    end
end

function uabStatus_Debuffs:DisableAllStatus()
    self:UnregisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dcurse)
	self:UnregisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.ddisease)
	self:UnregisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dmagic)
	self:UnregisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dpoison)
	self:UnregisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dweaksoul)
    
    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
        self:UnregisterUnitStatus("Debuffs", name)
    end
end

function uabStatus_Debuffs:DisableUnitStatus(name, displayname)
    if not self.db.profile.disabled then
        if displayname == uabStatus_Debuffs.constants.strings.dcurse then
            self:UnregisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dcurse)
        elseif displayname == uabStatus_Debuffs.constants.strings.ddisease then
        	self:UnregisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.ddisease)
    	elseif displayname == uabStatus_Debuffs.constants.strings.dmagic then
        	self:UnregisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dmagic)
    	elseif displayname == uabStatus_Debuffs.constants.strings.dpoison then
        	self:UnregisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dpoison)
    	elseif displayname == uabStatus_Debuffs.constants.strings.dweaksoul then
        	self:UnregisterUnitStatus("Debuffs", uabStatus_Debuffs.constants.strings.dweaksoul)
        else
            -- dynamically added buffs
            for debuffname, settings in pairs(self.db.profile.userdefined) do
                if name == debuffname then
                    self:UnregisterUnitStatus("Debuffs", name)
                end
            end
        end
    end
end

function uabStatus_Debuffs:SetEffectUse(name)
    if not self.registered then
        self.registered = true
--        self:RegisterEvent("SpecialEvents_UnitDebuffGained", "UnitDebuffGained")
--        self:RegisterEvent("SpecialEvents_UnitDebuffCountChanged", "UnitDebuffGained")
--        self:RegisterEvent("SpecialEvents_UnitDebuffRefreshed", "UnitDebuffGained")
--        self:RegisterEvent("SpecialEvents_UnitDebuffLost", "UnitDebuffLost")
    end
end

function uabStatus_Debuffs:ClearEffectUse(name)
    if self.registered then
--        self:UnregisterEvent("SpecialEvents_UnitDebuffGained")
--        self:UnregisterEvent("SpecialEvents_UnitDebuffCountChanged")
--        self:UnregisterEvent("SpecialEvents_UnitDebuffRefreshed")
--        self:UnregisterEvent("SpecialEvents_UnitDebuffLost")
        self.registered = nil
    end
end

function uabStatus_Debuffs:UnitDebuffGained(unit, debuffName, applications, debuffType, texture, rank, index, duration, timeLeft, debuffIndex)
    local class = self:GetUnitClass(unit)
    local found
    local has, debufftype
    local searchtype, searchname
    local enabled = 0

    if self.db.profile.disabled then return end

    local buffdata = uabStatus_Debuffs.constants.buffs[debuffName]
    if buffdata then
        if not self.db.profile[buffdata.dbsection].disabled then
            found = buffdata.foundbuff
            if not class or self.db.profile[buffdata.dbsection].classfilter[class] then
                searchname = debuffName
            end
        end
    else
        buffdata = uabStatus_Debuffs.constants.buffs[debuffType]
        if buffdata then
            if not self.db.profile[buffdata.dbsection].disabled then
                found = buffdata.foundbuff
                if not class or self.db.profile[buffdata.dbsection].classfilter[class] then
                    searchtype = debuffType
                end
            end
        end
    end

    -- Dynamically added de-buffs.
    -- These take precedence over the default "type" ones, since these are by name
    --  and therefore are more specific than the "type" ones.
    if not searchname then
        for dynname, settings in pairs(self.db.profile.userdefined) do
            if debuffName == settings.name and not settings.disabled then
                -- We found a match. If there has not been a previous match, then
                --  identify this one as the match. Otherwise, keep the previous
                --  match unless this one is not filtered.
                if not found then
                    found = dynname
                end

                if not class or settings.classfilter[class] then
                    -- Not filtered, so we are using this one.  Make sure we do not
                    -- search by type.
                    found = dynname
                    searchtype = nil
                    searchname = settings.name
                end

                break
            end
        end
    end
    
    if searchtype or searchname then
        local name, i

        -- get the duration of the debuff
        i = 1
        while (UnitDebuff(unit, i) ~= nil) do
            name, _, _, _, debufftype, duration, timeleft = UnitDebuff(unit, i)
            if (searchtype and debufftype == searchtype) or (searchname and name == searchname) then
                enabled = 1
                break
            end
            i = i + 1
        end

        local start = 0
        
        if enabled and enabled > 0 and duration and duration > 0 and timeleft and timeleft > 0 then
            start = (GetTime() + timeleft) - duration
        end

        self:UnitStatusGained(found, unit, enabled, start, duration)
    elseif found then
        self:UnitStatusLost(found, unit)
    end
end

function uabStatus_Debuffs:UnitDebuffLost(unit, debuffName, applications, debuffType, texture, rank, duration, debuffIndex)
    local class = self:GetUnitClass(unit)
    local found
    local hasbuff
    local searchtype, searchname

    if self.db.profile.disabled then return end

    local buffdata = uabStatus_Debuffs.constants.buffs[debuffName]
    if buffdata then
        if not self.db.profile[buffdata.dbsection].disabled then
            found = true
            hasbuff = buffdata.foundbuff
            searchname = debuffName
        end
    else
        buffdata = uabStatus_Debuffs.constants.buffs[debuffType]
        if buffdata then
            if not self.db.profile[buffdata.dbsection].disabled then
                found = true
                searchtype = debuffType
                hasbuff = buffdata.foundbuff
            end
        end
    end

    if not searchname then
        -- dynamically added buffs.  These take precedence since they are by name, and
        -- therefore more specific than by type.
        for dynname, settings in pairs(self.db.profile.userdefined) do
            if debuffName == settings.name and not settings.disabled then
                found = true
                hasbuff = dynname
                searchtype = nil
                searchname = hasbuff
                break
            end
        end
    end
    
    if hasbuff then
        self:UnitStatusLost(hasbuff, unit)
    end
end

function uabStatus_Debuffs:OnEnable()
end

function uabStatus_Debuffs:OnDisable()
end

function uabStatus_Debuffs:IsStatusGained(name, unit, action)
    if self.db.profile.disabled then return end

    local class = self:GetUnitClass(unit)
    local has, debufftype
    local searchtype, searchname
    local enabled = 0
    local duration = 0
    local timeleft = 0

    local statusinfo = uabStatus_Debuffs.constants.statusinfo[name]
    if statusinfo then
        if not self.db.profile[statusinfo.dbsection].disabled then
            if not class or self.db.profile[statusinfo.dbsection].classfilter[class] then
                searchname = statusinfo.buffname
                searchtype = statusinfo.bufftype
            end
        end
    end

    if not searchname then
        for dynname, settings in pairs(self.db.profile.userdefined) do
            if name == dynname and not settings.disabled then
                if not class or settings.classfilter[class] then
                    searchname = settings.name
                    searchtype = nil
                end
                break
            end
        end
    end
    
    if searchtype or searchname then
        local name, i
        
        i = 1
        while true do
            name, _, _, _, debufftype, duration, timeleft = UnitDebuff(unit, i)
            if not name then
                break
            end
            
            if (searchtype and debufftype == searchtype) or name == searchname then
                has = 1
                enabled = duration and timeleft and 1
                break
            end
            i = i + 1
        end
    
        local start = 0
        
        if enabled and enabled > 0 and duration and duration > 0 and timeleft and timeleft > 0 then
            start = (GetTime() + timeleft) - duration
        end
        
        return has, enabled, start, duration
    end
end

local lastorder

function uabStatus_Debuffs:RemoveUserDefined(buffname)
    local args = self.core.core.options.args.unitstatus.args[self.name]

    args.args[buffname] = nil
    args.args.remove.args[buffname] = nil
    self.db.profile.userdefined[buffname] = nil
    self:UnregisterUnitStatus("Debuffs", buffname)

    lastorder = 50
    
    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
        if not settings.name then
            settings.name = name
        end

        args.args[name].order = lastorder + 10
        lastorder = args.args[name].order
    end
    
    self:SetUserDefinedDebuffList()
end

function uabStatus_Debuffs:SetUserDefinedDebuffList()
    for pos, _ in pairs(self.userdefined) do
        self.userdefined[pos] = nil
    end

    local pos = 1
    
    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
        self.userdefined[pos] = name
        pos = pos + 1
    end
end

function uabStatus_Debuffs:CreateUnitStatusOptions()
    local args = {}

    args = {
        type = 'group',
        name = "Debuff",
        desc = "Configure the options for debuff unit status values",
        args = {
            enabled = {
                type = 'toggle',
                name = "Enabled",
                desc = "When checked, enable the use of the debuff unit status values",
                order = 1,
                get = function()
                    return not self.db.profile.disabled
                end,
                set = function(v)
                    self.db.profile.disabled = not v
                    if self.db.profile.disabled then
                        self:DisableAllStatus()
                    else
                        self:EnableAllStatus()
                    end

                    self.core.core.main:FrameGroupsChanged()
                end,
            },

            addnew = {
                name = "Add New",
                type = 'text',
                desc = "Create a new debuff",
                usage = "<name>",
                order = 30,
                get = function() return end,
                set = function(newname)
                    self.db.profile.userdefined["Debuff: "..newname] = {
                        name = newname,
                        disabled = nil,
                        priority = 50,
                        color = { r = 0, g = 0, b = 1, a = 1, },
                        classfilter = {
                            druid = true,
                            hunter = true,
                            mage = true,
                            paladin = true,
                            priest = true,
                            rogue = true,
                            shaman = true,
                            warlock = true,
                            warrior = true,
                        },
                    }

                    self:RegisterUnitStatus("Debuffs", newname, self.db.profile.userdefined["Debuff: "..newname], true)

                    local args = self.core.core.options.args.unitstatus.args[self.name]
                                    
                    args.args["Debuff: "..newname] = self:CreateUnitStatusOption(self.db.profile.userdefined["Debuff: "..newname], "Debuff: "..newname, "Debuff: "..newname, true)
                    args.args["Debuff: "..newname].order = lastorder + 10
                    lastorder = args.args["Debuff: "..newname].order

                    args.args.remove.args["Debuff: "..newname] = {
                        type = 'execute',
                        name = "Debuff: "..newname,
                        desc = "Remove the ".."Debuff: "..newname.." debuff",
                        func = function()
                            self:RemoveUserDefined("Debuff: "..newname)
                        end,
                    }
    
                    self:SetUserDefinedDebuffList()
                end,
                validate = function(newname)
                    for name, settings in pairs(self.db.profile.userdefined) do
                        if name == "Debuff: "..newname then
                            return false
                        end
                    end
                    
                    return true
                end,
                order = 2,
            },

            remove = {
                type = 'group',
                name = "Remove",
                desc = "Remove a debuff",
                order = 3,
                args = {
                },
            },

            spacing3 = {
                name = " ",
                type = 'header',
                order = 5,
            },

        },
    }

    args.args["weaksoul"] = self:CreateUnitStatusOption(self.db.profile.weaksoul, uabStatus_Debuffs.constants.strings.dweaksoul, uabStatus_Debuffs.constants.strings.dweaksoul, true)
    args.args["weaksoul"].order = 5

    args.args["curse"] = self:CreateUnitStatusOption(self.db.profile.curse, uabStatus_Debuffs.constants.strings.dcurse, uabStatus_Debuffs.constants.strings.dcurse, true)
    args.args["curse"].order = 10

    args.args["disease"] = self:CreateUnitStatusOption(self.db.profile.disease, uabStatus_Debuffs.constants.strings.ddisease, uabStatus_Debuffs.constants.strings.ddisease, true)
    args.args["disease"].order = 20

    args.args["magic"] = self:CreateUnitStatusOption(self.db.profile.magic, uabStatus_Debuffs.constants.strings.dmagic, uabStatus_Debuffs.constants.strings.dmagic, true)
    args.args["magic"].order = 30

    args.args["poison"] = self:CreateUnitStatusOption(self.db.profile.poison, uabStatus_Debuffs.constants.strings.dpoison, uabStatus_Debuffs.constants.strings.dpoison, true)
    args.args["poison"].order = 40

    lastorder = 50
    
    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
        if not settings.name then
            settings.name = name
        end
        
        args.args[name] = self:CreateUnitStatusOption(settings, name, name, true)
        args.args[name].order = lastorder + 10
        lastorder = args.args[name].order
    end
    
    for name, settings in pairs(self.db.profile.userdefined) do
        args.args.remove.args[name] = {
            type = 'execute',
            name = name,
            desc = "Remove the "..settings.name.." debuff",
            order = 100,
            func = function()
                self:RemoveUserDefined(name)
            end,
        }
    end

    self:SetUserDefinedDebuffList()
    
    return args
end
