-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local uabStatus_MainBuffs = uabUnitStatus:NewModule("Main Buffs")

uabStatus_MainBuffs.userdefined = {}
uabStatus_MainBuffs.mixins = {}
uabStatus_MainBuffs.mixins.aura = AceLibrary("SpecialEvents-Aura-2.0")
uabStatus_MainBuffs.defaultDB = {
    disabled = nil,
    intellect = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = nil,
            shaman = true,
            warlock = true,
            warrior = nil,
        },
	},
    fort = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = true,
            shaman = true,
            warlock = true,
            warrior = true,
        },
	},
    shadowprot = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = true,
            shaman = true,
            warlock = true,
            warrior = true,
        },
	},
    spirit = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = nil,
            shaman = true,
            warlock = true,
            warrior = nil,
        },
	},
    mark = {
        disabled = nil,
        priority = 50,
        color = { r = 0, g = 0, b = 1, a = 1, },
        classfilter = {
            druid = true,
            hunter = true,
            mage = true,
            paladin = true,
            priest = true,
            rogue = true,
            shaman = true,
            warlock = true,
            warrior = true,
        },
	},
    
    userdefined = {
    },
}

uabStatus_MainBuffs.constants = {
    strings = {
        bintellect = "Buff: Arcane Intellect",
        bfort = "Buff: Fortitude",
        bshadowprot = "Buff: Shadow Protection",
        bspirit = "Buff: Divine Spirit",
        bmark = "Buff: Mark of the Wild",
    
        intellect1 = "Arcane Intellect",
        intellect2 = "Arcane Brilliance",
        fort1 = "Power Word: Fortitude",
        fort2 = "Prayer of Fortitude",
        shadowprot = "Shadow Protection",
        spirit1 = "Divine Spirit",
        spirit2 = "Prayer of Spirit",
        mark1 = "Mark of the Wild",
        mark2 = "Gift of the Wild",
    },

    statusinfo = {
        ["Buff: Arcane Intellect"] = { dbsection = "intellect", foundbuff = "Buff: Arcane Intellect", mainbuff = "Arcane Brilliance", altbuff = "Arcane Intellect" },
        ["Buff: Fortitude"] = { dbsection = "fort", foundbuff = "Buff: Fortitude", mainbuff = "Prayer of Fortitude", altbuff = "Power Word: Fortitude" },
        ["Buff: Shadow Protection"] = { dbsection = "shadowprot", foundbuff = "Buff: Shadow Protection", mainbuff = "Shadow Protection", altbuff = nil },
        ["Buff: Divine Spirit"] = { dbsection = "spirit", foundbuff = "Buff: Divine Spirit", mainbuff = "Prayer of Spirit", altbuff = "Divine Spirit" },
        ["Buff: Mark of the Wild"] = { dbsection = "mark", foundbuff = "Buff: Mark of the Wild", mainbuff = "Mark of the Wild", altbuff = "Gift of the Wild" },
    },

    buffinfo = {
        ["Arcane Intellect"] = { dbsection = "intellect", foundbuff = "Buff: Arcane Intellect", altbuff = "Arcane Brilliance" },
        ["Arcane Brilliance"] = { dbsection = "intellect", foundbuff = "Buff: Arcane Intellect", altbuff = "Arcane Intellect" },
        ["Power Word: Fortitude"] = { dbsection = "fort", foundbuff = "Buff: Fortitude", altbuff = "Prayer of Fortitude" },
        ["Prayer of Fortitude"] = { dbsection = "fort", foundbuff = "Buff: Fortitude", altbuff = "Power Word: Fortitude" },
        ["Shadow Protection"] = { dbsection = "shadowprot", foundbuff = "Buff: Shadow Protection", altbuff = nil },
        ["Divine Spirit"] = { dbsection = "spirit", foundbuff = "Buff: Divine Spirit", altbuff = "Prayer of Spirit" },
        ["Prayer of Spirit"] = { dbsection = "spirit", foundbuff = "Buff: Divine Spirit", altbuff = "Divine Spirit" },
        ["Mark of the Wild"] = { dbsection = "mark", foundbuff = "Buff: Mark of the Wild", altbuff = "Gift of the Wild" },
        ["Gift of the Wild"] = { dbsection = "mark", foundbuff = "Buff: Mark of the Wild", altbuff = "Mark of the Wild" },
    }
}

function uabStatus_MainBuffs:OnInitialize()
    self.super.OnInitialize(self)

    if not self.db.profile.disabled then
        self:EnableAllStatus()
    end
end

function uabStatus_MainBuffs:EnableAllStatus()
	if not self.db.profile.intellect.disabled then
        self:RegisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bintellect, self.db.profile.intellect, true)
    end

	if not self.db.profile.fort.disabled then
        self:RegisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bfort, self.db.profile.fort, true)
    end

	if not self.db.profile.shadowprot.disabled then
        self:RegisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bshadowprot, self.db.profile.shadowprot, true)
    end

	if not self.db.profile.spirit.disabled then
        self:RegisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bspirit, self.db.profile.spirit, true)
    end

	if not self.db.profile.mark.disabled then
        self:RegisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bmark, self.db.profile.mark, true)
    end

    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
    	if not settings.disabled then
            self:RegisterUnitStatus("Buffs", name, settings, true)
        end
    end
end

function uabStatus_MainBuffs:EnableUnitStatus(name, displayname)
    if not self.db.profile.disabled then
    	if displayname == uabStatus_MainBuffs.constants.strings.bintellect then
            self:RegisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bintellect, self.db.profile.intellect, true)
        elseif displayname == uabStatus_MainBuffs.constants.strings.bfort then
        	self:RegisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bfort, self.db.profile.fort, true)
    	elseif displayname == uabStatus_MainBuffs.constants.strings.bshadowprot then
        	self:RegisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bshadowprot, self.db.profile.shadowprot, true)
    	elseif displayname == uabStatus_MainBuffs.constants.strings.bspirit then
        	self:RegisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bspirit, self.db.profile.spirit, true)
    	elseif displayname == uabStatus_MainBuffs.constants.strings.bmark then
        	self:RegisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bmark, self.db.profile.mark, true)
        else
            for buffname, settings in pairs(self.db.profile.userdefined) do
                if buffname == name then
                    self:RegisterUnitStatus("Buffs", name, settings, true)
                end
            end
        end
    end
end

function uabStatus_MainBuffs:DisableAllStatus()
	self:UnregisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bintellect)
	self:UnregisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bfort)
	self:UnregisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bshadowprot)
	self:UnregisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bspirit)
	self:UnregisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bmark)
    
    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
        self:UnregisterUnitStatus("Buffs", name)
    end
end

function uabStatus_MainBuffs:DisableUnitStatus(name, displayname)
    if not self.db.profile.disabled then
    	if displayname == uabStatus_MainBuffs.constants.strings.bintellect then
            self:UnregisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bintellect)
        elseif displayname == uabStatus_MainBuffs.constants.strings.bfort then
        	self:UnregisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bfort)
    	elseif displayname == uabStatus_MainBuffs.constants.strings.bshadowprot then
        	self:UnregisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bshadowprot)
    	elseif displayname == uabStatus_MainBuffs.constants.strings.bspirit then
        	self:UnregisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bspirit)
    	elseif displayname == uabStatus_MainBuffs.constants.strings.bmark then
        	self:UnregisterUnitStatus("Buffs", uabStatus_MainBuffs.constants.strings.bmark)
        else
            for buffname, settings in pairs(self.db.profile.userdefined) do
                if buffname == name then
                    self:UnregisterUnitStatus("Buffs", name)
                end
            end
        end
    end
end

function uabStatus_MainBuffs:SetEffectUse(name)
    if not self.registered then
        self.registered = true
--        self:RegisterEvent("SpecialEvents_UnitBuffGained", "UnitBuffGained")
--        self:RegisterEvent("SpecialEvents_UnitBuffChanged", "UnitBuffGained")
--        self:RegisterEvent("SpecialEvents_UnitBuffRefreshed", "UnitBuffGained")
--        self:RegisterEvent("SpecialEvents_UnitBuffLost", "UnitBuffLost")
    end
end

function uabStatus_MainBuffs:ClearEffectUse(name)
    if self.registered then
--        self:UnregisterEvent("SpecialEvents_UnitBuffGained")
--        self:UnregisterEvent("SpecialEvents_UnitBuffChanged")
--        self:UnregisterEvent("SpecialEvents_UnitBuffRefreshed")
--        self:UnregisterEvent("SpecialEvents_UnitBuffLost")
        self.registered = nil
    end
end

function uabStatus_MainBuffs:UnitBuffGained(unit, buffName, index, applications, texture, rank, duration, timeleft)
    local class = self:GetUnitClass(unit)
    local foundbuff
    local hasbuff
    local name1, name2
    local enabled = 0

    if self.db.profile.disabled then return end

    local buffinfo = uabStatus_MainBuffs.constants.buffinfo[buffName]
    if buffinfo then
        if not self.db.profile[buffinfo.dbsection].disabled then
            foundbuff = buffinfo.foundbuff
            if not class or self.db.profile[buffinfo.dbsection].classfilter[class] then
                name1 = buffName
                name2 = buffinfo.altbuff
            end
        end
    end

    if not foundbuff then
        -- dynamically added buffs
        for dynname, settings in pairs(self.db.profile.userdefined) do
            if buffName == settings.name and not settings.disabled then
                foundbuff = dynname
                if not class or settings.classfilter[class] then
                    name1 = settings.name
                end
                break
            end
        end
    end

    if foundbuff and name1 then
        enabled = duration and timeleft and 1

        local start = 0

        self:Debug("Found buff "..foundbuff.." on "..unit.." (" ..UnitName(unit).. ") duration "..(duration or "nil").." timeleft "..(timeleft or "nil"))
        
        if enabled and enabled > 0 and duration and duration > 0 and timeleft and timeleft > 0 then
            start = (GetTime() + timeleft) - duration
        end

        if enabled then
            self:UnitStatusGained(foundbuff, unit, enabled, start, duration)
        else
            self:UnitStatusLost(foundbuff, unit)
        end
    elseif foundbuff then
        self:UnitStatusLost(foundbuff, unit)
    end
end

function uabStatus_MainBuffs:UnitBuffLost(unit, buffName, applications, texture, rank)
    local class = self:GetUnitClass(unit)
    local foundbuff
    local hasbuff
    
    if self.db.profile.disabled then return end

    local buffinfo = uabStatus_MainBuffs.constants.buffinfo[buffName]
    if buffinfo then
        if not self.db.profile[buffinfo.dbsection].disabled then
            foundbuff = true
            hasbuff = buffinfo.foundbuff
        end
    end

    if not foundbuff then
        -- dynamically added buffs
        for dynname, settings in pairs(self.db.profile.userdefined) do
            if buffName == settings.name and not settings.disabled then
                foundbuff = true
                hasbuff = dynname
                break
            end
        end
    end

    if hasbuff then
        local name = UnitName(unit)
        
        self:Debug("Lost buff "..hasbuff.." on "..(unit or "nil").." (" ..(name or "nil").. ")")
        
        self:UnitStatusLost(hasbuff, unit)
    end
end

function uabStatus_MainBuffs:OnEnable()
end

function uabStatus_MainBuffs:OnDisable()
end

function uabStatus_MainBuffs:IsStatusGained(name, unit, action)
    if self.db.profile.disabled then return end

    local class = self:GetUnitClass(unit)
    local foundbuff
    local hasbuff
    local name1, name2
    local enabled = 0
    local duration = 0
    local timeleft = 0

    self:Debug("IsStatusGained: "..name..", " ..UnitName(unit))

    local info = uabStatus_MainBuffs.constants.statusinfo[name]
    if info then
        if not self.db.profile[info.dbsection].disabled then
            foundbuff = true
            if not class or self.db.profile[info.dbsection].classfilter[class] then
                name1 = info.mainbuff
                name2 = info.altbuff
            end
        end
    end

    if not foundbuff then
        for dynname, settings in pairs(self.db.profile.userdefined) do
            if name == dynname and not settings.disabled then
                foundbuff = true
                if not class or settings.classfilter[class] then
                    name1 = settings.name
                end
                break
            end
        end
    end

    if foundbuff and name1 then
        local name, i

        self:Debug("Searching for buff "..name1.." or "..(name2 or "nil").." on unit (" ..UnitName(unit).. ")")

        i = 1
        while true do
            name, _, _, _, duration, timeleft = UnitBuff(unit, i)

            if not name then
                break
            end

            if name:find(name1) or (name2 and name:find(name2)) then
                hasbuff = 1
                self:Debug("Found buff "..name.." on "..unit.." (" ..UnitName(unit).. ") duration "..(duration or "nil").." timeleft "..(timeleft or "nil"))
                enabled = duration and timeleft and 1
                break
            end
            i = i + 1
        end

        local start = 0
        
        if enabled and enabled > 0 then
            if duration and duration > 0 and timeleft and timeleft > 0 then
                start = (GetTime() + timeleft) - duration
            end
        end
        
        return hasbuff, enabled, start, duration
    end
end

local lastorder

function uabStatus_MainBuffs:RemoveUserDefined(buffname)
    local args = self.core.core.options.args.unitstatus.args[self.name]

    args.args[buffname] = nil
    args.args.remove.args[buffname] = nil
    self.db.profile.userdefined[buffname] = nil
    self:UnregisterUnitStatus("Buffs", buffname)

    lastorder = 50
    
    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
        if not settings.name then
            settings.name = name
        end

        args.args[name].order = lastorder + 10
        lastorder = args.args[name].order
    end
    
    self:SetUserDefinedBuffList()
end

function uabStatus_MainBuffs:SetUserDefinedBuffList()
    for pos, _ in pairs(self.userdefined) do
        self.userdefined[pos] = nil
    end

    local pos = 1
    
    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
        self.userdefined[pos] = name
        pos = pos + 1
    end
end

function uabStatus_MainBuffs:CreateUnitStatusOptions()
    local args = {}

    args = {
        type = 'group',
        name = "Buffs",
        desc = "Configure the options for Buffs unit status values",
        args = {
            enabled = {
                type = 'toggle',
                name = "Enabled",
                desc = "When checked, enable the use of the Buffs unit status values",
                order = 1,
                get = function()
                    return not self.db.profile.disabled
                end,
                set = function(v)
                    self.db.profile.disabled = not v
                    if self.db.profile.disabled then
                        self:DisableAllStatus()
                    else
                        self:EnableAllStatus()
                    end

                    self.core.core.main:FrameGroupsChanged()
                end,
            },

            addnew = {
                name = "Add New",
                type = 'text',
                desc = "Create a new buff",
                usage = "<name>",
                order = 30,
                get = function() return end,
                set = function(newname)
                    self.db.profile.userdefined["Buff: "..newname] = {
                        name = newname,
                        disabled = nil,
                        priority = 50,
                        color = { r = 0, g = 0, b = 1, a = 1, },
                        classfilter = {
                            druid = true,
                            hunter = true,
                            mage = true,
                            paladin = true,
                            priest = true,
                            rogue = true,
                            shaman = true,
                            warlock = true,
                            warrior = true,
                        },
                    }

                    self:RegisterUnitStatus("Buffs", "Buff: "..newname, self.db.profile.userdefined["Buff: "..newname], true)

                    local args = self.core.core.options.args.unitstatus.args[self.name]
                                    
                    args.args["Buff: "..newname] = self:CreateUnitStatusOption(self.db.profile.userdefined["Buff: "..newname], "Buff: "..newname, "Buff: "..newname, true)
                    args.args["Buff: "..newname].order = lastorder + 10
                    lastorder = args.args["Buff: "..newname].order

                    args.args.remove.args["Buff: "..newname] = {
                        type = 'execute',
                        name = "Buff: "..newname,
                        desc = "Remove the ".."Buff: "..newname.." buff",
                        func = function()
                            self:RemoveUserDefined("Buff: "..newname)
                        end,
                    }
    
                    self:SetUserDefinedBuffList()
                end,
                validate = function(newname)
                    for name, settings in pairs(self.db.profile.userdefined) do
                        if name == "Buff: "..newname then
                            return false
                        end
                    end
                    
                    return true
                end,
                order = 2,
            },

            remove = {
                type = 'group',
                name = "Remove",
                desc = "Remove a buff",
                order = 3,
                args = {
                },
            },

            spacing3 = {
                name = " ",
                type = 'header',
                order = 5,
            },
        },
    }

    args.args.intellect = self:CreateUnitStatusOption(self.db.profile.intellect, uabStatus_MainBuffs.constants.strings.bintellect, uabStatus_MainBuffs.constants.strings.bintellect, true)
    args.args.intellect.order = 10

    args.args.fort = self:CreateUnitStatusOption(self.db.profile.fort, uabStatus_MainBuffs.constants.strings.bfort, uabStatus_MainBuffs.constants.strings.bfort, true)
    args.args.fort.order = 20

    args.args.spirit = self:CreateUnitStatusOption(self.db.profile.spirit, uabStatus_MainBuffs.constants.strings.bspirit, uabStatus_MainBuffs.constants.strings.bspirit, true)
    args.args.spirit.order = 30

    args.args.shadowprot = self:CreateUnitStatusOption(self.db.profile.shadowprot, uabStatus_MainBuffs.constants.strings.bshadowprot, uabStatus_MainBuffs.constants.strings.bshadowprot, true)
    args.args.shadowprot.order = 40

    args.args.mark = self:CreateUnitStatusOption(self.db.profile.mark, uabStatus_MainBuffs.constants.strings.bmark, uabStatus_MainBuffs.constants.strings.bmark, true)
    args.args.mark.order = 50

    lastorder = 50
    
    -- dynamically added buffs
    for name, settings in pairs(self.db.profile.userdefined) do
        if not settings.name then
            settings.name = name
        end
        
        args.args[name] = self:CreateUnitStatusOption(settings, name, name, true)
        args.args[name].order = lastorder + 10
        lastorder = args.args[name].order
    end
    
    for name, settings in pairs(self.db.profile.userdefined) do
        args.args.remove.args[name] = {
            type = 'execute',
            name = name,
            desc = "Remove the "..settings.name.." buff",
            order = 100,
            func = function()
                self:RemoveUserDefined(name)
            end,
        }
    end

    self:SetUserDefinedBuffList()
    
    return args
end

