-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local uabStatus_LowMana = uabUnitStatus:NewModule("Low on Mana")

uabStatus_LowMana.defaultDB = {
    disabled = nil,
    threshold = 0.35,
    priority = 50,
    color = { r = 0,    g = 1,    b = 1, a = 1, },
    classfilter = {
        druid = true,
        hunter = true,
        mage = true,
        paladin = true,
        priest = true,
        rogue = nil,
        shaman = true,
        warlock = true,
        warrior = nil,
    },
}

function uabStatus_LowMana:OnInitialize()
    self.super.OnInitialize(self)

	self:RegisterUnitStatus(self.name, nil, self.db.profile, true)
end

function uabStatus_LowMana:UNIT_MANA(unit)
    if self.db.profile.disabled then return end

    local class = self:GetUnitClass(unit)
    
    if not class or self.db.profile.classfilter[class] then
        local curmana = UnitMana(unit)
        local maxmana = UnitManaMax(unit)

        if curmana and maxmana and curmana < (maxmana * self.db.profile.threshold) then
            if not self.status then
                self.status = true
                self:UnitStatusGained(self.name, unit)
            end
        elseif self.status then
            self.status = nil
            self:UnitStatusLost(self.name, unit)
        end
    elseif self.status then
        self.status = nil
        self:UnitStatusLost(self.name, unit)
    end
end

function uabStatus_LowMana:OnEnable()
end

function uabStatus_LowMana:OnDisable()
end

function uabStatus_LowMana:SetEffectUse(name)
    if not self.registered then
--        self:RegisterEvent("UNIT_MANA")
        self.registered = true
    end
end

function uabStatus_LowMana:ClearEffectUse(name)
    if self.registered then
--        self:UnregisterEvent("UNIT_MANA")
        self.registered = nil
    end
end

function uabStatus_LowMana:IsStatusGained(name, unit, action)
    if self.db.profile.disabled then return end

	if name ~= self.name then return end

    if not unit then return end

    local class = self:GetUnitClass(unit)
    
    if not class or self.db.profile.classfilter[class] then
        local curmana = UnitMana(unit)
        local maxmana = UnitManaMax(unit)

        return curmana and maxmana and curmana < (maxmana * self.db.profile.threshold)
    end
end

function uabStatus_LowMana:CreateUnitStatusOptions()
    local options = self:CreateUnitStatusOption(self.db.profile, "Low Mana", "Low Mana", true)

    options.args.threshold = {
        type = 'range',
        name = "Threshold",
        desc = "Low mana threshold",
        order = 100,
        min = 0.05,
        max = 1.00,
        step = 0.05,
        isPercent = true,
        get = function()
            return self.db.profile.threshold
        end,
        set = function(value)
            self.db.profile.threshold = value
        end,
    }

    return options
end

