-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local uabStatus_LowHealth = uabUnitStatus:NewModule("Low Health")

uabStatus_LowHealth:SetModuleMixins("AceEvent-2.0")

uabStatus_LowHealth.defaultDB = {
    disabled = nil,
    threshold = 0.40,
    priority = 50,
    color = { r = 0,    g = 1,    b = 1, a = 1, },
    classfilter = {
        druid = true,
        hunter = true,
        mage = true,
        paladin = true,
        priest = true,
        rogue = true,
        shaman = true,
        warlock = true,
        warrior = true,
    },
}

function uabStatus_LowHealth:OnInitialize()
    self.super.OnInitialize(self)

	self:RegisterUnitStatus(self.name, nil, self.db.profile, true)
end

function uabStatus_LowHealth:UNIT_HEALTH(unit)
    if self.db.profile.disabled then return end

    local class = self:GetUnitClass(unit)
    
    if not class or self.db.profile.classfilter[class] then
        local curhealth = UnitHealth(unit)
        local maxhealth = UnitHealthMax(unit)

        if curhealth and maxhealth and curhealth < (maxhealth * self.db.profile.threshold) then
            if not self.status then
                self.status = true
                self:UnitStatusGained(self.name, unit)
            end
        elseif self.status then
            self.status = nil
            self:UnitStatusLost(self.name, unit)
        end
    elseif self.status then
        self.status = nil
        self:UnitStatusLost(self.name, unit)
    end
end

function uabStatus_LowHealth:OnEnable()
end

function uabStatus_LowHealth:OnDisable()
end

function uabStatus_LowHealth:SetEffectUse(name)
    if not self.registered then
--        self:RegisterEvent("UNIT_HEALTH")
        self.registered = true
    end
end

function uabStatus_LowHealth:ClearEffectUse(name)
    if self.registered then
--        self:UnregisterEvent("UNIT_HEALTH")
        self.registered = nil
    end
end

function uabStatus_LowHealth:IsStatusGained(name, unit, action)
    if self.db.profile.disabled then return end

	if name ~= self.name then return end
    
    if not unit then return end
    
    local class = self:GetUnitClass(unit)
    
    if not class or self.db.profile.classfilter[class] then
        local curhealth = UnitHealth(unit)
        local maxhealth = UnitHealthMax(unit)

        return curhealth and maxhealth and curhealth < (maxhealth * self.db.profile.threshold)
    end
end

function uabStatus_LowHealth:CreateUnitStatusOptions()
    local option = self:CreateUnitStatusOption(self.db.profile, "Low Health", "Low Health", true)

    option.args["threshold"] = {
        type = 'range',
        name = "Threshold",
        desc = "Low health threshold",
        order = 100,
        min = 0.05,
        max = 1.00,
        step = 0.05,
        isPercent = true,
        get = function()
            return self.db.profile.threshold
        end,
        set = function(value)
            self.db.profile.threshold = value
        end,
    }
    
    return option
end
