-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local uabStatus_Dead = uabUnitStatus:NewModule("Dead")

uabStatus_Dead.mixins = {}
uabStatus_Dead.mixins.aura = AceLibrary("SpecialEvents-Aura-2.0")

uabStatus_Dead.defaultDB = {
    disabled = nil,
    checkfeign = false,
    priority = 50,
    color = { r = 1,    g = 0,    b = 0, a = 1, },
    classfilter = {
        druid = true,
        hunter = true,
        mage = true,
        paladin = true,
        priest = true,
        rogue = true,
        shaman = true,
        warlock = true,
        warrior = true,
    },
}

function uabStatus_Dead:OnInitialize()
    self.super.OnInitialize(self)

    self:RegisterUnitStatus(self.name, nil, self.db.profile, true)
end

function uabStatus_Dead:UNIT_HEALTH(unit)
    if self.db.profile.disabled then return end

    local class = self:GetUnitClass(unit)
    
    if not class or self.db.profile.classfilter[class] then
        if UnitIsDeadOrGhost(unit) then
            if not self.db.profile.checkfeign or not self.mixins.aura:UnitHasBuff(unit, "Feign Death") then
                self.isdead = true
                self:UnitStatusGained(self.name, unit)
            elseif self.isdead then
                self.isdead = nil
                self:UnitStatusLost(self.name, unit)
            end
        elseif self.isdead then
            self.isdead = nil
            self:UnitStatusLost(self.name, unit)
        end
    elseif self.isdead then
        self.isdead = nil
        self:UnitStatusLost(self.name, unit)
    end
end

function uabStatus_Dead:OnEnable()
end

function uabStatus_Dead:OnDisable()
end

function uabStatus_Dead:SetEffectUse(name)
    if not self.registered then
--        self:RegisterEvent("UNIT_HEALTH")
        self.registered = true
    end
end

function uabStatus_Dead:ClearEffectUse(name)
    if self.registered then
--        self:UnregisterEvent("UNIT_HEALTH")
        self.registered = nil
    end
end

function uabStatus_Dead:IsStatusGained(name, unit, action)
    if self.db.profile.disabled then return end

    local class = self:GetUnitClass(unit)
    
    if not class or self.db.profile.classfilter[class] then
    	if name == self.name then
        	if UnitIsDeadOrGhost(unit) then
		        if not self.db.profile.checkfeign or not self.mixins.aura:UnitHasBuff(unit, "Feign Death") then
                    return true
                end
            end
    	end
    end
end

function uabStatus_Dead:CreateUnitStatusOptions()
    local args = self:CreateUnitStatusOption(self.db.profile, "Dead", "Dead", true)

    args.args.feign = {
        type = 'toggle',
        name = "Feign Death",
        desc = "When checked, enable checking for a feign death to avoid false 'dead' indications",
        order = 6,
        get = function()
            return self.db.profile.checkfeign
        end,
        set = function(v)
            self.db.profile.checkfeign = v
        end,
    }
    
    return args
end

