-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local uabStatus_Aggro = uabUnitStatus:NewModule("Aggro", "AceEvent-2.0", "AceModuleCore-2.0")
uabStatus_Aggro:SetModuleMixins("LibBanzai-2.0")

uabStatus_Aggro.defaultDB = {
    disabled = nil,
    priority = 50,
    color = { r = 1,    g = 0,    b = 0, a = 1, },
    classfilter = {
        druid = true,
        hunter = true,
        mage = true,
        paladin = true,
        priest = true,
        rogue = true,
        shaman = true,
        warlock = true,
        warrior = true,
    },
}

function uabStatus_Aggro:OnInitialize()
    self.super.OnInitialize(self)

	self:RegisterUnitStatus(self.name, nil, self.db.profile, true)
--	self:RegisterUnitStatus(self.name, nil, self.db.profile)
end

function uabStatus_Aggro:SetEffectUse(name)
    if not self.registered then
    	self:RegisterEvent("Banzai_UnitGainedAggro")
    	self:RegisterEvent("Banzai_UnitLostAggro")
        self.registered = true
    end
end

function uabStatus_Aggro:ClearEffectUse(name)
    if self.registered then
    	self:UnregisterEvent("Banzai_UnitGainedAggro")
    	self:UnregisterEvent("Banzai_UnitLostAggro")
        self.registered = nil
    end
end

function uabStatus_Aggro:Banzai_UnitGainedAggro(unit)
--    if self.db.profile.disabled then return end
--
--    local class = self:GetUnitClass(unit)
--    
--    if not class or self.db.profile.classfilter[class] then
--        self:UnitStatusGained(self.name, unit)
--    end
end

function uabStatus_Aggro:Banzai_UnitLostAggro(unit)
--    if self.db.profile.disabled then return end
--
--    local class = self:GetUnitClass(unit)
--    
--    if not class or self.db.profile.classfilter[class] then
--        self:UnitStatusLost(self.name, unit)
--    end
end

function uabStatus_Aggro:OnEnable()
end

function uabStatus_Aggro:OnDisable()
end

function uabStatus_Aggro:IsStatusGained(name, unit, action)
    if self.db.profile.disabled then return end

	if name ~= self.name then return end
    
    local class = self:GetUnitClass(unit)
    
    if not class or self.db.profile.classfilter[class] then
        return self:GetUnitAggroByUnitId(unit)
    end
end

function uabStatus_Aggro:CreateUnitStatusOptions()
    return self:CreateUnitStatusOption(self.db.profile, "Aggro", "Aggro", true)
end
