-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local uabStatus_ActionRange = uabUnitStatus:NewModule("Out of Range")
uabStatus_ActionRange.defaultDB = {
    disabled = nil,
    priority = 50,
    color = { r = 1,    g = 0.5,  b = 0, a = 1, },
    classfilter = {
        druid = true,
        hunter = true,
        mage = true,
        paladin = true,
        priest = true,
        rogue = true,
        shaman = true,
        warlock = true,
        warrior = true,
    },
}

function uabStatus_ActionRange:OnInitialize()
    self.super.OnInitialize(self)

	self:RegisterUnitStatus(self.name, nil, self.db.profile)
end

function uabStatus_ActionRange:OnEnable()
end

function uabStatus_ActionRange:OnDisable()
end

function uabStatus_ActionRange:IsStatusGained(name, unit, action)
    if not unit then return end
    if self.db.profile.disabled then return end

	if name == self.name then
        local class = self:GetUnitClass(unit)
        
        if not class or self.db.profile.classfilter[class] then
    		if action then
    	        local spell = action:GetSpellName()
    	    
    	        if spell then
    	            local inRange = IsSpellInRange(spell, unit)
    	            if inRange then
    	                if inRange == 1 then
                            --uab.print("Spell action is in range")
                            return
                        end
    	                return true
    	            end
                    return
    	        end
    	    
    	        -- check follow distance as the default check (~28 yards)
    	        return not CheckInteractDistance(unit, 4)
    	    end
        end
	end
end

function uabStatus_ActionRange:CreateUnitStatusOptions()
    return self:CreateUnitStatusOption(self.db.profile, "Out of Range", "Out of Range", true)
end
