-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local uabStatus_ActionCooldown = uabUnitStatus:NewModule("Action Cooldown")

uabStatus_ActionCooldown.defaultDB = {
    disabled = nil,
    priority = 50,
    color = { r = 1,    g = 0.5,  b = 0, a = 1, },
    classfilter = {
        druid = true,
        hunter = true,
        mage = true,
        paladin = true,
        priest = true,
        rogue = true,
        shaman = true,
        warlock = true,
        warrior = true,
    },
}

function uabStatus_ActionCooldown:OnInitialize()
    self.super.OnInitialize(self)

	self:RegisterUnitStatus(self.name, nil, self.db.profile)
end

function uabStatus_ActionCooldown:OnEnable()
end

function uabStatus_ActionCooldown:OnDisable()
end

function uabStatus_ActionCooldown:IsStatusGained(name, unit, action)
    if self.db.profile.disabled then return end

	if name ~= self.name then return end
    
    local class = self:GetUnitClass(unit)
    
    if not class or self.db.profile.classfilter[class] then
        local hasstatus
        local start, duration, supports_cooldown
        if action then
            start, duration, supports_cooldown = action:GetActionCooldown()
        end

        if supports_cooldown and start and start > 0 and duration and duration > 0 then
            hasstatus = 1
        end
        
        return hasstatus
    end
end

function uabStatus_ActionCooldown:CreateUnitStatusOptions()
    return self:CreateUnitStatusOption(self.db.profile, "Action Cooldown", "Action Cooldown", true)
end

