-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 43447 $"):match("%d+")), ("$Date: 2007-07-10 23:36:10 -0500 (Tue, 10 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

--[[
A StanceCtrlSecureHeader presents an interface to the the Blizzard/WoW secure header
frame for the functionality that UAB needs to ensure that click-casting on registered
unit frames work properly as a player changes stances.
--]]
uab.classes.StanceCtrlSecureHeader = uab.mixins.aceOO.Class()

function uab.classes.StanceCtrlSecureHeader.prototype:init()
	uab.classes.StanceCtrlSecureHeader.super.prototype.init(self)

    self.pendingattributes = {}
	self.name = "UAB_StanceCtrlSecureHeader"
    self.framename = self.name

	--[[
	Create the header frame.
	--]]

    self.frame = getglobal(self.framename)
    if not self.frame then
        self.frame = CreateFrame("Frame", self.framename, UIParent, "SecureStateHeaderTemplate")
    end
    
    self.frame.uabobj = self
    
    local stance_map
    self:SetAttribute(self.frame, "statemap-stance-0", "0")
    for stance = 1, uab.MaxCurrentClassStances(), 1 do
        self:SetAttribute(self.frame, "statemap-stance-"..stance, ""..stance)
        local val = "[stance:"..stance.."] "..stance
        if not stance_map then
            stance_map = ""
        else
            stance_map = stance_map .. "; "
        end
        stance_map = stance_map .. val
    end

    if uab.MaxCurrentClassStances() > 0 then
        stance_map = stance_map .. "; 0"
    else
        stance_map = "0"
    end

    RegisterStateDriver(self.frame, "stance", stance_map)

    self:SetStanceState()
end

function uab.classes.StanceCtrlSecureHeader.prototype:Dump(dumper)
    dumper:Dump("StanceCtrlSecureHeader")
    dumper:IncIndent()
    dumper:DumpFrameAttribute(self.frame, "state")

    for stance = 0, uab.MaxCurrentClassStances(), 1 do
        dumper:DumpFrameAttribute(self.frame, "statemap-stance-"..stance)
    end
    dumper:DecIndent()
end

function uab.classes.StanceCtrlSecureHeader.prototype:ApplyPendingAttributes()
	for name, val in pairs(self.pendingattributes) do
		for frame, data in pairs(val) do
    		uab.SetFrameAttribute(frame, name, data.val)
            val[frame] = nil
        end
        self.pendingattributes[name] = nil
	end
end

function uab.classes.StanceCtrlSecureHeader.prototype:SetStanceState()
    self:SetAttribute(self.frame, "state", ""..GetShapeshiftForm(true))
end

function uab.classes.StanceCtrlSecureHeader.prototype:SetAttribute(frame, attribute, val)
    if uab:IsPendingAttributes() then
        if not self.pendingattributes[attribute] then
            self.pendingattributes[attribute] = {}
        end
        self.pendingattributes[attribute][frame] = { val = val }
    else
        self:ApplyPendingAttributes()
        uab.SetFrameAttribute(frame, attribute, val)
    end
end

