-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 65598 $"):match("%d+")), ("$Date: 2008-03-24 23:22:49 -0400 (Mon, 24 Mar 2008) $"):match("%d%d%d%d%-%d%d%-%d%d"))

uab.classes.MacroAction = uab.mixins.aceOO.Class(uab.classes.BaseAction)

function uab.classes.MacroAction.FindMacro(findname)
    local globalcount, localcount = GetNumMacros()

    for id = 1, globalcount, 1 do
        local name, texture, _, _ = GetMacroInfo(id)

        if name and name == findname then
            return id, texture
        end
    end

    for id = 1, localcount, 1 do
        local name, texture, _, _ = GetMacroInfo(id+18)

        if name and name == findname then
            return id+18, texture
        end
    end
end

function uab.classes.MacroAction.prototype:init(data)
	uab.classes.MacroAction.super.prototype.init(self)
	
	self.data = data
    self.text = self.data.name
    self.attribs = {}

    self.attribs["type"] = "macro"
    self.attribs["macro"] = self.text

	self:SetIcon()
end

function uab.classes.MacroAction.prototype:Dump(dumper)
    dumper:Dump("Macro Action")
    dumper:IncIndent()
    dumper:Dump("Name     : "..self.text)
    dumper:Dump("Icon     : "..self.data.icon)

    dumper:Dump("Attributes")
    dumper:IncIndent()
    for attr, val in pairs(self.attribs) do
        dumper:Dump(attr.." : "..val)
    end
    dumper:DecIndent()

    dumper:DecIndent()
end

-- Override
function uab.classes.MacroAction.prototype:ShowTooltip(frame)
    --[[
    Need to find the referenced item.  Look in the player's inventory first.
    If not there, look in the player's bags.
    --]]

    GameTooltip:SetOwner(frame, "ANCHOR_RIGHT")
    GameTooltip:SetBackdropColor(0.1, 0.1, 0.1, 0.8)

    local id, texture = uab.classes.MacroAction.FindMacro(self.data.name)
    if id then
        GameTooltip:SetText(self.data.name)
        return
    end
end

-- Override
function uab.classes.MacroAction.prototype:GetCount()
    local spell
    local rank

    if GetMacroSpell then
        spell, rank = GetMacroSpell(self.data.name)
    end
    
    if spell then
        return uab.classes.SpellAction.GetCount(spell, rank)
    elseif GetMacroItem then
        local itemText
        local itemLink
    
        if GetMacroItem then
            itemText, itemLink = GetMacroItem(self.data.name)
        end
        
        if itemText or itemLink then
            return uab.classes.ItemAction.GetCount(itemText, itemLink)
        end
    end
end

-- Override
function uab.classes.MacroAction.prototype:GetAttributes()
    return self.attribs
end

-- Override
function uab.classes.MacroAction.prototype:IsUsable()
    local spell
    local rank

    if GetMacroSpell then
        spell, rank = GetMacroSpell(self.data.name)
    end
    
    if spell then
        return IsUsableSpell(spell)
    elseif GetMacroItem then
        local item
        local link
        
        item, link = GetMacroItem(self.data.name)
        if item then
            return IsUsableItem(item)
        elseif link then
            return IsUsableItem(link)
        end
    end
end

-- Override
function uab.classes.MacroAction.prototype:GetClassName()
	return "MacroAction"
end

-- Override
function uab.classes.MacroAction.prototype:IsActive()
    local spell
    local rank

    if GetMacroSpell then
        spell, rank = GetMacroSpell(self.data.name)
    end
    
    if spell then
        return uab.classes.SpellAction.IsActive(spell, rank)
    elseif GetMacroItem then
        local item
        local link
        
        item, link = GetMacroItem(self.data.name)
        if item then
            return IsCurrentItem(item)
        elseif link then
            return IsCurrentItem(link)
        end
    end
end

-- Override
function uab.classes.MacroAction.prototype:GetCooldown()
    local spell
    local rank

    if GetMacroSpell then
        spell, rank = GetMacroSpell(self.data.name)
    end
    
    if spell then
        return uab.classes.SpellAction.GetCooldown(spell, rank)
    elseif GetMacroItem then
        local item
        local link
        
        item, link = GetMacroItem(self.data.name)
        if item then
            return GetItemCooldown(item)
        elseif link then
            return GetItemCooldown(link)
        end
    end
end

-- Override
function uab.classes.MacroAction.prototype:GetSpellName()
    local spell
    local rank

    if GetMacroSpell then
        spell, rank = GetMacroSpell(self.data.name)
    end
    
    return spell
end

-- Override
function uab.classes.MacroAction.prototype:PickupAction()
    local id, texture = uab.classes.MacroAction.FindMacro(self.data.name)
    if id then
        PickupMacro(id)
        return true
    end
end

--[[---------------------------------------------------------------------------
Helper methods, to be used only by the class itself
-----------------------------------------------------------------------------]]
-- Override
function uab.classes.MacroAction.prototype:SetIcon()
    self.icon = self.data.icon
    
    if not self.icon then
    	--[[
    	Need to find the referenced macro based on the name of the macro.
    	--]]

        local id, texture = uab.classes.MacroAction.FindMacro(self.data.name)
        if id and texture then
            self.icon = texture
        end
    end
    
    self.data.icon = self.icon
end

