-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

--[[
This controls the configuration settings (and display of a sample set of
actions based on those settings) for each ActionSetLayout.  Each
BarActionSetLayout is associated with an BarActionSetLayoutConfig, and each
BarActionSetLayoutConfig refers to that same BarActionSetLayout instance.
--]]
uabSquareLayoutManager.LayoutConfig = uab.mixins.aceOO.Class(uabLayoutManager.interfaces.IActionSetLayoutConfig, uab.mixins.aceEvent)
uabSquareLayoutManager.LayoutConfig.count = 0

function uabSquareLayoutManager.LayoutConfig.prototype:init(layout, settings)
    uabSquareLayoutManager.LayoutConfig.super.prototype.init(self)

	self.settings = settings
    self.layout = layout

	uabSquareLayoutManager.LayoutConfig.count = uabSquareLayoutManager.LayoutConfig.count + 1
	self.number = uabSquareLayoutManager.LayoutConfig.count

	self:SettingsChanged()
end

function uabSquareLayoutManager.LayoutConfig.prototype:SettingsChanged(settings)
	if not self.settings then
		self.settings = {}
	end

    if not settings then
        settings = self.settings
    end
    
    self.settings.growClockwise = (settings and settings.growClockwise) or "true"
    self.settings.startLocation = (settings and settings.startLocation) or uabLayoutManager.constants.placement.top
    self.settings.hspacing = (settings and settings.hspacing) or 0
    self.settings.vspacing = (settings and settings.vspacing) or 0
    self.settings.horizontal = (settings and settings.horizontal) or 0
    self.settings.vertical = (settings and settings.vertical) or 0
    self.settings.hidecancel = (settings and settings.hidecancel)

    --[[
    Update the controls in the frame to show the new settings
    --]]
    self:SetGrowClockwise(self.settings.growClockwise)
    self:SetStartLocation(self.settings.startLocation)
    self:SetHSpacing(self.settings.hspacing)
    self:SetVSpacing(self.settings.vspacing)
    self:SetHorizontal(self.settings.horizontal)
    self:SetVertical(self.settings.vertical)
end

function uabSquareLayoutManager.LayoutConfig.prototype:UseDefaults(bypassNotification)
	if not self.settings then
	    self.settings = {}
	end

    self.settings.growClockwise = "true"
    self.settings.startLocation = uabLayoutManager.constants.placement.top
    self.settings.hspacing = 0
    self.settings.vspacing = 0
    self.settings.horizontal = 0
    self.settings.vertical = 0
    self.settings.hidecancel = nil
	
    self:SettingsChanged()
	
    if not bypassNotification then
        self.layout:LayoutSettingsChanged()
    end
end

function uabSquareLayoutManager.LayoutConfig.prototype:MenuOptionArgs()
	--[[
	Build an AceOptions table of the options to be used to configure this
	config instance.  This table is inserted into a parent menu as a set of
	options.  If there are several options, just define them at the top level
	of the returned table.  Do not create a 'group' at the top level to enclose
	the options.
	--]]
	
	local options = {
        
        location = {
            type = 'text',
            name = "First button placement",
            desc = "Placement of the first button, relative to the cancel button",
            order = 105,
            get = function()
                return uabLayoutManager.PlacementDisplayValue(self.settings.startLocation)
            end,
            set = function(placement)
                if placement == uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.topleft) then
                    self:SetStartLocation(uabLayoutManager.constants.placement.topleft)
				elseif placement == uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.top) then
                	self:SetStartLocation(uabLayoutManager.constants.placement.top)
				elseif placement == uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.topright) then
                	self:SetStartLocation(uabLayoutManager.constants.placement.topright)
				elseif placement == uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.bottomleft) then
                	self:SetStartLocation(uabLayoutManager.constants.placement.bottomleft)
				elseif placement == uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.bottom) then
                	self:SetStartLocation(uabLayoutManager.constants.placement.bottom)
				elseif placement == uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.bottomright) then
                	self:SetStartLocation(uabLayoutManager.constants.placement.bottomright)
				elseif placement == uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.left) then
                	self:SetStartLocation(uabLayoutManager.constants.placement.left)
				elseif placement == uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.right) then
                	self:SetStartLocation(uabLayoutManager.constants.placement.right)
				end
            end,

            validate = {
				uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.topleft),
				uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.top),
				uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.topright),
				uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.bottomleft),
				uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.bottom),
				uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.bottomright),
				uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.left),
				uabLayoutManager.PlacementDisplayValue(uabLayoutManager.constants.placement.right),
			},
        },
        
        clockwise = {
            type = 'toggle',
            name = "Add buttons clockwise",
            desc = "As buttons are added, then should be added around the square in clockwise order",
            order = 110,
            get = function()
                return self.settings.growClockwise == "true"
            end,
            set = function(v)
                if v then
					self:SetGrowClockwise("true")
				else
				    self:SetGrowClockwise("false")
                end
            end,
        },
        space1 = {
            type = 'header',
            name = " ",
            order = 140,
        },
        
        hspacing = {
            type = 'range',
            name = "Horizontal Spacing",
            desc = "Amount of hosizontal space between buttons",
            order = 144,
            min = -20,
            max = 20,
            step = 1,
            isPercent = false,
            get = function()
                return self.settings.hspacing
            end,
            set = function(v)
                self:SetHSpacing(v)
            end,
        },
        
        vspacing = {
            type = 'range',
            name = "Vertical Spacing",
            desc = "Amount of vertical space between buttons",
            order = 146,
            min = -20,
            max = 20,
            step = 1,
            isPercent = false,
            get = function()
                return self.settings.vspacing
            end,
            set = function(v)
                self:SetVSpacing(v)
            end,
        },
	}
	
	return options
end

--[[---------------------------------------------------------------------------
Helper methods, to be used only by the class itself
-----------------------------------------------------------------------------]]

function uabSquareLayoutManager.LayoutConfig.prototype:SetStartLocation(value)
    local notify = (value ~= self.settings.startLocation)
        
    self.settings.startLocation = value
    
    if notify then
        self.layout:LayoutSettingsChanged()
    end        
end

function uabSquareLayoutManager.LayoutConfig.prototype:SetGrowClockwise(value)
    local newval
    
    if value and (tonumber(value) == 1 or value == "true") then
        newval = "true"
    else
        newval = "false"
    end
    
    local notify = (newval ~= self.settings.growClockwise)
        
    self.settings.growClockwise = newval

    if notify then
        self.layout:LayoutSettingsChanged()
    end        
end

function uabSquareLayoutManager.LayoutConfig.prototype:SetHSpacing(value)
    local notify = (value ~= self.settings.hspacing)

    self.settings.hspacing = value

    if notify then
        self.layout:LayoutSettingsChanged()
    end
end

function uabSquareLayoutManager.LayoutConfig.prototype:SetVSpacing(value)
    local notify = (value ~= self.settings.vspacing)

    self.settings.vspacing = value

    if notify then
        self.layout:LayoutSettingsChanged()
    end
end

function uabSquareLayoutManager.LayoutConfig.prototype:SetHorizontal(value)
    local notify = (value ~= self.settings.horizontal)

    self.settings.horizontal = value

    if notify then
        self.layout:LayoutSettingsChanged()
    end
end

function uabSquareLayoutManager.LayoutConfig.prototype:SetVertical(value)
    local notify = (value ~= self.settings.vertical)

    self.settings.vertical = value

    if notify then
        self.layout:LayoutSettingsChanged()
    end
end

function uabSquareLayoutManager.LayoutConfig.prototype:SetHideCancel(value)
    local notify = (value ~= self.settings.hidecancel)

    self.settings.hidecancel = value

    if notify then
        self.layout:LayoutSettingsChanged()
    end
end

function uabSquareLayoutManager.LayoutConfig.prototype:GetHorizontal()
    return self.settings.horizontal or 0
end

function uabSquareLayoutManager.LayoutConfig.prototype:GetVertical()
    return self.settings.vertical or 0
end

function uabSquareLayoutManager.LayoutConfig.prototype:GetHideCancel()
    return self.settings.hidecancel
end

