-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

--[[
This class controls the arrangement of the ActionButtonNone and ActionButton
instances for a UnitGroupHeader.

There are one or more IActionSetLayout instances allocated for each
UnitGroupHeader.  How many depends on whether the layout is changed while
in-game.  The only layouts allocated are ones that were selected in-game.  Each
UnitGroupHeader keeps track of the active ActionSetLayout to use.
--]]
uabSquareLayoutManager.Layout = uab.mixins.aceOO.Class(uabLayoutManager.Layout)

uabSquareLayoutManager.Layout.constants = {}
uabSquareLayoutManager.Layout.constants.rowButtonStart = { 1, 9 }
uabSquareLayoutManager.Layout.constants.rowButtons = { 8, 16 }
uabSquareLayoutManager.Layout.constants.buttonOrder = {
    row1 = { "l2", "u2l2", "u2", "u2r2", "r2", "d2r2", "d2", "d2l2" },
    row2 = { "l4", "u2l4", "u4l4", "u4l2", "u4", "u4r2", "u4r4", "u2r4", "r4", "d2r4", "d4r4", "d4r2", "d4", "d4l2", "d4l4", "d2l4" },
}

uabSquareLayoutManager.Layout.constants.buttonOrderSequence = {
    [uabLayoutManager.constants.placement.left] = { 1, 1 },
    [uabLayoutManager.constants.placement.topleft] = { 2, 2 },
    [uabLayoutManager.constants.placement.top] = { 3, 5 },
    [uabLayoutManager.constants.placement.topright] = { 4, 8 },
    [uabLayoutManager.constants.placement.right] = { 5, 9 },
    [uabLayoutManager.constants.placement.bottomright] = { 6, 10 },
    [uabLayoutManager.constants.placement.bottom] = { 7, 13 },
    [uabLayoutManager.constants.placement.bottomleft] = { 8, 16 }
}

function uabSquareLayoutManager.Layout.prototype:init(context, settings)
	uabSquareLayoutManager.Layout.super.prototype.init(self)
	
    local config = uabSquareLayoutManager.LayoutConfig:new(self, settings)
    self:Initialize(config, "uab.Square", context)
end

function uabSquareLayoutManager.Layout.prototype:PositionButton(orderCode, btnidx)
    local vMod = 0
    local hMod = 0

    tmpCode = orderCode        
    if string.sub(orderCode, 1, 1) == "u" then
        vMod = tonumber(string.sub(orderCode, 2, 2)) * 0.5
        tmpCode = string.sub(orderCode, 3)
    end

    if string.sub(tmpCode, 1, 1) == "d" then
        vMod = tonumber(string.sub(tmpCode, 2, 2)) * -0.5
        tmpCode = string.sub(tmpCode, 3)
    end

    if string.sub(tmpCode, 1, 1) == "r" then
        hMod = tonumber(string.sub(tmpCode, 2, 2)) * 0.5
        tmpCode = string.sub(tmpCode, 3)
    end

    if string.sub(tmpCode, 1, 1) == "l" then
        hMod = tonumber(string.sub(tmpCode, 2, 2)) * -0.5
        tmpCode = string.sub(tmpCode, 3)
    end

    local x = (uab.constants.buttonWidth + self.config.settings.hspacing) * hMod
    local y = (uab.constants.buttonHeight + self.config.settings.vspacing) * vMod
    
    self:SetButtonPoint(btnidx, "CENTER", x, y)
end

function uabSquareLayoutManager.Layout.prototype:PositionRow(row)
	local settings = self.config.settings

    local startpos = settings.startLocation
    local order = uabSquareLayoutManager.Layout.constants.buttonOrder["row"..row]
    local buttonIdx = uabSquareLayoutManager.Layout.constants.rowButtonStart[row]
    local sequence = uabSquareLayoutManager.Layout.constants.buttonOrderSequence

    if settings.growClockwise == "true" then
        for idx = sequence[startpos][row], uabSquareLayoutManager.Layout.constants.rowButtons[row], 1 do
            self:PositionButton(order[idx], buttonIdx)
            buttonIdx = buttonIdx + 1
        end
        
        local endpos = sequence[startpos][row] - 1
        
        for idx = 1, endpos, 1 do
            self:PositionButton(order[idx], buttonIdx)
            buttonIdx = buttonIdx + 1
        end
    else
        for idx = sequence[startpos][row], 1, -1 do
            self:PositionButton(order[idx], buttonIdx)
            buttonIdx = buttonIdx + 1
        end
        
        local endpos = sequence[startpos][row] + 1
        
        for idx = uabSquareLayoutManager.Layout.constants.rowButtons[row], endpos, -1 do
            self:PositionButton(order[idx], buttonIdx)
            buttonIdx = buttonIdx + 1
        end
    end
end

function uabSquareLayoutManager.Layout.prototype:SetupPositions()
    local settings = self.config.settings

	--[[
    Now, position the cancel button centered relative to the header (the
    parent of the cancel button)
    --]]
    if not settings.hidecancel then
        self:SetButtonPoint("cancel", "CENTER", 0, 0)
    end

    self:PositionRow(1)
    self:PositionRow(2)
end

