-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

uabPyramidLayoutManager.LayoutConfig = uab.mixins.aceOO.Class(uabLayoutManager.interfaces.IActionSetLayoutConfig, uab.mixins.aceEvent)
uabPyramidLayoutManager.LayoutConfig.count = 0

function uabPyramidLayoutManager.LayoutConfig.prototype:init(layout, settings)
    uabPyramidLayoutManager.LayoutConfig.super.prototype.init(self)

    self.fillDirections = {}
    self.settings = settings
    self.layout = layout

    uabPyramidLayoutManager.LayoutConfig.count = uabPyramidLayoutManager.LayoutConfig.count + 1
    self.number = uabPyramidLayoutManager.LayoutConfig.count

    self:SettingsChanged()
end

function uabPyramidLayoutManager.LayoutConfig.prototype:SettingsChanged(settings)
    if not self.settings then
        self.settings = {}
    end

    if not settings then
        settings = self.settings
    end

    self.settings.minRowCount = (settings and settings.minRowCount) or 1
    self.settings.rowChangeAmount = (settings and settings.rowChangeAmount) or 1
    self.settings.extendDirection = (settings and settings.extendDirection) or uabLayoutManager.constants.grow.down
    self.settings.fillDirection = (settings and settings.fillDirection) or uabLayoutManager.constants.grow.right
    self.settings.expand = (settings and settings.expand) or "true"
    self.settings.extendSpacing = (settings and settings.extendSpacing) or 0
    self.settings.rowSpacing = (settings and settings.rowSpacing) or 0
    self.settings.horizontal = (settings and settings.horizontal) or 0
    self.settings.vertical = (settings and settings.vertical) or 0
    self.settings.hidecancel = (settings and settings.hidecancel)

    self:VerifyFillDirection()

    --[[
    Update the controls in the frame to show the new settings
    --]]
    self:SetMinRowCount(self.settings.minRowCount)
    self:SetRowChangeAmount(self.settings.rowChangeAmount)
    self:SetExtendDirection(self.settings.extendDirection)
    self:SetFillDirection(self.settings.fillDirection)
    self:SetExpand(self.settings.expand)
    self:SetExtendSpacing(self.settings.extendSpacing)
    self:SetRowSpacing(self.settings.rowSpacing)
    self:SetHorizontal(self.settings.horizontal)
    self:SetVertical(self.settings.vertical)
    self:SetHideCancel(self.settings.hidecancel)
end

function uabPyramidLayoutManager.LayoutConfig.prototype:UseDefaults(bypassNotification)
    if not self.settings then
        self.settings = {}
    end

    self.settings.minRowCount = 1
    self.settings.rowChangeAmount = 1
    self.settings.extendDirection = uabLayoutManager.constants.grow.down
    self.settings.fillDirection = uabLayoutManager.constants.grow.right
    self.settings.expand = "true"
    self.settings.extendSpacing = 0
    self.settings.rowSpacing = 0
    self.settings.horizontal = 0
    self.settings.vertical = 0
    self.settings.hidecancel = nil

    self:VerifyFillDirection()

    self:SettingsChanged()
	
    if not bypassNotification then
        self.layout:LayoutSettingsChanged()
    end
end

function uabPyramidLayoutManager.LayoutConfig.prototype:MenuOptionArgs()
	--[[
	Build an AceOptions table of the options to be used to configure this
	config instance.  This table is inserted into a parent menu as a set of
	options.  If there are several options, just define them at the top level
	of the returned table.  Do not create a 'group' at the top level to enclose
	the options.
	--]]
	
	local options = {
        
        minrowcount = {
            type = 'range',
            name = "Min Row Count",
            desc = "Number of buttons in the smallest row",
            order = 105,
            min = 1,
            max = 12,
            step = 1,
            isPercent = false,
            get = function()
                return self.settings.minRowCount
            end,
            set = function(v)
            	self:SetMinRowCount(v)
            end,
        },
        rowchangeamount = {
            type = 'range',
            name = "Row Change Amount",
            desc = "Number of buttons to add or remove each row",
            order = 110,
            min = 1,
            max = 24,
            step = 1,
            isPercent = false,
            get = function()
                return self.settings.rowChangeAmount
            end,
            set = function(v)
            	self:SetRowChangeAmount(v)
            end,
        },
        extenddirection = {
            type = 'text',
            name = "Extend direction",
            desc = "The direction in which new rows of buttons are added",
            order = 120,
            usage = "Up, Down, Left, Right",
            get = function()
                return uabLayoutManager.GrowDirectionDisplayValue(self.settings.extendDirection)
            end,
            set = function(direction)
                if direction == uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.up) then
	                self:SetExtendDirection(uabLayoutManager.constants.grow.up)
				elseif direction == uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.down) then
	                self:SetExtendDirection(uabLayoutManager.constants.grow.down)
				elseif direction == uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.left) then
	                self:SetExtendDirection(uabLayoutManager.constants.grow.left)
				elseif direction == uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.right) then
	                self:SetExtendDirection(uabLayoutManager.constants.grow.right)
				end
            end,

            validate = {
				uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.up),
				uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.down),
				uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.left),
				uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.right),
			},
        },
        filldirection = {
            type = 'text',
            name = "Fill direction",
            desc = "The direction in which buttons should be added to a row",
            order = 125,
            usage = "Up, Down, Left, Right",
            get = function()
                return uabLayoutManager.GrowDirectionDisplayValue(self.settings.fillDirection)
            end,
            set = function(direction)
                if direction == uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.up) then
	                self:SetFillDirection(uabLayoutManager.constants.grow.up)
				elseif direction == uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.down) then
	                self:SetFillDirection(uabLayoutManager.constants.grow.down)
				elseif direction == uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.left) then
	                self:SetFillDirection(uabLayoutManager.constants.grow.left)
				elseif direction == uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.right) then
	                self:SetFillDirection(uabLayoutManager.constants.grow.right)
				end
            end,

            validate = self.fillDirections,
        },
        expand = {
            type = 'toggle',
            name = "Expand",
            desc = "When checked, the row change amount of buttons are added to each row.  When not checked, they are subtracted from each row",
            order = 130,
            get = function()
                return self.settings.expand == "true"
            end,
            set = function(v)
                if v then
					self:SetExpand("true")
				else
				    self:SetExpand("false")
                end
            end,
        },
        
        space1 = {
            type = 'header',
            name = " ",
            order = 140,
        },
        
        extendspacing = {
            type = 'range',
            name = "Extend Spacing",
            desc = "Amount of space between buttons as you extend a row",
            order = 144,
            min = -20,
            max = 20,
            step = 1,
            isPercent = false,
            get = function()
                return self.settings.extendSpacing
            end,
            set = function(v)
                self:SetExtendSpacing(v)
            end,
        },
        rowspacing = {
            type = 'range',
            name = "Row Spacing",
            desc = "Amount of space between each row of buttons",
            order = 148,
            min = -20,
            max = 20,
            step = 1,
            isPercent = false,
            get = function()
                return self.settings.rowSpacing
            end,
            set = function(v)
                self:SetRowSpacing(v)
            end,
        },
	}
	
	return options
end

--[[---------------------------------------------------------------------------
Helper methods, to be used only by the class itself
-----------------------------------------------------------------------------]]

function uabPyramidLayoutManager.LayoutConfig.prototype:SetMinRowCount(value)
    local notify = (value ~= self.settings.minRowCount)
        
    self.settings.minRowCount = value
    
    if notify then
        self.layout:LayoutSettingsChanged()
    end        
end

function uabPyramidLayoutManager.LayoutConfig.prototype:SetRowChangeAmount(value)
    local notify = (value ~= self.settings.rowChangeAmount)
        
    self.settings.rowChangeAmount = value
    
    if notify then
        self.layout:LayoutSettingsChanged()
    end        
end

function uabPyramidLayoutManager.LayoutConfig.prototype:SetExtendDirection(value)
    local notify = (value ~= self.settings.extendDirection)
        
    self.settings.extendDirection = value
    if self:VerifyFillDirection() then
        notify = true
    end
    
    if notify then
        self.layout:LayoutSettingsChanged()
    end        
end

function uabPyramidLayoutManager.LayoutConfig.prototype:SetFillDirection(value)
    local notify = (value ~= self.settings.fillDirection)
        
    self.settings.fillDirection = value
    
    if notify then
        self.layout:LayoutSettingsChanged()
    end        
end

function uabPyramidLayoutManager.LayoutConfig.prototype:SetExpand(value)
    local newval
    
    if value and (tonumber(value) == 1 or value == "true") then
        newval = "true"
    else
        newval = "false"
    end
    
    local notify = (newval ~= self.settings.expand)
        
    self.settings.expand = newval

    if notify then
        self.layout:LayoutSettingsChanged()
    end        
end

function uabPyramidLayoutManager.LayoutConfig.prototype:VerifyFillDirection()
    if self.settings.extendDirection == uabLayoutManager.constants.grow.down or self.settings.extendDirection == uabLayoutManager.constants.grow.up then
        self.fillDirections[1] = uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.left)
        self.fillDirections[2] = uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.right)

        if self.settings.fillDirection == uabLayoutManager.constants.grow.up or self.settings.fillDirection == uabLayoutManager.constants.grow.down then
            self.settings.fillDirection = uabLayoutManager.constants.grow.right
            return true
        end
    else
        self.fillDirections[1] = uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.up)
        self.fillDirections[2] = uabLayoutManager.GrowDirectionDisplayValue(uabLayoutManager.constants.grow.down)

        if self.settings.fillDirection == uabLayoutManager.constants.grow.right or self.settings.fillDirection == uabLayoutManager.constants.grow.left then
            self.settings.fillDirection = uabLayoutManager.constants.grow.up
            return true
        end
    end
end

function uabPyramidLayoutManager.LayoutConfig.prototype:SetExtendSpacing(value)
    local notify = (value ~= self.settings.extendSpacing)

    self.settings.extendSpacing = value

    if notify then
        self.layout:LayoutSettingsChanged()
    end
end

function uabPyramidLayoutManager.LayoutConfig.prototype:SetRowSpacing(value)
    local notify = (value ~= self.settings.rowSpacing)

    self.settings.rowSpacing = value

    if notify then
        self.layout:LayoutSettingsChanged()
    end
end

function uabPyramidLayoutManager.LayoutConfig.prototype:SetHorizontal(value)
    local notify = (value ~= self.settings.horizontal)

    self.settings.horizontal = value

    if notify then
        self.layout:LayoutSettingsChanged()
    end
end

function uabPyramidLayoutManager.LayoutConfig.prototype:SetVertical(value)
    local notify = (value ~= self.settings.vertical)

    self.settings.vertical = value

    if notify then
        self.layout:LayoutSettingsChanged()
    end
end

function uabPyramidLayoutManager.LayoutConfig.prototype:SetHideCancel(value)
    local notify = (value ~= self.settings.hidecancel)

    self.settings.hidecancel = value

    if notify then
        self.layout:LayoutSettingsChanged()
    end
end

function uabPyramidLayoutManager.LayoutConfig.prototype:GetHorizontal()
    return self.settings.horizontal or 0
end

function uabPyramidLayoutManager.LayoutConfig.prototype:GetVertical()
    return self.settings.vertical or 0
end

function uabPyramidLayoutManager.LayoutConfig.prototype:GetHideCancel()
    return self.settings.hidecancel
end

