-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

--[[
This class controls the arrangement of the ActionButtonNone and ActionButton
instances for a UnitGroupHeader.

There are one or more IActionSetLayout instances allocated for each
UnitGroupHeader.  How many depends on whether the layout is changed while
in-game.  The only layouts allocated are ones that were selected in-game.  Each
UnitGroupHeader keeps track of the active ActionSetLayout to use.
--]]
uabPyramidLayoutManager.Layout = uab.mixins.aceOO.Class(uabLayoutManager.Layout)

function uabPyramidLayoutManager.Layout.prototype:init(context, settings)
	uabPyramidLayoutManager.Layout.super.prototype.init(self)
	
    local config = uabPyramidLayoutManager.LayoutConfig:new(self, settings)
    self:Initialize(config, "uab.Pyramid", context)
end

function uabPyramidLayoutManager.Layout.prototype:SetupRowInfo()
    local settings = self.config.settings

    if not self.rowinfo then
        self.rowinfo = {}
    end

    self.rowinfo.numrows = 1
    if not self.rowinfo.rowcount then
        self.rowinfo.rowcount = {}
    else
        for idx, val in pairs(self.rowinfo.rowcount) do
            self.rowinfo.rowcount[idx] = nil
        end
    end

    self.rowinfo.rowcount[1] = settings.minRowCount

    local remaining = 24 - settings.minRowCount
    local idx = 2
    local rowcount = settings.minRowCount

    while remaining > 0 do
        rowcount = rowcount + settings.rowChangeAmount
        if rowcount > remaining then
            rowcount = remaining
        end
        self.rowinfo.rowcount[idx] = rowcount
        idx = idx + 1
        remaining = remaining - rowcount
        self.rowinfo.numrows = self.rowinfo.numrows + 1
    end

    if settings.expand ~= "true" then
        local reverse = {}

        for revidx = 1, self.rowinfo.numrows, 1 do
            reverse[revidx] = self.rowinfo.rowcount[(self.rowinfo.numrows-revidx)+1]
        end

        for index, val in pairs(reverse) do
            self.rowinfo.rowcount[index] = val
        end
    end
end

function uabPyramidLayoutManager.Layout.prototype:FirstButtonForRow(row)
    local btnpos = 1
    for idx = 1, row-1, 1 do
        btnpos = btnpos + self.rowinfo.rowcount[idx]
    end
    
    return btnpos
end

function uabPyramidLayoutManager.Layout.prototype:PositionRow(row)
    local settings = self.config.settings
    local startbutton = self:FirstButtonForRow(row)
    local numbuttons = self.rowinfo.rowcount[row]
    local endbutton = startbutton + numbuttons - 1

    local hchange
    local vchange
    local hstart
    local vstart
    local hspacing
    local vspacing

    if settings.extendDirection == uabLayoutManager.constants.grow.down or
        settings.extendDirection == uabLayoutManager.constants.grow.up then
        hspacing = settings.rowSpacing
        vspacing = settings.extendSpacing
    else
        hspacing = settings.extendSpacing
        vspacing = settings.rowSpacing
    end
    
    if settings.extendDirection == uabLayoutManager.constants.grow.down then
        local buttonspace = (uab.constants.buttonWidth + hspacing) * numbuttons

        hchange = (uab.constants.buttonWidth + hspacing)
        hstart = -((buttonspace - (uab.constants.buttonWidth + hspacing)) / 2)
        if settings.fillDirection == uabLayoutManager.constants.grow.left then
            hchange = hchange * -1
            hstart = hstart * -1
        end

        vchange = 0
        vstart = -((uab.constants.buttonHeight + vspacing) * row)
    elseif settings.extendDirection == uabLayoutManager.constants.grow.up then
        local buttonspace = (uab.constants.buttonWidth + hspacing) * numbuttons

        hchange = (uab.constants.buttonWidth + hspacing)
        hstart = -((buttonspace - (uab.constants.buttonWidth + hspacing)) / 2)
        if settings.fillDirection == uabLayoutManager.constants.grow.left then
            hchange = hchange * -1
            hstart = hstart * -1
        end

        vchange = 0
        vstart = (uab.constants.buttonHeight + vspacing) * row
    elseif settings.extendDirection == uabLayoutManager.constants.grow.left then
        local buttonspace = (uab.constants.buttonHeight + vspacing) * numbuttons

        hchange = 0
        hstart = -((uab.constants.buttonWidth + hspacing) * row)

        vchange = (uab.constants.buttonHeight + vspacing)
        vstart = -((buttonspace - (uab.constants.buttonHeight + 1)) / 2)
        if settings.fillDirection == uabLayoutManager.constants.grow.down then
            vchange = vchange * -1
            vstart = vstart * -1
        end
    elseif settings.extendDirection == uabLayoutManager.constants.grow.right then
        local buttonspace = (uab.constants.buttonHeight + vspacing) * numbuttons

        hchange = 0
        hstart = (uab.constants.buttonWidth + hspacing) * row

        vchange = (uab.constants.buttonHeight + vspacing)
        vstart = -((buttonspace - (uab.constants.buttonHeight + vspacing)) / 2)
        if settings.fillDirection == uabLayoutManager.constants.grow.down then
            vchange = vchange * -1
            vstart = vstart * -1
        end
    end

    local hpos = hstart
    local vpos = vstart

    for idx = startbutton, endbutton, 1 do
        self:SetButtonPoint(idx, "CENTER", hpos, vpos)

        hpos = hpos + hchange
        vpos = vpos + vchange
    end
end

function uabPyramidLayoutManager.Layout.prototype:SetupPositions()
    --[[
    Now, position the cancel button centered relative to the header (the
    parent of the cancel button)
    --]]
    if not self.config.settings.hidecancel then
        self:SetButtonPoint("cancel", "CENTER", 0, 0)
    end

    self:SetupRowInfo()

    for idx = 1, self.rowinfo.numrows, 1 do
        self:PositionRow(idx)
    end

    self.settingsset = true
end

