-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

uabOvalLayoutManager = uabLayoutManager:NewModule("uab.Oval")
uabOvalLayoutManager.localizedName = "Oval"
uabOvalLayoutManager.layouts = {}
uabOvalLayoutManager.defaultDB = {
    disabled = nil,
    settings = {
    },
}

function uabOvalLayoutManager:OnInitialize()
    self.super.OnInitialize(self)
end

function uabOvalLayoutManager:OnDisable()
    --[[
    Called when the manager is disabled.  This could happen
    when profiles change, or the manager is disabled and then re-enabled.
    
    We clear out the loaded layouts so that when we are
    enabled the next time, we have no layouts, and we have
    to load them again from our DB.
    --]]

    for name, val in pairs(self.layouts) do
        self.layouts[name] = nil
    end
end

function uabOvalLayoutManager:GetLayout(contextName)
    if not self.layouts[contextName] then
        local useoldconfig

        if not self.db.profile.settings[contextName] then
            self.db.profile.settings[contextName] = {}
            useoldconfig = contextName == "main"
        end

        self.layouts[contextName] = uabOvalLayoutManager.Layout:new(contextName, self.db.profile.settings[contextName])
        if useoldconfig and uab.db.profile.layoutSettings and uab.db.profile.layoutSettings[self.name] then
            self.layouts[contextName]:SetSettings(uab.db.profile.layoutSettings[self.name])
        end
        if uab.db.profile.layoutSettings then
            uab.db.profile.layoutSettings[self.name] = nil
        end
    end

    return self.layouts[contextName]
end

function uabOvalLayoutManager:GetDisplayName()
	return self.localizedName
end

