-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 42775 $"):match("%d+")), ("$Date: 2007-07-04 16:50:18 -0500 (Wed, 04 Jul 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

--[[
This class controls the arrangement of the ActionButtonNone and ActionButton
instances for a UnitGroupHeader.

There are one or more IActionSetLayout instances allocated for each
UnitGroupHeader.  How many depends on whether the layout is changed while
in-game.  The only layouts allocated are ones that were selected in-game.  Each
UnitGroupHeader keeps track of the active ActionSetLayout to use.
--]]
uabOvalLayoutManager.Layout = uab.mixins.aceOO.Class(uabLayoutManager.Layout)

--[[
This table defines the placement order for the buttons assuming
a specific starting point.  Each row is positioned, then the next
row.  Iterate over the button order positions until all have been
used, then go to the next row.  This means position 6 buttons in
the first row, 12 in the second, and 6 in the third.

To use this table when not starting at the specific starting point
use the buttonOrderSequence table to find the first index for each
row for a specific starting point.
--]]
uabOvalLayoutManager.Layout.constants = {}
uabOvalLayoutManager.Layout.constants.rowButtonStart = { 1, 7, 19 }
uabOvalLayoutManager.Layout.constants.rowButtons = { 6, 12, 6 }
uabOvalLayoutManager.Layout.constants.buttonOrder = {
    [uabLayoutManager.constants.anchor.left] = { row1 = { "l2", "u2l1", "u2r1", "r2", "d2r1", "d2l1" },
          row2 = { "l4", "u2l3", "u4l2", "u4", "u4r2", "u2r3", "r4", "d2r3", "d4r2", "d4", "d4l2", "d2l3" },
          row3 = { "l6", "u2l5", "u2r5", "r6", "d2r5", "d2l5" }
    },
    [uabLayoutManager.constants.anchor.top] = { row1 = { "u2", "u1r2", "d1r2", "d2", "d1l2", "u1l2" },
          row2 = { "u4", "u3r2", "u2r4", "r4", "d2r4", "d3r2", "d4", "d3l2", "d2l4", "l4", "u2l4", "u3l2" },
          row3 = { "u6", "u5r2", "d5r2", "d6", "d5l2", "u5l2" }
    }
}

uabOvalLayoutManager.Layout.constants.buttonOrderSequence = {
    [uabLayoutManager.constants.anchor.left] = {
          [uabLayoutManager.constants.placement.left] = { 1, 1, 1 },
          [uabLayoutManager.constants.placement.topleft] = { 2, 2, 2 },
          [uabLayoutManager.constants.placement.topright] = { 3, 4, 3 },
          [uabLayoutManager.constants.placement.right] = { 4, 7, 4 },
          [uabLayoutManager.constants.placement.bottomright] = { 5, 8, 5 },
          [uabLayoutManager.constants.placement.bottomleft] = { 6, 10, 6 }
    },
    [uabLayoutManager.constants.anchor.top] = {
          [uabLayoutManager.constants.placement.top] = { 1, 1, 1 },
          [uabLayoutManager.constants.placement.topright] = { 2, 2, 2 },
          [uabLayoutManager.constants.placement.bottomright] = { 3, 4, 3 },
          [uabLayoutManager.constants.placement.bottom] = { 4, 7, 4 },
          [uabLayoutManager.constants.placement.bottomleft] = { 5, 8, 5 },
          [uabLayoutManager.constants.placement.topleft] = { 6, 10, 6 }
    }
}

function uabOvalLayoutManager.Layout.prototype:init(context, settings)
	uabOvalLayoutManager.Layout.super.prototype.init(self)
	
    local config = uabOvalLayoutManager.LayoutConfig:new(self, settings)
    
    self:Initialize(config, "uab.Oval", context)
end

function uabOvalLayoutManager.Layout.prototype:PositionButton(orderCode, buttonIdx)
    local settings = self.config.settings
    local vMod = 0
    local hMod = 0

    tmpCode = orderCode        
    if string.sub(orderCode, 1, 1) == "u" then
        vMod = tonumber(string.sub(orderCode, 2, 2)) * 0.5
        tmpCode = string.sub(orderCode, 3)
    end

    if string.sub(tmpCode, 1, 1) == "d" then
        vMod = tonumber(string.sub(tmpCode, 2, 2)) * -0.5
        tmpCode = string.sub(tmpCode, 3)
    end

    if string.sub(tmpCode, 1, 1) == "r" then
        hMod = tonumber(string.sub(tmpCode, 2, 2)) * 0.5
        tmpCode = string.sub(tmpCode, 3)
    end

    if string.sub(tmpCode, 1, 1) == "l" then
        hMod = tonumber(string.sub(tmpCode, 2, 2)) * -0.5
        tmpCode = string.sub(tmpCode, 3)
    end

    local x = (uab.constants.buttonWidth + settings.hspacing) * hMod
    local y = (uab.constants.buttonHeight + settings.vspacing) * vMod
    
    self:SetButtonPoint(buttonIdx, "CENTER", x, y)
end

function uabOvalLayoutManager.Layout.prototype:PositionRow(row)
    local settings = self.config.settings
    local order = uabOvalLayoutManager.Layout.constants.buttonOrder[settings.anchor]["row"..row]
    local sequence = uabOvalLayoutManager.Layout.constants.buttonOrderSequence[settings.anchor]
    local startpos = settings.startLocation
    local buttonIdx = uabOvalLayoutManager.Layout.constants.rowButtonStart[row]

    if settings.growClockwise == "true" then
        for idx = sequence[startpos][row], uabOvalLayoutManager.Layout.constants.rowButtons[row], 1 do
            self:PositionButton(order[idx], buttonIdx)
            buttonIdx = buttonIdx + 1
        end
        
        local endpos = sequence[startpos][row] - 1
        
        for idx = 1, endpos, 1 do
            self:PositionButton(order[idx], buttonIdx)
            buttonIdx = buttonIdx + 1
        end
    else
        for idx = sequence[startpos][row], 1, -1 do
            self:PositionButton(order[idx], buttonIdx)
            buttonIdx = buttonIdx + 1
        end
        
        local endpos = sequence[startpos][row] + 1
        
        for idx = uabOvalLayoutManager.Layout.constants.rowButtons[row], endpos, -1 do
            self:PositionButton(order[idx], buttonIdx)
            buttonIdx = buttonIdx + 1
        end
    end
end

function uabOvalLayoutManager.Layout.prototype:SetupPositions()
    local settings = self.config.settings

	--[[
    Now, position the cancel button centered relative to the header (the
    parent of the cancel button)
    --]]

    if not settings.hidecancel then
        self:SetButtonPoint("cancel", "CENTER", 0, 0)
    end

    self:PositionRow(1)
    self:PositionRow(2)
    self:PositionRow(3)
end

