-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

--[[
This class controls the arrangement of the ActionButtonNone and ActionButton
instances for a UnitGroupHeader.

There are one or more IActionSetLayout instances allocated for each
UnitGroupHeader.  How many depends on whether the layout is changed while
in-game.  The only layouts allocated are ones that were selected in-game.  Each
UnitGroupHeader keeps track of the active ActionSetLayout to use.
--]]
uabBarLayoutManager.Layout = uab.mixins.aceOO.Class(uabLayoutManager.Layout)

function uabBarLayoutManager.Layout.prototype:init(context, settings)
    uabBarLayoutManager.Layout.super.prototype.init(self)

    local config = uabBarLayoutManager.LayoutConfig:new(self, settings)

    self:Initialize(config, "uab.Bar", context)
end

function uabBarLayoutManager.Layout.prototype:SetPointsForRow(row, placementMod, spacing)
	local settings = self.config.settings
    local ofs = (row - 1) * settings.growLimit
    local relofs = ofs - settings.growLimit

    for pos = 1, settings.growLimit, 1 do
        local btnpos = pos + ofs
        local relbtnpos = pos + relofs
        local relpos = self:GetButtonPoint(relbtnpos)

        self:SetButtonPoint(
            btnpos,
            "CENTER",
            relpos.x + (placementMod.x * (uab.constants.buttonWidth + spacing.x)),
            relpos.y + (placementMod.y * (uab.constants.buttonHeight + spacing.y)))
    end
end

function uabBarLayoutManager.Layout.prototype:SetupPositions()
    local settings = self.config.settings
    local havecancel

    if not settings.hidecancel then
        havecancel = true
        self:SetButtonPoint("cancel", "CENTER", 0, 0)
    end
    
    local overflowModifier = { x = 0, y = 0 }
    local buttonRows = 24 / settings.growLimit

    if buttonRows * settings.growLimit < 24 then
        buttonRows = buttonRows + 1
    end

    if settings.overflowClockwise == "true" then
        if settings.growDirection == uabLayoutManager.constants.grow.up then
            overflowModifier.x = 1
            overflowModifier.y = 0
        elseif settings.growDirection == uabLayoutManager.constants.grow.down then
            overflowModifier.x = -1
            overflowModifier.y = 0
        elseif settings.growDirection == uabLayoutManager.constants.grow.right then
            overflowModifier.x = 0
            overflowModifier.y = -1
        else
            overflowModifier.x = 0
            overflowModifier.y = 1
        end
    else
        if settings.growDirection == uabLayoutManager.constants.grow.up then
            overflowModifier.x = -1
            overflowModifier.y = 0
        elseif settings.growDirection == uabLayoutManager.constants.grow.down then
            overflowModifier.x = 1
            overflowModifier.y = 0
        elseif settings.growDirection == uabLayoutManager.constants.grow.right then
            overflowModifier.x = 0
            overflowModifier.y = 1
        else
            overflowModifier.x = 0
            overflowModifier.y = -1
        end
    end

    local growModifier = { x = 0, y = 0 }
    local start = { x = 0, y = 0 }
    local spacing = { x = 0, y = 0 }
    
    if settings.growDirection == uabLayoutManager.constants.grow.up or settings.growDirection == uabLayoutManager.constants.grow.down then
        spacing.x = settings.overflowSpacing
        spacing.y = settings.growSpacing
    else
        spacing.x = settings.growSpacing
        spacing.y = settings.overflowSpacing
    end

    if settings.placement == uabLayoutManager.constants.placement.top then
        if settings.growDirection == uabLayoutManager.constants.grow.up then
            growModifier.x = 0
            growModifier.y = 1
        elseif settings.growDirection == uabLayoutManager.constants.grow.left then
            growModifier.x = -1
            growModifier.y = 0
        else    -- uabLayoutManager.constants.grow.right
            growModifier.x = 1
            growModifier.y = 0
        end

        start.x = 0
        start.y = 1
    elseif settings.placement == uabLayoutManager.constants.placement.right then
        if settings.growDirection == uabLayoutManager.constants.grow.right then
            growModifier.x = 1
            growModifier.y = 0
        elseif settings.growDirection == uabLayoutManager.constants.grow.up then
            growModifier.x = 0
            growModifier.y = 1
        else    -- uabLayoutManager.constants.grow.down
            growModifier.x = 0
            growModifier.y = -1
        end

        start.x = 1
        start.y = 0
    elseif settings.placement == uabLayoutManager.constants.placement.bottom then
        if settings.growDirection == uabLayoutManager.constants.grow.down then
            growModifier.x = 0
            growModifier.y = -1
        elseif settings.growDirection == uabLayoutManager.constants.grow.right then
            growModifier.x = 1
            growModifier.y = 0
        else    -- uabLayoutManager.constants.grow.left
            growModifier.x = -1
            growModifier.y = 0
        end

        start.x = 0
        start.y = -1
    elseif settings.placement == uabLayoutManager.constants.placement.left then
        if settings.growDirection == uabLayoutManager.constants.grow.left then
            growModifier.x = -1
            growModifier.y = 0
        elseif settings.growDirection == uabLayoutManager.constants.grow.up then
            growModifier.x = 0
            growModifier.y = 1
        else    -- uabLayoutManager.constants.grow.down
            growModifier.x = 0
            growModifier.y = -1
        end

        start.x = -1
        start.y = 0
    end

    if not havecancel then
        start.x = 0
        start.y = 0
    end
    
    self:SetButtonPoint(1, "CENTER", start.x * (uab.constants.buttonWidth + spacing.x), start.y * (uab.constants.buttonHeight + spacing.y))

    for pos = 2, settings.growLimit, 1 do
        self:SetButtonPoint(
            pos,
            "CENTER",
            (start.x + (growModifier.x * (pos - 1))) * (uab.constants.buttonWidth + spacing.x),
            (start.y + (growModifier.y * (pos - 1))) * (uab.constants.buttonHeight + spacing.y))
    end

    for row = 2, buttonRows, 1 do
        self:SetPointsForRow(row, overflowModifier, spacing)
    end
end

