-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 78318 $"):match("%d+")), ("$Date: 2008-07-13 02:57:17 -0400 (Sun, 13 Jul 2008) $"):match("%d%d%d%d%-%d%d%-%d%d"))

uabItemAction = uab:NewModule("ItemAction", "AceEvent-2.0")

uabItemAction.core = uab
uabItemAction.bagitems = {}

function uabItemAction:OnInitialize()
	uabItemAction.super.OnInitialize(self)
    self:RegisterEvent("BAG_UPDATE", "LoadBags") -- inventory change
    self:RegisterEvent("UNIT_INVENTORY_CHANGED", "LoadBags") -- inventory change
end

function uabItemAction:LoadBags()
    self.loaded = true

    for item, data in pairs(self.bagitems) do
        data.bag = nil
        data.slot = nil
        self.bagitems[item] = nil
    end

    self.bagitems = {}

    for bag=0,4 do
        for slot=1,GetContainerNumSlots(bag) do
            local itemLink = GetContainerItemLink(bag,slot)
            if itemLink then
                self.bagitems[itemLink] = { bag = bag, slot = slot }
            end
        end
    end
    
    for slot = 0, 19, 1 do
        local itemLink = GetInventoryItemLink("player", slot)
        if itemLink then
            self.bagitems[itemLink] = { bag = nil, slot = slot }
        end
    end
end    

function uabItemAction:FindItem(text)
    if not self.loaded then
        self:LoadBags()
    end

    for item, data in pairs(self.bagitems) do
        if string.find(item, text) then
            return data.bag, data.slot
        end
    end
end

uab.classes.ItemAction = uab.mixins.aceOO.Class(uab.classes.BaseAction)

function uab.classes.ItemAction.GetCount(itemText, itemLink)
    if itemText then
        if IsEquippableItem(itemText) then
            -- equippable items don't show counts
            return
        elseif IsConsumableItem(itemText) or IsUsableItem(itemLink) then
            local itemCount = GetItemCount(itemText, false, true)
            return itemCount
        end
    elseif itemLink then
        if IsEquippableItem(itemLink) then
            -- equippable items don't show counts
            return
        elseif IsConsumableItem(itemLink) or IsUsableItem(itemLink) then
            local itemCount = GetItemCount(itemLink, false, true)
            return itemCount
        end
    end
    
    local bag
    local slot

    if itemText then
        bag, slot = uabItemAction:FindItem(itemText)
    end

    if bag and slot then
        local texture, itemCount, locked, quality, readable = GetContainerItemInfo(bag, slot)
        
        if itemCount then
            return itemCount
        else
            local _, _, _, _, _, _, _, maxstack, _, _ = GetItemInfo(itemText)
  
            if maxstack > 1 then
                return "0"
            end
        end
    elseif not slot then
        --[[
        Need to handle items that are no longer in inventory or bags.  In this case
        need to either return a nil value or a count of 0 based on whether the item
        is equipable or not, or a non-stackable item.
        --]]

        if itemlink then
            local itemName, link, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemCount, itemEquipLoc, itemTexture = GetItemInfo(itemlink)

            if itemType == "Consumable" or itemType == "Key" or itemType == "Miscellaneous" or itemType == "Reagent" or itemType == "Projectile" or itemType == "Trade Goods" then
                return "0"
            end
        end
    end
end

function uab.classes.ItemAction.prototype:init(data)
	uab.classes.ItemAction.super.prototype.init(self)
	
	self.data = data
    self.text = data.name
    self.attribs = {}

    self.attribs["type"] = "item"
    self.attribs["item"] = self.text
    
	self:SetIcon()
end

function uab.classes.ItemAction.prototype:Dump(dumper)
    dumper:Dump("Item Action")
    dumper:IncIndent()
    dumper:Dump("Name     : "..self.text)
    dumper:Dump("Icon     : "..self.data.icon)
    dumper:Dump("Attributes")
    dumper:IncIndent()
    
    for attr, val in pairs(self.attribs) do
        dumper:Dump(attr.." : "..val)
    end
    
    dumper:DecIndent()
    dumper:DecIndent()
end

-- Override
function uab.classes.ItemAction.prototype:ShowTooltip(frame)
    --[[
    Need to find the referenced item.  Look in the player's inventory first.
    If not there, look in the player's bags.
    --]]

    GameTooltip:SetOwner(frame, "ANCHOR_RIGHT")
    GameTooltip:SetBackdropColor(0.1, 0.1, 0.1, 0.8)
    
    local bag, slot = uabItemAction:FindItem(self.text)

    if bag and slot then
        GameTooltip:SetBagItem(bag,slot)
    elseif slot then
        GameTooltip:SetInventoryItem("player", slot)
    elseif self.data.itemlink then
        GameTooltip:SetHyperlink(self.data.itemlink)
    end
end

-- Override
function uab.classes.ItemAction.prototype:GetCount()
    return uab.classes.ItemAction.GetCount(self.text, self.data.itemLink)
end

-- Override
function uab.classes.ItemAction.prototype:GetAttributes()
    return self.attribs
end

-- Override
function uab.classes.ItemAction.prototype:IsUsable()
    return IsUsableItem(self.text)
end

-- Override
function uab.classes.ItemAction.prototype:GetClassName()
	return "ItemAction"
end

-- Override
function uab.classes.ItemAction.prototype:IsActive()
    return IsCurrentItem(self.text)
end

-- Override
function uab.classes.ItemAction.prototype:GetCooldown()
    return GetItemCooldown(self.text)
end

-- Override
function uab.classes.ItemAction.prototype:PickupAction()
    local bag, slot = uabItemAction:FindItem(self.text)

    if bag and slot then
        PickupContainerItem(bag, slot)
        return true
    elseif slot then
        PickupInventoryItem(slot)
        return true
    elseif PickupItem then
        PickupItem(self.text)
        return true
    end
end

--[[---------------------------------------------------------------------------
Helper methods, to be used only by the class itself
-----------------------------------------------------------------------------]]
-- Override
function uab.classes.ItemAction.prototype:SetIcon()
    self.icon = self.data.icon

    if not self.icon then
    	--[[
    	Need to find the referenced item.  Look in the player's inventory first.
        If not there, look in the player's bags.
    	--]]
    
        local bag, slot = uabItemAction:FindItem(self.text)
    
        if bag and slot then
            self.icon = GetContainerItemInfo(bag,slot)
            self.data.itemlink = GetContainerItemLink(bag,slot)
        elseif slot then
            self.icon = GetInventoryItemTexture("player",slot)
            self.data.itemlink = GetInventoryItemLink("player",slot)
        else
            local _, link, _, _, _, _, _, _, _, texture = GetItemInfo(self.text)
    
            self.icon = texture
            self.data.itemlink = link
        end
    end        
    
    self.data.icon = self.icon
end

