-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local frameGroupBase = uab.mixins.aceOO.Class()
local moduleName = "oRA2"

function frameGroupBase:GetOptionsMenu()
    local menu = uabFrameGroup:GetMainOptionsMenu()

    if not menu.args[moduleName] then
        menu.args[moduleName] = {
            type = 'group',
            name = moduleName,
            desc = "Use, anchor, scale, and match expression for "..moduleName.." frames",
            args = {
            },
        }
    end

    return menu.args[moduleName]
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local mtFrameGroup = uabFrameGroup:NewModule(moduleName.." Main Tank")

mtFrameGroup.defaultDB = {
    expression = "^oRAMainTankUnitButton%d+$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "partyraid",
}

function mtFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function mtFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function mtFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local mttFrameGroup = uabFrameGroup:NewModule(moduleName.." Main Tank Target")

mttFrameGroup.defaultDB = {
    expression = "^oRAMainTankUnitButton%d+Target$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function mttFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function mttFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function mttFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local mtttFrameGroup = uabFrameGroup:NewModule(moduleName.." Main Tank Target of Target")

mtttFrameGroup.defaultDB = {
    expression = "^oRAMainTankUnitButton%d+TargetTarget$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function mtttFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function mtttFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function mtttFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local ptFrameGroup = uabFrameGroup:NewModule(moduleName.." Player Target")

ptFrameGroup.defaultDB = {
    expression = "^oRAPlayerTargetUnitButton%d+$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "partyraid",
}

function ptFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function ptFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function ptFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local pttFrameGroup = uabFrameGroup:NewModule(moduleName.." Player Target Target")

pttFrameGroup.defaultDB = {
    expression = "^oRAPlayerTargetUnitButton%d+Target$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function pttFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function pttFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function pttFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local ptttFrameGroup = uabFrameGroup:NewModule(moduleName.." Player Target ToT")

ptttFrameGroup.defaultDB = {
    expression = "^oRAPlayerTargetUnitButton%d+TargetTarget$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function ptttFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function ptttFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function ptttFrameGroup:GetModuleName()
    return moduleName
end

