-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local frameGroupBase = uab.mixins.aceOO.Class()
local moduleName = "XPerl"

function frameGroupBase:GetOptionsMenu()
    local menu = uabFrameGroup:GetMainOptionsMenu()

    if not menu.args[moduleName] then
        menu.args[moduleName] = {
            type = 'group',
            name = moduleName,
            desc = "Use, anchor, scale, and match expression for "..moduleName.." frames",
            args = {
            },
        }
    end

    return menu.args[moduleName]
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local playerFrameGroup = uabFrameGroup:NewModule(moduleName.." Player")

playerFrameGroup.defaultDB = {
    expressions = {
        "^XPerl_Player$",
        "^XPerl_Player[^_].*$",
    },
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "player",
}

function playerFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function playerFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function playerFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local petFrameGroup = uabFrameGroup:NewModule(moduleName.." Player Pet")

petFrameGroup.defaultDB = {
    expression = "^XPerl_Player_Pet.*$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "pet",
}

function petFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function petFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function petFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local partyFrameGroup = uabFrameGroup:NewModule(moduleName.." Party")

partyFrameGroup.defaultDB = {
    expression = "^XPerl_party%d+.*$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "partyraid",
}

function partyFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function partyFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function partyFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local partyPetFrameGroup = uabFrameGroup:NewModule(moduleName.." Party Pet")

partyPetFrameGroup.defaultDB = {
    expression = "^XPerl_partypet%d+.*$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "partyraid",
}

function partyPetFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function partyPetFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function partyPetFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local focusFrameGroup = uabFrameGroup:NewModule(moduleName.." Focus")

focusFrameGroup.defaultDB = {
    expression = "^XPerl_Focus.*$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "focus",
}

function focusFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function focusFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function focusFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local targetFrameGroup = uabFrameGroup:NewModule(moduleName.." Target")

targetFrameGroup.defaultDB = {
    expressions = {
        "^XPerl_Target$",
        "^XPerl_Target[^T].*$",
    },
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function targetFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function targetFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function targetFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local totFrameGroup = uabFrameGroup:NewModule(moduleName.." Target of Target")

totFrameGroup.defaultDB = {
    expression = "^XPerl_TargetTarget.*$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function totFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function totFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function totFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local raidFrameGroup = uabFrameGroup:NewModule(moduleName.." Raid")

raidFrameGroup.defaultDB = {
    expression = "^XPerl_Raid_Grp%d+.*$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function raidFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function raidFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function raidFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local raidPetsFrameGroup = uabFrameGroup:NewModule(moduleName.." Raid Pets")

raidPetsFrameGroup.defaultDB = {
    expression = "^XPerl_Raid_GrpPets.*$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function raidPetsFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function raidPetsFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function raidPetsFrameGroup:GetModuleName()
    return moduleName
end

