-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

if PitBull then
    local uabPitBull = PitBull:NewModule("UnitActionBars")
    
    uabPitBull.activatorframecontrolobjs = {}
    uabPitBull.framegroupcodes = {}
    
    function uabPitBull:AddActivatorFrameControl(activatorframecontrolobj)
        uabPitBull.activatorframecontrolobjs[activatorframecontrolobj] = true
    end
    
    function uabPitBull:RemoveActivatorFrameControl(activatorframecontrolobj)
        uabPitBull.activatorframecontrolobjs[activatorframecontrolobj] = nil
    end
    
    function uabPitBull:AddFrameGroupCode(code)
        self.framegroupcodes[code] = true
    end
    
    function uabPitBull:FixControls()
        for ctrl, _ in pairs(self.activatorframecontrolobjs) do
            if ctrl.frame:GetParent() ~= ctrl.unitframe then
                ctrl:ResetParent()
            end
        end
    --    uab.classes.ActivatorFrameControl:FixControls(nil, nil, self.framegroupcodes, nil)
    end
    
    function uabPitBull:OnUnitFrameUnitChange(unit, frame, oldUnit)
        self:FixControls()
    end
    
    function uabPitBull:OnPopulateUnitFrame(unit, frame)
        self:FixControls()
    end
    
    function uabPitBull:OnClearUnitFrame(unit, frame)
        self:FixControls()
    end
    
    function uabPitBull:OnSwapUnitFrame(unit, frame, oldFrame)
        self:FixControls()
    end
    
    local frameGroupBase = uab.mixins.aceOO.Class()
    local module = "PitBull"
    
    frameGroupBase.defn = {
        expressions = {
            "^PitBullUnitFrame%d+$",
            "^PitBullCluster%d+UnitButton%d+$",
        },
    }
    
    function frameGroupBase:GetOptionsMenu()
        local menu = uabFrameGroup:GetMainOptionsMenu()
    
        if not menu.args.PitBull then
            menu.args.PitBull = {
                type = 'group',
                name = "PitBull",
                desc = "Use, anchor, scale, and match expression for PitBull frames",
                args = {
                },
            }
        end
    
        return menu.args.PitBull
    end
    
    function frameGroupBase:UnitMatch(unit, defn)
        if defn.expressions then
            for exp, _ in pairs(defn.expressions) do
                if unit:match(exp) then
                    return true
                end
            end
        end
        
        if defn.expression then
            if unit:match(defn.expression) then
                return true
            end
        end
    end
    
    local playerFrameGroup = uabFrameGroup:NewModule(module .." Player")
    
    playerFrameGroup.defaultDB = {
        expression = "^player$",
        usedefaultscale = true,
        usedefaultanchor = true,
        unitgroup = "player",
    }
    
    function playerFrameGroup:OnInitialize()
        self.super.OnInitialize(self)
        uabPitBull:AddFrameGroupCode(self.framegroupcode)
    end
    
    function playerFrameGroup:GetOptionsMenu()
        return frameGroupBase:GetOptionsMenu()
    end
    
    function playerFrameGroup:AddActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:AddActivatorFrameControl(activatorframecontrolobj)
    end
    
    function playerFrameGroup:RemoveActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:RemoveActivatorFrameControl(activatorframecontrolobj)
    end
    
    function playerFrameGroup:IsFrameGroup(frame)
        if self:MatchFrame(frame, frameGroupBase.defn) then
            local unit = SecureButton_GetModifiedUnit(frame)
            if not unit then
                unit = frame:GetUnit()
            end
    
            if unit then
                return frameGroupBase:UnitMatch(unit, self.db.profile)
            end
        end
    end
    
    -- Override expected
    function playerFrameGroup:GetModuleName()
        return module
    end
    
    local petFrameGroup = uabFrameGroup:NewModule(module .. " Pet")
    
    petFrameGroup.defaultDB = {
        expression = "^pet$",
        usedefaultscale = true,
        usedefaultanchor = true,
        unitgroup = "pet",
    }
    
    function petFrameGroup:OnInitialize()
        self.super.OnInitialize(self)
        uabPitBull:AddFrameGroupCode(self.framegroupcode)
    end
    
    function petFrameGroup:GetOptionsMenu()
        return frameGroupBase:GetOptionsMenu()
    end
    
    function petFrameGroup:AddActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:AddActivatorFrameControl(activatorframecontrolobj)
    end
    
    function petFrameGroup:RemoveActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:RemoveActivatorFrameControl(activatorframecontrolobj)
    end
    
    function petFrameGroup:IsFrameGroup(frame)
        if self:MatchFrame(frame, frameGroupBase.defn) then
            local unit = SecureButton_GetModifiedUnit(frame)
            if not unit then
                unit = frame:GetUnit()
            end
    
            if unit then
                return frameGroupBase:UnitMatch(unit, self.db.profile)
            end
        end
    end
    
    -- Override expected
    function petFrameGroup:GetModuleName()
        return module
    end
    
    local partyFrameGroup = uabFrameGroup:NewModule(module .. " Party")
    
    partyFrameGroup.defaultDB = {
        expression = "^party%d$",
        usedefaultscale = true,
        usedefaultanchor = true,
        unitgroup = "partyraid",
    }
    
    function partyFrameGroup:OnInitialize()
        self.super.OnInitialize(self)
        uabPitBull:AddFrameGroupCode(self.framegroupcode)
    end
    
    function partyFrameGroup:GetOptionsMenu()
        return frameGroupBase:GetOptionsMenu()
    end
    
    function partyFrameGroup:AddActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:AddActivatorFrameControl(activatorframecontrolobj)
    end
    
    function partyFrameGroup:RemoveActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:RemoveActivatorFrameControl(activatorframecontrolobj)
    end
    
    function partyFrameGroup:IsFrameGroup(frame)
        if self:MatchFrame(frame, frameGroupBase.defn) then
            local unit = SecureButton_GetModifiedUnit(frame)
            if not unit then
                unit = frame:GetUnit()
            end
    
            if unit then
                return frameGroupBase:UnitMatch(unit, self.db.profile)
            end
        end
    end
    
    -- Override expected
    function partyFrameGroup:GetModuleName()
        return module
    end
    
    local partyPetFrameGroup = uabFrameGroup:NewModule(module .. " Party Pet")
    
    partyPetFrameGroup.defaultDB = {
        expression = "^partypet%d$",
        usedefaultscale = true,
        usedefaultanchor = true,
        unitgroup = "partyraid",
    }
    
    function partyPetFrameGroup:OnInitialize()
        self.super.OnInitialize(self)
        uabPitBull:AddFrameGroupCode(self.framegroupcode)
    end
    
    function partyPetFrameGroup:GetOptionsMenu()
        return frameGroupBase:GetOptionsMenu()
    end
    
    function partyPetFrameGroup:AddActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:AddActivatorFrameControl(activatorframecontrolobj)
    end
    
    function partyPetFrameGroup:RemoveActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:RemoveActivatorFrameControl(activatorframecontrolobj)
    end
    
    function partyPetFrameGroup:IsFrameGroup(frame)
        if self:MatchFrame(frame, frameGroupBase.defn) then
            local unit = SecureButton_GetModifiedUnit(frame)
            if not unit then
                unit = frame:GetUnit()
            end
    
            if unit then
                return frameGroupBase:UnitMatch(unit, self.db.profile)
            end
        end
    end
    
    -- Override expected
    function partyPetFrameGroup:GetModuleName()
        return module
    end
    
    local raidFrameGroup = uabFrameGroup:NewModule(module .. " Raid")
    
    raidFrameGroup.defaultDB = {
        expression = "^raid%d$",
        usedefaultscale = true,
        usedefaultanchor = true,
        unitgroup = "partyraid",
    }
    
    function raidFrameGroup:OnInitialize()
        self.super.OnInitialize(self)
        uabPitBull:AddFrameGroupCode(self.framegroupcode)
    end
    
    function raidFrameGroup:GetOptionsMenu()
        return frameGroupBase:GetOptionsMenu()
    end
    
    function raidFrameGroup:AddActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:AddActivatorFrameControl(activatorframecontrolobj)
    end
    
    function raidFrameGroup:RemoveActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:RemoveActivatorFrameControl(activatorframecontrolobj)
    end
    
    function raidFrameGroup:IsFrameGroup(frame)
        if self:MatchFrame(frame, frameGroupBase.defn) then
            local unit = SecureButton_GetModifiedUnit(frame)
            if not unit then
                unit = frame:GetUnit()
            end
    
            if unit then
                return frameGroupBase:UnitMatch(unit, self.db.profile)
            end
        end
    end
    
    -- Override expected
    function raidFrameGroup:GetModuleName()
        return module
    end
    
    local raidPetFrameGroup = uabFrameGroup:NewModule(module .. " Raid Pet")
    
    raidPetFrameGroup.defaultDB = {
        expression = "^raidpet%d$",
        usedefaultscale = true,
        usedefaultanchor = true,
        unitgroup = "partyraid",
    }
    
    function raidPetFrameGroup:OnInitialize()
        self.super.OnInitialize(self)
        uabPitBull:AddFrameGroupCode(self.framegroupcode)
    end
    
    function raidPetFrameGroup:GetOptionsMenu()
        return frameGroupBase:GetOptionsMenu()
    end
    
    function raidPetFrameGroup:AddActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:AddActivatorFrameControl(activatorframecontrolobj)
    end
    
    function raidPetFrameGroup:RemoveActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:RemoveActivatorFrameControl(activatorframecontrolobj)
    end
    
    function raidPetFrameGroup:IsFrameGroup(frame)
        if self:MatchFrame(frame, frameGroupBase.defn) then
            local unit = SecureButton_GetModifiedUnit(frame)
            if not unit then
                unit = frame:GetUnit()
            end
    
            if unit then
                return frameGroupBase:UnitMatch(unit, self.db.profile)
            end
        end
    end
    
    -- Override expected
    function raidPetFrameGroup:GetModuleName()
        return module
    end
    
    local focusFrameGroup = uabFrameGroup:NewModule(module .. " Focus")
    
    focusFrameGroup.defaultDB = {
        expression = "^focus$",
        usedefaultscale = true,
        usedefaultanchor = true,
        unitgroup = "partyraid",
    }
    
    function focusFrameGroup:OnInitialize()
        self.super.OnInitialize(self)
        uabPitBull:AddFrameGroupCode(self.framegroupcode)
    end
    
    function focusFrameGroup:GetOptionsMenu()
        return frameGroupBase:GetOptionsMenu()
    end
    
    function focusFrameGroup:AddActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:AddActivatorFrameControl(activatorframecontrolobj)
    end
    
    function focusFrameGroup:RemoveActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:RemoveActivatorFrameControl(activatorframecontrolobj)
    end
    
    function focusFrameGroup:IsFrameGroup(frame)
        if self:MatchFrame(frame, frameGroupBase.defn) then
            local unit = SecureButton_GetModifiedUnit(frame)
            if not unit then
                unit = frame:GetUnit()
            end
    
            if unit then
                return frameGroupBase:UnitMatch(unit, self.db.profile)
            end
        end
    end
    
    -- Override expected
    function focusFrameGroup:GetModuleName()
        return module
    end
    
    local focusTargetFrameGroup = uabFrameGroup:NewModule(module .. " Focus Target")
    
    focusTargetFrameGroup.defaultDB = {
        expression = "^focustarget$",
        usedefaultscale = true,
        usedefaultanchor = true,
        unitgroup = "target",
    }
    
    function focusTargetFrameGroup:OnInitialize()
        self.super.OnInitialize(self)
        uabPitBull:AddFrameGroupCode(self.framegroupcode)
    end
    
    function focusTargetFrameGroup:GetOptionsMenu()
        return frameGroupBase:GetOptionsMenu()
    end
    
    function focusTargetFrameGroup:AddActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:AddActivatorFrameControl(activatorframecontrolobj)
    end
    
    function focusTargetFrameGroup:RemoveActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:RemoveActivatorFrameControl(activatorframecontrolobj)
    end
    
    function focusTargetFrameGroup:IsFrameGroup(frame)
        if self:MatchFrame(frame, frameGroupBase.defn) then
            local unit = SecureButton_GetModifiedUnit(frame)
            if not unit then
                unit = frame:GetUnit()
            end
    
            if unit then
                return frameGroupBase:UnitMatch(unit, self.db.profile)
            end
        end
    end
    
    -- Override expected
    function focusTargetFrameGroup:GetModuleName()
        return module
    end
    
    local targetFrameGroup = uabFrameGroup:NewModule(module .. " Target")
    
    targetFrameGroup.defaultDB = {
        expression = "^target$",
        usedefaultscale = true,
        usedefaultanchor = true,
        unitgroup = "target",
    }
    
    function targetFrameGroup:OnInitialize()
        self.super.OnInitialize(self)
        uabPitBull:AddFrameGroupCode(self.framegroupcode)
    end
    
    function targetFrameGroup:GetOptionsMenu()
        return frameGroupBase:GetOptionsMenu()
    end
    
    function targetFrameGroup:AddActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:AddActivatorFrameControl(activatorframecontrolobj)
    end
    
    function targetFrameGroup:RemoveActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:RemoveActivatorFrameControl(activatorframecontrolobj)
    end
    
    function targetFrameGroup:IsFrameGroup(frame)
        if self:MatchFrame(frame, frameGroupBase.defn) then
            local unit = SecureButton_GetModifiedUnit(frame)
            if not unit then
                unit = frame:GetUnit()
            end
    
            if unit then
                return frameGroupBase:UnitMatch(unit, self.db.profile)
            end
        end
    end
    
    -- Override expected
    function targetFrameGroup:GetModuleName()
        return module
    end
    
    local targetTargetFrameGroup = uabFrameGroup:NewModule(module .. " Target of Target")
    
    targetTargetFrameGroup.defaultDB = {
        expression = "^targettarget$",
        usedefaultscale = true,
        usedefaultanchor = true,
        unitgroup = "target",
    }
    
    function targetTargetFrameGroup:OnInitialize()
        self.super.OnInitialize(self)
        uabPitBull:AddFrameGroupCode(self.framegroupcode)
    end
    
    function targetTargetFrameGroup:GetOptionsMenu()
        return frameGroupBase:GetOptionsMenu()
    end
    
    function targetTargetFrameGroup:AddActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:AddActivatorFrameControl(activatorframecontrolobj)
    end
    
    function targetTargetFrameGroup:RemoveActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:RemoveActivatorFrameControl(activatorframecontrolobj)
    end
    
    function targetTargetFrameGroup:IsFrameGroup(frame)
        if self:MatchFrame(frame, frameGroupBase.defn) then
            local unit = SecureButton_GetModifiedUnit(frame)
            if not unit then
                unit = frame:GetUnit()
            end
    
            if unit then
                return frameGroupBase:UnitMatch(unit, self.db.profile)
            end
        end
    end
    
    -- Override expected
    function targetTargetFrameGroup:GetModuleName()
        return module
    end
    
    local tottargetFrameGroup = uabFrameGroup:NewModule(module .. " ToT Target")
    
    tottargetFrameGroup.defaultDB = {
        expression = "^targettargettarget$",
        usedefaultscale = true,
        usedefaultanchor = true,
        unitgroup = "target",
    }
    
    function tottargetFrameGroup:OnInitialize()
        self.super.OnInitialize(self)
        uabPitBull:AddFrameGroupCode(self.framegroupcode)
    end
    
    function tottargetFrameGroup:GetOptionsMenu()
        return frameGroupBase:GetOptionsMenu()
    end
    
    function tottargetFrameGroup:AddActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:AddActivatorFrameControl(activatorframecontrolobj)
    end
    
    function tottargetFrameGroup:RemoveActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:RemoveActivatorFrameControl(activatorframecontrolobj)
    end
    
    function tottargetFrameGroup:IsFrameGroup(frame)
        if self:MatchFrame(frame, frameGroupBase.defn) then
            local unit = SecureButton_GetModifiedUnit(frame)
            if not unit then
                unit = frame:GetUnit()
            end
    
            if unit then
                return frameGroupBase:UnitMatch(unit, self.db.profile)
            end
        end
    end
    
    -- Override expected
    function tottargetFrameGroup:GetModuleName()
        return module
    end
    
    local othertargetFrameGroup = uabFrameGroup:NewModule(module .. " Other Target")
    
    othertargetFrameGroup.defaultDB = {
        expression = "target$",
        usedefaultscale = true,
        usedefaultanchor = true,
        unitgroup = "target",
    }
    
    function othertargetFrameGroup:OnInitialize()
        self.super.OnInitialize(self)
        uabPitBull:AddFrameGroupCode(self.framegroupcode)
    end
    
    function othertargetFrameGroup:GetOptionsMenu()
        return frameGroupBase:GetOptionsMenu()
    end
    
    function othertargetFrameGroup:AddActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:AddActivatorFrameControl(activatorframecontrolobj)
    end
    
    function othertargetFrameGroup:RemoveActivatorFrameControl(activatorframecontrolobj)
        uabPitBull:RemoveActivatorFrameControl(activatorframecontrolobj)
    end
    
    function othertargetFrameGroup:IsFrameGroup(frame)
        if self:MatchFrame(frame, frameGroupBase.defn) then
            local unit = SecureButton_GetModifiedUnit(frame)
            if not unit then
                unit = frame:GetUnit()
            end
    
            if unit then
                if not frameGroupBase:UnitMatch(unit, playerFrameGroup.db.profile) and
                    not frameGroupBase:UnitMatch(unit, petFrameGroup.db.profile) and
                    not frameGroupBase:UnitMatch(unit, partyFrameGroup.db.profile) and
                    not frameGroupBase:UnitMatch(unit, partyPetFrameGroup.db.profile) and
                    not frameGroupBase:UnitMatch(unit, raidFrameGroup.db.profile) and
                    not frameGroupBase:UnitMatch(unit, raidPetFrameGroup.db.profile) and
                    not frameGroupBase:UnitMatch(unit, focusFrameGroup.db.profile) and
                    not frameGroupBase:UnitMatch(unit, focusTargetFrameGroup.db.profile) and
                    not frameGroupBase:UnitMatch(unit, targetFrameGroup.db.profile) and
                    not frameGroupBase:UnitMatch(unit, targetTargetFrameGroup.db.profile) and
                    not frameGroupBase:UnitMatch(unit, tottargetFrameGroup.db.profile) then
                    return not frameGroupBase:UnitMatch(unit, self.db.profile)
                end
            end
        end
    end
    
    -- Override expected
    function othertargetFrameGroup:GetModuleName()
        return module
    end
end
