-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local frameGroupBase = uab.mixins.aceOO.Class()
local moduleName = "PerlClassic"

function frameGroupBase:GetOptionsMenu()
    local menu = uabFrameGroup:GetMainOptionsMenu()

    if not menu.args[moduleName] then
        menu.args[moduleName] = {
            type = 'group',
            name = moduleName,
            desc = "Use, anchor, scale, and match expression for "..moduleName.." frames",
            args = {
            },
        }
    end

    return menu.args[moduleName]
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local playerFrameGroup = uabFrameGroup:NewModule(moduleName.." Player")

playerFrameGroup.defaultDB = {
    expression = "^Perl_Player_.+_CastClickOverlay$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "player",
}

function playerFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function playerFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function playerFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local playerCombatFrameGroup = uabFrameGroup:NewModule(moduleName.." Player Combat")

playerCombatFrameGroup.defaultDB = {
    expression = "^Perl_CombatDisplay_[^T].+_CastClickOverlay$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "player",
}

function playerCombatFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function playerCombatFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function playerCombatFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local petFrameGroup = uabFrameGroup:NewModule(moduleName.." Player Pet")

petFrameGroup.defaultDB = {
    expression = "^Perl_Player_Pet_.+_CastClickOverlay$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "pet",
}

function petFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function petFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function petFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local partyFrameGroup = uabFrameGroup:NewModule(moduleName.." Party")

partyFrameGroup.defaultDB = {
    expression = "^Perl_Party_MemberFrame%d+_.+_CastClickOverlay$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "partyraid",
}

function partyFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function partyFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function partyFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local focusFrameGroup = uabFrameGroup:NewModule(moduleName.." Focus")

focusFrameGroup.defaultDB = {
    expression = "^Perl_Focus_.+_CastClickOverlay$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "focus",
}

function focusFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function focusFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function focusFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local targetFrameGroup = uabFrameGroup:NewModule(moduleName.." Target")

targetFrameGroup.defaultDB = {
    expression = "^Perl_Target_[^T].+_CastClickOverlay$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function targetFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function targetFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function targetFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local targetCombatFrameGroup = uabFrameGroup:NewModule(moduleName.." Target Combat")

targetCombatFrameGroup.defaultDB = {
    expression = "^Perl_CombatDisplay_Target_.+_CastClickOverlay$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function targetCombatFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function targetCombatFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function targetCombatFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local totFrameGroup = uabFrameGroup:NewModule(moduleName.." Target of Target")

totFrameGroup.defaultDB = {
    expression = "^Perl_Target_Target_[^T].+_CastClickOverlay$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function totFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function totFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function totFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local tottargetFrameGroup = uabFrameGroup:NewModule(moduleName.." ToT Target")

tottargetFrameGroup.defaultDB = {
    expression = "^Perl_Target_Target_Target_.+_CastClickOverlay$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function tottargetFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function tottargetFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function tottargetFrameGroup:GetModuleName()
    return moduleName
end

