-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local frameGroupBase = uab.mixins.aceOO.Class()
local moduleName = "IceHUD"

function frameGroupBase:GetOptionsMenu()
    local menu = uabFrameGroup:GetMainOptionsMenu()

    if not menu.args[moduleName] then
        menu.args[moduleName] = {
            type = 'group',
            name = moduleName,
            desc = "Use, anchor, scale, and match expression for "..moduleName.." frames",
            args = {
            },
        }
    end

    return menu.args[moduleName]
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local targetFrameGroup = uabFrameGroup:NewModule(moduleName.." TargetInfo")

targetFrameGroup.defaultDB = {
    expression = "^IceHUD_TargetInfo$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function targetFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function targetFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function targetFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local totFrameGroup = uabFrameGroup:NewModule(moduleName.." TargetOfTarget")

totFrameGroup.defaultDB = {
    expression = "^IceHUD_TargetOfTarget$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function totFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function totFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function totFrameGroup:GetModuleName()
    return moduleName
end

