-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local frameGroupBase = uab.mixins.aceOO.Class()
local moduleName = "Grid"

function frameGroupBase:GetOptionsMenu()
    local menu = uabFrameGroup:GetMainOptionsMenu()

    if not menu.args[moduleName] then
        menu.args[moduleName] = {
            type = 'group',
            name = moduleName,
            desc = "Use, anchor, scale, and match expression for "..moduleName.." frames",
            args = {
            },
        }
    end

    return menu.args[moduleName]
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local playerFrameGroup = uabFrameGroup:NewModule(moduleName.." Player")

playerFrameGroup.defaultDB = {
    expression = "^GridLayoutPartyPlayer$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "player",
}

function playerFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function playerFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function playerFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local partyFrameGroup = uabFrameGroup:NewModule(moduleName.." Party")

partyFrameGroup.defaultDB = {
    expression = "^GridLayoutPartyHeaderUnitButton.+",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "partyraid",
}

function partyFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function partyFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function partyFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local partyPetFrameGroup = uabFrameGroup:NewModule(moduleName.." Party Pet")

partyPetFrameGroup.defaultDB = {
    expression = "^GridLayoutPartyPetHeaderUnitButton.+",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "partyraid",
}

function partyPetFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function partyPetFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function partyPetFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local raidFrameGroup = uabFrameGroup:NewModule(moduleName.." Raid")

raidFrameGroup.defaultDB = {
    expression = "^GridLayoutHeader.+UnitButton.+",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "partyraid",
}

function raidFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function raidFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function raidFrameGroup:GetModuleName()
    return moduleName
end

