-- Update the UAB version if the version of this file is later than any other already loaded
uab.CheckVersion(tonumber(("$Revision: 54416 $"):match("%d+")), ("$Date: 2007-11-12 16:16:09 -0500 (Mon, 12 Nov 2007) $"):match("%d%d%d%d%-%d%d%-%d%d"))

local frameGroupBase = uab.mixins.aceOO.Class()
local moduleName = "CTRA"

function frameGroupBase:GetOptionsMenu()
    local menu = uabFrameGroup:GetMainOptionsMenu()

    if not menu.args[moduleName] then
        menu.args[moduleName] = {
            type = 'group',
            name = moduleName,
            desc = "Use, anchor, scale, and match expression for "..moduleName.." frames",
            args = {
            },
        }
    end

    return menu.args[moduleName]
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local mtFrameGroup = uabFrameGroup:NewModule(moduleName.." Main Tank")

mtFrameGroup.defaultDB = {
    expression = "^CT_RAMTGroupUnitButton%d$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "partyraid",
}

function mtFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function mtFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function mtFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local mttFrameGroup = uabFrameGroup:NewModule(moduleName.." Main Tank Target")

mttFrameGroup.defaultDB = {
    expression = "^CT_RAMTTGroupUnitButton%d$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function mttFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function mttFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function mttFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local ptFrameGroup = uabFrameGroup:NewModule(moduleName.." Player Target")

ptFrameGroup.defaultDB = {
    expression = "^CT_RAPTGroupUnitButton%d$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function ptFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function ptFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function ptFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local pttFrameGroup = uabFrameGroup:NewModule(moduleName.." Player Target Target")

pttFrameGroup.defaultDB = {
    expression = "^CT_RAPTTGroupUnitButton%d$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "target",
}

function pttFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function pttFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function pttFrameGroup:GetModuleName()
    return moduleName
end

--[[------------------------------------------------------------------------
--------------------------------------------------------------------------]]
local raidFrameGroup = uabFrameGroup:NewModule(moduleName.." Raid Frames")

raidFrameGroup.defaultDB = {
    expression = "^CT_RAGroup%dUnitButton%d$",
    usedefaultscale = true,
    usedefaultanchor = true,
    unitgroup = "partyraid",
}

function raidFrameGroup:OnInitialize()
    self.super.OnInitialize(self)
end

function raidFrameGroup:GetOptionsMenu()
    return frameGroupBase:GetOptionsMenu()
end

-- Override expected
function raidFrameGroup:GetModuleName()
    return moduleName
end

